/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.complexeventmanager.defaultimplementation;

import de.aristaflow.adept2.core.complexeventmanager.EventFilter;
import de.aristaflow.adept2.core.complexeventmanager.EventQueue;
import de.aristaflow.adept2.core.complexeventmanager.EventSource;
import de.aristaflow.adept2.model.eventmodel.EventClass;
import de.aristaflow.adept2.model.eventmodel.EventModelFactory;
import de.aristaflow.adept2.model.eventmodel.EventReference;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class DefaultEventSource
implements EventSource {
    protected final Logger logger = LoggerTools.getLogger(this);
    private static final AtomicLong eventNumber = new AtomicLong(0L);
    private final String id;
    private final Set<EventClass> producedEventClasses;
    private EventQueue eventQueue;
    private EventModelFactory eventModelFactory;

    public DefaultEventSource(String id, Set<EventClass> producedEventTypes, EventModelFactory factory) {
        this.id = id;
        this.eventModelFactory = factory;
        this.producedEventClasses = new HashSet<EventClass>(producedEventTypes);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public Set<EventClass> getProducedEventClasses() {
        return Collections.unmodifiableSet(new HashSet<EventClass>(this.producedEventClasses));
    }

    @Override
    public void publishEvent(EventReference event) {
        if (!this.id.equals(event.getSourceID())) {
            throw new IllegalArgumentException("Illegal Event Source");
        }
        if (!this.contains(this.producedEventClasses, event.getEventClassID())) {
            this.logger.info(String.format("Event Source '%1$s' raises event of type %2$s which is not registered as produced event!", this.id, event.getEventClassID()));
        }
        this.eventQueue.queueEvent(event);
    }

    private boolean contains(Set<EventClass> producedEventClasses, String eventClassID) {
        for (EventClass cls : producedEventClasses) {
            if (!eventClassID.equals(cls.getEventClassID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setPreFilter(EventFilter filter) {
        this.eventQueue.setFilter(filter);
    }

    @Override
    public EventReference createEvent(String eventClassID, String eventID, long timeStamp, Map<String, Object> attributes) {
        ArgChecks.checkForNull(eventClassID, "eventClassID");
        ArgChecks.checkForNull(eventID, "eventID");
        ArgChecks.checkForNull(attributes, "attributes");
        EventClass eventClass = this.getEventClass(eventClassID);
        if (eventClass == null) {
            throw new IllegalArgumentException("Unkown EventClass ID");
        }
        if (!attributes.keySet().containsAll(eventClass.getAttributes().keySet())) {
            throw new IllegalArgumentException("Attribute Set does not match EventClass");
        }
        for (Map.Entry<String, Class<?>> entry : eventClass.getAttributes().entrySet()) {
            Object attribute = attributes.get(entry.getKey());
            if (attribute == null || entry.getValue().isAssignableFrom(attribute.getClass())) continue;
            throw new IllegalArgumentException(String.format("Attribute '%1$s' has invalid class '%3$s' expected '%2$s'!", entry.getKey(), entry.getValue(), attribute.getClass()));
        }
        return this.getEventModelFactory().createEventReference(this.id, eventNumber.incrementAndGet(), eventClassID, eventID, timeStamp, attributes);
    }

    private EventModelFactory getEventModelFactory() {
        return this.eventModelFactory;
    }

    protected EventClass getEventClass(String eventClassID) {
        ArgChecks.checkForNull(eventClassID, "eventClassID");
        for (EventClass e : this.producedEventClasses) {
            if (!eventClassID.equals(e.getEventClassID())) continue;
            return e;
        }
        return null;
    }

    @Override
    public void setEventQueue(EventQueue queue) {
        this.eventQueue = queue;
    }
}

