/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.complexeventmanager.syncronimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.complexeventmanager.EventManager;
import de.aristaflow.adept2.core.complexeventmanager.EventQueue;
import de.aristaflow.adept2.core.complexeventmanager.defaultimplementation.DefaultEventManager;
import de.aristaflow.adept2.core.complexeventmanager.syncronimplementation.SyncronEventSinkManager;
import de.aristaflow.adept2.core.complexeventmanager.syncronimplementation.SyncronEventSourceManager;
import de.aristaflow.adept2.model.eventmodel.EventReference;
import java.net.URI;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class SyncronEventManager
extends DefaultEventManager
implements EventManager {
    public SyncronEventManager(Configuration configuration, Registry registry) {
        this(configuration, registry, new String[0], new String[0]);
    }

    public SyncronEventManager(Configuration configuration, Registry registry, String[] startupRequiredServices, String[] runtimeRequiredServices) {
        super(configuration, registry, startupRequiredServices, runtimeRequiredServices);
        this.logger.log(Level.INFO, "Event Manager initialized");
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        this.eventSourceManager.shutdown();
        this.eventSinkManager.shutdown();
        this.eventSourceManager = new SyncronEventSourceManager(this.configuration, this.registry, this, this.eventClassManager);
        this.eventSinkManager = new SyncronEventSinkManager(this.configuration, this.registry, this, this.eventClassManager);
        this.eventSourceManager.init(myURIs);
        this.eventSinkManager.init(myURIs);
    }

    @Override
    public void propagateEvent(EventReference event) {
        this.logger.log(Level.INFO, String.format("Event Received (%s))", event));
        Set<EventQueue> queues = this.eventSinkManager.getEventQueues(event);
        this.logger.fine(String.format("Distributing Event %2$d@%1$s to Event Queues", event.getEventID(), event.getEventNumber()));
        for (EventQueue queue : queues) {
            queue.queueEvent(event);
        }
        this.logger.fine(String.format("Finished distributing Event %2$d@%1$s to Event Queues", event.getEventID(), event.getEventNumber()));
    }
}

