/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.datamanager.archive.dbimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.core.datamanager.archive.dbimplementation.DbArchiveDataElement;
import de.aristaflow.adept2.core.datamanager.archive.dbimplementation.DbArchiveDataValue;
import de.aristaflow.adept2.core.datamanager.archive.dbimplementation.DbArchiveExternalValue;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbDataManagerArchive {
    private static final int INTEGERVALUE = 0;
    private static final int FLOATVALUE = 1;
    private static final int BOOLEANVALUE = 2;
    private static final int STRINGVALUE = 3;
    private static final int BLOBVALUE = 4;
    private JDBCDataSource dataSource;
    protected final Logger logger = LoggerTools.getLogger(this);

    public DbDataManagerArchive(JDBCDataSource dataSource) {
        this.dataSource = dataSource;
    }

    JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public void archiveDataElements(List<DbArchiveDataElement> dataElements) {
        ExtendedConnection con = null;
        PreparedStatement insertElementStmt = null;
        PreparedStatement insertDataValueStmt = null;
        PreparedStatement insertExternalValueStmt = null;
        try {
            try {
                con = this.getDataSource().getConnection();
                con.setAutoCommit(false);
                String query = String.format("INSERT INTO dataElementsArchive(instanceID_hi, instanceID_lo, dataElementID, type, isNull_, latestNull, latestBooleanValue, latestIntegerValue, latestFloatValue, latestStringValue, latestBLOBvalue, externalNull, externalBooleanValue, externalIntegerValue, externalFloatValue, externalStringValue, externalBLOBvalue) VALUES(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?");
                insertElementStmt = con.prepareStatement(query);
                query = String.format("INSERT INTO dataValuesArchive(instanceID_hi, instanceID_lo, dataElementID, nodeID, iteration, createTime, agent, orgPosition, valid, isNull_, IntegerValue, FloatValue, BooleanValue, StringValue, BLOBValue) VALUES(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?");
                insertDataValueStmt = con.prepareStatement(query);
                query = String.format("INSERT INTO externalDataValuesArchive(instanceID_hi, instanceID_lo, dataElementID, createTime, agent, orgPosition, isNull_, IntegerValue, FloatValue, BooleanValue, StringValue, BLOBValue) VALUES(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?");
                insertExternalValueStmt = con.prepareStatement(query);
                int i = 0;
                while (i < dataElements.size()) {
                    this.storeDataElement(insertElementStmt, insertDataValueStmt, insertExternalValueStmt, dataElements.get(i));
                    ++i;
                }
                insertElementStmt.close();
                insertDataValueStmt.close();
                insertExternalValueStmt.close();
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, "Data could not be written to the archive database. " + e.getMessage());
                throw new RuntimeException("Data could not be written to the archive database.", e);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Data could not be written to the archive database. " + e.getMessage());
                throw new RuntimeException("Data could not be written to the archive database.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(insertElementStmt, insertDataValueStmt, insertExternalValueStmt);
            JDBCTools.closeQuietly(con);
            throw throwable;
        }
        JDBCTools.closeQuietly(insertElementStmt, insertDataValueStmt, insertExternalValueStmt);
        JDBCTools.closeQuietly(con);
    }

    private void storeDataElement(PreparedStatement insertElementStmt, PreparedStatement insertDataValueStmt, PreparedStatement insertExternalValueStmt, DbArchiveDataElement element) throws SQLException, IOException {
        insertElementStmt.clearParameters();
        int index = 1;
        insertElementStmt.setLong(index++, element.getInstanceID().getMostSignificantBits());
        insertElementStmt.setLong(index++, element.getInstanceID().getLeastSignificantBits());
        insertElementStmt.setInt(index++, element.getDataElementID());
        insertElementStmt.setString(index++, this.getTypeRepresentaion(element.getType(), element.getUserDefinedType()));
        insertElementStmt.setBoolean(index++, this.isNull(element));
        if (!this.isNull(element)) {
            insertElementStmt.setBoolean(index++, this.isLatestNull(element));
            this.setParametersForValue(this.getFirstValidValue(element).getValue(), element.getType(), insertElementStmt, index++);
        } else {
            insertElementStmt.setNull(index++, -7);
            this.setParametersForValue(null, null, insertElementStmt, index++);
        }
        Iterator<DbArchiveExternalValue> iter = element.getExternalValues();
        index += 4;
        if (iter.hasNext()) {
            DbArchiveExternalValue externalValue = iter.next();
            insertElementStmt.setBoolean(index++, externalValue.isNull());
            this.setParametersForValue(externalValue.getValue(), element.getType(), insertElementStmt, index);
        } else {
            insertElementStmt.setNull(index++, -7);
            this.setParametersForValue(null, null, insertElementStmt, index);
        }
        insertElementStmt.executeUpdate();
        Iterator<Object> values = element.getDataValues();
        while (values.hasNext()) {
            this.storeDataValue(insertDataValueStmt, element, (DbArchiveDataValue)values.next());
        }
        values = element.getExternalValues();
        while (values.hasNext()) {
            this.storeExternalValue(insertExternalValueStmt, element, (DbArchiveExternalValue)values.next());
        }
    }

    private void storeExternalValue(PreparedStatement insertExternalValueStmt, DbArchiveDataElement element, DbArchiveExternalValue externalValue) throws SQLException, IOException {
        insertExternalValueStmt.clearParameters();
        int index = 1;
        insertExternalValueStmt.setLong(index++, element.getInstanceID().getMostSignificantBits());
        insertExternalValueStmt.setLong(index++, element.getInstanceID().getLeastSignificantBits());
        insertExternalValueStmt.setInt(index++, element.getDataElementID());
        insertExternalValueStmt.setTimestamp(index++, externalValue.getCreateTime(), JDBCTools.createUTCCalendar());
        insertExternalValueStmt.setInt(index++, externalValue.getAgent());
        insertExternalValueStmt.setInt(index++, externalValue.getOrgPosition());
        insertExternalValueStmt.setBoolean(index++, externalValue.isNull());
        this.setParametersForValue(externalValue.getValue(), element.getType(), insertExternalValueStmt, index);
        insertExternalValueStmt.executeUpdate();
    }

    private void storeDataValue(PreparedStatement insertDataValueStmt, DbArchiveDataElement element, DbArchiveDataValue dataValue) throws SQLException, IOException {
        insertDataValueStmt.clearParameters();
        int index = 1;
        insertDataValueStmt.setLong(index++, element.getInstanceID().getMostSignificantBits());
        insertDataValueStmt.setLong(index++, element.getInstanceID().getLeastSignificantBits());
        insertDataValueStmt.setInt(index++, element.getDataElementID());
        insertDataValueStmt.setInt(index++, dataValue.getNodeID());
        insertDataValueStmt.setInt(index++, dataValue.getIteration());
        insertDataValueStmt.setTimestamp(index++, dataValue.getCreateTime(), JDBCTools.createUTCCalendar());
        insertDataValueStmt.setInt(index++, dataValue.getAgent());
        insertDataValueStmt.setInt(index++, dataValue.getOrgPosition());
        insertDataValueStmt.setBoolean(index++, dataValue.isValid());
        insertDataValueStmt.setBoolean(index++, dataValue.isNull());
        this.setParametersForValue(dataValue.getValue(), element.getType(), insertDataValueStmt, index);
        insertDataValueStmt.executeUpdate();
    }

    private void setParametersForValue(Object value, ProcessConstants.AdeptDataType type, PreparedStatement stmt, int offset) throws SQLException, IOException {
        if (type == ProcessConstants.AdeptDataType.INTEGER && value instanceof Long) {
            stmt.setLong(offset + 0, (Long)value);
        } else if (type == ProcessConstants.AdeptDataType.DATE && value instanceof Date) {
            stmt.setLong(offset + 0, ((Date)value).getTime());
        } else {
            stmt.setNull(offset + 0, -5);
        }
        if (type == ProcessConstants.AdeptDataType.FLOAT && value instanceof Double) {
            stmt.setDouble(offset + 1, (Double)value);
        } else {
            stmt.setNull(offset + 1, 8);
        }
        if (type == ProcessConstants.AdeptDataType.BOOLEAN && value instanceof Boolean) {
            stmt.setBoolean(offset + 2, (Boolean)value);
        } else {
            stmt.setNull(offset + 2, -7);
        }
        if (type == ProcessConstants.AdeptDataType.STRING && value instanceof String) {
            stmt.setString(offset + 3, (String)value);
        } else {
            stmt.setNull(offset + 3, 12);
        }
        try {
            if (type == ProcessConstants.AdeptDataType.URI && value instanceof URI) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutput = new ObjectOutputStream(outputStream);
                objectOutput.writeObject(value);
                byte[] uriBytes = outputStream.toByteArray();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(uriBytes);
                stmt.setBinaryStream(offset + 4, (InputStream)inputStream, uriBytes.length);
            } else if (type == ProcessConstants.AdeptDataType.USERDEFINED && value instanceof byte[]) {
                int length = ((byte[])value).length;
                stmt.setBinaryStream(offset + 4, (InputStream)new ByteArrayInputStream((byte[])value), length);
            } else {
                stmt.setNull(offset + 4, 2004);
            }
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, "Could not write BLOB. " + ioe.getMessage());
            throw ioe;
        }
    }

    private boolean isLatestNull(DbArchiveDataElement element) {
        return this.getFirstValidValue(element).isNull();
    }

    private DbArchiveDataValue getFirstValidValue(DbArchiveDataElement element) {
        Iterator<DbArchiveDataValue> i = element.getDataValues();
        while (i.hasNext()) {
            DbArchiveDataValue value = i.next();
            if (!value.isValid()) continue;
            return value;
        }
        return null;
    }

    private boolean isNull(DbArchiveDataElement element) {
        Iterator<DbArchiveDataValue> i = element.getDataValues();
        while (i.hasNext()) {
            if (!i.next().isValid()) continue;
            return false;
        }
        return true;
    }

    private String getTypeRepresentaion(ProcessConstants.AdeptDataType type, String userDefinedType) {
        switch (type) {
            case BOOLEAN: {
                return "Boolean";
            }
            case INTEGER: {
                return "Integer";
            }
            case FLOAT: {
                return "Float";
            }
            case STRING: {
                return "String";
            }
            case DATE: {
                return "Date";
            }
            case URI: {
                return "URI";
            }
            case USERDEFINED: {
                return userDefinedType;
            }
        }
        return null;
    }
}

