/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.datamanager.dbimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataManager;
import de.aristaflow.adept2.core.logmanager.LogManager;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DbDataAccess {
    protected static final int INTEGERVALUE = 0;
    protected static final int FLOATVALUE = 1;
    protected static final int BOOLEANVALUE = 2;
    protected static final int STRINGVALUE = 3;
    protected static final int BLOBVALUE = 4;
    protected final Logger logger = LoggerTools.getLogger(this);
    protected DbDataManager dataManager;

    public DbDataAccess(DbDataManager dataManager) {
        this.dataManager = dataManager;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataManager.getDataSource();
    }

    protected LogManager getDataLogManager() {
        return this.dataManager.getDataLogManager();
    }

    protected Serializable getValueFrom(ResultSet rs, ProcessConstants.AdeptDataType type) throws SQLException {
        String dbField = DbDataAccess.getDBField(type);
        Object value = null;
        switch (type) {
            case BOOLEAN: {
                value = rs.getBoolean(dbField);
                break;
            }
            case FLOAT: {
                value = rs.getDouble(dbField);
                break;
            }
            case INTEGER: {
                value = rs.getLong(dbField);
                break;
            }
            case STRING: {
                value = rs.getString(dbField);
                if (value != null) break;
                value = "";
                break;
            }
            case DATE: {
                value = new Date(rs.getLong(dbField));
                break;
            }
            case URI: {
                InputStream blobInput = rs.getBinaryStream(dbField);
                if (blobInput == null) break;
                try {
                    ObjectInputStream objInput = new ObjectInputStream(blobInput);
                    Object res = objInput.readObject();
                    if (!(res instanceof URI)) {
                        String msg = "Object in database is not of type URI as it should be.";
                        throw new InternalServiceException(msg);
                    }
                    value = (URI)res;
                    break;
                }
                catch (IOException e) {
                    String msg = "IOException occurred.";
                    throw new InternalServiceException(msg, e);
                }
                catch (ClassNotFoundException e) {
                    String msg = "Object in database is not of type URI as it should be.";
                    throw new InternalServiceException(msg, e);
                }
            }
            case USERDEFINED: {
                String udtName = rs.getString("type");
                byte[] udtBytes = rs.getBytes(dbField);
                if (udtBytes == null) {
                    udtBytes = new byte[]{};
                }
                value = new ADEPT2UDTValue(udtName, udtBytes);
                break;
            }
            default: {
                throw new AssertionError((Object)type);
            }
        }
        return value;
    }

    protected void setParametersForValue(Object value, ProcessConstants.AdeptDataType expectedType, PreparedStatement stmt, int offset) throws SQLException, IOException {
        if (expectedType == ProcessConstants.AdeptDataType.INTEGER && value instanceof Long) {
            stmt.setLong(offset + 0, (Long)value);
        } else if (expectedType == ProcessConstants.AdeptDataType.DATE && value instanceof Date) {
            stmt.setLong(offset + 0, ((Date)value).getTime());
        } else {
            stmt.setNull(offset + 0, -5);
        }
        if (expectedType == ProcessConstants.AdeptDataType.FLOAT && value instanceof Double) {
            stmt.setDouble(offset + 1, (Double)value);
        } else {
            stmt.setNull(offset + 1, 8);
        }
        if (expectedType == ProcessConstants.AdeptDataType.BOOLEAN && value instanceof Boolean) {
            stmt.setBoolean(offset + 2, (Boolean)value);
        } else {
            stmt.setNull(offset + 2, -7);
        }
        if (expectedType == ProcessConstants.AdeptDataType.STRING && value instanceof String) {
            stmt.setString(offset + 3, (String)value);
        } else {
            stmt.setNull(offset + 3, 12);
        }
        try {
            if (expectedType == ProcessConstants.AdeptDataType.URI && value instanceof URI) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutput = new ObjectOutputStream(outputStream);
                objectOutput.writeObject(value);
                byte[] uriBytes = outputStream.toByteArray();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(uriBytes);
                stmt.setBinaryStream(offset + 4, (InputStream)inputStream, uriBytes.length);
            } else if (expectedType == ProcessConstants.AdeptDataType.USERDEFINED && value instanceof UDTValue) {
                InputStream is = ((UDTValue)value).getValueAsStream();
                int length = is.available();
                stmt.setBinaryStream(offset + 4, is, length);
            } else {
                stmt.setBytes(offset + 4, null);
            }
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, "Could not write BLOB.", ioe);
            throw ioe;
        }
    }

    protected boolean checkDataElementAndType(UUID instanceID, int dataElementID, ProcessConstants.AdeptDataType expectedType) throws InvalidDataTypeException {
        boolean bl;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            boolean exists;
            con = this.getDataSource().getConnection();
            UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
            String query = String.format("SELECT type FROM dataElements dE WHERE dE.instanceID_hi = %s AND dE.instanceID_lo = %s AND dE.dataElementID = %s", "?", "?", "?");
            stmt = con.prepareStatement(query);
            stmt.setLong(1, instanceLogID.getMostSignificantBits());
            stmt.setLong(2, instanceLogID.getLeastSignificantBits());
            stmt.setInt(3, dataElementID);
            rs = stmt.executeQuery();
            if (rs.next()) {
                String type = rs.getString("type");
                ProcessConstants.AdeptDataType actualType = DbDataAccess.getType(type);
                if (actualType != expectedType) {
                    throw new InvalidDataTypeException(instanceID, dataElementID, expectedType, actualType);
                }
                exists = true;
            } else {
                exists = false;
            }
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.close(con);
            bl = exists;
        }
        catch (SQLException e) {
            try {
                this.logSQLException(e, "checkDataElementAndType");
                throw new RuntimeException("Database access failed.", e);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        return bl;
    }

    protected void logSQLException(SQLException e, String function) {
        this.logger.log(Level.SEVERE, String.format("A SQLException occurred in function %s.", function), e);
    }

    protected static String getDBField(ProcessConstants.AdeptDataType type) {
        switch (type) {
            case BOOLEAN: {
                return "BooleanValue";
            }
            case INTEGER: 
            case DATE: {
                return "IntegerValue";
            }
            case FLOAT: {
                return "FloatValue";
            }
            case STRING: {
                return "StringValue";
            }
            case URI: 
            case USERDEFINED: {
                return "BLOBValue";
            }
        }
        return null;
    }

    protected static String getTypeRepresentation(ProcessConstants.AdeptDataType type) {
        switch (type) {
            case BOOLEAN: {
                return "Boolean";
            }
            case INTEGER: {
                return "Integer";
            }
            case FLOAT: {
                return "Float";
            }
            case STRING: {
                return "String";
            }
            case DATE: {
                return "Date";
            }
            case URI: {
                return "URI";
            }
        }
        return null;
    }

    protected static ProcessConstants.AdeptDataType getType(String typeRepresentation) {
        if (typeRepresentation.equals(DbDataAccess.getTypeRepresentation(ProcessConstants.AdeptDataType.BOOLEAN))) {
            return ProcessConstants.AdeptDataType.BOOLEAN;
        }
        if (typeRepresentation.equals(DbDataAccess.getTypeRepresentation(ProcessConstants.AdeptDataType.FLOAT))) {
            return ProcessConstants.AdeptDataType.FLOAT;
        }
        if (typeRepresentation.equals(DbDataAccess.getTypeRepresentation(ProcessConstants.AdeptDataType.INTEGER))) {
            return ProcessConstants.AdeptDataType.INTEGER;
        }
        if (typeRepresentation.equals(DbDataAccess.getTypeRepresentation(ProcessConstants.AdeptDataType.STRING))) {
            return ProcessConstants.AdeptDataType.STRING;
        }
        if (typeRepresentation.equals(DbDataAccess.getTypeRepresentation(ProcessConstants.AdeptDataType.DATE))) {
            return ProcessConstants.AdeptDataType.DATE;
        }
        if (typeRepresentation.equals(DbDataAccess.getTypeRepresentation(ProcessConstants.AdeptDataType.URI))) {
            return ProcessConstants.AdeptDataType.URI;
        }
        return ProcessConstants.AdeptDataType.USERDEFINED;
    }
}

