/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.datamanager.dbimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.AbstractMemoryBasedDataContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;

public class DbDataContainer
extends AbstractMemoryBasedDataContainer
implements DataContainer {
    private static final long serialVersionUID = 1251195012996374844L;
    private final UUID instanceID;
    private final int nodeID;
    private final int iteration;
    private final LinkedList<DataContainer.Savepoint> savePoints;

    public DbDataContainer(UUID instanceID, int nodeID, int nodeIteration, Map<String, ProcessConstants.AdeptDataType> inputTypes, Map<String, Serializable> inputValues, Map<String, ProcessConstants.AdeptDataType> outputTypes, Map<String, Serializable> outputValues, List<DataContainer.Savepoint> savepoints) {
        Serializable value;
        ProcessConstants.AdeptDataType dataType;
        String paramName;
        this.instanceID = instanceID;
        this.nodeID = nodeID;
        this.iteration = nodeIteration;
        for (Map.Entry<String, ProcessConstants.AdeptDataType> entry : inputTypes.entrySet()) {
            paramName = entry.getKey();
            dataType = entry.getValue();
            value = inputValues.get(paramName);
            this.addInParam(paramName, dataType, value);
        }
        for (Map.Entry<String, ProcessConstants.AdeptDataType> entry : outputTypes.entrySet()) {
            paramName = entry.getKey();
            dataType = entry.getValue();
            value = outputValues.get(paramName);
            this.addOutParam(paramName, dataType, value);
        }
        this.savePoints = new LinkedList<DataContainer.Savepoint>(savepoints);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isNull(SessionToken session, String parameterName) throws NoSuchParameterException {
        return this.getInParamNull(parameterName);
    }

    @Override
    public boolean retrieveBoolean(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (Boolean)this.getInParam(parameterName, ProcessConstants.AdeptDataType.BOOLEAN);
    }

    @Override
    public Date retrieveDate(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (Date)this.getInParam(parameterName, ProcessConstants.AdeptDataType.DATE);
    }

    @Override
    public double retrieveFloat(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (Double)this.getInParam(parameterName, ProcessConstants.AdeptDataType.FLOAT);
    }

    @Override
    public long retrieveInteger(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (Long)this.getInParam(parameterName, ProcessConstants.AdeptDataType.INTEGER);
    }

    @Override
    public String retrieveString(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (String)this.getInParam(parameterName, ProcessConstants.AdeptDataType.STRING);
    }

    @Override
    public UDTValue retrieveUDT(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (UDTValue)this.getInParam(parameterName, ProcessConstants.AdeptDataType.USERDEFINED);
    }

    @Override
    public URI retrieveURI(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (URI)this.getInParam(parameterName, ProcessConstants.AdeptDataType.URI);
    }

    @Override
    public void ignoreValue(SessionToken session, String parameterName) throws NoSuchParameterException {
        this.setOutParamNull(parameterName);
    }

    @Override
    public void storeBoolean(SessionToken session, String parameterName, boolean value) throws InvalidDataTypeException, NoSuchParameterException {
        this.setOutParam(parameterName, Boolean.valueOf(value));
    }

    @Override
    public void storeDate(SessionToken session, String parameterName, Date value) throws InvalidDataTypeException, NoSuchParameterException {
        this.setOutParam(parameterName, value);
    }

    @Override
    public void storeFloat(SessionToken session, String parameterName, double value) throws InvalidDataTypeException, NoSuchParameterException {
        this.setOutParam(parameterName, Double.valueOf(value));
    }

    @Override
    public void storeInteger(SessionToken session, String parameterName, long value) throws InvalidDataTypeException, NoSuchParameterException {
        this.setOutParam(parameterName, Long.valueOf(value));
    }

    @Override
    public void storeString(SessionToken session, String parameterName, String value) throws InvalidDataTypeException, NoSuchParameterException {
        this.setOutParam(parameterName, (Serializable)((Object)value));
    }

    @Override
    public void storeUDT(SessionToken session, String parameterName, UDTValue value) throws InvalidDataTypeException, NoSuchParameterException {
        this.setOutParam(parameterName, value);
    }

    @Override
    public void storeURI(SessionToken session, String parameterName, URI value) throws InvalidDataTypeException, NoSuchParameterException {
        this.setOutParam(parameterName, value);
    }

    @Override
    public boolean ignoredValue(String parameterName) throws NoSuchParameterException {
        return this.getOutParamNull(parameterName);
    }

    @Override
    public boolean storedBoolean(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (Boolean)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.BOOLEAN);
    }

    @Override
    public Date storedDate(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (Date)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.DATE);
    }

    @Override
    public double storedFloat(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (Double)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.FLOAT);
    }

    @Override
    public long storedInteger(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (Long)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.INTEGER);
    }

    @Override
    public String storedString(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (String)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.STRING);
    }

    @Override
    public UDTValue storedUDT(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (UDTValue)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.USERDEFINED);
    }

    @Override
    public URI storedURI(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (URI)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.URI);
    }

    @Override
    public void storeSessionState(SessionToken session, int savepointID, byte[] sessionState) {
        this.savePoints.add(new DataContainer.Savepoint(savepointID, sessionState));
    }

    @Override
    public byte[] restoreSessionState(SessionToken session, int savepointID) {
        byte[] sessionState = new byte[]{};
        for (DataContainer.Savepoint sp : this.savePoints) {
            if (sp.getSavepointID() != savepointID) continue;
            sessionState = sp.getSessionState();
            break;
        }
        return sessionState;
    }

    @Override
    public List<Integer> getStoredSavepoints(SessionToken session) {
        LinkedList<Integer> storedSavepoints = new LinkedList<Integer>();
        for (DataContainer.Savepoint sp : this.savePoints) {
            storedSavepoints.add(sp.getSavepointID());
        }
        return storedSavepoints;
    }

    @Override
    public int getLastSavepointID(SessionToken session) {
        int savepointID = -1;
        try {
            int i = this.savePoints.size();
            while (i > 0) {
                DataContainer.Savepoint current;
                if ((savepointID = (current = this.savePoints.get(--i)).getSavepointID()) >= Integer.MAX_VALUE) {
                    continue;
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            LoggerTools.getLogger(this).info("The method getLastSavepointID() was called without any stored session states.");
        }
        return savepointID;
    }

    @Override
    public UUID getInstanceID() {
        return this.instanceID;
    }

    @Override
    public int getNodeID() {
        return this.nodeID;
    }

    @Override
    public int getNodeIteration() {
        return this.iteration;
    }

    @Override
    public Collection<String> getUnsavedParameterNames() {
        return Collections.unmodifiableCollection(this.outParamsTypes.keySet());
    }

    @Override
    public List<DataContainer.Savepoint> getUnsavedSessions() {
        return Collections.unmodifiableList(this.savePoints);
    }

    @Override
    public Map<String, ProcessConstants.AdeptDataType> getUnsavedTypes() {
        return Collections.unmodifiableMap(this.outParamsTypes);
    }

    @Override
    public Collection<String> getUnsavedIgnoredParameters() {
        return Collections.unmodifiableCollection(this.outParamsNullValues);
    }

    @Override
    public Map<String, Serializable> getUnsavedValues() {
        return Collections.unmodifiableMap(this.outParamsValues);
    }
}

