/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.datamanager.dbimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.SQLTools;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.datamanager.ProcessUnawareAccess;
import de.aristaflow.adept2.core.datamanager.SessionStateManager;
import de.aristaflow.adept2.core.datamanager.UDFExecution;
import de.aristaflow.adept2.core.datamanager.UDTManager;
import de.aristaflow.adept2.core.datamanager.archive.dbimplementation.DbArchiveDataElement;
import de.aristaflow.adept2.core.datamanager.archive.dbimplementation.DbArchiveDataValue;
import de.aristaflow.adept2.core.datamanager.archive.dbimplementation.DbArchiveExternalValue;
import de.aristaflow.adept2.core.datamanager.archive.dbimplementation.DbDataManagerArchive;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataAccess;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbProcessAwareAccess;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbProcessUnAwareAccess;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbSessionStateManager;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbUDFExecution;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbUDTManager;
import de.aristaflow.adept2.core.logmanager.LogManager;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InstanceDataContainer;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.DefaultInstanceDataContainer;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.util.DataSourceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class DbDataManager
extends AbstractADEPT2Service
implements DataManager {
    protected JDBCDataSource dataSource;
    protected LogManager dataLogManager;
    protected ProcessAwareAccess processAwareAccess;
    protected ProcessUnawareAccess processUnawareAccess;
    protected SessionStateManager sessionStateManager;
    protected UDFExecution udfExecution;
    protected UDTManager udfManager;
    private SessionFactory sessionFactory;

    public DbDataManager(Configuration configuration, Registry registry) {
        super(configuration, registry, new String[]{"JDBCDataSource", "LogManager"}, new String[0]);
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        block17: {
            super.init(myURIs);
            try {
                this.sessionFactory = this.registry.getSecurityManager().authenticatePrivileged(-2L, -2L, "password");
            }
            catch (AuthenticationException ae) {
                throw new InternalServiceException("Failed to authenticate at the security manager due to wrongauthentication data. Check the configuration of this DataManager.", ae);
            }
            catch (DataSourceException dse) {
                throw new InternalServiceException("Failed to authenticate at the security manager due to unavailability of the data.", dse);
            }
            SessionToken session = this.sessionFactory.getSessionToken(myURIs);
            this.dataSource = this.registry.getServiceOfType(session, "JDBCDataSource", JDBCDataSource.class);
            this.dataLogManager = this.registry.getServiceOfType(session, "LogManager", LogManager.class);
            ExecutionFactory exFact = this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
            this.processAwareAccess = new DbProcessAwareAccess(this, exFact);
            exFact = this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
            this.processUnawareAccess = new DbProcessUnAwareAccess(this, exFact);
            this.sessionStateManager = new DbSessionStateManager(this);
            this.udfExecution = new DbUDFExecution(this);
            this.udfManager = new DbUDTManager(this);
            ExtendedConnection con = null;
            Statement stmt = null;
            try {
                con = this.getDataSource().getConnection();
                if (!con.tableExists("dataElements")) {
                    SQLTools.runSQLScriptQuietly(con, DbDataManager.class.getResourceAsStream("sqlscripts/dm-create.sql"));
                    SQLTools.runSQLScriptQuietly(con, DbDataManager.class.getResourceAsStream("sqlscripts/dm-types.sql"));
                    SQLTools.runSQLScriptQuietly(con, DbDataManager.class.getResourceAsStream("sqlscripts/dm-arc-create.sql"));
                } else {
                    stmt = con.createStatement();
                    String sql = "RENAME COLUMN %s.isNull TO isNull_";
                    if (con.columnExists("isNull", "dataValues")) {
                        stmt.executeUpdate(String.format(sql, "dataValues"));
                    }
                    if (con.columnExists("isNull", "externalDataValues")) {
                        stmt.executeUpdate(String.format(sql, "externalDataValues"));
                    }
                    if (con.columnExists("isNull", "dataElementsArchive")) {
                        stmt.executeUpdate(String.format(sql, "dataElementsArchive"));
                    }
                    if (con.columnExists("isNull", "dataValuesArchive")) {
                        stmt.executeUpdate(String.format(sql, "dataValuesArchive"));
                    }
                    if (con.columnExists("isNull", "externalDataValuesArchive")) {
                        stmt.executeUpdate(String.format(sql, "externalDataValuesArchive"));
                    }
                    stmt = JDBCTools.close(stmt);
                }
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                e.printStackTrace(System.out);
                JDBCTools.closeQuietly(con, stmt);
                break block17;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace(System.out);
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    JDBCTools.closeQuietly(con, stmt);
                }
            }
            JDBCTools.closeQuietly(con, stmt);
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.dataSource = null;
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        this.dataSource = null;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    protected LogManager getDataLogManager() {
        return this.dataLogManager;
    }

    @Override
    public ProcessAwareAccess getProcessAwareAccess() {
        return this.processAwareAccess;
    }

    @Override
    public ProcessUnawareAccess getProcessUnawareAccess() {
        return this.processUnawareAccess;
    }

    @Override
    public SessionStateManager getSessionStateManager() {
        return this.sessionStateManager;
    }

    @Override
    public UDFExecution getUDFExecution() {
        return this.udfExecution;
    }

    @Override
    public UDTManager getUDTManagement() {
        return this.udfManager;
    }

    @Override
    public void instanceStarted(SessionToken session, ExecutableInstance instance, DataContainer dataContainer) {
        super.sessionActive(session);
        ExtendedConnection con = null;
        PreparedStatement pstmt = null;
        try {
            try {
                con = this.getDataSource().getConnection();
                con.setAutoCommit(false);
                this.registerLogIDForInstanceID(con, instance.getID(), instance.getLogID());
                Set<DataElement> dataElems = instance.getTemplate().getDataElements();
                Set<Integer> existingDataElements = this.getDataElements(instance.getLogID(), con);
                if (existingDataElements.size() != 0) {
                    throw new IllegalStateException("When starting a process instance,there shouldn't be any already existing data elements for it!");
                }
                String query = String.format("INSERT INTO dataElements(instanceID_hi, instanceID_lo, dataElementID, type) VALUES(%s, %s, %s, %s) ", "?", "?", "?", "?");
                pstmt = con.prepareStatement(query);
                for (DataElement elem : dataElems) {
                    this.insertDataElement(instance.getLogID(), elem, pstmt);
                }
                if (dataContainer != null) {
                    this.storeInstanceDataContainer(instance.getLogID(), dataContainer, con);
                }
                con.commit();
                pstmt = JDBCTools.close(pstmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "SQLException in function instanceStartedOrChanged", e);
                throw new RuntimeException("Instance could not be stored to the database.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, pstmt);
            super.sessionFinished(session);
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)pstmt);
        super.sessionFinished(session);
    }

    @Override
    public DataContainer retrieveInstanceDataContainer(SessionToken session, Instance instance, boolean deletable) {
        super.sessionActive(session);
        ExtendedConnection con = null;
        try {
            con = this.getDataSource().getConnection();
            DataContainer container = this.loadInstanceDataContainer(instance.getLogID(), con);
            if (deletable) {
                this.deleteInstanceDataContainer(instance.getLogID(), con);
            }
            con = JDBCTools.close(con);
            DataContainer dataContainer = container;
            return dataContainer;
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, "A SQLException occurred.", e);
            throw new RuntimeException("Database access failed.", e);
        }
        finally {
            JDBCTools.closeQuietly(con);
            super.sessionFinished(session);
        }
    }

    @Override
    public void instanceChanged(SessionToken session, Instance instance) {
        super.sessionActive(session);
        ExtendedConnection con = null;
        PreparedStatement insertStmt = null;
        PreparedStatement deleteStmt = null;
        try {
            try {
                con = this.getDataSource().getConnection();
                con.setAutoCommit(false);
                this.registerLogIDForInstanceID(con, instance.getID(), instance.getLogID());
                Set<DataElement> dataElements = instance.getTemplate().getDataElements();
                Set<Integer> existingDataElements = this.getDataElements(instance.getLogID(), con);
                String insertQuery = String.format("INSERT INTO dataElements(instanceID_hi, instanceID_lo, dataElementID, type) VALUES(%s, %s, %s, %s) ", "?", "?", "?", "?");
                insertStmt = con.prepareStatement(insertQuery);
                String deleteQuery = String.format("DELETE FROM dataElements WHERE instanceID_hi = %s AND instanceID_lo = %s AND dataElementID = %s", "?", "?", "?");
                deleteStmt = con.prepareStatement(deleteQuery);
                for (DataElement elem : dataElements) {
                    boolean exists = existingDataElements.remove(elem.getID());
                    if (exists) {
                        this.deleteDataElement(instance.getLogID(), elem.getID(), deleteStmt);
                        this.insertDataElement(instance.getLogID(), elem, insertStmt);
                        continue;
                    }
                    this.insertDataElement(instance.getLogID(), elem, insertStmt);
                }
                Iterator<Object> iterator = existingDataElements.iterator();
                while (iterator.hasNext()) {
                    int dataElementID = (Integer)iterator.next();
                    this.deleteDataElement(instance.getLogID(), dataElementID, deleteStmt);
                }
                insertStmt = JDBCTools.close(insertStmt);
                deleteStmt = JDBCTools.close(deleteStmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "SQLException in function instanceStartedOrChanged", e);
                throw new RuntimeException("Instance could not be stored to the database.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(insertStmt, deleteStmt);
            JDBCTools.closeQuietly(con);
            super.sessionFinished(session);
            throw throwable;
        }
        JDBCTools.closeQuietly(insertStmt, deleteStmt);
        JDBCTools.closeQuietly(con);
        super.sessionFinished(session);
    }

    @Override
    public void instanceChanged(SessionToken session, Instance instance, DataContainer changedDataContainer) {
        super.sessionActive(session);
        this.instanceChanged(session, instance);
        ExtendedConnection con = null;
        try {
            try {
                con = this.getDataSource().getConnection();
                con.setAutoCommit(false);
                this.deleteInstanceDataContainer(instance.getLogID(), con);
                if (changedDataContainer != null) {
                    this.storeInstanceDataContainer(instance.getLogID(), changedDataContainer, con);
                }
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "SQLException in function instanceStartedOrChanged", e);
                throw new RuntimeException("Instance could not be stored to the database.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con);
            super.sessionFinished(session);
            throw throwable;
        }
        JDBCTools.closeQuietly(con);
        super.sessionFinished(session);
    }

    @Override
    public void instanceTerminated(SessionToken session, ExecutableInstance instance, DataContainer dataContainer) {
        super.sessionActive(session);
        ExtendedConnection con = null;
        try {
            try {
                con = this.getDataSource().getConnection();
                con.setAutoCommit(false);
                this.deleteInstanceDataContainer(instance.getLogID(), con);
                if (dataContainer != null) {
                    this.storeInstanceDataContainer(instance.getLogID(), dataContainer, con);
                }
                con.commit();
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "SQLException in function instanceStartedOrChanged", e);
                throw new RuntimeException("Instance could not be stored to the database.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con);
            super.sessionFinished(session);
            throw throwable;
        }
        JDBCTools.closeQuietly(con);
        super.sessionFinished(session);
    }

    public void archiveInstance(UUID instanceID) {
        ExtendedConnection con = null;
        try {
            try {
                con = this.getDataSource().getConnection();
                List<DbArchiveDataElement> dataElements = this.readDataElements(instanceID, con);
                DbDataManagerArchive archive = new DbDataManagerArchive(this.getDataSource());
                archive.archiveDataElements(dataElements);
                this.logger.log(Level.INFO, String.format("Data elements for instance with ID %s has been archived and will now be deleted.", "" + instanceID));
                con.setAutoCommit(false);
                UUID instanceLogID = this.getLogIDForInstanceID(con, instanceID);
                Statement deleteElementsStmt = null;
                try {
                    String query = String.format("DELETE FROM dataElements WHERE instanceID_hi = %s AND instanceID_lo = %s", "?", "?");
                    deleteElementsStmt = con.prepareStatement(query);
                    deleteElementsStmt.setLong(1, instanceLogID.getMostSignificantBits());
                    deleteElementsStmt.setLong(2, instanceLogID.getLeastSignificantBits());
                    deleteElementsStmt.executeUpdate();
                }
                finally {
                    if (deleteElementsStmt != null) {
                        deleteElementsStmt.close();
                    }
                }
                Statement deleteSavepointsStmt = null;
                try {
                    String query = String.format("DELETE FROM savepoints WHERE instanceID_hi = %s AND instanceID_lo = %s", "?", "?");
                    deleteSavepointsStmt = con.prepareStatement(query);
                    deleteSavepointsStmt.setLong(1, instanceLogID.getMostSignificantBits());
                    deleteSavepointsStmt.setLong(2, instanceLogID.getLeastSignificantBits());
                    deleteSavepointsStmt.executeUpdate();
                }
                finally {
                    if (deleteSavepointsStmt != null) {
                        deleteSavepointsStmt.close();
                    }
                }
                con.commit();
                this.logger.log(Level.INFO, String.format("Data elements for instance with ID %s has been deleted because they were archived.", "" + instanceLogID));
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Could not connect to database.", e);
                throw new RuntimeException("Could not connect to database.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con);
            throw throwable;
        }
        JDBCTools.closeQuietly(con);
    }

    private Set<Integer> getDataElements(UUID instanceLogID, Connection con) {
        HashSet<Integer> dataElements = new HashSet<Integer>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String query = String.format("SELECT dataElementID, type FROM dataElements dE WHERE instanceID_hi = %s AND instanceID_lo = %s", "?", "?");
                pstmt = con.prepareStatement(query);
                pstmt.setLong(1, instanceLogID.getMostSignificantBits());
                pstmt.setLong(2, instanceLogID.getLeastSignificantBits());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    Integer value = rs.getInt("dataElementID");
                    dataElements.add(value);
                }
                rs = JDBCTools.close(rs);
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "SQLExcpetion in function getDataElements", e);
                throw new RuntimeException("SQL Exception occurred while retrieving data elements. ", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return dataElements;
    }

    private void storeInstanceDataContainer(UUID instanceLogID, DataContainer dataContainer, ExtendedConnection con) {
        String sql = String.format("INSERT INTO instanceDataContainers(instanceID_hi, instanceID_lo, dataContainer) VALUES(%s, %s, %s) ", "?", "?", "?");
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(sql);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream objOut = new ObjectOutputStream(out);
                objOut.writeObject(dataContainer);
                objOut.close();
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                pstmt.setLong(1, instanceLogID.getMostSignificantBits());
                pstmt.setLong(2, instanceLogID.getLeastSignificantBits());
                pstmt.setBinaryStream(3, (InputStream)in, ((InputStream)in).available());
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Database access failed.", e);
                throw new RuntimeException("Database access failed.", e);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "DataContainer could not be serialised.", e);
                throw new RuntimeException("DataContainer could not be serialised.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataContainer loadInstanceDataContainer(UUID instanceLogID, ExtendedConnection con) {
        DataContainer dataContainer;
        DataContainer res = null;
        String sql = String.format("SELECT dataContainer FROM instanceDataContainers WHERE instanceID_hi = %s AND instanceID_lo = %s", "?", "?");
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            InputStream binaryStream;
            pstmt = con.prepareStatement(sql);
            pstmt.setLong(1, instanceLogID.getMostSignificantBits());
            pstmt.setLong(2, instanceLogID.getLeastSignificantBits());
            rs = pstmt.executeQuery();
            if (rs.next() && (binaryStream = rs.getBinaryStream("dataContainer")) != null) {
                ObjectInputStream stream = new ObjectInputStream(binaryStream);
                Object o = stream.readObject();
                stream.close();
                if (o != null && o instanceof DataContainer) {
                    res = (DataContainer)o;
                } else {
                    this.logger.log(Level.SEVERE, "Deserialised object is not a data container.");
                    throw new RuntimeException("Deserialised object is not a data container.");
                }
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            dataContainer = res;
        }
        catch (SQLException e) {
            try {
                this.logger.log(Level.SEVERE, "SQLException occurred.", e);
                throw new RuntimeException("Database access failed.", e);
                catch (IOException e2) {
                    this.logger.log(Level.SEVERE, "IOException occurred. ", e2);
                    throw new RuntimeException("Data container could not be deserialised.", e2);
                }
                catch (ClassNotFoundException e3) {
                    this.logger.log(Level.SEVERE, "ClassNotFoundException occurred.", e3);
                    throw new RuntimeException("DataContainer class not found.", e3);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return dataContainer;
    }

    private void deleteInstanceDataContainer(UUID instanceLogID, ExtendedConnection con) {
        String sql = String.format("DELETE FROM instanceDataContainers WHERE instanceID_hi = %s AND instanceID_lo = %s", "?", "?");
        PreparedStatement stmt = null;
        try {
            try {
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                stmt.executeUpdate();
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "SQLException occurred.", e);
                throw new RuntimeException("Database access failed.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    private void insertDataElement(UUID instanceLogID, DataElement elem, PreparedStatement insertDataElementStmt) throws SQLException {
        int dataElementID = elem.getID();
        ProcessConstants.AdeptDataType type = elem.getDataType();
        String typeRepresentation = type == ProcessConstants.AdeptDataType.USERDEFINED ? elem.getUDTName() : DbDataAccess.getTypeRepresentation(type);
        insertDataElementStmt.clearParameters();
        insertDataElementStmt.setLong(1, instanceLogID.getMostSignificantBits());
        insertDataElementStmt.setLong(2, instanceLogID.getLeastSignificantBits());
        insertDataElementStmt.setInt(3, dataElementID);
        insertDataElementStmt.setString(4, typeRepresentation);
        insertDataElementStmt.executeUpdate();
    }

    private void deleteDataElement(UUID instanceLogID, int dataElementID, PreparedStatement deleteDataElementStmt) throws SQLException {
        deleteDataElementStmt.clearParameters();
        deleteDataElementStmt.setLong(1, instanceLogID.getMostSignificantBits());
        deleteDataElementStmt.setLong(2, instanceLogID.getLeastSignificantBits());
        deleteDataElementStmt.setInt(3, dataElementID);
        deleteDataElementStmt.executeUpdate();
    }

    private List<DbArchiveDataElement> readDataElements(UUID instanceLogID, ExtendedConnection con) {
        ArrayList<DbArchiveDataElement> arrayList;
        ArrayList<DbArchiveDataElement> elements = new ArrayList<DbArchiveDataElement>();
        PreparedStatement dataElementsStmt = null;
        ResultSet rs = null;
        try {
            String query = String.format("SELECT dataElementID, type FROM dataElements dE WHERE instanceID_hi = %s AND instanceID_lo = %s", "?", "?");
            dataElementsStmt = con.prepareStatement(query);
            query = String.format("SELECT nodeID, iteration, createTime, agent, orgPosition, isNull_, valid, IntegerValue, BooleanValue, FloatValue, StringValue, BLOBValue FROM dataValues WHERE instanceID_hi = %s AND instanceID_lo = %s AND dataElementID = %s ORDER BY createTime DESC", "?", "?", "?");
            PreparedStatement dataValuesStmt = con.prepareStatement(query);
            query = String.format("SELECT createTime, agent, orgPosition, isNull_, IntegerValue, BooleanValue, FloatValue, StringValue, BLOBValue FROM externalDataValues WHERE instanceID_hi = %s AND instanceID_lo = %s AND dataElementID = %s ORDER BY createTime DESC", "?", "?", "?");
            PreparedStatement dataExternalValuesStmt = con.prepareStatement(query);
            dataElementsStmt.setLong(1, instanceLogID.getMostSignificantBits());
            dataElementsStmt.setLong(2, instanceLogID.getLeastSignificantBits());
            rs = dataElementsStmt.executeQuery();
            while (rs.next()) {
                int dataElementID = rs.getInt("dataElementID");
                ProcessConstants.AdeptDataType type = DbDataAccess.getType(rs.getString("type"));
                String userDefinedType = null;
                if (type == ProcessConstants.AdeptDataType.USERDEFINED) {
                    userDefinedType = rs.getString("type");
                }
                List<DbArchiveDataValue> dataValues = this.readDataValues(instanceLogID, dataElementID, type, dataValuesStmt);
                List<DbArchiveExternalValue> externalValues = this.readExternalValues(instanceLogID, dataElementID, type, dataExternalValuesStmt);
                DbArchiveDataElement archiveElement = new DbArchiveDataElement(instanceLogID, dataElementID, type, userDefinedType, dataValues, externalValues);
                elements.add(archiveElement);
            }
            rs = JDBCTools.close(rs);
            dataElementsStmt = JDBCTools.close(dataElementsStmt);
            arrayList = elements;
        }
        catch (SQLException e) {
            try {
                this.logger.log(Level.SEVERE, "SQLExcpetion in function getDataElements", e);
                throw new RuntimeException("SQL Exception occurred while retrieving data elements. ", e);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(dataElementsStmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)dataElementsStmt, rs);
        return arrayList;
    }

    private List<DbArchiveExternalValue> readExternalValues(UUID instanceLogID, int dataElementID, ProcessConstants.AdeptDataType type, PreparedStatement externalValuesStmt) {
        ArrayList<DbArchiveExternalValue> dataValues = new ArrayList<DbArchiveExternalValue>();
        ResultSet rs = null;
        try {
            try {
                externalValuesStmt.clearParameters();
                externalValuesStmt.setLong(1, instanceLogID.getMostSignificantBits());
                externalValuesStmt.setLong(2, instanceLogID.getLeastSignificantBits());
                externalValuesStmt.setLong(3, dataElementID);
                rs = externalValuesStmt.executeQuery();
                while (rs.next()) {
                    Timestamp createTime = rs.getTimestamp("createTime", JDBCTools.createUTCCalendar());
                    int agent = rs.getInt("agent");
                    int orgPosition = rs.getInt("orgPosition");
                    boolean isNull = rs.getBoolean("isNull_");
                    Object value = this.readValue(rs, type);
                    DbArchiveExternalValue dataValue = new DbArchiveExternalValue(createTime, agent, orgPosition, isNull, value);
                    dataValues.add(dataValue);
                }
                rs = JDBCTools.close(rs);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "SQLException occurred while reading data values.", e);
                throw new RuntimeException("SQLException occurred while reading data values.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(rs);
        return dataValues;
    }

    private List<DbArchiveDataValue> readDataValues(UUID instanceLogID, int dataElementID, ProcessConstants.AdeptDataType type, PreparedStatement dataValuesStmt) {
        ArrayList<DbArchiveDataValue> dataValues = new ArrayList<DbArchiveDataValue>();
        ResultSet rs = null;
        try {
            try {
                dataValuesStmt.clearParameters();
                dataValuesStmt.setLong(1, instanceLogID.getMostSignificantBits());
                dataValuesStmt.setLong(2, instanceLogID.getLeastSignificantBits());
                dataValuesStmt.setLong(3, dataElementID);
                rs = dataValuesStmt.executeQuery();
                while (rs.next()) {
                    int nodeID = rs.getInt("nodeID");
                    int iteration = rs.getInt("iteration");
                    Timestamp createTime = rs.getTimestamp("createTime", JDBCTools.createUTCCalendar());
                    int agent = rs.getInt("agent");
                    int orgPosition = rs.getInt("orgPosition");
                    boolean isNull = rs.getBoolean("isNull_");
                    boolean valid = rs.getBoolean("valid");
                    Object value = this.readValue(rs, type);
                    DbArchiveDataValue dataValue = new DbArchiveDataValue(nodeID, iteration, createTime, agent, orgPosition, isNull, valid, value);
                    dataValues.add(dataValue);
                }
                rs = JDBCTools.close(rs);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "SQLException occurred while reading data values.", e);
                throw new RuntimeException("SQLException occurred while reading data values. ", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(rs);
        return dataValues;
    }

    private Object readValue(ResultSet rsValues, ProcessConstants.AdeptDataType type) {
        Object value = null;
        String dbField = DbDataAccess.getDBField(type);
        try {
            switch (type) {
                case BOOLEAN: {
                    value = rsValues.getBoolean(dbField);
                    break;
                }
                case INTEGER: 
                case DATE: {
                    value = rsValues.getLong(dbField);
                    break;
                }
                case FLOAT: {
                    value = rsValues.getDouble(dbField);
                    break;
                }
                case STRING: {
                    value = rsValues.getString(dbField);
                    break;
                }
                case URI: {
                    try {
                        ObjectInputStream ois = new ObjectInputStream(rsValues.getBinaryStream(dbField));
                        value = ois.readObject();
                        if (!(value instanceof URI)) {
                            this.logger.log(Level.WARNING, "Value should be of type URI but is not.");
                            throw new RuntimeException("Value should be of type URI but is not.");
                        }
                        break;
                    }
                    catch (IOException e) {
                        this.logger.log(Level.WARNING, "IOException occurred while reading URI from database.", e);
                        throw new RuntimeException("IOException occurred while reading URI from database. ", e);
                    }
                    catch (ClassNotFoundException e) {
                        this.logger.log(Level.WARNING, e.getMessage(), e);
                        throw new RuntimeException("URI could not be read from database.", e);
                    }
                }
                case USERDEFINED: {
                    value = rsValues.getBytes(dbField);
                    break;
                }
                default: {
                    String msg = String.format("Unexpected data type '%s' occurred!", new Object[]{type});
                    this.logger.warning(msg);
                    break;
                }
            }
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, "Value could not be read.", e);
            throw new RuntimeException("Value could not be read.", e);
        }
        return value;
    }

    @Override
    public InstanceDataContainer createInstanceDataContainer(SessionToken session, Template template) {
        return new DefaultInstanceDataContainer(template);
    }

    @Override
    public URI[] getDataLogManager(SessionToken session) {
        return this.dataLogManager.getURIs();
    }

    void registerLogIDForInstanceID(Connection con, UUID instanceID, UUID instanceLogID) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            String sql = "INSERT INTO instanceIDMapping (instanceID_hi, instanceID_lo, instanceLogID_hi, instanceLogID_lo) VALUES(%d, %d, %d, %d)";
            sql = String.format(sql, instanceID.getMostSignificantBits(), instanceID.getLeastSignificantBits(), instanceLogID.getMostSignificantBits(), instanceLogID.getLeastSignificantBits());
            stmt.executeUpdate(sql);
            stmt = JDBCTools.close(stmt);
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    UUID getLogIDForInstanceID(Connection con, UUID instanceID) throws SQLException {
        UUID uUID;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            String sql = "SELECT instanceLogID_hi, instanceLogID_lo FROM instanceIDMapping WHERE instanceID_hi = %d AND instanceID_lo = %d";
            sql = String.format(sql, instanceID.getMostSignificantBits(), instanceID.getLeastSignificantBits());
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                String msg = "The instance ID '%s' is unknown to this data manager!";
                msg = String.format(msg, instanceID);
                throw new RuntimeException(msg);
            }
            UUID instanceLogID = new UUID(rs.getLong("instanceLogID_hi"), rs.getLong("instanceLogID_lo"));
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            uUID = instanceLogID;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(stmt, rs);
        return uUID;
    }

    public QualifiedAgent checkAndGetTopLevelAgent(SessionToken sessionToken) {
        super.sessionActive(sessionToken);
        try {
            QualifiedAgent qualifiedAgent = this.sessionFactory.checkAndGetTopLevelAgent(sessionToken);
            return qualifiedAgent;
        }
        catch (SecurityTokenIntegrityException e) {
            throw new ServiceAccessControlException("The agent could not be retrieved from the session token!", e);
        }
        finally {
            super.sessionFinished(sessionToken);
        }
    }
}

