/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.datamanager.dbimplementation;

import de.aristaflow.adept2.util.StringTools;
import java.util.Collection;
import java.util.List;

class DbDataManagerSQLHelper {
    static final String dbDataAccess_retriveDataElementType = "SELECT type FROM dataElements dE WHERE dE.instanceID_hi = %s AND dE.instanceID_lo = %s AND dE.dataElementID = %s";
    private static final String dbProcessAwareAccess_DefaultWhereClause = "WHERE dv.instanceID_hi = %s AND dv.instanceID_lo = %s AND dv.dataElementID = %s AND (dv.valid <> 0 OR ( dv.nodeID = %s AND dv.iteration = %s ) )";
    static final String dbProcessAwareAccess_isNull = "SELECT isNull_ as value FROM dataValues dV WHERE dv.instanceID_hi = %s AND dv.instanceID_lo = %s AND dv.dataElementID = %s AND (dv.valid <> 0 OR ( dv.nodeID = %s AND dv.iteration = %s ) ) ORDER BY createTime DESC";
    static final String dbDataManager_getDataElements = "SELECT dataElementID, type FROM dataElements dE WHERE instanceID_hi = %s AND instanceID_lo = %s";
    static final String dbDataManager_insertDataElement = "INSERT INTO dataElements(instanceID_hi, instanceID_lo, dataElementID, type) VALUES(%s, %s, %s, %s) ";
    static final String dbDataManager_deleteDataElement = "DELETE FROM dataElements WHERE instanceID_hi = %s AND instanceID_lo = %s AND dataElementID = %s";
    static final String dbDataManager_retrieveValues = "SELECT nodeID, iteration, createTime, agent, orgPosition, isNull_, valid, IntegerValue, BooleanValue, FloatValue, StringValue, BLOBValue FROM dataValues WHERE instanceID_hi = %s AND instanceID_lo = %s AND dataElementID = %s ORDER BY createTime DESC";
    static final String dbDataManager_retrieveExternalValues = "SELECT createTime, agent, orgPosition, isNull_, IntegerValue, BooleanValue, FloatValue, StringValue, BLOBValue FROM externalDataValues WHERE instanceID_hi = %s AND instanceID_lo = %s AND dataElementID = %s ORDER BY createTime DESC";
    static final String dbDataManager_deleteInstance = "DELETE FROM dataElements WHERE instanceID_hi = %s AND instanceID_lo = %s";
    static final String dbDataManager_deleteSavepoints = "DELETE FROM savepoints WHERE instanceID_hi = %s AND instanceID_lo = %s";
    static final String dbDataManager_insertDataContainer = "INSERT INTO instanceDataContainers(instanceID_hi, instanceID_lo, dataContainer) VALUES(%s, %s, %s) ";
    static final String dbDataManager_loadDataContainer = "SELECT dataContainer FROM instanceDataContainers WHERE instanceID_hi = %s AND instanceID_lo = %s";
    static final String dbDataManager_deleteDataContainer = "DELETE FROM instanceDataContainers WHERE instanceID_hi = %s AND instanceID_lo = %s";
    static final String dbProcessAwareAccess_retrieveWhetherDateValueIsAlreadySet = "SELECT valid FROM dataValues WHERE instanceID_hi = %s AND instanceID_lo = %s AND dataElementID = %s AND nodeID = %s AND iteration = %s ";
    static final String dbProcessAwareAccess_insertDataValue = "INSERT INTO dataValues(instanceID_hi, instanceID_lo, dataElementID, nodeID, iteration, createTime, agent, orgPosition, isNull_, IntegerValue, FloatValue, BooleanValue, StringValue, BLOBValue) VALUES(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s) ";
    static final String dbProcessAwareAccess_updateDataValue = "UPDATE dataValues SET createTime = %s, agent = %s, orgPosition = %s, isNull_ = %s, IntegerValue = %s, FloatValue = %s, BooleanValue = %s, StringValue = %s, BLOBValue = %s WHERE instanceID_hi = %s AND instanceID_lo = %s AND dataElementID = %s AND nodeID = %s AND iteration = %s ";
    static final String dbProcessAwareAccess_retrieveValue = "SELECT IntegerValue, BooleanValue, FloatValue, StringValue, BLOBValue, dE.type AS type FROM dataElements dE JOIN dataValues dV ON dE.instanceID_hi = dV.instanceID_hi AND dE.instanceID_lo = dV.instanceID_lo AND dE.dataElementID = dV.dataElementID WHERE dv.instanceID_hi = %s AND dv.instanceID_lo = %s AND dv.dataElementID = %s AND (dv.valid <> 0 OR ( dv.nodeID = %s AND dv.iteration = %s ) ) ORDER BY createTime DESC";
    static final String dbProcessAwareAccess_naiveRetrieveValue = "SELECT type, isNull_, BooleanValue, IntegerValue, FloatValue,       StringValue, BLOBvalue FROM dataValues dV    JOIN dataElements dE ON dV.instanceID_hi = dE.instanceID_hi AND dV.instanceID_lo = dE.instanceID_lo AND         dV.dataElementID = dE.dataElementID  WHERE dE.instanceID_hi = ? AND dE.instanceID_lo = ? AND dE.dataElementID = ? AND        nodeID = ? AND iteration = ? AND valid = ?";
    private static final String dbProcessAwareAccess_getPublicDataContext_start = "SELECT dE.dataElementID, dE.type AS type, isNull_, IntegerValue, BooleanValue, FloatValue, StringValue, BLOBValue  FROM dataElements dE    JOIN dataValues dV ON dE.instanceID_hi = dV.instanceID_hi AND dE.instanceID_lo = dV.instanceID_lo AND dE.dataElementID = dV.dataElementID  WHERE dv.instanceID_hi = ? AND dv.instanceID_lo = ? AND dv.dataElementID IN (";
    private static final String dbProcessAwareAccess_getPublicDataContext_end = ") AND dv.valid <> 0    AND createTime = (SELECT MAX(createTime) FROM dataValues WHERE instanceID_hi = ? AND instanceID_lo = ? AND dataElementID = dV.dataElementID AND valid <> 0 )";
    private static final String dbProcessAwareAccess_newDataContainer_end = ") AND (dv.valid <> 0 OR (dv.nodeID = ? AND dv.iteration = ?))    AND createTime = (SELECT MAX(createTime) FROM dataValues WHERE instanceID_hi = ? AND instanceID_lo = ? AND dataElementID = dV.dataElementID AND (dv.valid <> 0 OR (dv.nodeID = ? AND dv.iteration = ?)))";
    static final String dbProcessAwareAccess_validateWrittenValues = "UPDATE dataValues SET valid = 1 WHERE instanceID_hi = %s AND instanceID_lo = %s AND nodeID = %s AND iteration = %s";
    static final String dbProcessAwareAccess_discardInvalidWrittenValue = "DELETE FROM dataValues WHERE instanceID_hi = %s AND instanceID_lo = %s AND dataElementID = %s AND nodeID = %s AND iteration = %s AND valid = 0";
    static final String dbProcessAwareAccess_removeInvalidWrittenValues = "DELETE FROM dataValues WHERE instanceID_hi = %s AND instanceID_lo = %s AND nodeID = %s AND iteration = %s AND valid = 0";
    private static String dbProcessUnAwareAccess_defaultExternalWhereClause = "WHERE eV.instanceID_hi = %s AND eV.instanceID_lo = %s AND eV.dataElementID = %s ";
    static final String dbProcessUnAwareAccess_isExternalNull = "SELECT isNull_ AS value FROM externalDataValues eV " + dbProcessUnAwareAccess_defaultExternalWhereClause + " ORDER BY createTime DESC";
    static final String dbProcessUnAwareAccess_retrieveExternalValue = "SELECT IntegerValue, BooleanValue, FloatValue, StringValue, BLOBValue, dE.type AS type FROM dataElements dE JOIN externalDataValues eV ON dE.instanceID_hi = eV.instanceID_hi AND dE.instanceID_lo = eV.instanceID_lo AND dE.dataElementID = eV.dataElementID " + dbProcessUnAwareAccess_defaultExternalWhereClause + " ORDER BY createTime DESC";
    static final String dbProcessUnAwareAccess_insertExternalDataValue = "INSERT INTO externalDataValues(instanceID_hi, instanceID_lo, dataElementID, createTime, agent, orgPosition, isNull_, IntegerValue, FloatValue, BooleanValue, StringValue, BLOBValue) VALUES(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s) ";
    private static String dbProcessUnAwareAccess_defaultLatestWhereClause = "WHERE dV.instanceID_hi = %s AND dV.instanceID_lo = %s AND dV.dataElementID = %s AND dV.Valid <> 0 ";
    static final String dbProcessUnAwareAccess_isLatestNull = "SELECT isNull_ AS value FROM dataValues dV " + dbProcessUnAwareAccess_defaultLatestWhereClause + " ORDER BY createTime DESC";
    static final String dbProcessUnAwareAccess_retrieveLatestValue = "SELECT IntegerValue, BooleanValue, FloatValue, StringValue, BLOBValue, dE.type AS type FROM dataElements dE JOIN dataValues dV ON dE.instanceID_hi = dV.instanceID_hi AND dE.instanceID_lo = dV.instanceID_lo AND dE.dataElementID = dV.dataElementID " + dbProcessUnAwareAccess_defaultLatestWhereClause + " ORDER BY createTime DESC";
    private static final String dbSessionStateManager_defaultWhere = " WHERE sp.instanceID_hi = %s AND sp.instanceID_lo = %s AND sp.nodeID = %s AND sp.iteration = %s ";
    static final String dbSessionStateManager_getSavePointIDs = "SELECT savePointID AS id FROM savepoints sp  WHERE sp.instanceID_hi = %s AND sp.instanceID_lo = %s AND sp.nodeID = %s AND sp.iteration = %s  ORDER BY createTime DESC";
    static final String dbSessionStateManager_retrieveSessionState = "SELECT sessionState AS state FROM savepoints sp  WHERE sp.instanceID_hi = %s AND sp.instanceID_lo = %s AND sp.nodeID = %s AND sp.iteration = %s  AND savePointID = %s";
    static final String dbSessionStateManager_storeSessionState = "INSERT INTO savepoints (savePointID, instanceID_hi, instanceID_lo, nodeID, iteration, createTime, sessionState, agent, orgPosition) VALUES(%s, %s, %s, %s, %s, %s, %s, %s, %s)";
    static final String dbSessionStateManager_updateSessionState = "UPDATE savepoints SET createTime = %s, sessionState = %s, agent = %s, orgPosition = %s WHERE savePointID = %s AND instanceID_hi = %s AND instanceID_lo = %s AND nodeID = %s AND iteration = %s";
    static final String dbDataManager_deleteSavepointsOfNodeIteration = "DELETE FROM savepoints WHERE instanceID_hi = %s AND instanceID_lo = %s AND nodeID = %s AND iteration = %s";
    static final String dbUDTManager_getDataType = "SELECT dT.dataType, count(dE.dataElementID) as cnt FROM dataTypes dT LEFT OUTER JOIN dataElements dE ON dT.dataType = dE.type WHERE dT.dataType = %s GROUP BY dT.dataType";
    static final String dbUDTManager_insertDataType = "INSERT INTO dataTypes(dataType, isUserDefined) VALUES(%s, 1)";
    static final String dbUDTManager_deleteDataType = "DELETE FROM dataTypes WHERE dataType = %s AND  isUserDefined <> 0";
    static final String dbUDTManager_insertUDF = "INSERT INTO userDefinedFunctions(userDefinedType, functionName, returnType, body, language) VALUES(%s, %s, %s, %s, %s)";
    static final String dbUDTManager_existsUDF = "SELECT COUNT(userDefinedType) as cnt FROM userDefinedFunctions WHERE userDefinedType = %s AND functionName = %s ";
    static final String dbUDTManager_deleteUDF = "DELETE FROM userDefinedFunctions WHERE userDefinedType = %s AND functionName = %s ";
    static final String dbUDFExecution_retrieveUDFInfo = "SELECT returnType, function, language FROM userDefinedFunctions WHERE userDefinedType = %s AND functionName = %s ";

    DbDataManagerSQLHelper() {
    }

    static String dbProcessAwareAccess_getPublicDataContext(List<Integer> dataElementIDs) {
        String deIDs = StringTools.join(", ", dataElementIDs.toArray());
        return dbProcessAwareAccess_getPublicDataContext_start + deIDs + dbProcessAwareAccess_getPublicDataContext_end;
    }

    static String dbProcessAwareAccess_newDataContainer(Collection<Integer> dataElementIDs) {
        String deIDs = StringTools.join(", ", dataElementIDs.toArray());
        return dbProcessAwareAccess_getPublicDataContext_start + deIDs + dbProcessAwareAccess_newDataContainer_end;
    }
}

