/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.datamanager.dbimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.datamanager.SessionStateManager;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataAccess;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataContainer;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataManager;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataManagerSQLHelper;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.MandatoryParameterValueNotSetException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.logmanagement.LogEntrySet;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.types.Pair;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbProcessAwareAccess
extends DbDataAccess
implements ProcessAwareAccess {
    protected final ExecutionFactory exFact;

    public DbProcessAwareAccess(DbDataManager dataManager, ExecutionFactory exFact) {
        super(dataManager);
        this.exFact = exFact;
    }

    private PreparedStatement prepareIsNullStmt(Connection con) throws SQLException {
        String query = String.format("SELECT isNull_ as value FROM dataValues dV WHERE dv.instanceID_hi = %s AND dv.instanceID_lo = %s AND dv.dataElementID = %s AND (dv.valid <> 0 OR ( dv.nodeID = %s AND dv.iteration = %s ) ) ORDER BY createTime DESC", "?", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareValidateWrittenValuesStmt(Connection con) throws SQLException {
        String query = String.format("UPDATE dataValues SET valid = 1 WHERE instanceID_hi = %s AND instanceID_lo = %s AND nodeID = %s AND iteration = %s", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareDiscardInvalidWrittenValueStmt(Connection con) throws SQLException {
        String query = String.format("DELETE FROM dataValues WHERE instanceID_hi = %s AND instanceID_lo = %s AND dataElementID = %s AND nodeID = %s AND iteration = %s AND valid = 0", "?", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareRemoveInvalidWrittenValuesStmt(Connection con) throws SQLException {
        String query = String.format("DELETE FROM dataValues WHERE instanceID_hi = %s AND instanceID_lo = %s AND nodeID = %s AND iteration = %s AND valid = 0", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareRetrieveValueStmt(Connection con) throws SQLException {
        String query = String.format("SELECT IntegerValue, BooleanValue, FloatValue, StringValue, BLOBValue, dE.type AS type FROM dataElements dE JOIN dataValues dV ON dE.instanceID_hi = dV.instanceID_hi AND dE.instanceID_lo = dV.instanceID_lo AND dE.dataElementID = dV.dataElementID WHERE dv.instanceID_hi = %s AND dv.instanceID_lo = %s AND dv.dataElementID = %s AND (dv.valid <> 0 OR ( dv.nodeID = %s AND dv.iteration = %s ) ) ORDER BY createTime DESC", "?", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareInsertValueStmt(Connection con) throws SQLException {
        String query = String.format("INSERT INTO dataValues(instanceID_hi, instanceID_lo, dataElementID, nodeID, iteration, createTime, agent, orgPosition, isNull_, IntegerValue, FloatValue, BooleanValue, StringValue, BLOBValue) VALUES(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s) ", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareHasWrittenValuesStmt(Connection con) throws SQLException {
        String query = String.format("SELECT valid FROM dataValues WHERE instanceID_hi = %s AND instanceID_lo = %s AND dataElementID = %s AND nodeID = %s AND iteration = %s ", "?", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareUdpateValuesStmt(Connection con) throws SQLException {
        String query = String.format("UPDATE dataValues SET createTime = %s, agent = %s, orgPosition = %s, isNull_ = %s, IntegerValue = %s, FloatValue = %s, BooleanValue = %s, StringValue = %s, BLOBValue = %s WHERE instanceID_hi = %s AND instanceID_lo = %s AND dataElementID = %s AND nodeID = %s AND iteration = %s ", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareRemoveSessionStateOfNodeIterationStmt(Connection con) throws SQLException {
        String query = String.format("DELETE FROM savepoints WHERE instanceID_hi = %s AND instanceID_lo = %s AND nodeID = %s AND iteration = %s", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    @Override
    public DataContainer getDataContainer(SessionToken session, Instance instance, int nodeID) {
        this.dataManager.sessionActive(session);
        try {
            DbDataContainer dbDataContainer = this.createDataContainer(session, instance, nodeID, this, false, this.dataManager.getSessionStateManager());
            return dbDataContainer;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    private DbDataContainer createDataContainer(SessionToken session, Instance instance, int nodeID, DbProcessAwareAccess paa, boolean systemAccess, SessionStateManager sessionStateManager) {
        UUID instanceID = instance.getID();
        int iteration = instance.getNodeIteration(nodeID);
        Logger logger = LoggerTools.getLogger(this);
        HashMap<String, ProcessConstants.AdeptDataType> inputTypes = new HashMap<String, ProcessConstants.AdeptDataType>();
        HashMap<String, Serializable> inputValues = new HashMap<String, Serializable>();
        HashMap<String, ProcessConstants.AdeptDataType> outputTypes = new HashMap<String, ProcessConstants.AdeptDataType>();
        HashMap<String, Serializable> outputValues = new HashMap<String, Serializable>();
        ArrayList<DataContainer.Savepoint> savepoints = new ArrayList<DataContainer.Savepoint>();
        HashMap<Integer, Pair<DataElement, String>> input = new HashMap<Integer, Pair<DataElement, String>>();
        ActivityConstants.AccessType readAccess = systemAccess ? ActivityConstants.AccessType.SYSTEM_READ : ActivityConstants.AccessType.READ;
        for (Map.Entry<String, Integer> entry : this.getConnectorMapping(instance, nodeID, readAccess).entrySet()) {
            String paramName = entry.getKey();
            int connectorID = entry.getValue();
            DataElement de = instance.getTemplate().getDataElement(nodeID, connectorID);
            if (de == null) {
                ProcessModelParameter inParam;
                if (systemAccess) {
                    inParam = instance.getTemplate().getNode(nodeID).getSystemParameter(paramName, ActivityConstants.AccessType.SYSTEM_READ);
                } else {
                    ExecutableBusinessProcess ebp = instance.getTemplate().getNode(nodeID).getExecutableBusinessProcess();
                    inParam = ebp.getParameter(paramName, ActivityConstants.AccessType.READ);
                }
                inputTypes.put(paramName, inParam.getDataType());
                continue;
            }
            input.put(de.getID(), new Pair<DataElement, String>(de, paramName));
            inputTypes.put(paramName, de.getDataType());
        }
        if (input.size() > 0) {
            String sql = DbDataManagerSQLHelper.dbProcessAwareAccess_newDataContainer(input.keySet());
            ExtendedConnection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    con = paa.getDataSource().getConnection();
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(2, instance.getLogID().getLeastSignificantBits());
                    stmt.setInt(3, nodeID);
                    stmt.setInt(4, iteration);
                    stmt.setLong(5, instance.getLogID().getMostSignificantBits());
                    stmt.setLong(6, instance.getLogID().getLeastSignificantBits());
                    stmt.setInt(7, nodeID);
                    stmt.setInt(8, iteration);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        int dataElementID = rs.getInt("dataElementID");
                        Pair pair = (Pair)input.get(dataElementID);
                        DataElement dataElement = (DataElement)pair.getFirst();
                        String inputParamName = (String)pair.getSecond();
                        boolean isNull = rs.getBoolean("isNull_");
                        if (isNull) continue;
                        Serializable value = paa.getValueFrom(rs, dataElement.getDataType());
                        inputValues.put(inputParamName, value);
                    }
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException ex) {
                    String msg = "Database access failed.";
                    logger.log(Level.SEVERE, msg, ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        }
        ActivityConstants.AccessType writeAccess = systemAccess ? ActivityConstants.AccessType.SYSTEM_WRITE : ActivityConstants.AccessType.WRITE;
        for (Map.Entry<String, Integer> entry : this.getConnectorMapping(instance, nodeID, writeAccess).entrySet()) {
            ProcessConstants.AdeptDataType dataType;
            String paramName = entry.getKey();
            int connectorID = entry.getValue();
            DataElement de = instance.getTemplate().getDataElement(nodeID, connectorID);
            if (de == null) {
                ProcessModelParameter outParam;
                if (systemAccess) {
                    outParam = instance.getTemplate().getNode(nodeID).getSystemParameter(paramName, ActivityConstants.AccessType.SYSTEM_WRITE);
                } else {
                    ExecutableBusinessProcess ebp = instance.getTemplate().getNode(nodeID).getExecutableBusinessProcess();
                    outParam = ebp.getParameter(paramName, ActivityConstants.AccessType.WRITE);
                }
                dataType = outParam.getDataType();
            } else {
                dataType = de.getDataType();
            }
            outputTypes.put(paramName, dataType);
        }
        Iterator<Object> iterator = sessionStateManager.getStoredSavepoints(instanceID, nodeID, iteration).iterator();
        while (iterator.hasNext()) {
            int spID = (Integer)iterator.next();
            byte[] sessionState = sessionStateManager.retrieveSessionState(session, spID, instanceID, nodeID, iteration);
            savepoints.add(new DataContainer.Savepoint(spID, sessionState));
        }
        return new DbDataContainer(instanceID, nodeID, iteration, inputTypes, inputValues, outputTypes, outputValues, savepoints);
    }

    private Map<String, Integer> getConnectorMapping(Instance instance, int nodeID, ActivityConstants.AccessType access) {
        Node node = instance.getTemplate().getNode(nodeID);
        HashMap<String, Integer> connectorMapping = new HashMap<String, Integer>(node.getConnectorMapping(access));
        if (node.getExecutableBusinessProcess() == null) {
            int[] ids;
            int[] nArray = ids = instance.getTemplate().getAccessedDataElementIDsForNode(nodeID, access);
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                DataElement de = instance.getTemplate().getDataElement(id);
                Integer connector = instance.getTemplate().getConnector(nodeID, id, access);
                connectorMapping.put(de.getName(), connector);
                ++n2;
            }
        }
        return connectorMapping;
    }

    @Override
    public void flushDataContainer(SessionToken session, Instance instance, int writingNodeID, int writerIteration, DataContainer dataContainer) throws InvalidDataContainerException {
        UUID instanceID = instance.getID();
        if (!instanceID.equals(dataContainer.getInstanceID())) {
            String msg = String.format("instance id %s not equal to dc.instanceID %s", instanceID, dataContainer.getInstanceID());
            this.logger.severe(msg);
            throw new InvalidDataContainerException(dataContainer, instanceID, writingNodeID, writerIteration);
        }
        if (writingNodeID != dataContainer.getNodeID()) {
            String msg = String.format("nodeID %s not equal to dc.nodeID %s", writingNodeID, dataContainer.getNodeID());
            this.logger.severe(msg);
            throw new InvalidDataContainerException(dataContainer, instanceID, writingNodeID, writerIteration);
        }
        if (writerIteration != dataContainer.getNodeIteration()) {
            String msg = String.format("iteration %s not equal to dc.iteration %s", writerIteration, dataContainer.getNodeIteration());
            this.logger.severe(msg);
            throw new InvalidDataContainerException(dataContainer, instanceID, writingNodeID, writerIteration);
        }
        block12: for (String name : dataContainer.getUnsavedParameterNames()) {
            Object temp;
            int n;
            Template template = instance.getTemplate();
            Node node = template.getNode(writingNodeID);
            int connector = node.getConnector(name, ActivityConstants.AccessType.WRITE);
            Object de = template.getDataElement(writingNodeID, connector);
            if (node.getExecutableBusinessProcess() == null) {
                int[] ids;
                int[] nArray = ids = template.getAccessedDataElementIDsForNode(writingNodeID, ActivityConstants.AccessType.WRITE);
                n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    temp = template.getDataElement(id);
                    if (temp.getName().equals(name)) {
                        de = temp;
                    }
                    ++n2;
                }
            }
            if (de == null) {
                int[] disabledConnectors = template.getDisabledConnectors(writingNodeID, ActivityConstants.AccessType.WRITE);
                boolean isDisabled = false;
                temp = disabledConnectors;
                int n3 = disabledConnectors.length;
                n = 0;
                while (n < n3) {
                    int disabled = temp[n];
                    if (connector == disabled) {
                        isDisabled = true;
                        break;
                    }
                    ++n;
                }
                if (isDisabled) continue;
                String msg = String.format("The parameter '%s' of node #%s in template '%s' (%s) will be not flushed, since no matching data element could be found! This is a severe problem since the parameter is NOT disabled!", name, writingNodeID, template.getName(), template.getID());
                this.logger.severe(msg);
                continue;
            }
            ProcessConstants.AdeptDataType type = de.getDataType();
            int dataElementID = de.getID();
            try {
                if (dataContainer.ignoredValue(name)) {
                    this.discardValue(session, instance.getLogID(), writingNodeID, writerIteration, dataElementID);
                    continue;
                }
                switch (type) {
                    case BOOLEAN: {
                        boolean b = dataContainer.storedBoolean(name);
                        this.storeBoolean(session, instanceID, writingNodeID, writerIteration, dataElementID, b);
                        continue block12;
                    }
                    case DATE: {
                        Date d = dataContainer.storedDate(name);
                        this.storeDate(session, instanceID, writingNodeID, writerIteration, dataElementID, d);
                        continue block12;
                    }
                    case FLOAT: {
                        Double f = dataContainer.storedFloat(name);
                        this.storeFloat(session, instanceID, writingNodeID, writerIteration, dataElementID, f);
                        continue block12;
                    }
                    case INTEGER: {
                        Long i = dataContainer.storedInteger(name);
                        this.storeInteger(session, instanceID, writingNodeID, writerIteration, dataElementID, i);
                        continue block12;
                    }
                    case STRING: {
                        String s = dataContainer.storedString(name);
                        this.storeString(session, instanceID, writingNodeID, writerIteration, dataElementID, s);
                        continue block12;
                    }
                    case URI: {
                        URI uri = dataContainer.storedURI(name);
                        this.storeURI(session, instanceID, writingNodeID, writerIteration, dataElementID, uri);
                        continue block12;
                    }
                    case USERDEFINED: {
                        UDTValue udt = dataContainer.storedUDT(name);
                        this.storeUDT(session, instanceID, writingNodeID, writerIteration, dataElementID, udt);
                        continue block12;
                    }
                    default: {
                        throw new RuntimeException("Unexpected data type!");
                    }
                }
            }
            catch (InvalidDataTypeException e) {
                String msg = "An unexpected InvalidDataTypeException occurred during flush while storing the output parameter values in the process aware access!";
                LoggerTools.getLogger(this).log(Level.SEVERE, msg, e);
            }
            catch (NoSuchParameterException e) {
                String msg = "An unexpected NoSuchParameterException occurred during flush while storing the output parameter values in the process aware access!";
                LoggerTools.getLogger(this).log(Level.SEVERE, msg, e);
            }
        }
        for (DataContainer.Savepoint sp : dataContainer.getUnsavedSessions()) {
            this.dataManager.getSessionStateManager().storeSessionState(session, sp.getSavepointID(), instanceID, writingNodeID, writerIteration, sp.getSessionState());
        }
    }

    @Override
    public ParameterDataContext getPublicDataContext(SessionToken session, Instance instance, int nodeID) {
        this.dataManager.sessionActive(session);
        try {
            HashMap<String, Serializable> dataValues = new HashMap<String, Serializable>();
            HashMap<String, ProcessConstants.AdeptDataType> dataTypes = new HashMap<String, ProcessConstants.AdeptDataType>();
            Template template = instance.getTemplate();
            ArrayList<Integer> publicDataElementIDs = new ArrayList<Integer>();
            for (DataElement de : template.getDataElements()) {
                if (!de.isPublic()) continue;
                publicDataElementIDs.add(de.getID());
                dataTypes.put(de.getName(), de.getDataType());
            }
            if (publicDataElementIDs.size() > 0) {
                String sql = DbDataManagerSQLHelper.dbProcessAwareAccess_getPublicDataContext(publicDataElementIDs);
                ExtendedConnection con = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    try {
                        con = this.getDataSource().getConnection();
                        UUID instanceLogID = instance.getLogID();
                        stmt = con.prepareStatement(sql);
                        stmt.setLong(1, instanceLogID.getMostSignificantBits());
                        stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                        stmt.setLong(3, instanceLogID.getMostSignificantBits());
                        stmt.setLong(4, instanceLogID.getLeastSignificantBits());
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            int dataElementID = rs.getInt("dataElementID");
                            DataElement dataElement = template.getDataElement(dataElementID);
                            boolean isNull = rs.getBoolean("isNull_");
                            if (isNull) continue;
                            Serializable value = this.getValueFrom(rs, dataElement.getDataType());
                            dataValues.put(dataElement.getName(), value);
                        }
                        rs = JDBCTools.close(rs);
                        stmt = JDBCTools.close(stmt);
                        con = JDBCTools.close(con);
                    }
                    catch (SQLException e) {
                        this.logSQLException(e, "getPublicDataContext");
                        throw new RuntimeException("Database access failed.", e);
                    }
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            }
            ParameterDataContext parameterDataContext = this.exFact.createParameterDataContext(dataTypes, dataValues);
            return parameterDataContext;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public InputDataContainer getNodeDataContainer(SessionToken session, Instance instance, int nodeID) {
        this.dataManager.sessionActive(session);
        try {
            DbDataContainer dbDataContainer = this.createDataContainer(session, instance, nodeID, this, true, this.dataManager.getSessionStateManager());
            return dbDataContainer;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public DataContainer getObsoleteDataContainer(SessionToken session, ExecutionHistory execHist, Instance instance, int nodeID, int iteration) throws InvalidActivityStateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void discardValue(SessionToken session, UUID instanceLogID, int discardingNodeID, int discarderIteration, int dataElementID) {
        this.dataManager.sessionActive(session);
        try {
            ExtendedConnection con = null;
            PreparedStatement stmt = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    stmt = this.prepareDiscardInvalidWrittenValueStmt(con);
                    stmt.setLong(1, instanceLogID.getMostSignificantBits());
                    stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                    stmt.setInt(3, dataElementID);
                    stmt.setInt(4, discardingNodeID);
                    stmt.setInt(5, discarderIteration);
                    stmt.executeUpdate();
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    this.logSQLException(e, "discardWrittenValue");
                    throw new RuntimeException("Database access failed.", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public boolean isNull(SessionToken session, UUID instanceID, int readingNodeID, int readerIteration, int dataElementID) {
        this.dataManager.sessionActive(session);
        try {
            boolean bl;
            ExtendedConnection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getDataSource().getConnection();
                UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
                stmt = this.prepareIsNullStmt(con);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                stmt.setInt(3, dataElementID);
                stmt.setInt(4, readingNodeID);
                stmt.setInt(5, readerIteration);
                rs = stmt.executeQuery();
                boolean isNull = true;
                if (rs.next()) {
                    isNull = rs.getBoolean("value");
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                bl = isNull;
            }
            catch (SQLException e) {
                try {
                    this.logSQLException(e, "isNull");
                    throw new RuntimeException("A SQLException occurred while trying to retrieve Null-state", e);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            return bl;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public boolean retrieveBoolean(SessionToken session, UUID instanceID, int readingNodeID, int readerIteration, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveValue(instanceID, readingNodeID, readerIteration, dataElementID, ProcessConstants.AdeptDataType.BOOLEAN);
            if (obj != null && obj instanceof Boolean) {
                boolean bl = (Boolean)obj;
                return bl;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public Date retrieveDate(SessionToken session, UUID instanceID, int readingNodeID, int readerIteration, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveValue(instanceID, readingNodeID, readerIteration, dataElementID, ProcessConstants.AdeptDataType.DATE);
            if (obj != null && obj instanceof Date) {
                Date date = (Date)obj;
                return date;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public double retrieveFloat(SessionToken session, UUID instanceID, int readingNodeID, int readerIteration, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveValue(instanceID, readingNodeID, readerIteration, dataElementID, ProcessConstants.AdeptDataType.FLOAT);
            if (obj != null && obj instanceof Double) {
                double d = (Double)obj;
                return d;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public long retrieveInteger(SessionToken session, UUID instanceID, int readingNodeID, int readerIteration, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveValue(instanceID, readingNodeID, readerIteration, dataElementID, ProcessConstants.AdeptDataType.INTEGER);
            if (obj != null && obj instanceof Long) {
                long l = (Long)obj;
                return l;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public String retrieveString(SessionToken session, UUID instanceID, int readingNodeID, int readerIteration, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveValue(instanceID, readingNodeID, readerIteration, dataElementID, ProcessConstants.AdeptDataType.STRING);
            if (obj != null && obj instanceof String) {
                String string = (String)obj;
                return string;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public UDTValue retrieveUDT(SessionToken session, UUID instanceID, int readingNodeID, int readerIteration, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveValue(instanceID, readingNodeID, readerIteration, dataElementID, ProcessConstants.AdeptDataType.USERDEFINED);
            if (obj != null && obj instanceof UDTValue) {
                UDTValue uDTValue = (UDTValue)obj;
                return uDTValue;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public URI retrieveURI(SessionToken session, UUID instanceID, int readingNodeID, int readerIteration, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveValue(instanceID, readingNodeID, readerIteration, dataElementID, ProcessConstants.AdeptDataType.URI);
            if (obj != null && obj instanceof URI) {
                URI uRI = (URI)obj;
                return uRI;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeBoolean(SessionToken session, UUID instanceID, int writingNodeID, int writerIteration, int dataElementID, boolean value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Boolean obj = value;
            this.storeValue(instanceID, writingNodeID, writerIteration, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.BOOLEAN, obj);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeDate(SessionToken session, UUID instanceID, int writingNodeID, int writerIteration, int dataElementID, Date value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            this.storeValue(instanceID, writingNodeID, writerIteration, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.DATE, value);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeFloat(SessionToken session, UUID instanceID, int writingNodeID, int writerIteration, int dataElementID, double value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Double obj = value;
            this.storeValue(instanceID, writingNodeID, writerIteration, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.FLOAT, obj);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeInteger(SessionToken session, UUID instanceID, int writingNodeID, int writerIteration, int dataElementID, long value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Long obj = value;
            this.storeValue(instanceID, writingNodeID, writerIteration, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.INTEGER, obj);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeString(SessionToken session, UUID instanceID, int writingNodeID, int writerIteration, int dataElementID, String value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            this.storeValue(instanceID, writingNodeID, writerIteration, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.STRING, value);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeUDT(SessionToken session, UUID instanceID, int writingNodeID, int writerIteration, int dataElementID, UDTValue value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            this.storeValue(instanceID, writingNodeID, writerIteration, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.USERDEFINED, value);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeURI(SessionToken session, UUID instanceID, int writingNodeID, int writerIteration, int dataElementID, URI value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            this.storeValue(instanceID, writingNodeID, writerIteration, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.URI, value);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void validateWrittenValues(SessionToken session, Instance instance, int nodeID, int nodeIteration) throws MandatoryParameterValueNotSetException {
        this.dataManager.sessionActive(session);
        try {
            Node node = instance.getTemplate().getNode(nodeID);
            ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
            if (ebp != null) {
                this.checkMandatoryParameters(ebp.getParameters(ActivityConstants.AccessType.WRITE), ActivityConstants.AccessType.WRITE, instance, node, nodeIteration, session);
            }
            this.checkMandatoryParameters(node.getSystemParameters(ActivityConstants.AccessType.SYSTEM_WRITE), ActivityConstants.AccessType.SYSTEM_WRITE, instance, node, nodeIteration, session);
            UUID instanceLogID = instance.getLogID();
            ExtendedConnection con = null;
            PreparedStatement stmt = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    stmt = this.prepareValidateWrittenValuesStmt(con);
                    stmt.setLong(1, instanceLogID.getMostSignificantBits());
                    stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                    stmt.setInt(3, nodeID);
                    stmt.setInt(4, nodeIteration);
                    stmt.executeUpdate();
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    this.logSQLException(e, "validateWrittenValues");
                    throw new RuntimeException("Database access failed.", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    private void checkMandatoryParameters(Collection<ProcessModelParameter> outParams, ActivityConstants.AccessType accessType, Instance instance, Node node, int nodeIteration, SessionToken session) throws MandatoryParameterValueNotSetException {
        for (ProcessModelParameter outParam : outParams) {
            int connectorID;
            if (outParam.isOptional() || outParam.isVirtual() || (connectorID = node.getConnector(outParam.getName(), accessType)) == Integer.MIN_VALUE || this.isConnectorDisabled(instance.getTemplate().getDisabledConnectors(node.getID(), accessType), connectorID)) continue;
            DataElement dataElement = instance.getTemplate().getDataElement(node.getID(), connectorID);
            if (!this.isNull(session, instance.getID(), node.getID(), nodeIteration, dataElement.getID())) continue;
            throw new MandatoryParameterValueNotSetException(instance.getID(), node.getID(), nodeIteration, dataElement.getID(), outParam.getName(), outParam.getIdentifierID(), outParam.getDataType(), accessType);
        }
    }

    private boolean isConnectorDisabled(int[] disabledConnectors, int connectorID) {
        boolean ret = false;
        int[] nArray = disabledConnectors;
        int n = disabledConnectors.length;
        int n2 = 0;
        while (n2 < n) {
            int disabled = nArray[n2];
            if (disabled == connectorID) {
                ret = true;
                break;
            }
            ++n2;
        }
        return ret;
    }

    private Object retrieveValue(UUID instanceID, int readingNodeID, int readerIteration, int dataElementID, ProcessConstants.AdeptDataType expectedType) throws InvalidDataTypeException {
        Serializable serializable;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDataSource().getConnection();
            UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
            stmt = this.prepareRetrieveValueStmt(con);
            stmt.setLong(1, instanceLogID.getMostSignificantBits());
            stmt.setLong(2, instanceLogID.getLeastSignificantBits());
            stmt.setInt(3, dataElementID);
            stmt.setInt(4, readingNodeID);
            stmt.setInt(5, readerIteration);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ProcessConstants.AdeptDataType actualDataType = DbProcessAwareAccess.getType(rs.getString("type"));
                if (actualDataType != expectedType) {
                    throw new InvalidDataTypeException(instanceID, dataElementID, expectedType, actualDataType);
                }
            } else {
                if (this.checkDataElementAndType(instanceID, dataElementID, expectedType)) {
                    this.logger.log(Level.SEVERE, "Trying to retrieve a value that is Null.");
                    throw new RuntimeException("The data element is Null");
                }
                this.logger.log(Level.SEVERE, "Trying to access a non-existing dataElement");
                throw new RuntimeException("The given data element does not exist.");
            }
            Serializable result = this.getValueFrom(rs, expectedType);
            rs.close();
            serializable = result;
        }
        catch (SQLException e) {
            try {
                this.logSQLException(e, "retriveValue");
                throw new RuntimeException("Database access failed.", e);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        return serializable;
    }

    private Serializable readDataElement(SessionToken session, LogEntrySet prevSteps, Instance instance, int readingNodeID, int readingIteration, int readDataElementID, ProcessConstants.AdeptDataType expectedDataType) throws InvalidActivityStateException, InvalidDataTypeException, DataSourceException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(prevSteps, "prevSteps");
        ArgChecks.checkForNull(instance, "instance");
        ArgChecks.checkForNull((Object)expectedDataType, "expectedDataType");
        Template template = instance.getTemplate();
        if (template.getNode(readingNodeID) == null) {
            String msg = "The (reading) node #%d does not exist in the process instance %s!";
            msg = String.format(msg, readingNodeID, instance.getID());
            throw new IllegalArgumentException(msg);
        }
        if (readingIteration > instance.getNodeIteration(readingNodeID)) {
            String msg = "The (reading) node #%d never reached iteration #%d in the process instance %s!";
            msg = String.format(msg, readingNodeID, readingIteration, instance.getID());
            throw new InvalidActivityStateException(msg);
        }
        if (readingIteration == instance.getNodeIteration(readingNodeID) && instance.getNodeState(readDataElementID) != ProcessConstants.NodeState.NS_COMPLETED && instance.getNodeState(readDataElementID) != ProcessConstants.NodeState.NS_ENQUIRED) {
            String msg = "The (reading) node #%d never completed iteration #%d in the process instance %s!";
            msg = String.format(msg, readingNodeID, readingIteration, instance.getID());
            throw new InvalidActivityStateException(msg);
        }
        if (template.getDataElement(readDataElementID) == null) {
            String msg = "The data element #%d does not exist in the process instance %s!";
            msg = String.format(msg, readDataElementID, instance.getID());
            throw new IllegalArgumentException(msg);
        }
        if (template.getConnector(readingNodeID, readDataElementID, ActivityConstants.AccessType.READ) == Integer.MIN_VALUE) {
            String msg = "The node #%d does never read the data element #%d in the process instance %s!";
            msg = String.format(msg, readingNodeID, readDataElementID, instance.getID());
            throw new IllegalArgumentException(msg);
        }
        LogEntrySet.Cursor cursor = prevSteps.getCursor();
        while (cursor.nextEntry()) {
            int stepNodeID = cursor.getInteger("nodeID");
            int stepNodeIteration = cursor.getInteger("iteration");
            if (template.getConnector(stepNodeID, readDataElementID, ActivityConstants.AccessType.WRITE) == Integer.MIN_VALUE) continue;
            try {
                Serializable value = this.naiveRetrieveValue(instance.getID(), stepNodeID, stepNodeIteration, readDataElementID, expectedDataType);
                return value;
            }
            catch (NothingWrittenException nothingWrittenException) {}
        }
        return null;
    }

    private Serializable naiveRetrieveValue(UUID instanceID, int nodeID, int iteration, int dataElementID, ProcessConstants.AdeptDataType expectedDataType) throws InvalidDataTypeException, NothingWrittenException, DataSourceException {
        Serializable serializable;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDataSource().getConnection();
            UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
            String query = "SELECT type, isNull_, BooleanValue, IntegerValue, FloatValue,       StringValue, BLOBvalue FROM dataValues dV    JOIN dataElements dE ON dV.instanceID_hi = dE.instanceID_hi AND dV.instanceID_lo = dE.instanceID_lo AND         dV.dataElementID = dE.dataElementID  WHERE dE.instanceID_hi = ? AND dE.instanceID_lo = ? AND dE.dataElementID = ? AND        nodeID = ? AND iteration = ? AND valid = ?";
            stmt = con.prepareStatement(query);
            stmt.setLong(1, instanceLogID.getMostSignificantBits());
            stmt.setLong(2, instanceLogID.getLeastSignificantBits());
            stmt.setInt(3, dataElementID);
            stmt.setInt(4, nodeID);
            stmt.setInt(5, iteration);
            stmt.setByte(6, (byte)1);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new NothingWrittenException();
            }
            ProcessConstants.AdeptDataType actualDataType = DbProcessAwareAccess.getType(rs.getString("type"));
            if (actualDataType != expectedDataType) {
                throw new InvalidDataTypeException(instanceID, dataElementID, expectedDataType, actualDataType);
            }
            Serializable value = this.getValueFrom(rs, expectedDataType);
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.close(con);
            serializable = value;
        }
        catch (SQLException ex) {
            try {
                throw new DataSourceException("The data element value could not be retrieved from the database!", ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        return serializable;
    }

    private void storeValue(UUID instanceID, int writingNodeID, int writerIteration, int dataElementID, QualifiedAgent agent, ProcessConstants.AdeptDataType expectedType, Object value) throws InvalidDataTypeException {
        if (!this.checkDataElementAndType(instanceID, dataElementID, expectedType)) {
            this.logger.log(Level.SEVERE, "Tried to store data to a non-existing dataElement.");
            return;
        }
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        try {
            try {
                con = this.getDataSource().getConnection();
                UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
                if (this.checkHasWrittenValue(instanceID, writingNodeID, writerIteration, dataElementID, con)) {
                    stmt = this.prepareUdpateValuesStmt(con);
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    stmt.setTimestamp(1, now, JDBCTools.createUTCCalendar());
                    stmt.setLong(2, agent.getAgentID());
                    stmt.setLong(3, agent.getOrgPositionID());
                    stmt.setBoolean(4, false);
                    this.setParametersForValue(value, expectedType, stmt, 5);
                    stmt.setLong(10, instanceLogID.getMostSignificantBits());
                    stmt.setLong(11, instanceLogID.getLeastSignificantBits());
                    stmt.setInt(12, dataElementID);
                    stmt.setInt(13, writingNodeID);
                    stmt.setInt(14, writerIteration);
                    stmt.executeUpdate();
                } else {
                    stmt = this.prepareInsertValueStmt(con);
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    stmt.setLong(1, instanceLogID.getMostSignificantBits());
                    stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                    stmt.setInt(3, dataElementID);
                    stmt.setInt(4, writingNodeID);
                    stmt.setInt(5, writerIteration);
                    stmt.setTimestamp(6, now, JDBCTools.createUTCCalendar());
                    stmt.setLong(7, agent.getAgentID());
                    stmt.setLong(8, agent.getOrgPositionID());
                    stmt.setBoolean(9, false);
                    this.setParametersForValue(value, expectedType, stmt, 10);
                    stmt.executeUpdate();
                }
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                this.logSQLException(e, "storeValue");
                throw new RuntimeException("Database access failed.", e);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "IOException occurred while writing BLOB value. ", e);
                throw new RuntimeException("Value could not be written to the database. ", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt);
    }

    private boolean checkHasWrittenValue(UUID instanceID, int writingNodeID, int writerIteration, int dataElementID, ExtendedConnection con) {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
            stmt = this.prepareHasWrittenValuesStmt(con);
            stmt.setLong(1, instanceLogID.getMostSignificantBits());
            stmt.setLong(2, instanceLogID.getLeastSignificantBits());
            stmt.setInt(3, dataElementID);
            stmt.setInt(4, writingNodeID);
            stmt.setInt(5, writerIteration);
            rs = stmt.executeQuery();
            boolean hasWrittenValue = rs.next();
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            bl = hasWrittenValue;
        }
        catch (SQLException e) {
            try {
                this.logSQLException(e, "checkHasWrittenValue");
                throw new RuntimeException("Database access failed.", e);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(stmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        return bl;
    }

    @Override
    public void dropWrittenValues(SessionToken session, Instance instance, int nodeID, int nodeIteration) {
        this.dataManager.sessionActive(session);
        try {
            ExtendedConnection con = null;
            PreparedStatement stmt = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    UUID instanceLogID = instance.getLogID();
                    stmt = this.prepareRemoveInvalidWrittenValuesStmt(con);
                    stmt.setLong(1, instanceLogID.getMostSignificantBits());
                    stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                    stmt.setInt(3, nodeID);
                    stmt.setInt(4, nodeIteration);
                    stmt.executeUpdate();
                    stmt = JDBCTools.close(stmt);
                    stmt = this.prepareRemoveSessionStateOfNodeIterationStmt(con);
                    stmt.setLong(1, instanceLogID.getMostSignificantBits());
                    stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                    stmt.setInt(3, nodeID);
                    stmt.setInt(4, nodeIteration);
                    stmt.executeUpdate();
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    this.logSQLException(e, "dropWrittenValues");
                    throw new RuntimeException("Database access failed.", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    static class NothingWrittenException
    extends Exception {
        private static final long serialVersionUID = 306435934487271177L;

        NothingWrittenException() {
        }
    }
}

