/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.datamanager.dbimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.ProcessUnawareAccess;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataAccess;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataManager;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataManagerSQLHelper;
import de.aristaflow.adept2.core.datamanager.dbimplementation.SimpleInputDataContainer;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;

public class DbProcessUnAwareAccess
extends DbDataAccess
implements ProcessUnawareAccess {
    protected final ExecutionFactory exFact;

    public DbProcessUnAwareAccess(DbDataManager dataManager, ExecutionFactory exFact) {
        super(dataManager);
        this.exFact = exFact;
    }

    private PreparedStatement prepareIsNullExternalStmt(Connection con) throws SQLException {
        String query = String.format(DbDataManagerSQLHelper.dbProcessUnAwareAccess_isExternalNull, "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareRetrieveExternalValueStmt(Connection con) throws SQLException {
        String query = String.format(DbDataManagerSQLHelper.dbProcessUnAwareAccess_retrieveExternalValue, "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareInsertExternalValueStmt(Connection con) throws SQLException {
        String query = String.format("INSERT INTO externalDataValues(instanceID_hi, instanceID_lo, dataElementID, createTime, agent, orgPosition, isNull_, IntegerValue, FloatValue, BooleanValue, StringValue, BLOBValue) VALUES(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s) ", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareIsNullLatestStmt(Connection con) throws SQLException {
        String query = String.format(DbDataManagerSQLHelper.dbProcessUnAwareAccess_isLatestNull, "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareRetrieveLatestValueStmt(Connection con) throws SQLException {
        String query = String.format(DbDataManagerSQLHelper.dbProcessUnAwareAccess_retrieveLatestValue, "?", "?", "?");
        return con.prepareStatement(query);
    }

    @Override
    public boolean isExternalValueNull(SessionToken session, UUID instanceID, int dataElementID) {
        this.dataManager.sessionActive(session);
        try {
            ResultSet rs;
            PreparedStatement stmt;
            ExtendedConnection con;
            block9: {
                con = null;
                stmt = null;
                rs = null;
                con = this.getDataSource().getConnection();
                UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
                stmt = this.prepareIsNullExternalStmt(con);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                stmt.setInt(3, dataElementID);
                rs = stmt.executeQuery();
                if (!rs.next()) break block9;
                boolean result = rs.getBoolean("value");
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                boolean bl = result;
                JDBCTools.closeQuietly(con, (Statement)stmt, rs);
                return bl;
            }
            try {
                try {
                    this.logger.log(Level.WARNING, "Tried to get NULL for a data element that does not exist.");
                    throw new RuntimeException("Data element does not exist.");
                }
                catch (SQLException e) {
                    this.logSQLException(e, "isExternalValueNull");
                    throw new RuntimeException("Database access failed", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public boolean retrieveExternalBooleanValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveExternalValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.BOOLEAN);
            if (obj != null && obj instanceof Boolean) {
                boolean bl = (Boolean)obj;
                return bl;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public Date retrieveExternalDateValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveExternalValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.DATE);
            if (obj != null && obj instanceof Date) {
                Date date = (Date)obj;
                return date;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public double retrieveExternalFloatValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveExternalValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.FLOAT);
            if (obj != null && obj instanceof Double) {
                double d = (Double)obj;
                return d;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public long retrieveExternalIntegerValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveExternalValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.INTEGER);
            if (obj != null && obj instanceof Long) {
                long l = (Long)obj;
                return l;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public String retrieveExternalStringValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveExternalValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.STRING);
            if (obj != null && obj instanceof String) {
                String string = (String)obj;
                return string;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public UDTValue retrieveExternalUDTValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveExternalValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.USERDEFINED);
            if (obj != null && obj instanceof UDTValue) {
                UDTValue uDTValue = (UDTValue)obj;
                return uDTValue;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public URI retrieveExternalURIValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Object obj = this.retrieveExternalValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.URI);
            if (obj != null && obj instanceof URI) {
                URI uRI = (URI)obj;
                return uRI;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void setNullExternal(SessionToken session, UUID instanceID, int dataElementID) {
        this.dataManager.sessionActive(session);
        try {
            ExtendedConnection con = null;
            PreparedStatement stmt = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
                    stmt = this.prepareInsertExternalValueStmt(con);
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    stmt.setLong(1, instanceLogID.getMostSignificantBits());
                    stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                    stmt.setInt(3, dataElementID);
                    stmt.setTimestamp(4, now, JDBCTools.createUTCCalendar());
                    stmt.setLong(5, this.dataManager.checkAndGetTopLevelAgent(session).getAgentID());
                    stmt.setLong(6, this.dataManager.checkAndGetTopLevelAgent(session).getOrgPositionID());
                    stmt.setBoolean(7, true);
                    stmt.setNull(8, -5);
                    stmt.setNull(9, 8);
                    stmt.setNull(10, -6);
                    stmt.setNull(11, 12);
                    stmt.setNull(12, 2004);
                    stmt.executeUpdate();
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    this.logSQLException(e, "setNullExternal");
                    throw new RuntimeException("Database access failed.", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeBooleanExternal(SessionToken session, UUID instanceID, int dataElementID, boolean value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Boolean obj = value;
            this.storeValueExternal(instanceID, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.BOOLEAN, obj);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeDateExternal(SessionToken session, UUID instanceID, int dataElementID, Date value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            this.storeValueExternal(instanceID, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.DATE, value);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeFloatExternal(SessionToken session, UUID instanceID, int dataElementID, double value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Double obj = value;
            this.storeValueExternal(instanceID, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.FLOAT, obj);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeIntegerExternal(SessionToken session, UUID instanceID, int dataElementID, long value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Long obj = value;
            this.storeValueExternal(instanceID, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.INTEGER, obj);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeStringExternal(SessionToken session, UUID instanceID, int dataElementID, String value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            this.storeValueExternal(instanceID, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.STRING, value);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeUDTExternal(SessionToken session, UUID instanceID, int dataElementID, UDTValue value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            this.storeValueExternal(instanceID, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.USERDEFINED, value);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeURIExternal(SessionToken session, UUID instanceID, int dataElementID, URI value) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            this.storeValueExternal(instanceID, dataElementID, this.dataManager.checkAndGetTopLevelAgent(session), ProcessConstants.AdeptDataType.URI, value);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public boolean isLatestValueNull(SessionToken session, UUID instanceID, int dataElementID) {
        this.dataManager.sessionActive(session);
        try {
            boolean bl;
            ExtendedConnection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getDataSource().getConnection();
                UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
                stmt = this.prepareIsNullLatestStmt(con);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                stmt.setInt(3, dataElementID);
                rs = stmt.executeQuery();
                boolean isNull = true;
                if (rs.next()) {
                    isNull = rs.getBoolean("value");
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                bl = isNull;
            }
            catch (SQLException e) {
                try {
                    this.logSQLException(e, "isLatestValueNull");
                    throw new RuntimeException("Database access failed.", e);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            return bl;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public boolean retrieveLatestBooleanValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Serializable obj = this.retrieveLatestValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.BOOLEAN);
            if (obj != null && obj instanceof Boolean) {
                boolean bl = (Boolean)obj;
                return bl;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public Date retrieveLatestDateValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Serializable obj = this.retrieveLatestValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.DATE);
            if (obj != null && obj instanceof Date) {
                Date date = (Date)obj;
                return date;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public double retrieveLatestFloatValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Serializable obj = this.retrieveLatestValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.FLOAT);
            if (obj != null && obj instanceof Double) {
                double d = (Double)obj;
                return d;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public long retrieveLatestIntegerValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Serializable obj = this.retrieveLatestValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.INTEGER);
            if (obj != null && obj instanceof Long) {
                long l = (Long)obj;
                return l;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public String retrieveLatestStringValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Serializable obj = this.retrieveLatestValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.STRING);
            if (obj != null && obj instanceof String) {
                String string = (String)((Object)obj);
                return string;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public UDTValue retrieveLatestUDTValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Serializable obj = this.retrieveLatestValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.USERDEFINED);
            if (obj != null && obj instanceof UDTValue) {
                UDTValue uDTValue = (UDTValue)obj;
                return uDTValue;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public URI retrieveLatestURIValue(SessionToken session, UUID instanceID, int dataElementID) throws InvalidDataTypeException {
        this.dataManager.sessionActive(session);
        try {
            Serializable obj = this.retrieveLatestValue(instanceID, dataElementID, ProcessConstants.AdeptDataType.URI);
            if (obj != null && obj instanceof URI) {
                URI uRI = (URI)obj;
                return uRI;
            }
            throw new RuntimeException("Value could not be retrieved.");
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public ParameterDataContext getPublicDataContext(SessionToken session, Instance instance) {
        this.dataManager.sessionActive(session);
        try {
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            UUID instanceID = instance.getID();
            HashMap<String, ProcessConstants.AdeptDataType> parameterTypes = new HashMap<String, ProcessConstants.AdeptDataType>();
            for (DataElement de : instance.getTemplate().getDataElements()) {
                Object value;
                if (!de.isPublic()) continue;
                String paramName = de.getName();
                parameterTypes.put(paramName, de.getDataType());
                if (this.isLatestValueNull(session, instanceID, de.getID())) continue;
                try {
                    switch (de.getDataType()) {
                        case BOOLEAN: {
                            value = this.retrieveLatestBooleanValue(session, instanceID, de.getID());
                            break;
                        }
                        case INTEGER: {
                            value = this.retrieveLatestIntegerValue(session, instanceID, de.getID());
                            break;
                        }
                        case FLOAT: {
                            value = this.retrieveLatestFloatValue(session, instanceID, de.getID());
                            break;
                        }
                        case STRING: {
                            value = this.retrieveLatestStringValue(session, instanceID, de.getID());
                            break;
                        }
                        case DATE: {
                            value = this.retrieveLatestDateValue(session, instanceID, de.getID());
                            break;
                        }
                        case URI: {
                            value = this.retrieveLatestURIValue(session, instanceID, de.getID());
                            break;
                        }
                        case USERDEFINED: {
                            value = this.retrieveLatestUDTValue(session, instanceID, de.getID());
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown data type '" + (Object)((Object)de.getDataType()) + "' found"));
                        }
                    }
                }
                catch (InvalidDataTypeException e) {
                    throw new RuntimeException("InvalidDataTypeException while trying to create a data context.", e);
                }
                parameters.put(paramName, (Serializable)value);
            }
            ParameterDataContext parameterDataContext = this.exFact.createParameterDataContext(parameterTypes, parameters);
            return parameterDataContext;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public InputDataContainer getInputDataContainer(SessionToken session, Instance instance, Set<Integer> dataElementIDs) {
        Template template = instance.getTemplate();
        HashMap<String, Serializable> parameterValues = new HashMap<String, Serializable>(dataElementIDs.size());
        HashMap<String, ProcessConstants.AdeptDataType> parameterTypes = new HashMap<String, ProcessConstants.AdeptDataType>(dataElementIDs.size());
        for (Integer id : dataElementIDs) {
            DataElement de = template.getDataElement(id);
            try {
                Serializable value = this.isLatestValueNull(session, instance.getID(), de.getID()) ? null : this.retrieveLatestValue(instance.getID(), id, de.getDataType());
                parameterValues.put(de.getName(), value);
                parameterTypes.put(de.getName(), de.getDataType());
            }
            catch (InvalidDataTypeException idte) {
                String msg = "The data type '%s' of data element '%s' (%d) does not match the stored type '%s'. Ignoring this data element.";
                msg = String.format(msg, new Object[]{de.getDataType(), de.getName(), id, idte.getActualDataType()});
                this.logger.log(Level.WARNING, msg, idte);
            }
        }
        return new SimpleInputDataContainer(parameterValues, parameterTypes);
    }

    private Object retrieveExternalValue(UUID instanceID, int dataElementID, ProcessConstants.AdeptDataType expectedType) throws InvalidDataTypeException {
        ResultSet rs;
        PreparedStatement stmt;
        ExtendedConnection con;
        block7: {
            con = null;
            stmt = null;
            rs = null;
            con = this.getDataSource().getConnection();
            UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
            stmt = this.prepareRetrieveExternalValueStmt(con);
            stmt.setLong(1, instanceLogID.getMostSignificantBits());
            stmt.setLong(2, instanceLogID.getLeastSignificantBits());
            stmt.setInt(3, dataElementID);
            rs = stmt.executeQuery();
            if (!rs.next()) break block7;
            String realType = rs.getString("type");
            ProcessConstants.AdeptDataType actualDataType = DbProcessUnAwareAccess.getType(realType);
            if (actualDataType != expectedType) {
                throw new InvalidDataTypeException(instanceID, dataElementID, expectedType, actualDataType);
            }
            Serializable result = this.getValueFrom(rs, expectedType);
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.close(con);
            Serializable serializable = result;
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            return serializable;
        }
        try {
            try {
                if (this.checkDataElementAndType(instanceID, dataElementID, expectedType)) {
                    this.logger.log(Level.WARNING, "Trying to retrieve a value that is Null.");
                    throw new RuntimeException("Value is Null.");
                }
                this.logger.log(Level.WARNING, "Trying to access a non-existing dataElement");
                throw new RuntimeException("Data element does not exist.");
            }
            catch (SQLException e) {
                this.logSQLException(e, "retrieveExternalValue");
                throw new RuntimeException("Database access failed.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            throw throwable;
        }
    }

    private void storeValueExternal(UUID instanceID, int dataElementID, QualifiedAgent agent, ProcessConstants.AdeptDataType expectedType, Object value) throws InvalidDataTypeException {
        if (!this.checkDataElementAndType(instanceID, dataElementID, expectedType)) {
            this.logger.log(Level.SEVERE, "Tried to store data to a non-existing dataElement.");
            return;
        }
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        try {
            try {
                con = this.getDataSource().getConnection();
                UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
                stmt = this.prepareInsertExternalValueStmt(con);
                Timestamp now = new Timestamp(System.currentTimeMillis());
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                stmt.setInt(3, dataElementID);
                stmt.setTimestamp(4, now, JDBCTools.createUTCCalendar());
                stmt.setLong(5, agent.getAgentID());
                stmt.setLong(6, agent.getOrgPositionID());
                stmt.setBoolean(7, false);
                this.setParametersForValue(value, expectedType, stmt, 8);
                stmt.executeUpdate();
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException e) {
                this.logSQLException(e, "storeValue");
                throw new RuntimeException("Database access failed.", e);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "IOException occurred while writing data. ", e);
                throw new RuntimeException("IOException occurred.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt);
    }

    private Serializable retrieveLatestValue(UUID instanceID, int dataElementID, ProcessConstants.AdeptDataType expectedType) throws InvalidDataTypeException {
        ResultSet rs;
        PreparedStatement stmt;
        ExtendedConnection con;
        block7: {
            con = null;
            stmt = null;
            rs = null;
            con = this.getDataSource().getConnection();
            UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
            stmt = this.prepareRetrieveLatestValueStmt(con);
            stmt.setLong(1, instanceLogID.getMostSignificantBits());
            stmt.setLong(2, instanceLogID.getLeastSignificantBits());
            stmt.setInt(3, dataElementID);
            rs = stmt.executeQuery();
            if (!rs.next()) break block7;
            String realType = rs.getString("type");
            ProcessConstants.AdeptDataType actualDataType = DbProcessUnAwareAccess.getType(realType);
            if (actualDataType != expectedType) {
                throw new InvalidDataTypeException(instanceID, dataElementID, expectedType, actualDataType);
            }
            Serializable result = this.getValueFrom(rs, expectedType);
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.close(con);
            Serializable serializable = result;
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            return serializable;
        }
        try {
            try {
                if (this.checkDataElementAndType(instanceID, dataElementID, expectedType)) {
                    this.logger.log(Level.WARNING, "Trying to retrieve a value that is Null.");
                    throw new RuntimeException("Data element is Null.");
                }
                this.logger.log(Level.WARNING, "Trying to access a non-existing dataElement");
                throw new RuntimeException("Data element does not exist.");
            }
            catch (SQLException e) {
                this.logSQLException(e, "retriveLatestValue");
                throw new RuntimeException("Database access failed.", e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            throw throwable;
        }
    }
}

