/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.datamanager.dbimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.SessionStateManager;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataManager;
import de.aristaflow.adept2.util.LoggerTools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbSessionStateManager
implements SessionStateManager {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected DbDataManager dataManager;

    public DbSessionStateManager(DbDataManager dataManager) {
        this.dataManager = dataManager;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataManager.getDataSource();
    }

    private PreparedStatement prepareRetrieveSavepointsIDsStmt(Connection con) throws SQLException {
        String query = String.format("SELECT savePointID AS id FROM savepoints sp  WHERE sp.instanceID_hi = %s AND sp.instanceID_lo = %s AND sp.nodeID = %s AND sp.iteration = %s  ORDER BY createTime DESC", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareRetrieveSessionStateStmt(Connection con) throws SQLException {
        String query = String.format("SELECT sessionState AS state FROM savepoints sp  WHERE sp.instanceID_hi = %s AND sp.instanceID_lo = %s AND sp.nodeID = %s AND sp.iteration = %s  AND savePointID = %s", "?", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareStoreSessionStateStmt(Connection con) throws SQLException {
        String query = String.format("INSERT INTO savepoints (savePointID, instanceID_hi, instanceID_lo, nodeID, iteration, createTime, sessionState, agent, orgPosition) VALUES(%s, %s, %s, %s, %s, %s, %s, %s, %s)", "?", "?", "?", "?", "?", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareUpdateSessionStateStmt(Connection con) throws SQLException {
        String query = String.format("UPDATE savepoints SET createTime = %s, sessionState = %s, agent = %s, orgPosition = %s WHERE savePointID = %s AND instanceID_hi = %s AND instanceID_lo = %s AND nodeID = %s AND iteration = %s", "?", "?", "?", "?", "?", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    @Override
    public int getLatestSavepointID(UUID instanceID, int nodeID, int iteration) {
        int n;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDataSource().getConnection();
            UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
            stmt = this.prepareRetrieveSavepointsIDsStmt(con);
            stmt.setLong(1, instanceLogID.getMostSignificantBits());
            stmt.setLong(2, instanceLogID.getLeastSignificantBits());
            stmt.setInt(3, nodeID);
            stmt.setInt(4, iteration);
            rs = stmt.executeQuery();
            int savepointID = rs.next() ? rs.getInt("id") : -1;
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.close(con);
            n = savepointID;
        }
        catch (SQLException e) {
            try {
                this.logSQLException(e, "getLatestSavepointID");
                throw new RuntimeException("Database access failed. ", e);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        return n;
    }

    @Override
    public List<Integer> getStoredSavepoints(UUID instanceID, int nodeID, int iteration) {
        LinkedList<Integer> linkedList;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDataSource().getConnection();
            UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
            stmt = this.prepareRetrieveSavepointsIDsStmt(con);
            stmt.setLong(1, instanceLogID.getMostSignificantBits());
            stmt.setLong(2, instanceLogID.getLeastSignificantBits());
            stmt.setInt(3, nodeID);
            stmt.setInt(4, iteration);
            rs = stmt.executeQuery();
            LinkedList<Integer> savepoints = new LinkedList<Integer>();
            while (rs.next()) {
                savepoints.add(rs.getInt("id"));
            }
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.close(con);
            linkedList = savepoints;
        }
        catch (SQLException e) {
            try {
                this.logSQLException(e, "getStoredSavepoints");
                throw new RuntimeException("Database access failed. ", e);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        return linkedList;
    }

    @Override
    public byte[] retrieveSessionState(SessionToken session, int savepointID, UUID instanceID, int nodeID, int iteration) {
        this.dataManager.sessionActive(session);
        try {
            byte[] byArray;
            ExtendedConnection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getDataSource().getConnection();
                UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
                stmt = this.prepareRetrieveSessionStateStmt(con);
                stmt.setLong(1, instanceLogID.getMostSignificantBits());
                stmt.setLong(2, instanceLogID.getLeastSignificantBits());
                stmt.setInt(3, nodeID);
                stmt.setInt(4, iteration);
                stmt.setInt(5, savepointID);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new IllegalArgumentException("No session state found for the given savepoint ID!");
                }
                byte[] ret = rs.getBytes("state");
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
                byArray = ret;
            }
            catch (SQLException e) {
                try {
                    this.logSQLException(e, "retrieveSessionState");
                    throw new RuntimeException("Database access failed. ", e);
                }
                catch (Throwable throwable) {
                    JDBCTools.closeQuietly(con, stmt, rs);
                    throw throwable;
                }
            }
            JDBCTools.closeQuietly(con, (Statement)stmt, rs);
            return byArray;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void storeSessionState(SessionToken session, int savepointID, UUID instanceID, int nodeID, int iteration, byte[] sessionState) {
        this.dataManager.sessionActive(session);
        try {
            boolean exists = this.getStoredSavepoints(instanceID, nodeID, iteration).contains(savepointID);
            ExtendedConnection con = null;
            PreparedStatement stmt = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    UUID instanceLogID = this.dataManager.getLogIDForInstanceID(con, instanceID);
                    if (exists) {
                        stmt = this.prepareUpdateSessionStateStmt(con);
                        stmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()), JDBCTools.createUTCCalendar());
                        stmt.setBytes(2, sessionState);
                        stmt.setLong(3, this.dataManager.checkAndGetTopLevelAgent(session).getAgentID());
                        stmt.setLong(4, this.dataManager.checkAndGetTopLevelAgent(session).getOrgPositionID());
                        stmt.setInt(5, savepointID);
                        stmt.setLong(6, instanceLogID.getMostSignificantBits());
                        stmt.setLong(7, instanceLogID.getLeastSignificantBits());
                        stmt.setInt(8, nodeID);
                        stmt.setInt(9, iteration);
                        stmt.executeUpdate();
                    } else {
                        stmt = this.prepareStoreSessionStateStmt(con);
                        stmt.setInt(1, savepointID);
                        stmt.setLong(2, instanceLogID.getMostSignificantBits());
                        stmt.setLong(3, instanceLogID.getLeastSignificantBits());
                        stmt.setInt(4, nodeID);
                        stmt.setInt(5, iteration);
                        stmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()), JDBCTools.createUTCCalendar());
                        stmt.setBytes(7, sessionState);
                        stmt.setLong(8, this.dataManager.checkAndGetTopLevelAgent(session).getAgentID());
                        stmt.setLong(9, this.dataManager.checkAndGetTopLevelAgent(session).getOrgPositionID());
                        stmt.executeUpdate();
                    }
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    this.logSQLException(e, "getLatestSavepointID");
                    throw new RuntimeException("Database access failed. ", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    protected void logSQLException(SQLException e, String function) {
        this.logger.log(Level.SEVERE, String.format("A SQLException occurred in function %s.", function), e);
    }
}

