/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.datamanager.dbimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.UDFExecution;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataAccess;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataManager;
import de.aristaflow.adept2.model.datamanagement.UDFException;
import de.aristaflow.adept2.model.datamanagement.UDFNotRegisteredException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbUDFExecution
implements UDFExecution {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected DbDataManager dataManager;

    public DbUDFExecution(DbDataManager dataManager) {
        this.dataManager = dataManager;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataManager.getDataSource();
    }

    private PreparedStatement prepareRetrieveUDFStmt(Connection con) throws SQLException {
        String query = String.format("SELECT returnType, function, language FROM userDefinedFunctions WHERE userDefinedType = %s AND functionName = %s ", "?", "?");
        return con.prepareStatement(query);
    }

    @Override
    public boolean executeBooleanFunction(SessionToken session, UDTValue proxy, String functionName) throws UDFNotRegisteredException, UDFException {
        this.dataManager.sessionActive(session);
        try {
            this.getFunctionBody(proxy.getUserDefinedType(), functionName, ProcessConstants.AdeptDataType.BOOLEAN);
            return false;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public double executeFloatFunction(SessionToken session, UDTValue proxy, String functionName) throws UDFNotRegisteredException, UDFException {
        this.dataManager.sessionActive(session);
        try {
            this.getFunctionBody(proxy.getUserDefinedType(), functionName, ProcessConstants.AdeptDataType.FLOAT);
            return 0.0;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public long executeIntegerFunction(SessionToken session, UDTValue proxy, String functionName) throws UDFNotRegisteredException, UDFException {
        this.dataManager.sessionActive(session);
        try {
            this.getFunctionBody(proxy.getUserDefinedType(), functionName, ProcessConstants.AdeptDataType.INTEGER);
            return 0L;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public String executeStringFunction(SessionToken session, UDTValue proxy, String functionName) throws UDFNotRegisteredException, UDFException {
        this.dataManager.sessionActive(session);
        try {
            this.getFunctionBody(proxy.getUserDefinedType(), functionName, ProcessConstants.AdeptDataType.STRING);
            return null;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public UDTValue executeUDTFunction(SessionToken session, UDTValue proxy, String functionName) throws UDFNotRegisteredException, UDFException {
        this.dataManager.sessionActive(session);
        try {
            this.getFunctionBody(proxy.getUserDefinedType(), functionName, ProcessConstants.AdeptDataType.USERDEFINED);
            return null;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public URI executeURIFunction(SessionToken session, UDTValue proxy, String functionName) throws UDFNotRegisteredException, UDFException {
        this.dataManager.sessionActive(session);
        try {
            this.getFunctionBody(proxy.getUserDefinedType(), functionName, ProcessConstants.AdeptDataType.URI);
            return null;
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void executeVoidFunction(SessionToken session, UDTValue proxy, String functionName) throws UDFNotRegisteredException, UDFException {
        this.dataManager.sessionActive(session);
        try {
            this.getFunctionBody(proxy.getUserDefinedType(), functionName, null);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    private UDFInfo getFunctionBody(String userDefinedType, String functionName, ProcessConstants.AdeptDataType expectedReturnType) throws UDFException, UDFNotRegisteredException {
        UDFInfo uDFInfo;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDataSource().getConnection();
            stmt = this.prepareRetrieveUDFStmt(con);
            stmt.setString(1, userDefinedType);
            stmt.setString(2, functionName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                boolean correctReturnType = true;
                String realReturnType = rs.getString("returnType");
                if (rs.wasNull()) {
                    if (expectedReturnType != null) {
                        correctReturnType = false;
                    }
                } else if (DbDataAccess.getType(realReturnType) != expectedReturnType) {
                    correctReturnType = false;
                }
                if (!correctReturnType) {
                    throw new UDFException(String.format("Function's return type is %s.", realReturnType));
                }
            } else {
                throw new UDFNotRegisteredException();
            }
            Clob function = rs.getClob("body");
            String language = rs.getString("language");
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.close(con);
            uDFInfo = new UDFInfo(function.toString(), language);
        }
        catch (SQLException e) {
            try {
                this.logger.log(Level.SEVERE, "SQLException occured.", e);
                throw new RuntimeException("Error while communicating with the database.", e);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        return uDFInfo;
    }

    private static class UDFInfo {
        private String function;
        private String language;

        public UDFInfo(String function, String language) {
            this.function = function;
            this.language = language;
        }

        public String getFunction() {
            return this.function;
        }

        public String getLanguage() {
            return this.language;
        }
    }
}

