/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.datamanager.dbimplementation;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.UDTManager;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataAccess;
import de.aristaflow.adept2.core.datamanager.dbimplementation.DbDataManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ConstraintViolationException;
import de.aristaflow.adept2.util.LoggerTools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbUDTManager
implements UDTManager {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected DbDataManager dataManager;

    public DbUDTManager(DbDataManager dataManager) {
        this.dataManager = dataManager;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataManager.getDataSource();
    }

    private PreparedStatement prepareRetreiveDataTypeStmt(Connection con) throws SQLException {
        String query = String.format("SELECT dT.dataType, count(dE.dataElementID) as cnt FROM dataTypes dT LEFT OUTER JOIN dataElements dE ON dT.dataType = dE.type WHERE dT.dataType = %s GROUP BY dT.dataType", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareInsertDataTypeStmt(Connection con) throws SQLException {
        String query = String.format("INSERT INTO dataTypes(dataType, isUserDefined) VALUES(%s, 1)", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareDeleteDataTypeStmt(Connection con) throws SQLException {
        String query = String.format("DELETE FROM dataTypes WHERE dataType = %s AND  isUserDefined <> 0", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareInsertUDFStmt(Connection con) throws SQLException {
        String query = String.format("INSERT INTO userDefinedFunctions(userDefinedType, functionName, returnType, body, language) VALUES(%s, %s, %s, %s, %s)", "?", "?", "?", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareRetrieveUDFExistsStmt(Connection con) throws SQLException {
        String query = String.format("SELECT COUNT(userDefinedType) as cnt FROM userDefinedFunctions WHERE userDefinedType = %s AND functionName = %s ", "?", "?");
        return con.prepareStatement(query);
    }

    private PreparedStatement prepareDeleteUDFStmt(Connection con) throws SQLException {
        String query = String.format("DELETE FROM userDefinedFunctions WHERE userDefinedType = %s AND functionName = %s ", "?", "?");
        return con.prepareStatement(query);
    }

    @Override
    public void createDataType(SessionToken session, String userDefinedDataType) throws ConstraintViolationException {
        block9: {
            this.dataManager.sessionActive(session);
            try {
                if (this.isTypeInUse(userDefinedDataType) == -1) {
                    ExtendedConnection con = null;
                    PreparedStatement stmt = null;
                    try {
                        try {
                            con = this.getDataSource().getConnection();
                            stmt = this.prepareInsertDataTypeStmt(con);
                            stmt.setString(1, userDefinedDataType);
                            stmt.executeUpdate();
                            stmt = JDBCTools.close(stmt);
                            con = JDBCTools.close(con);
                        }
                        catch (SQLException e) {
                            this.logSQLException(e, "createDataType");
                            throw new RuntimeException("UDT could not be created. ", e);
                        }
                    }
                    catch (Throwable throwable) {
                        JDBCTools.closeQuietly(con, stmt);
                        throw throwable;
                    }
                    JDBCTools.closeQuietly(con, (Statement)stmt);
                    break block9;
                }
                throw new ConstraintViolationException();
            }
            finally {
                this.dataManager.sessionFinished(session);
            }
        }
    }

    @Override
    public void deleteDataType(SessionToken session, String userDefinedDataType) throws ConstraintViolationException {
        block9: {
            this.dataManager.sessionActive(session);
            try {
                if (DbDataAccess.getType(userDefinedDataType) == ProcessConstants.AdeptDataType.USERDEFINED && this.isTypeInUse(userDefinedDataType) == 0) {
                    ExtendedConnection con = null;
                    PreparedStatement stmt = null;
                    try {
                        try {
                            con = this.getDataSource().getConnection();
                            stmt = this.prepareDeleteDataTypeStmt(con);
                            stmt.setString(1, userDefinedDataType);
                            stmt.executeUpdate();
                            stmt = JDBCTools.close(stmt);
                            con = JDBCTools.close(con);
                        }
                        catch (SQLException e) {
                            this.logSQLException(e, "deleteDataType");
                            throw new RuntimeException("UDT could not be deleted. ", e);
                        }
                    }
                    catch (Throwable throwable) {
                        JDBCTools.closeQuietly(con, stmt);
                        throw throwable;
                    }
                    JDBCTools.closeQuietly(con, (Statement)stmt);
                    break block9;
                }
                throw new ConstraintViolationException();
            }
            finally {
                this.dataManager.sessionFinished(session);
            }
        }
    }

    @Override
    public void createUDF(SessionToken session, String userDefinedDataType, String functionName, ProcessConstants.AdeptDataType returnType, String function, String language) throws ConstraintViolationException {
        this.dataManager.sessionActive(session);
        try {
            ExtendedConnection con = null;
            PreparedStatement stmt = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    if (this.isFunctionInUse(userDefinedDataType, functionName, false) == -1) {
                        stmt = this.prepareInsertUDFStmt(con);
                        stmt.setString(1, userDefinedDataType);
                        stmt.setString(2, functionName);
                        if (returnType == null) {
                            stmt.setNull(3, 2005);
                        } else {
                            stmt.setString(3, DbDataAccess.getTypeRepresentation(returnType));
                        }
                    } else {
                        throw new ConstraintViolationException();
                    }
                    stmt.setString(4, function);
                    stmt.setString(5, language);
                    stmt.executeUpdate();
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    this.logSQLException(e, "createUDF");
                    throw new RuntimeException("UDF could not be created. ", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    @Override
    public void deleteUDF(SessionToken session, String userDefinedDataType, String functionName) throws ConstraintViolationException {
        this.dataManager.sessionActive(session);
        try {
            ExtendedConnection con = null;
            PreparedStatement stmt = null;
            try {
                try {
                    con = this.getDataSource().getConnection();
                    if (this.isFunctionInUse(userDefinedDataType, functionName, true) != 0) {
                        throw new ConstraintViolationException();
                    }
                    stmt = this.prepareDeleteUDFStmt(con);
                    stmt.setString(1, userDefinedDataType);
                    stmt.setString(2, functionName);
                    stmt.executeUpdate();
                    stmt = JDBCTools.close(stmt);
                    con = JDBCTools.close(con);
                }
                catch (SQLException e) {
                    this.logSQLException(e, "deleteUDF");
                    throw new RuntimeException("UDF could not be deleted. ", e);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt);
                throw throwable;
            }
            JDBCTools.closeQuietly(con, (Statement)stmt);
        }
        finally {
            this.dataManager.sessionFinished(session);
        }
    }

    private int isTypeInUse(String userDefinedDataType) {
        int n;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getDataSource().getConnection();
            stmt = this.prepareRetreiveDataTypeStmt(con);
            stmt.setString(1, userDefinedDataType);
            rs = stmt.executeQuery();
            int result = rs.next() ? rs.getInt("cnt") : -1;
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.close(con);
            n = result;
        }
        catch (SQLException e) {
            try {
                this.logSQLException(e, "isTypeInUse");
                throw new RuntimeException("Database access failed.", e);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        return n;
    }

    private int isFunctionInUse(String userDefinedDataType, String functionName, boolean checkTemplates) throws SQLException {
        int n;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int result;
            con = this.getDataSource().getConnection();
            stmt = this.prepareRetrieveUDFExistsStmt(con);
            stmt.setString(1, userDefinedDataType);
            stmt.setString(2, functionName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                boolean isUsed;
                boolean exists;
                boolean bl = exists = rs.getInt("cnt") > 0;
                result = exists && checkTemplates ? ((isUsed = false) ? 1 : 0) : (exists ? 0 : -1);
            } else {
                result = -1;
            }
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.close(con);
            n = result;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        return n;
    }

    protected void logSQLException(SQLException e, String function) {
        this.logger.log(Level.SEVERE, String.format("A SQLException occurred in function %s.", function), e);
    }
}

