/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.datamanager.tools;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.ProcessUnawareAccess;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataManagerTools {
    protected static final Logger logger = LoggerTools.getLogger(DataManagerTools.class);
    public static final int MAX_STRING_LENGTH = 100;

    public static String getStringRepresentationForDataElementContent(SessionToken session, ProcessUnawareAccess processUnawareAccess, UUID instanceID, int dataElementID, ProcessConstants.AdeptDataType dataType, QualifiedAgent agent) throws InvalidDataTypeException {
        if (processUnawareAccess.isLatestValueNull(session, instanceID, dataElementID)) {
            return "(null)";
        }
        switch (dataType) {
            case BOOLEAN: {
                return Boolean.toString(processUnawareAccess.retrieveLatestBooleanValue(session, instanceID, dataElementID));
            }
            case DATE: {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return dateFormat.format(processUnawareAccess.retrieveLatestDateValue(session, instanceID, dataElementID));
            }
            case FLOAT: {
                return Double.toString(processUnawareAccess.retrieveLatestFloatValue(session, instanceID, dataElementID));
            }
            case INTEGER: {
                return Long.toString(processUnawareAccess.retrieveLatestIntegerValue(session, instanceID, dataElementID));
            }
            case STRING: {
                String string = processUnawareAccess.retrieveLatestStringValue(session, instanceID, dataElementID);
                if (string.length() > 100) {
                    string = string.substring(0, 99);
                    string = String.valueOf(string) + "...";
                }
                return string;
            }
            case URI: {
                return processUnawareAccess.retrieveLatestURIValue(session, instanceID, dataElementID).toASCIIString();
            }
            case USERDEFINED: {
                String content;
                int bytesRead;
                UDTValue udtValue = processUnawareAccess.retrieveLatestUDTValue(session, instanceID, dataElementID);
                InputStream stream = udtValue.getValueAsStream();
                byte[] b = new byte[100];
                try {
                    bytesRead = stream.read(b);
                }
                catch (IOException e) {
                    String message = String.format("An IO exception occurred while trying to read data element with ID %s from instance #%s as '%s:%s' (agent:position).", dataElementID, instanceID, agent.getAgentID(), agent.getOrgPositionID());
                    logger.log(Level.SEVERE, message, e);
                    throw new RuntimeException(message, e);
                }
                if (bytesRead == -1) {
                    content = "(empty)";
                } else {
                    content = new String(b);
                    if (bytesRead == 100) {
                        content = String.valueOf(content) + "...";
                    }
                    content = content.replaceAll("\\p{Cntrl}", "");
                }
                return content;
            }
        }
        logger.severe("Unknown data type: " + (Object)((Object)dataType));
        return "(unknown data type)";
    }
}

