/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.common;

import de.aristaflow.adept2.core.eventmanager.common.EventTypeIndex;
import de.aristaflow.adept2.model.events.Event;
import de.aristaflow.adept2.util.ArgChecks;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class AbstractEvent
implements Event {
    protected static final Map<EventTypeIndex, AtomicLong> ID_COUNT = new HashMap<EventTypeIndex, AtomicLong>();
    protected final long id;
    protected final URI[] managerURI;
    protected final String eventType;
    protected final String sourceType;
    protected final String sourceID;
    protected final long creationTime;

    public AbstractEvent(URI[] managerURI, String eventType, String sourceType, String sourceID) {
        AtomicLong idCount;
        ArgChecks.checkForEmpty(managerURI, "managerURI");
        ArgChecks.checkForBlank(eventType, "eventType");
        ArgChecks.checkForBlank(sourceType, "sourceType");
        ArgChecks.checkForBlank(sourceID, "sourceID");
        this.managerURI = (URI[])managerURI.clone();
        this.eventType = eventType;
        this.sourceType = sourceType;
        this.sourceID = sourceID;
        this.creationTime = System.currentTimeMillis();
        EventTypeIndex index = new EventTypeIndex(this);
        if (ID_COUNT.containsKey(index)) {
            idCount = ID_COUNT.get(index);
        } else {
            idCount = new AtomicLong();
            ID_COUNT.put(index, idCount);
        }
        this.id = idCount.getAndIncrement();
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public URI[] getEventManager() {
        return (URI[])this.managerURI.clone();
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    @Override
    public String getSourceType() {
        return this.sourceType;
    }

    @Override
    public String getSourceID() {
        return this.sourceID;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }
}

