/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.common;

import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.model.events.handler.EventHandler;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;

public abstract class AbstractEventHandler
implements EventHandler {
    protected final Logger logger;
    protected final String id;
    protected final boolean exclusive;
    protected final boolean consuming;

    public AbstractEventHandler(String id, boolean exclusive, boolean consuming) {
        this.logger = LoggerTools.getLogger(this);
        this.id = id;
        this.exclusive = exclusive || consuming;
        this.consuming = consuming;
    }

    public AbstractEventHandler(Registry registry, boolean exclusive, boolean consuming) {
        ArgChecks.checkForNull(registry, "registry");
        this.logger = LoggerTools.getLogger(this);
        this.id = AbstractRegistry.getSimpleInstanceName(registry.getInstanceName());
        this.exclusive = exclusive || consuming;
        this.consuming = consuming;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public boolean isConsuming() {
        return this.consuming;
    }
}

