/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.common;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.model.events.Event;
import de.aristaflow.adept2.model.events.EventHandlingException;
import de.aristaflow.adept2.model.events.handler.EventHandler;
import de.aristaflow.adept2.model.events.sources.EventSource;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public abstract class AbstractEventSource<T extends Event>
implements EventSource<T> {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final String type;
    protected String id;
    protected final ReadWriteLock lock;
    protected final List<EventHandler> handlerList;

    public AbstractEventSource(String type) {
        this.type = type;
        this.lock = new ReentrantReadWriteLock();
        this.handlerList = new ArrayList<EventHandler>();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setConfiguration(Configuration conf, String id) throws ConfigurationException {
        ArgChecks.checkForEmpty(id, "id");
        this.id = id;
    }

    @Override
    public List<EventHandler> getEventHandler() {
        this.lock.readLock().lock();
        try {
            ArrayList<EventHandler> ret = new ArrayList<EventHandler>(this.handlerList);
            List<EventHandler> list = Collections.unmodifiableList(ret);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void addHandler(EventHandler handler, int index) {
        ArgChecks.checkForNull(handler, "handler");
        ArgChecks.checkForNegative(index, "index");
        this.lock.writeLock().lock();
        try {
            this.handlerList.add(index, handler);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void addAll(List<EventHandler> handler) {
        ArgChecks.checkForNull(handler, "handler");
        this.lock.writeLock().lock();
        try {
            this.handlerList.addAll(handler);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public EventHandler removeHandler(String handlerID) {
        ArgChecks.checkForEmpty(handlerID, "handlerID");
        EventHandler ret = null;
        this.lock.writeLock().lock();
        try {
            Iterator<EventHandler> it = this.handlerList.iterator();
            while (it.hasNext()) {
                EventHandler current = it.next();
                if (!handlerID.equals(current.getID())) continue;
                it.remove();
                ret = current;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return ret;
    }

    protected boolean handleEvent(T event, boolean concurrent) throws EventHandlingException {
        boolean ret = false;
        EventHandlingException ex = null;
        this.lock.readLock().lock();
        try {
            for (EventHandler handler : this.handlerList) {
                String msg;
                try {
                    if (!this.nextHandler(event, ret, false)) {
                        msg = "Preparation of the handling of event '%s/%s/%s/%s' (service: '%s') with event handler '%s' failed. Aborting event handling.";
                        msg = String.format(msg, event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()), handler.getID());
                        this.logger.info(msg);
                        break;
                    }
                    ret |= handler.handleEvent((Event)event, ret);
                }
                catch (EventHandlingException ehe) {
                    if (ex == null) {
                        ex = ehe;
                    }
                    msg = "An event handling exception occurred when handling the event '%s/%s/%s/%s' (service: '%s') with event handler '%s'. Continuing with event handling.";
                    msg = String.format(msg, event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()), handler.getID());
                    this.logger.log(Level.INFO, msg, ehe);
                }
                catch (RuntimeException re) {
                    msg = "A runtime exception occurred when handling the event '%s/%s/%s/%s' (service: '%s') with event handler '%s'. Continuing with event handling.";
                    msg = String.format(msg, event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()), handler.getID());
                    this.logger.log(Level.INFO, msg, re);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (ex != null) {
            throw ex;
        }
        return ret;
    }

    protected abstract boolean nextHandler(T var1, boolean var2, boolean var3);
}

