/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.common;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.service.AbstractAuthenticatedService;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.eventmanager.ActivityEventManager;
import de.aristaflow.adept2.core.eventmanager.InstanceStartEventManager;
import de.aristaflow.adept2.core.eventmanager.common.WorklistHandler;
import de.aristaflow.adept2.core.executionmanager.ActivityStarting;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.processmanager.ProcessManagerTools;
import de.aristaflow.adept2.core.runtimeservice.RemoteActivityStarting;
import de.aristaflow.adept2.core.runtimeservice.RemoteProgressMonitor;
import de.aristaflow.adept2.core.runtimeservice.RemoteRuntimeEnvironment;
import de.aristaflow.adept2.core.runtimeservice.RuntimeService;
import de.aristaflow.adept2.core.worklistmanager.WorklistManager;
import de.aristaflow.adept2.model.datamanagement.InstanceDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.events.Event;
import de.aristaflow.adept2.model.events.MailEvent;
import de.aristaflow.adept2.model.events.ResultSetEvent;
import de.aristaflow.adept2.model.events.handler.EventHandler;
import de.aristaflow.adept2.model.events.sources.EventSource;
import de.aristaflow.adept2.model.events.sources.PollingSource;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.runtimeenvironment.SimpleSessionContext;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.ExecutorTools;
import de.aristaflow.adept2.util.types.Pair;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="StartActivityTimeout", type=Property.Type.LONG, defaultValue="30000", description="The time in milliseconds to wait for the start of an activity by the runtime service."), @Property(name="AddEventSourceRetryCount", type=Property.Type.INT, defaultValue="10", description="The number of retries for adding an event source."), @Property(name="AddEventSourceRetryDelay", type=Property.Type.LONG, defaultValue="20000", description="The time in milliseconds to wait before retrying to add an event source."), @Property(name="MinPoolSize", type=Property.Type.INT, defaultValue="0", description="The minimal number of executor threads for polling events."), @Property(name="PingWLM", type=Property.Type.INT, defaultValue="5000", description="The time span in milliseconds after which the worklist manager is pinged to check whether it is still available. If not, reconnecting will be tried in the same time span."), @Property(name="PollerPriority", type=Property.Type.INT, defaultValue="3", description="The priority of the worker threads. The worklist handler thread responsible for worklist updates will have a priority higher by 2."), @Property(name="UpdateInterval", type=Property.Type.LONG, defaultValue="1000", description="The interval for pushed updates in ms.")})
public class DefaultEventManager
extends AbstractAuthenticatedService
implements ActivityEventManager,
InstanceStartEventManager {
    public static final String PLUGIN_TYPE_DB_RESULT_SET_EVENT = "DBResultSetEvent";
    public static final String PLUGIN_TYPE_MAIL_EVENT = "MailEvent";
    protected static final String PREREGISTERED_EVENT_HANDLER = "EventHandler";
    protected static final String CONF_START_ACTIVITY_TIMEOUT = "StartActivityTimeout";
    protected final long startActivityTimeout;
    protected static final String CONF_ADD_EVENT_SOURCE_RETRY_COUNT = "AddEventSourceRetryCount";
    protected final int addEventSourceRetryCount;
    protected static final String CONF_ADD_EVENT_SOURCE_RETRY_DELAY = "AddEventSourceRetryDelay";
    protected final long addEventSourceRetryDelay;
    protected static final String CONF_MIN_POOL_SIZE = "MinPoolSize";
    protected final int minPoolSize;
    protected static final String CONF_PING_WLM_INTERVAL = "PingWLM";
    protected final long pingWLMInterval;
    protected static final String CONF_POLLER_PRIORITY = "PollerPriority";
    protected final int pollerPriority;
    protected static final String CONF_UPDATE_INTERVAL = "UpdateInterval";
    protected final long updateInterval;
    protected final Configuration configuration;
    protected ExecutionFactory exmFactory;
    protected FilterFactory filterFactory;
    protected RuntimeService runtimeService;
    protected ProcessManager pm;
    protected InstanceControl instanceControl;
    protected ActivityStarting activitySelecting;
    protected ScheduledThreadPoolExecutor pollService;
    protected WorklistHandler worklistHandler;
    protected final ReadWriteLock dataLock;
    protected final Map<Pair<String, String>, Map<String, EventSource<? extends Event>>> sources;
    protected final Map<PollingSource<? extends Event>, ScheduledFuture<?>> futures;
    protected final Map<Pair<String, String>, List<EventHandler>> handler;
    protected final Map<EventHandler, Collection<EventSource<? extends Event>>> handlerSource;
    private static final String[] startupRequiredServices = new String[]{"RuntimeService", "ProcessManager", "ExecutionManager", "WorklistManager"};
    private static final String[] runtimeRequiredServices = new String[]{"JDBCDataSource"};
    protected final Map<String, Class<? extends Event>> supportedEventTypes;

    public DefaultEventManager(Configuration conf, Registry registry) throws ConfigurationException {
        super(conf, registry, startupRequiredServices, runtimeRequiredServices);
        this.startActivityTimeout = conf.getLong(CONF_START_ACTIVITY_TIMEOUT);
        this.addEventSourceRetryCount = conf.getInt(CONF_ADD_EVENT_SOURCE_RETRY_COUNT);
        this.addEventSourceRetryDelay = conf.getLong(CONF_ADD_EVENT_SOURCE_RETRY_DELAY);
        this.minPoolSize = conf.getInt(CONF_MIN_POOL_SIZE) + 2;
        this.pingWLMInterval = conf.getLong(CONF_PING_WLM_INTERVAL);
        this.pollerPriority = conf.getInt(CONF_POLLER_PRIORITY);
        this.updateInterval = conf.getLong(CONF_UPDATE_INTERVAL);
        this.configuration = conf;
        this.dataLock = new ReentrantReadWriteLock();
        this.sources = new HashMap<Pair<String, String>, Map<String, EventSource<? extends Event>>>();
        this.futures = new HashMap();
        this.handler = new HashMap<Pair<String, String>, List<EventHandler>>();
        this.handlerSource = new HashMap<EventHandler, Collection<EventSource<? extends Event>>>();
        HashMap<String, Class> supEvTypes = new HashMap<String, Class>(1);
        supEvTypes.put(PLUGIN_TYPE_DB_RESULT_SET_EVENT, ResultSetEvent.class);
        supEvTypes.put(PLUGIN_TYPE_MAIL_EVENT, MailEvent.class);
        this.supportedEventTypes = Collections.unmodifiableMap(supEvTypes);
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        SessionToken session = this.createSession();
        this.exmFactory = this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
        this.filterFactory = this.registry.getModelFactory("FilterFactory", FilterFactory.class);
        this.runtimeService = this.registry.getServiceOfType(session, "RuntimeService", RuntimeService.class);
        this.pm = this.registry.getServiceOfType(session, "ProcessManager", ProcessManager.class);
        ExecutionManager exMgr = this.registry.getServiceOfType(session, "ExecutionManager", ExecutionManager.class);
        this.instanceControl = exMgr.getInstanceControl();
        this.activitySelecting = exMgr.getActivityStarting();
        Adept2ThreadFactory factory = new Adept2ThreadFactory("EventPoller", this.pollerPriority, this.logger);
        this.pollService = new ScheduledThreadPoolExecutor(this.minPoolSize, factory);
        this.pollService.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.pollService.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        WorklistManager wlm = this.registry.getServiceOfType(session, "WorklistManager", WorklistManager.class);
        WorklistModelFactory wmf = this.registry.getModelFactory("WorklistModelFactory", WorklistModelFactory.class);
        WorklistUpdateConfiguration updateConfiguration = wmf.createPushWorklistConfiguration(this.updateInterval, null);
        boolean successful = false;
        try {
            this.addPreregistered(this.configuration);
            this.worklistHandler = new WorklistHandler(wlm, updateConfiguration, this.pingWLMInterval, Math.min(this.pollerPriority + 2, 10), this.addEventSourceRetryCount, this.addEventSourceRetryDelay, this, this.registry);
            successful = true;
        }
        finally {
            if (!successful) {
                this.emergencyShutdown();
            }
        }
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.pollService.execute(this.worklistHandler);
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
        super.shutdown();
    }

    @Override
    public void emergencyShutdown() {
        this.shutdown(true);
        super.emergencyShutdown();
    }

    protected void addPreregistered(Configuration conf) throws ServiceNotKnownException, ConfigurationException {
        this.addPreregistered(conf, conf.getKeys(PLUGIN_TYPE_DB_RESULT_SET_EVENT));
        this.addPreregistered(conf, conf.getKeys(PLUGIN_TYPE_MAIL_EVENT));
    }

    protected void addPreregistered(Configuration conf, Iterator<String> sourceTypes) throws ServiceNotKnownException, ConfigurationException {
        while (sourceTypes.hasNext()) {
            String key = sourceTypes.next();
            String[] keys = key.split(Pattern.quote("."));
            if (keys.length == 3 && PREREGISTERED_EVENT_HANDLER.equals(keys[2])) {
                List regHandler = conf.getList(key);
                int i = 0;
                while (i < regHandler.size()) {
                    this.addEventHandler(this.createSession(), keys[0], keys[1], (String)regHandler.get(i), i);
                    ++i;
                }
            }
            if (keys.length != 3 || !"Instances".equals(keys[2])) continue;
            List regSources = conf.getList(key);
            for (String sourceID : regSources) {
                Configuration sourceConf = conf.subset(sourceID);
                this.addEventSource(this.createSession(), keys[0], keys[1], sourceID, sourceConf);
            }
        }
    }

    @Override
    public SessionToken createSession() {
        return super.createSession();
    }

    protected void shutdown(boolean emergency) {
        this.awaitActiveSessions(emergency);
        if (this.worklistHandler != null) {
            this.worklistHandler.shutdown();
        }
        this.removeAllSources();
        if (emergency) {
            this.pollService.shutdownNow();
        } else {
            this.pollService.shutdown();
        }
        ExecutorTools.awaitTermination(this.pollService);
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return this.pollService;
    }

    protected void removeAllSources() {
        this.dataLock.writeLock().lock();
        try {
            SessionToken session = this.createSession();
            HashSet<Pair<String, String>> typePairs = new HashSet<Pair<String, String>>(this.sources.keySet());
            for (Pair pair : typePairs) {
                HashSet<String> sourceIDs = new HashSet<String>(this.sources.get(pair).keySet());
                for (String sourceID : sourceIDs) {
                    this.removeEventSource(session, (String)pair.getFirst(), (String)pair.getSecond(), sourceID);
                }
            }
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public Map<String, Class<? extends Event>> getSupportedEventTypes(SessionToken session) {
        super.sessionActive(session);
        try {
            Map<String, Class<? extends Event>> map = this.supportedEventTypes;
            return map;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Collection<String> getEventSources(SessionToken session, String eventType, String sourceType) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForBlank(eventType, "eventType");
        ArgChecks.checkForBlank(sourceType, "sourceType");
        super.sessionActive(session);
        try {
            Collection<Object> ret;
            this.dataLock.readLock().lock();
            try {
                Pair<String, String> typePair = new Pair<String, String>(eventType, sourceType);
                if (this.sources.containsKey(typePair)) {
                    ret = this.sources.get(typePair).keySet();
                    ret = Collections.unmodifiableCollection(ret);
                } else {
                    ret = Collections.emptySet();
                }
            }
            finally {
                this.dataLock.readLock().unlock();
            }
            Set<String> set = ret;
            return set;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public EventSource<? extends Event> addEventSource(SessionToken session, String eventType, String sourceType, String sourceID, Configuration conf) throws ConfigurationException, ServiceNotKnownException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForBlank(eventType, "eventType");
        ArgChecks.checkForBlank(sourceType, "sourceType");
        ArgChecks.checkForBlank(sourceID, "sourceID");
        ArgChecks.checkForNull(conf, "conf");
        String msg = "Add event source '%s' with eventType: %s, sourceType: %s, session: %s";
        this.logger.finer(String.format(msg, sourceID, eventType, sourceType, session));
        super.sessionActive(session);
        try {
            Pair<String, String> typePair = new Pair<String, String>(eventType, sourceType);
            EventSource ret = null;
            this.dataLock.writeLock().lock();
            try {
                Map<Object, Object> source;
                if (this.sources.containsKey(typePair)) {
                    source = this.sources.get(typePair);
                } else {
                    source = new HashMap(3);
                    this.sources.put(typePair, source);
                }
                if (source.containsKey(sourceID)) {
                    EventSource eventSource = (EventSource)source.get(sourceID);
                    return eventSource;
                }
                ret = this.registry.getConfiguredPlugin(this.createSession(), this, eventType, EventSource.class, sourceType);
                ret.setConfiguration(conf, sourceID);
                source.put(sourceID, ret);
                if (this.handler.containsKey(typePair)) {
                    List<EventHandler> handlerList = this.handler.get(typePair);
                    ret.addAll(handlerList);
                    for (EventHandler current : handlerList) {
                        Collection<Object> srcs;
                        if (this.handlerSource.containsKey(current)) {
                            srcs = this.handlerSource.get(current);
                        } else {
                            srcs = new HashSet();
                            this.handlerSource.put(current, srcs);
                        }
                        srcs.add(ret);
                    }
                }
                if (ret instanceof PollingSource) {
                    PollingSource poller = (PollingSource)ret;
                    poller.init();
                    long initDelay = Math.min(5000L, poller.getPollTime());
                    ScheduledFuture<?> future = this.pollService.scheduleAtFixedRate(poller, initDelay, poller.getPollTime(), TimeUnit.MILLISECONDS);
                    this.futures.put(poller, future);
                }
            }
            finally {
                this.dataLock.writeLock().unlock();
            }
            EventSource eventSource = ret;
            return eventSource;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public EventSource<? extends Event> removeEventSource(SessionToken session, String eventType, String sourceType, String sourceID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForBlank(eventType, "eventType");
        ArgChecks.checkForBlank(sourceType, "sourceType");
        ArgChecks.checkForBlank(sourceID, "sourceID");
        String msg = "Remove event source '%s' with eventType: %s, sourceType: %s, session: %s";
        this.logger.finer(String.format(msg, sourceID, eventType, sourceType, session));
        super.sessionActive(session);
        try {
            EventSource<? extends Event> ret = null;
            Pair<String, String> typePair = new Pair<String, String>(eventType, sourceType);
            this.dataLock.writeLock().lock();
            try {
                if (this.sources.containsKey(typePair)) {
                    Map<String, EventSource<? extends Event>> source = this.sources.get(typePair);
                    ret = source.remove(sourceID);
                    if (source.size() < 1) {
                        this.sources.remove(typePair);
                    }
                }
                if (ret != null) {
                    List<EventHandler> regHandlers;
                    ScheduledFuture<?> future = this.futures.remove(ret);
                    if (future != null) {
                        future.cancel(false);
                    }
                    if ((regHandlers = ret.getEventHandler()) != null) {
                        for (EventHandler regHandler : regHandlers) {
                            Collection<EventSource<? extends Event>> srcs = this.handlerSource.get(regHandler);
                            srcs.remove(ret);
                            if (srcs.size() >= 1) continue;
                            this.handlerSource.remove(regHandler);
                        }
                    }
                    if (ret instanceof PollingSource) {
                        ((PollingSource)ret).terminate();
                    }
                }
                EventSource<? extends Event> eventSource = ret;
                this.dataLock.writeLock().unlock();
                return eventSource;
            }
            catch (Throwable throwable) {
                this.dataLock.writeLock().unlock();
                throw throwable;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public List<String> getEventHandler(SessionToken session, String eventType, String sourceType) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForBlank(eventType, "eventType");
        ArgChecks.checkForBlank(sourceType, "sourceType");
        super.sessionActive(session);
        try {
            List<String> ret;
            this.dataLock.readLock().lock();
            try {
                Pair<String, String> typePair = new Pair<String, String>(eventType, sourceType);
                List<EventHandler> handlerList = this.handler.get(typePair);
                if (handlerList != null) {
                    ret = new ArrayList(handlerList.size());
                    for (EventHandler regHandler : handlerList) {
                        ret.add(regHandler.getID());
                    }
                    ret = Collections.unmodifiableList(ret);
                } else {
                    ret = Collections.emptyList();
                }
            }
            finally {
                this.dataLock.readLock().unlock();
            }
            List<String> list = ret;
            return list;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public EventHandler addEventHandler(SessionToken session, String eventType, String sourceType, String handlerID, int index) throws ServiceNotKnownException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForBlank(eventType, "eventType");
        ArgChecks.checkForBlank(sourceType, "sourceType");
        ArgChecks.checkForBlank(handlerID, "handlerID");
        super.sessionActive(session);
        try {
            EventHandler eventHandler = this.addEventHandler(session, eventType, sourceType, handlerID, null, index);
            return eventHandler;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public EventHandler addEventHandler(SessionToken session, String eventType, String sourceType, EventHandler current, int index) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForBlank(eventType, "eventType");
        ArgChecks.checkForBlank(sourceType, "sourceType");
        ArgChecks.checkForNull(current, "current");
        super.sessionActive(session);
        try {
            EventHandler ret = null;
            try {
                ret = this.addEventHandler(session, eventType, sourceType, null, current, index);
            }
            catch (ServiceNotKnownException serviceNotKnownException) {}
            EventHandler eventHandler = ret;
            return eventHandler;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected EventHandler addEventHandler(SessionToken session, String eventType, String sourceType, String handlerID, EventHandler current, int index) throws ServiceNotKnownException {
        Pair<String, String> typePair = new Pair<String, String>(eventType, sourceType);
        if (current != null) {
            handlerID = current.getID();
        }
        String msg = "Add event handler '%s' with eventType: %s, sourceType: %s, index: %d, session: %s";
        msg = String.format(msg, handlerID, eventType, sourceType, index, session);
        this.logger.finer(msg);
        this.dataLock.writeLock().lock();
        try {
            EventHandler ret;
            List<Object> handlerList;
            if (this.handler.containsKey(typePair)) {
                handlerList = this.handler.get(typePair);
            } else {
                handlerList = new ArrayList();
                this.handler.put(typePair, handlerList);
            }
            int pos = -1;
            int i = 0;
            while (i < handlerList.size()) {
                if (handlerID.equals(((EventHandler)handlerList.get(i)).getID())) {
                    pos = i;
                    break;
                }
                ++i;
            }
            if (pos > -1) {
                if (pos != index) {
                    ret = (EventHandler)handlerList.remove(pos);
                    pos = -1;
                } else {
                    ret = (EventHandler)handlerList.get(index);
                }
            } else {
                ret = current == null ? this.registry.getConfiguredPlugin(this.createSession(), this, PREREGISTERED_EVENT_HANDLER, EventHandler.class, handlerID) : current;
                Map<String, EventSource<? extends Event>> source = this.sources.get(typePair);
                if (source != null) {
                    Collection<EventSource<? extends Event>> srcs;
                    if (this.handlerSource.containsKey(ret)) {
                        srcs = this.handlerSource.get(ret);
                    } else {
                        srcs = new HashSet<EventSource<? extends Event>>(source.values());
                        this.handlerSource.put(ret, srcs);
                    }
                    for (EventSource<? extends Event> src : source.values()) {
                        src.addHandler(ret, index);
                        srcs.add(src);
                    }
                }
            }
            if (pos < 0) {
                handlerList.add(index, ret);
            }
            EventHandler eventHandler = ret;
            return eventHandler;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public EventHandler removeEventHandler(SessionToken session, String eventType, String sourceType, String handlerID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForBlank(eventType, "eventType");
        ArgChecks.checkForBlank(sourceType, "sourceType");
        ArgChecks.checkForBlank(handlerID, "handlerID");
        String msg = "Remove event handler '%s' with eventType: %s, sourceType: %s, session: %s";
        msg = String.format(msg, handlerID, eventType, sourceType, session);
        this.logger.finer(msg);
        super.sessionActive(session);
        try {
            EventHandler ret;
            block12: {
                ret = null;
                Pair<String, String> typePair = new Pair<String, String>(eventType, sourceType);
                this.dataLock.writeLock().lock();
                List<EventHandler> handlerList = this.handler.get(typePair);
                if (handlerList != null && handlerList.size() > 0) {
                    Iterator<EventHandler> iterator = handlerList.iterator();
                    while (iterator.hasNext()) {
                        EventHandler current = iterator.next();
                        if (!handlerID.equals(current.getID())) continue;
                        ret = current;
                        iterator.remove();
                        if (handlerList.size() >= 1) break;
                        this.handler.remove(typePair);
                        break;
                    }
                }
                if (ret != null) break block12;
                EventHandler eventHandler = ret;
                this.dataLock.writeLock().unlock();
                return eventHandler;
            }
            try {
                Collection<EventSource<? extends Event>> srcs = this.handlerSource.remove(ret);
                if (srcs != null) {
                    for (EventSource<? extends Event> src : srcs) {
                        src.removeHandler(handlerID);
                    }
                }
                EventHandler eventHandler = ret;
                this.dataLock.writeLock().unlock();
                return eventHandler;
            }
            catch (Throwable throwable) {
                this.dataLock.writeLock().unlock();
                throw throwable;
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public Connection getConnection(String dataSource) throws ServiceNotKnownException, SQLException {
        String name = AbstractRegistry.getHierarchicalInstanceName("JDBCDataSource", dataSource);
        JDBCDataSource ds = this.registry.getService(this.createSession(), name, JDBCDataSource.class);
        return ds.getConnection();
    }

    public Connection getConnection(String driver, String connectionURL, String userName, String password) throws ConfigurationException, SQLException {
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "Unable to find specified JDBC-driver '%s'. Please check whether the corresponding library is available in '%s'.";
            msg = String.format(msg, driver, SystemProperties.getLibDir());
            throw new ConfigurationException(msg, cnfe);
        }
        catch (IllegalAccessException iae) {
            String msg = "Unable to access the constructor of the specified JDBC-driver '%s'. Please check corresponding library in '%s'.";
            msg = String.format(msg, driver, SystemProperties.getLibDir());
            throw new ConfigurationException(msg, iae);
        }
        catch (InstantiationException ie) {
            String msg = "Unable to instantiate the constructor of the specified JDBC-driver '%s'. Please check corresponding library in '%s'.";
            msg = String.format(msg, driver, SystemProperties.getLibDir());
            throw new ConfigurationException(msg, ie);
        }
        return DriverManager.getConnection(connectionURL, userName, password);
    }

    @Override
    public SimpleSessionContext selectActivity(EBPInstanceReference activity) throws InvalidActivityStateException, InvalidInstanceStateException {
        SessionToken session = this.createSession();
        this.activitySelecting.selectActivity(session, activity);
        RemoteActivityStarting actStarting = this.runtimeService.getRemoteActivityStarting();
        SimpleSessionContext ret = actStarting.getSimpleSessionContext(session, activity, ProcessConstants.ExecutionMode.PRODUCTION);
        return ret;
    }

    @Override
    public void deselectActivity(EBPInstanceReference activity) throws InvalidActivityStateException, InvalidInstanceStateException {
        SessionToken session = this.createSession();
        this.activitySelecting.deselectActivity(session, activity);
    }

    @Override
    public SimpleSessionContext getSimpleSessionContext(EBPInstanceReference activity, ProcessConstants.ExecutionMode executionMode) throws InvalidActivityStateException, InvalidInstanceStateException {
        SessionToken session = this.createSession();
        RemoteActivityStarting actStarting = this.runtimeService.getRemoteActivityStarting();
        SimpleSessionContext ret = actStarting.getSimpleSessionContext(session, activity, executionMode);
        return ret;
    }

    @Override
    public Pair<SessionToken, SimpleSessionContext> startActivity(EBPInstanceReference activity, ProcessConstants.ExecutionMode executionMode) throws InvalidActivityStateException, InvalidInstanceStateException, InterruptedException {
        Pair<SessionToken, SimpleSessionContext> ret = null;
        SessionToken session = this.createSession();
        String msg = String.format("Start activity '%s' with execution mode '%s'.", new Object[]{activity, executionMode});
        this.logger.finer(msg);
        RemoteActivityStarting actStarting = this.runtimeService.getRemoteActivityStarting();
        SimpleSessionContext context = actStarting.startActivity(session, activity, executionMode, null, this.startActivityTimeout);
        if (context != null) {
            ret = new Pair<SessionToken, SimpleSessionContext>(session, context);
        }
        return ret;
    }

    @Override
    public RemoteRuntimeEnvironment getRuntimeEnvironment() {
        return this.runtimeService.getRuntimeEnvironment();
    }

    @Override
    public RemoteProgressMonitor getProgressMonitor() {
        return this.runtimeService.getProgressMonitor();
    }

    public InstanceControl getInstanceControl() {
        return this.instanceControl;
    }

    @Override
    public TemplateReference getTemplateReference(SessionToken session, UUID templateID) {
        super.sessionActive(session);
        try {
            TemplateReference templateReference = this.pm.getTemplateManager().getTemplateReference(session, templateID);
            return templateReference;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public TemplateReference getLatestTemplateReference(SessionToken session, String processType) {
        super.sessionActive(session);
        try {
            TemplateReference templateReference = ProcessManagerTools.getLatestTemplateVersion(session, processType, this.pm.getTemplateManager(), this.filterFactory);
            return templateReference;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public InstanceDataContainer createInstanceDataContainer(SessionToken session, UUID templateID) {
        super.sessionActive(session);
        try {
            InstanceDataContainer instanceDataContainer = this.instanceControl.createInstanceDataContainer(session, templateID);
            return instanceDataContainer;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public UUID createAndStartInstance(SessionToken session, UUID templateID, InstanceDataContainer dataContainer) throws InvalidTemplateStateException, InvalidDataContainerException {
        super.sessionActive(session);
        try {
            QualifiedAgent agent = this.getUserCredentials(session).getSecond();
            ExecutionContext execContext = this.exmFactory.getExecutionContext(agent, null, dataContainer, null, null);
            UUID uUID = this.instanceControl.createAndStartInstance(session, templateID, execContext, null);
            return uUID;
        }
        finally {
            super.sessionFinished(session);
        }
    }
}

