/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.common;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.automaticclient.ItemHandler;
import de.aristaflow.adept2.core.eventmanager.ActivityEventManager;
import de.aristaflow.adept2.core.eventmanager.common.WorklistHandler;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.model.runtimeenvironment.SimpleSessionContext;
import de.aristaflow.adept2.model.runtimeenvironment.UnknownSessionException;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.util.types.Pair;
import de.aristaflow.adept2.util.types.Triple;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class EventSourceAdder
extends ItemHandler {
    public static final String EVENT_SOURCE_ADDING_FAILED_STATE = "AristaFlow:WorklistHandler:EventSourceAdder:AddingFailed";
    public static final long EVENT_SOURCE_ADDING_FAILED_CODE = 1000000L;
    protected final WorklistHandler handler;
    protected final ScheduledExecutorService pollService;
    protected final ActivityEventManager eventManager;
    protected int currentRun;
    protected int retries;
    protected long retryDelay;

    public EventSourceAdder(WorklistItem item, int retries, long retryDelay, WorklistHandler handler, Collection<? extends ItemHandler> pendingSelected, ScheduledExecutorService pollService, ActivityEventManager eventManager) {
        super(item, pendingSelected);
        this.handler = handler;
        this.pollService = pollService;
        this.eventManager = eventManager;
        this.currentRun = 0;
        this.retries = retries;
        this.retryDelay = retryDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String msg;
        EventSourceAdder eventSourceAdder = this;
        synchronized (eventSourceAdder) {
            this.abortable = this.invalidated;
        }
        if (this.abortable) {
            this.pendingItems.remove(this);
            return;
        }
        Throwable t = null;
        ++this.currentRun;
        ADEPT2EBPReference activity = (ADEPT2EBPReference)this.worklistItem.getActivityReference();
        ClientWorklistItem newWorklistItem = this.handler.getWorklistItem(activity);
        if (newWorklistItem == null || this.invalidated) {
            this.pendingItems.remove(this);
            return;
        }
        try {
            try {
                Triple<Throwable, Integer, Long> triple = this.handler.addEventSource(newWorklistItem);
                if (triple != null) {
                    t = triple.getFirst();
                    if (triple.getSecond() != null) {
                        this.retries = triple.getSecond();
                    }
                    if (triple.getThird() != null) {
                        this.retryDelay = triple.getThird();
                    }
                }
                this.pendingItems.remove(this);
            }
            catch (RuntimeException re) {
                t = re;
                throw re;
            }
        }
        catch (Throwable throwable) {
            if (t != null) {
                if (this.currentRun < this.retries) {
                    msg = "Got an exception when adding event source for worklist item '%1$s' in try %2$d. Retrying it for %3$d times, next try in %5$d:%4$tM:%4$tS.%4$tL.";
                    msg = String.format(msg, newWorklistItem, this.currentRun, this.retries - this.currentRun, this.retryDelay, this.retryDelay / 1000L / 60L / 60L);
                    this.logger.log(Level.FINE, msg, t);
                    this.pollService.schedule(this, this.retryDelay, TimeUnit.MILLISECONDS);
                } else {
                    try {
                        Pair<SessionToken, SimpleSessionContext> context = this.eventManager.startActivity(activity, ProcessConstants.ExecutionMode.PRODUCTION);
                        String sessionID = context.getSecond().getSessionID();
                        msg = "Adding the event source for worklist item '%s' failed after %d tries. Failing the activity. Exception of the last try was: ";
                        msg = String.format(msg, newWorklistItem, this.currentRun);
                        this.logger.log(Level.WARNING, msg, t);
                        ApplicationFailedException afe = new ApplicationFailedException(msg, EVENT_SOURCE_ADDING_FAILED_STATE, 1000000L, t);
                        this.eventManager.getRuntimeEnvironment().applicationFailed(context.getFirst(), sessionID, afe, null);
                    }
                    catch (InvalidActivityStateException iase) {
                        msg = "Could not start activity '%s' for failing after all retries for adding the corresponding event source failed (see previous log messages). The activity remains selected and the worklist handler may try to add the corresponding event source again despite this failing.";
                        msg = String.format(msg, activity);
                        this.logger.log(Level.WARNING, msg, iase);
                    }
                    catch (InvalidInstanceStateException iise) {
                        msg = "Could not start activity '%s' for failing after all retries for adding the corresponding event source failed (see previous log messages). The activity remains selected and the worklist handler may try to add the corresponding event source again despite this failing.";
                        msg = String.format(msg, activity);
                        this.logger.log(Level.WARNING, msg, iise);
                    }
                    catch (InterruptedException ie) {
                        msg = "Could not start activity '%s' for failing after all retries for adding the corresponding event source failed (see previous log messages). The activity remains selected and the worklist handler may try to add the corresponding event source again despite this failing.";
                        msg = String.format(msg, activity);
                        this.logger.log(Level.WARNING, msg, ie);
                    }
                    catch (UnknownSessionException use) {
                        msg = "Could not fail activity '%s' after all retries for adding the corresponding event source failed (see previous log messages). The activity remains started and therefore has the wrong state. Reset it manually.";
                        msg = String.format(msg, activity);
                        this.logger.log(Level.SEVERE, msg, use);
                    }
                    this.pendingItems.remove(this);
                }
            }
            throw throwable;
        }
        if (t != null) {
            if (this.currentRun < this.retries) {
                msg = "Got an exception when adding event source for worklist item '%1$s' in try %2$d. Retrying it for %3$d times, next try in %5$d:%4$tM:%4$tS.%4$tL.";
                msg = String.format(msg, newWorklistItem, this.currentRun, this.retries - this.currentRun, this.retryDelay, this.retryDelay / 1000L / 60L / 60L);
                this.logger.log(Level.FINE, msg, t);
                this.pollService.schedule(this, this.retryDelay, TimeUnit.MILLISECONDS);
            } else {
                try {
                    Pair<SessionToken, SimpleSessionContext> context = this.eventManager.startActivity(activity, ProcessConstants.ExecutionMode.PRODUCTION);
                    String sessionID = context.getSecond().getSessionID();
                    msg = "Adding the event source for worklist item '%s' failed after %d tries. Failing the activity. Exception of the last try was: ";
                    msg = String.format(msg, newWorklistItem, this.currentRun);
                    this.logger.log(Level.WARNING, msg, t);
                    ApplicationFailedException afe = new ApplicationFailedException(msg, EVENT_SOURCE_ADDING_FAILED_STATE, 1000000L, t);
                    this.eventManager.getRuntimeEnvironment().applicationFailed(context.getFirst(), sessionID, afe, null);
                }
                catch (InvalidActivityStateException iase) {
                    msg = "Could not start activity '%s' for failing after all retries for adding the corresponding event source failed (see previous log messages). The activity remains selected and the worklist handler may try to add the corresponding event source again despite this failing.";
                    msg = String.format(msg, activity);
                    this.logger.log(Level.WARNING, msg, iase);
                }
                catch (InvalidInstanceStateException iise) {
                    msg = "Could not start activity '%s' for failing after all retries for adding the corresponding event source failed (see previous log messages). The activity remains selected and the worklist handler may try to add the corresponding event source again despite this failing.";
                    msg = String.format(msg, activity);
                    this.logger.log(Level.WARNING, msg, iise);
                }
                catch (InterruptedException ie) {
                    msg = "Could not start activity '%s' for failing after all retries for adding the corresponding event source failed (see previous log messages). The activity remains selected and the worklist handler may try to add the corresponding event source again despite this failing.";
                    msg = String.format(msg, activity);
                    this.logger.log(Level.WARNING, msg, ie);
                }
                catch (UnknownSessionException use) {
                    msg = "Could not fail activity '%s' after all retries for adding the corresponding event source failed (see previous log messages). The activity remains started and therefore has the wrong state. Reset it manually.";
                    msg = String.format(msg, activity);
                    this.logger.log(Level.SEVERE, msg, use);
                }
                this.pendingItems.remove(this);
            }
        }
    }
}

