/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.common;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.paramref.ParameterRefReplacer;
import de.aristaflow.adept2.model.common.paramref.ParameterRefTools;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.InputDataContext;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationEnvironmentException;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Date;

public class ParamRefTools {
    public static String replaceParams(String rawString, InputDataContext dataContext) throws ConfigurationException {
        ParameterRefReplacer replacer = ParameterRefTools.getReplacer(rawString, null);
        while (replacer.findNext()) {
            ParameterRef ref = replacer.getParameterRef();
            try {
                String value;
                if (dataContext.isNull(ref.getName())) {
                    String string = "null";
                }
                switch (ref.getDataType()) {
                    case BOOLEAN: {
                        boolean b = dataContext.retrieveBooleanParameterValue(ref.getName());
                        value = Boolean.toString(b);
                        break;
                    }
                    case INTEGER: {
                        long i = dataContext.retrieveIntegerParameterValue(ref.getName());
                        value = Long.toString(i);
                        break;
                    }
                    case FLOAT: {
                        double f = dataContext.retrieveFloatParameterValue(ref.getName());
                        value = Double.toString(f);
                        break;
                    }
                    case STRING: {
                        value = dataContext.retrieveStringParameterValue(ref.getName());
                        break;
                    }
                    case URI: {
                        URI u = dataContext.retrieveURIParameterValue(ref.getName());
                        value = u.toString();
                        break;
                    }
                    case DATE: {
                        Date d = dataContext.retrieveDateParameterValue(ref.getName());
                        Timestamp t = new Timestamp(d.getTime());
                        value = JDBCTools.toString(t);
                        break;
                    }
                    case USERDEFINED: {
                        String msg = "A user defined data type is not supported for parameterised attribute value for the event source. Therefore the parameter '%s' cannot be used in the attribute value '%s'.";
                        msg = String.format(msg, ref.getName(), replacer.getProcessedString());
                        throw new ApplicationEnvironmentException(msg, -401001L);
                    }
                    default: {
                        String msg = String.format("'%s' not supported/implemented", new Object[]{ref.getDataType()});
                        throw new AssertionError((Object)msg);
                    }
                }
                replacer.replaceWith(value);
            }
            catch (NoSuchParameterException nspe) {
                String msg = "There is a reference to an input parameter '%s' (%s) in the the attribute value but the activity has no corresponding input parameter. Please check the statement in the configuration and/or the data context of the activity.";
                msg = String.format(msg, new Object[]{ref.getName(), ref.getDataType()});
                throw new ConfigurationException(msg, nspe);
            }
            catch (InvalidDataTypeException idte) {
                String msg = "There is a reference to the input parameter '%s' of type '%s' in the attribute value but in the activity the input parameter is of type '%s'. Please check the statement in the configuration and/or the data context of the activity.";
                msg = String.format(msg, new Object[]{ref.getName(), ref.getDataType(), idte.getExpectedDataType()});
                throw new ConfigurationException(msg, idte);
            }
        }
        return replacer.getProcessedString();
    }
}

