/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.common;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.automaticclient.AbstractWorklistHandler;
import de.aristaflow.adept2.core.automaticclient.ItemHandler;
import de.aristaflow.adept2.core.eventmanager.common.DefaultEventManager;
import de.aristaflow.adept2.core.eventmanager.common.EventSourceAdder;
import de.aristaflow.adept2.core.worklistmanager.WorklistManager;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.types.Triple;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class WorklistHandler
extends AbstractWorklistHandler {
    protected final DefaultEventManager eventManager;
    protected final Registry registry;
    protected int addSourceRetries;
    protected long addSourceRetryDelay;
    protected final Collection<ItemHandler> pendingSelected;
    protected final Map<EBPInstanceReference, Triple<String, String, String>> runningItems;
    protected final Map<Triple<String, String, String>, Long> sourceCount;

    public WorklistHandler(WorklistManager wlm, WorklistUpdateConfiguration updateConfiguration, long recheckTime, int threadPriority, int addSourceRetries, long addSourceRetryDelay, DefaultEventManager eventManager, Registry registry) {
        super(wlm, updateConfiguration, recheckTime, threadPriority);
        ArgChecks.checkForNull(eventManager, "eventManager");
        ArgChecks.checkForNull(registry, "registry");
        this.addSourceRetries = addSourceRetries;
        this.addSourceRetryDelay = addSourceRetryDelay;
        this.eventManager = eventManager;
        this.registry = registry;
        this.pendingSelected = Collections.synchronizedCollection(new HashSet());
        this.runningItems = new HashMap<EBPInstanceReference, Triple<String, String, String>>();
        this.sourceCount = new HashMap<Triple<String, String, String>, Long>();
    }

    @Override
    protected boolean itemProcessable(ClientWorklistItem item) {
        boolean ret = super.itemProcessable(item);
        if (ret) {
            ADEPT2EBPReference ebpRef = (ADEPT2EBPReference)item.getActivityReference();
            ret &= ebpRef.getExecutableComponentName().startsWith("de.aristaflow.events");
        }
        return ret;
    }

    @Override
    protected SessionToken createSession() {
        return this.eventManager.createSession();
    }

    @Override
    protected void processCompleteUpdate(ClientWorklistItem item) {
        switch (item.getState()) {
            case AVAILABLE: 
            case ASSIGNED: 
            case SUSPENDED: {
                String msg = String.format("Submitting item %s '%s' for polling.", item.getState().name(), item.getActivityReference());
                this.logger.finer(msg);
                ItemHandler adder = this.createItemHandler(item);
                this.pendingSelected.add(adder);
                adder.run();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareCompleteUpdate() {
        Object object = this.pendingSelected;
        synchronized (object) {
            HashSet<ItemHandler> copy = new HashSet<ItemHandler>(this.pendingSelected);
            for (ItemHandler handler : copy) {
                handler.invalidate();
            }
        }
        object = this.runningItems;
        synchronized (object) {
            Iterator<Map.Entry<EBPInstanceReference, Triple<String, String, String>>> itemIterator = this.runningItems.entrySet().iterator();
            while (itemIterator.hasNext()) {
                Triple<String, String, String> triple = itemIterator.next().getValue();
                Long count = this.sourceCount.get(triple);
                if (count != null) {
                    if (count > 1L) {
                        count = count - 1L;
                        this.sourceCount.put(triple, count);
                    } else {
                        this.sourceCount.remove(triple);
                        this.eventManager.removeEventSource(this.createSession(), triple.getFirst(), triple.getSecond(), triple.getThird());
                    }
                } else {
                    this.eventManager.removeEventSource(this.createSession(), triple.getFirst(), triple.getSecond(), triple.getThird());
                }
                itemIterator.remove();
            }
        }
    }

    @Override
    protected void processUpdatedItem(ClientWorklistItem updatedItem, WorklistConstants.WorklistItemUpdateType updateType) {
        block0 : switch (updateType) {
            case CHANGED: 
            case ADDED: {
                switch (updatedItem.getState()) {
                    case AVAILABLE: 
                    case ASSIGNED: 
                    case SUSPENDED: {
                        String msg = String.format("Submitting retrieved item '%s' ('%s') in state '%s' for polling.", new Object[]{updatedItem.getActivityReference(), updatedItem.getID(), updatedItem.getState()});
                        this.logger.finer(msg);
                        ItemHandler adder = this.createItemHandler(updatedItem);
                        this.pendingSelected.add(adder);
                        adder.run();
                        break block0;
                    }
                }
                String msg = String.format("Ignore WorklistItemState %s.", new Object[]{updatedItem.getState()});
                this.logger.finest(msg);
                break;
            }
            case REMOVED: {
                this.removeEventSource(updatedItem);
                break;
            }
            default: {
                assert (false) : updatedItem;
                break;
            }
        }
    }

    protected ItemHandler createItemHandler(WorklistItem worklistItem) {
        return new EventSourceAdder(worklistItem, this.addSourceRetries, this.addSourceRetryDelay, this, this.pendingSelected, this.eventManager.getScheduledExecutorService(), this.eventManager);
    }

    /*
     * Exception decompiling
     */
    protected Triple<Throwable, Integer, Long> addEventSource(WorklistItem item) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEventSource(WorklistItem item) {
        ADEPT2EBPReference activity = (ADEPT2EBPReference)item.getActivityReference();
        String msg = String.format("Remove event source for item '%s', activity '%s'.", item.getID(), activity);
        this.logger.finest(msg);
        Map<EBPInstanceReference, Triple<String, String, String>> map = this.runningItems;
        synchronized (map) {
            Triple<String, String, String> triple;
            if (this.runningItems.containsKey(activity) && (triple = this.runningItems.remove(activity)) != null) {
                this.eventManager.removeEventSource(this.createSession(), triple.getFirst(), triple.getSecond(), triple.getThird());
            }
        }
    }
}

