/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.dbevents;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.core.eventmanager.common.DefaultEventManager;
import de.aristaflow.adept2.core.eventmanager.common.ParamRefTools;
import de.aristaflow.adept2.core.eventmanager.dbevents.DBEventSource;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.runtimeenvironment.SimpleSessionContext;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.configuration.Configuration;

public class DBActivityEventSource
extends DBEventSource {
    public DBActivityEventSource(Configuration conf, DefaultEventManager eventManager, Registry registry) throws ConfigurationException {
        super(conf, eventManager, registry);
    }

    @Override
    public void setConfiguration(Configuration conf, boolean completed) throws ConfigurationException {
        if (!(!completed || conf.containsKey("SimpleSessionContext") && conf.getProperty("SimpleSessionContext") instanceof SimpleSessionContext)) {
            String msg = "The configuration for activity event source '%s/%s/%s' cannot be set since it does not provide the required simple session context.";
            msg = String.format(msg, this.eventType, this.getType(), this.getID());
            throw new ConfigurationException(msg);
        }
        super.setConfiguration(conf, false);
        if (completed) {
            SimpleSessionContext sessionContext = (SimpleSessionContext)conf.getProperty("SimpleSessionContext");
            ActivityConfiguration actConf = sessionContext.getActivityInstance().getConfiguration();
            if (actConf.getString("JDBCDataSource") != null) {
                this.dataSource = actConf.getString("JDBCDataSource");
            }
            if (actConf.getString("Driver") != null) {
                this.jdbcDriver = actConf.getString("Driver");
            }
            if (actConf.getString("ConnectionURL") != null) {
                this.jdbcConnectionURL = actConf.getString("ConnectionURL");
            }
            if (actConf.getString("UserName") != null) {
                this.jdbcUserName = actConf.getString("UserName");
            }
            if (actConf.getString("Password") != null) {
                this.jdbcPassword = actConf.getString("Password");
            }
            if (actConf.getString("SelectStatement") != null) {
                this.selectStatement = actConf.getString("SelectStatement");
            }
            if (actConf.getBoolean("NotifyEmptyOnly") != null) {
                this.notifyEmptyOnly = actConf.getBoolean("NotifyEmptyOnly");
            }
            if (actConf.getInteger("PollTime") != null) {
                this.pollTime = actConf.getInteger("PollTime");
            }
            this.selectStatement = ParamRefTools.replaceParams(this.selectStatement, sessionContext.getDataContext());
            EBPInstanceReference activity = sessionContext.getEBPInstanceReference();
            Connection conn = null;
            try {
                try {
                    conn = this.dataSource != null ? this.eventManager.getConnection(this.dataSource) : this.eventManager.getConnection(this.jdbcDriver, this.jdbcConnectionURL, this.jdbcUserName, this.jdbcPassword);
                }
                catch (ServiceNotKnownException snke) {
                    String msg = "Could not retrieve the data source '%s' configured for event type '%s' for activity '%s'. Aborting activity.";
                    msg = String.format(msg, this.dataSource, this.eventType, activity);
                    throw new ConfigurationException(msg, snke);
                }
                catch (ConfigurationException ce) {
                    String msg = "Could not retrieve the data source '%s' configured for event type '%s' for activity '%s'. Aborting activity.";
                    msg = String.format(msg, this.dataSource, this.eventType, activity);
                    throw new ConfigurationException(msg, ce);
                }
                catch (SQLException sqle) {
                    String msg = "Could not retrieve a connection to the data source '%s' configured for event type '%s' for activity '%s'. Aborting activity.";
                    msg = String.format(msg, this.dataSource, this.eventType, activity);
                    throw new ConfigurationException(msg, sqle);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(conn);
                throw throwable;
            }
            JDBCTools.closeQuietly(conn);
            this.verifyConfigurationValues();
        }
    }
}

