/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.dbevents;

import de.aristaflow.adept2.base.configuration.ConfigurationDescriptionTools;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.PropertyNotSetException;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.eventmanager.common.AbstractEventSource;
import de.aristaflow.adept2.core.eventmanager.common.DefaultEventManager;
import de.aristaflow.adept2.core.eventmanager.dbevents.ResultSetEventImpl;
import de.aristaflow.adept2.model.events.ResultSetEvent;
import de.aristaflow.adept2.model.events.sources.PollingSource;
import de.aristaflow.adept2.model.events.sources.ResultSetSource;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class DBEventSource
extends AbstractEventSource<ResultSetEvent>
implements PollingSource<ResultSetEvent>,
ResultSetSource {
    protected final String eventType;
    protected Long pollTime = null;
    protected String dataSource = null;
    protected String jdbcDriver;
    protected String jdbcConnectionURL;
    protected String jdbcUserName;
    protected String jdbcPassword;
    protected String selectStatement = null;
    protected Boolean notifyEmptyOnly = null;
    protected final DefaultEventManager eventManager;

    public DBEventSource(Configuration conf, DefaultEventManager eventManager, Registry registry) throws ConfigurationException {
        super(AbstractRegistry.getSimpleInstanceName(registry.getInstanceName()));
        this.eventType = "DBResultSetEvent";
        this.eventManager = eventManager;
        ConfigurationDescriptionTools.validateConfiguration(conf, DBEventSource.class, true, this.type);
        this.setConfiguration(conf, false);
    }

    protected void setConfiguration(Configuration conf, boolean completed) throws ConfigurationException {
        if (conf.containsKey("PollTime")) {
            this.pollTime = conf.getLong("PollTime");
        }
        if (conf.containsKey("JDBCDataSource")) {
            this.dataSource = conf.getString("JDBCDataSource");
        }
        if (conf.containsKey("Driver")) {
            this.jdbcDriver = conf.getString("Driver");
        }
        if (conf.containsKey("ConnectionURL")) {
            this.jdbcConnectionURL = conf.getString("ConnectionURL");
        }
        if (conf.containsKey("UserName")) {
            this.jdbcUserName = conf.getString("UserName");
        }
        if (conf.containsKey("Password")) {
            this.jdbcPassword = conf.getString("Password");
        }
        if (conf.containsKey("SelectStatement")) {
            this.selectStatement = conf.getString("SelectStatement");
        }
        if (conf.containsKey("NotifyEmptyOnly")) {
            this.notifyEmptyOnly = conf.getBoolean("NotifyEmptyOnly");
        }
        if (completed) {
            this.verifyConfigurationValues();
        }
    }

    protected void verifyConfigurationValues() throws ConfigurationException {
        boolean jdbcManually;
        String msg = null;
        boolean bl = jdbcManually = !ConfigurationTools.stringValid(this.dataSource);
        if (this.pollTime == null) {
            msg = "The poll time needs to be set for event source '%s/%s/%s': %s.";
            msg = String.format(msg, this.eventType, this.getType(), this.getID(), "PollTime");
        } else if (jdbcManually && !ConfigurationTools.stringValid(this.jdbcDriver)) {
            msg = "A JDBC driver or a JDBC data source need to be set for event source '%s/%s/%s': %s or %s.";
            msg = String.format(msg, this.eventType, this.getType(), this.getID(), "Driver", "JDBCDataSource");
        } else if (jdbcManually && !ConfigurationTools.stringValid(this.jdbcConnectionURL)) {
            msg = "A JDBC connection URL or a JDBC data source need to be set for event source '%s/%s/%s': %s or %s.";
            msg = String.format(msg, this.eventType, this.getType(), this.getID(), "ConnectionURL", "JDBCDataSource");
        } else if (!ConfigurationTools.stringValid(this.selectStatement)) {
            msg = "The select statement needs to be set for event source '%s/%s/%s': %s.";
            msg = String.format(msg, this.eventType, this.getType(), this.getID(), "SelectStatement");
        } else if (this.notifyEmptyOnly == null) {
            msg = "Whether notification should take place with an empty result setonly needs to be set for event source '%s/%s/%s': %s.";
            msg = String.format(msg, this.eventType, this.getType(), this.getID(), "NotifyEmptyOnly");
        }
        if (msg != null) {
            throw new PropertyNotSetException(msg);
        }
    }

    @Override
    public void setConfiguration(Configuration conf, String id) throws ConfigurationException {
        super.setConfiguration(conf, id);
        this.setConfiguration(conf, true);
    }

    @Override
    public long getPollTime() {
        return this.pollTime;
    }

    @Override
    public void init() {
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void terminate() {
    }

    protected ResultSetEvent createResultSetEvent(ResultSet resultSet) {
        return new ResultSetEventImpl(this.eventManager.getURIs(), this.eventType, this.getType(), this.getID(), resultSet);
    }

    @Override
    protected boolean nextHandler(ResultSetEvent event, boolean consumed, boolean concurrent) {
        boolean ret = true;
        try {
            event.getResultSet().first();
        }
        catch (SQLException sqle) {
            String msg = "Positioning the result set for event handling of event '%s/%s/%s/%s' (service: '%s') failed. Aborting event handling but continuing polling.";
            msg = String.format(msg, event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()));
            this.logger.log(Level.WARNING, msg, sqle);
        }
        return ret;
    }
}

