/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.mailevents;

import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.eventmanager.common.AbstractEventHandler;
import de.aristaflow.adept2.core.eventmanager.mailevents.MailTools;
import de.aristaflow.adept2.extensions.datatypes.FileUDT;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.InvalidUDTException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.events.MailEvent;
import de.aristaflow.adept2.util.StackTraceTools;
import de.aristaflow.adept2.util.StreamTools;
import de.aristaflow.adept2.util.UUIDTools;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.configuration.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ConfigurationDescription(properties={@Property(name="FileStorePath", type=Property.Type.STRING, defaultNull=true, description="File system path for storing mails, e.g. in case URI parameters are used for storing the message. If this is not set, temporary files will be created.")})
public abstract class AbstractMailEventHandler
extends AbstractEventHandler {
    public static final String CONF_FILE_STORE_PATH = "FileStorePath";
    public static final String PARAM_MESSAGE = "Message";
    public static final String PARAM_ATTACHMENTS = "Attachments";
    public static final String PARAM_BODY = "Body";
    public static final String PARAM_TO = "To";
    public static final String PARAM_CC = "CC";
    public static final String PARAM_BCC = "BCC";
    public static final String PARAM_FROM = "From";
    public static final String PARAM_SENT_DATE = "Sent Date";
    public static final String PARAM_SUBJECT = "Subject";
    public static final String SUBTABLE_NAME_MAIL_ADDRESSES = "MailAddresses";
    protected final File fileStore;

    public AbstractMailEventHandler(Configuration conf, Registry registry, boolean exclusive, boolean consuming) throws ConfigurationException {
        super(registry, exclusive, consuming);
        if (conf.containsKey(CONF_FILE_STORE_PATH)) {
            String fileStorePath = conf.getString(CONF_FILE_STORE_PATH);
            this.fileStore = new File(fileStorePath);
            if (this.fileStore.exists()) {
                if (!this.fileStore.canWrite() || !this.fileStore.isDirectory()) {
                    String msg = "File store path can not be written or is not a directory '%s'.";
                    msg = String.format(msg, fileStorePath);
                    throw new ConfigurationException(msg);
                }
            } else if (!this.fileStore.mkdirs()) {
                String msg = "Unable to create file store path directory '%s'.";
                msg = String.format(msg, fileStorePath);
                throw new ConfigurationException(msg);
            }
        } else {
            this.fileStore = null;
        }
    }

    protected UDTValue addressListToUDT(Parameter parameter, Address[] addresses) throws IOException, InvalidDataTypeException {
        byte[] ret;
        String udtName = parameter.getUDTName();
        if ("java.util.List<STRING>".equals(udtName)) {
            String[] addrs = MailTools.toString(addresses);
            ArrayList<String> list = new ArrayList<String>(addrs.length);
            list.addAll(Arrays.asList(addrs));
            ret = StreamTools.toByteArray(list);
        } else if ("subtable".equals(udtName)) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.newDocument();
                Element subtableElement = document.createElement("Subtable");
                subtableElement.setAttribute("name", SUBTABLE_NAME_MAIL_ADDRESSES);
                subtableElement.setAttribute("template", "false");
                document.appendChild(subtableElement);
                Element currentRowNode = document.createElement("Row");
                currentRowNode.setAttribute("id", Integer.toString(0));
                this.addSubtableElement(currentRowNode, "Name", null);
                this.addSubtableElement(currentRowNode, "Address", null);
                subtableElement.appendChild(currentRowNode);
                int i = 0;
                while (i < addresses.length) {
                    if (addresses[i] instanceof InternetAddress) {
                        InternetAddress address = (InternetAddress)addresses[i];
                        currentRowNode = document.createElement("Row");
                        currentRowNode.setAttribute("id", Integer.toString(i + 1));
                        this.addSubtableElement(currentRowNode, "Name", address.getPersonal());
                        this.addSubtableElement(currentRowNode, "Address", address.getAddress());
                        subtableElement.appendChild(currentRowNode);
                    }
                    ++i;
                }
                ret = XMLHelperTools.getByteArrayForDocument(document);
            }
            catch (ParserConfigurationException pce) {
                String msg = "XML parser exception while trying to create a subtable UDT for parameter '%s':\n%s";
                msg = String.format(msg, parameter.getName(), StackTraceTools.stackTraceToString(pce));
                throw new IOException(msg);
            }
        } else {
            String[] expct = new String[]{"java.util.List<STRING>", "subtable"};
            throw new InvalidUDTException(parameter.getName(), expct, udtName);
        }
        return new ADEPT2UDTValue(udtName, ret);
    }

    private void addSubtableElement(Node parent, String name, String value) {
        Element element = parent.getOwnerDocument().createElement("Element");
        element.setAttribute("name", name);
        element.setAttribute("value", value == null ? "" : value);
        parent.appendChild(element);
    }

    protected UDTValue getMessageAsFileUDT(MailEvent event) throws MessagingException, IOException {
        File file = this.writeMessageToFile(event, true);
        UDTValue ret = new FileUDT(file).getAsXML();
        if (!file.delete()) {
            file.deleteOnExit();
        }
        return ret;
    }

    protected File writeMessageToFile(MailEvent event, boolean intermediate) throws MessagingException, IOException {
        String fileName = this.createFileNameForEvent(event, !intermediate);
        File file = null;
        boolean success = false;
        try {
            if (this.fileStore != null) {
                file = new File(this.fileStore, String.format("%s.eml", fileName));
                success = file.createNewFile();
            } else {
                file = File.createTempFile(fileName, ".eml");
                success = true;
            }
        }
        catch (IOException ioe) {
            String msg = String.format("Unable to create file '%s', falling back to a default file name.", fileName);
            this.logger.log(Level.INFO, msg, ioe);
        }
        if (!success) {
            fileName = UUIDTools.createRandomUUID().toString();
            if (this.fileStore != null) {
                file = new File(this.fileStore, String.format("%s.eml", fileName));
                success = file.createNewFile();
            } else {
                file = File.createTempFile(fileName, ".eml");
                success = true;
            }
        }
        if (!success) {
            throw new IOException();
        }
        FileOutputStream os = new FileOutputStream(file);
        try {
            event.getMessage().writeTo((OutputStream)os);
            os.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
        return file;
    }

    protected String createFileNameForEvent(MailEvent event, boolean unique) {
        String ret = event.getSubject();
        ret = ret.replace(':', '_');
        ret = ret.replace('*', '_');
        ret = ret.replace('?', '_');
        ret = ret.replace('\"', '_');
        ret = ret.replace('<', '_');
        ret = ret.replace('>', '_');
        ret = ret.replace('|', '_');
        ret = ret.replace('/', '_');
        ret = ret.replace('\\', '_');
        StringBuilder builder = new StringBuilder(ret);
        while (builder.charAt(0) == '.') {
            builder.deleteCharAt(0);
        }
        if (unique) {
            ret = String.format("%s-%s", UUIDTools.createRandomUUID(), builder.toString());
        } else if (builder.length() < 1) {
            ret = UUIDTools.createRandomUUID().toString();
        }
        return ret;
    }

    protected UDTValue attachmentsToUDT(Parameter parameter, MailEvent event) throws MessagingException, IOException, InvalidUDTException {
        byte[] bytes;
        String udtName = parameter.getUDTName();
        String dirName = this.createFileNameForEvent(event, true);
        LinkedList<Part> parts = new LinkedList<Part>();
        this.flatAttachmentList(event.getMessage(), parts);
        File dir = null;
        if (this.fileStore != null && !(dir = new File(this.fileStore, dirName)).mkdirs()) {
            String msg = "Unable to create directory '%s' for storing the attachments as files for parameter '%s'.";
            msg = String.format(msg, dir, parameter.getName());
            throw new IOException(msg);
        }
        ArrayList<URI> uriList = new ArrayList<URI>(parts.size());
        ArrayList<String> fileNameList = new ArrayList<String>(parts.size());
        ArrayList<String> contentTypeList = new ArrayList<String>(parts.size());
        ArrayList<Integer> sizeList = new ArrayList<Integer>(parts.size());
        for (Part part : parts) {
            String fileName = part.getFileName();
            if (fileName == null || fileName.length() == 0) {
                fileName = UUIDTools.createRandomUUID().toString();
            }
            File file = dir != null ? new File(dir, fileName) : File.createTempFile(fileName, null);
            this.writeContentToFile(part.getContent(), file);
            uriList.add(file.toURI());
            fileNameList.add(fileName);
            contentTypeList.add(part.getContentType());
            sizeList.add(part.getSize());
        }
        if ("java.util.List<URI>".equals(udtName)) {
            bytes = StreamTools.toByteArray(uriList);
        } else if ("subtable".equals(udtName)) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.newDocument();
                Element subtableElement = document.createElement("Subtable");
                subtableElement.setAttribute("name", SUBTABLE_NAME_MAIL_ADDRESSES);
                subtableElement.setAttribute("template", "false");
                document.appendChild(subtableElement);
                Element currentRowNode = document.createElement("Row");
                currentRowNode.setAttribute("id", Integer.toString(0));
                this.addSubtableElement(currentRowNode, "FileName", null);
                this.addSubtableElement(currentRowNode, "File", null);
                this.addSubtableElement(currentRowNode, "FileType", null);
                this.addSubtableElement(currentRowNode, "FileSize", null);
                subtableElement.appendChild(currentRowNode);
                int i = 0;
                while (i < uriList.size()) {
                    currentRowNode = document.createElement("Row");
                    currentRowNode.setAttribute("id", Integer.toString(i + 1));
                    this.addSubtableElement(currentRowNode, "FileName", (String)fileNameList.get(i));
                    this.addSubtableElement(currentRowNode, "File", ((URI)uriList.get(i)).toASCIIString());
                    this.addSubtableElement(currentRowNode, "FileType", (String)contentTypeList.get(i));
                    this.addSubtableElement(currentRowNode, "FileSize", Integer.toString((Integer)sizeList.get(i)));
                    subtableElement.appendChild(currentRowNode);
                    ++i;
                }
                bytes = XMLHelperTools.getByteArrayForDocument(document);
            }
            catch (ParserConfigurationException pce) {
                String msg = "XML parser exception while trying to create a subtable UDT for parameter '%s':\n%s";
                msg = String.format(msg, parameter.getName(), StackTraceTools.stackTraceToString(pce));
                throw new IOException(msg);
            }
        } else {
            String[] expct = new String[]{"java.util.List<URI>", "subtable"};
            throw new InvalidUDTException(parameter.getName(), expct, udtName);
        }
        return new ADEPT2UDTValue(udtName, bytes);
    }

    private void flatAttachmentList(Object content, List<Part> parts) throws MessagingException, IOException {
        if (content instanceof Part) {
            Part part = (Part)content;
            Object innerContent = part.getContent();
            if (innerContent instanceof String || innerContent instanceof InputStream) {
                parts.add(part);
            } else {
                this.flatAttachmentList(part.getContent(), parts);
            }
        } else if (content instanceof Multipart) {
            Multipart mp = (Multipart)content;
            int i = 0;
            while (i < mp.getCount()) {
                this.flatAttachmentList(mp.getBodyPart(i), parts);
                ++i;
            }
        } else {
            String msg = "Cannot handle content type '%s':\n%s";
            msg = String.format(msg, content.getClass().getName(), content.toString());
            this.logger.warning(msg);
        }
    }

    protected String getStringContentOfMessage(Message message) throws MessagingException, IOException {
        return this.getStringContent(message);
    }

    private String getStringContent(Object content) throws MessagingException, IOException {
        Multipart p;
        String ret = null;
        if (content instanceof String) {
            ret = (String)content;
        } else if (content instanceof Part) {
            ret = this.getStringContent(((Part)content).getContent());
        } else if (content instanceof Multipart && (p = (Multipart)content).getCount() > 0) {
            ret = this.getStringContent(p.getBodyPart(0));
        }
        if (ret == null) {
            ret = String.format("ERROR: unknown type: %s\n%s", content.getClass().getName(), content.toString());
        }
        return ret;
    }

    private void writeContentToFile(Object content, File file) throws FileNotFoundException, IOException {
        block11: {
            if (content instanceof String) {
                OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(file));
                try {
                    osw.write((String)content);
                    ((Writer)osw).flush();
                }
                finally {
                    ((Writer)osw).close();
                }
            }
            if (content instanceof InputStream) {
                FileOutputStream os = new FileOutputStream(file);
                try {
                    try {
                        StreamTools.copyStreamToStream((InputStream)content, os);
                        break block11;
                    }
                    finally {
                        ((InputStream)content).close();
                    }
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            String error = String.format("ERROR: unknown type: %s\n%s", content.getClass().getName(), content.toString());
            this.writeContentToFile(error, file);
        }
    }
}

