/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.mailevents;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.eventmanager.common.DefaultEventManager;
import de.aristaflow.adept2.core.eventmanager.common.ParamRefTools;
import de.aristaflow.adept2.core.eventmanager.mailevents.FilteredMailEventSource;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.execution.InputDataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SerialisableDataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SimpleSessionContext;
import de.aristaflow.adept2.util.ConfigurationTools;
import org.apache.commons.configuration.Configuration;

public class FilteredMailEventActivitySource
extends FilteredMailEventSource {
    public FilteredMailEventActivitySource(Configuration conf, DefaultEventManager eventManager, Registry registry) throws ConfigurationException {
        super(conf, eventManager, registry);
    }

    @Override
    public void setConfiguration(Configuration conf, boolean completed) throws ConfigurationException {
        if (!(!completed || conf.containsKey("SimpleSessionContext") && conf.getProperty("SimpleSessionContext") instanceof SimpleSessionContext)) {
            String msg = "The configuration for activity event source '%s/%s/%s' cannot be set since it does not provide the required simple session context.";
            msg = String.format(msg, this.eventType, this.getType(), this.getID());
            throw new ConfigurationException(msg);
        }
        super.setConfiguration(conf, false);
        if (completed) {
            SimpleSessionContext sessionContext = (SimpleSessionContext)conf.getProperty("SimpleSessionContext");
            ActivityConfiguration actConf = sessionContext.getActivityInstance().getConfiguration();
            SerialisableDataContext dataContext = sessionContext.getDataContext();
            if (actConf.getInteger("PollTime") != null) {
                this.pollTime = actConf.getInteger("PollTime");
            }
            if (actConf.getBoolean("KeepConnection") != null) {
                this.keepConnection = conf.getBoolean("KeepConnection");
            }
            if (actConf.getString("Protocol") != null) {
                this.protocol = actConf.getString("Protocol");
            }
            if (actConf.getString("Host") != null) {
                this.host = actConf.getString("Host");
            }
            if (actConf.getInteger("Port") != null) {
                this.port = actConf.getInteger("Port").intValue();
            }
            if (actConf.getString("UserName") != null) {
                this.userName = actConf.getString("UserName");
            }
            if (actConf.getString("Password") != null) {
                this.password = actConf.getString("Password");
            }
            if (actConf.getString("Folder") != null) {
                this.folderName = actConf.getString("Folder");
            }
            this.protocol = this.replaceValueParams(this.protocol, dataContext);
            this.userName = this.replaceValueParams(this.userName, dataContext);
            this.password = this.replaceValueParams(this.password, dataContext);
            this.folderName = this.replaceValueParams(this.folderName, dataContext);
            this.filterSubject = this.replaceValueParams(this.filterSubject, dataContext);
            this.filterTo = this.replaceValueParams(this.filterTo, dataContext);
            this.filterFrom = this.replaceValueParams(this.filterFrom, dataContext);
            this.patternSubject = this.createPattern(this.filterSubject);
            this.patternTo = this.createPattern(this.filterTo);
            this.patternFrom = this.createPattern(this.filterFrom);
            if (actConf.getBoolean("FlagAnsweredFilter") != null) {
                this.filterFlagAnswered = actConf.getBoolean("FlagAnsweredFilter");
            }
            if (actConf.getBoolean("FlagDeletedFilter") != null) {
                this.filterFlagDeleted = actConf.getBoolean("FlagDeletedFilter");
            }
            if (actConf.getBoolean("FlagDraftFilter") != null) {
                this.filterFlagDraft = actConf.getBoolean("FlagDraftFilter");
            }
            if (actConf.getBoolean("FlagFlaggedFilter") != null) {
                this.filterFlagFlagged = actConf.getBoolean("FlagFlaggedFilter");
            }
            if (actConf.getBoolean("FlagRecentFilter") != null) {
                this.filterFlagRecent = actConf.getBoolean("FlagRecentFilter");
            }
            if (actConf.getBoolean("FlagSeenFilter") != null) {
                this.filterFlagSeen = actConf.getBoolean("FlagSeenFilter");
            }
            if (actConf.getBoolean("FlagUserFilter") != null) {
                this.filterFlagUser = actConf.getBoolean("FlagUserFilter");
            }
            this.verifyConfigurationValues();
        }
    }

    protected String replaceValueParams(String value, InputDataContext dataContext) throws ConfigurationException {
        String ret = null;
        if (ConfigurationTools.stringValid(value)) {
            ret = ParamRefTools.replaceParams(value, dataContext);
        }
        return ret;
    }
}

