/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.mailevents;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.eventmanager.common.DefaultEventManager;
import de.aristaflow.adept2.core.eventmanager.mailevents.MailEventSource;
import de.aristaflow.adept2.core.eventmanager.mailevents.MailTools;
import de.aristaflow.adept2.model.events.MailEvent;
import de.aristaflow.adept2.model.events.sources.FilteredMailSource;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.configuration.Configuration;

public class FilteredMailEventSource
extends MailEventSource
implements FilteredMailSource {
    protected String filterSubject;
    protected String filterTo;
    protected String filterFrom;
    protected Pattern patternSubject;
    protected Pattern patternTo;
    protected Pattern patternFrom;
    protected Boolean filterFlagAnswered;
    protected Boolean filterFlagDeleted;
    protected Boolean filterFlagDraft;
    protected Boolean filterFlagFlagged;
    protected Boolean filterFlagRecent;
    protected Boolean filterFlagSeen;
    protected Boolean filterFlagUser;

    public FilteredMailEventSource(Configuration conf, DefaultEventManager eventManager, Registry registry) throws ConfigurationException {
        super(conf, eventManager, registry, FilteredMailEventSource.class);
    }

    @Override
    protected void setConfiguration(Configuration conf, boolean completed) throws ConfigurationException {
        if (conf.containsKey("SubjectFilter")) {
            this.filterSubject = conf.getString("SubjectFilter");
        }
        if (conf.containsKey("ToFilter")) {
            this.filterTo = conf.getString("ToFilter");
        }
        if (conf.containsKey("FromFilter")) {
            this.filterFrom = conf.getString("FromFilter");
        }
        if (completed) {
            this.patternSubject = this.createPattern(this.filterSubject);
            this.patternTo = this.createPattern(this.filterTo);
            this.patternFrom = this.createPattern(this.filterFrom);
        }
        if (conf.containsKey("FlagAnsweredFilter")) {
            this.filterFlagAnswered = conf.getBoolean("FlagAnsweredFilter", null);
        }
        if (conf.containsKey("FlagDeletedFilter")) {
            this.filterFlagDeleted = conf.getBoolean("FlagDeletedFilter", null);
        }
        if (conf.containsKey("FlagDraftFilter")) {
            this.filterFlagDraft = conf.getBoolean("FlagDraftFilter", null);
        }
        if (conf.containsKey("FlagFlaggedFilter")) {
            this.filterFlagFlagged = conf.getBoolean("FlagFlaggedFilter", null);
        }
        if (conf.containsKey("FlagRecentFilter")) {
            this.filterFlagRecent = conf.getBoolean("FlagRecentFilter", null);
        }
        if (conf.containsKey("FlagSeenFilter")) {
            this.filterFlagSeen = conf.getBoolean("FlagSeenFilter", null);
        }
        if (conf.containsKey("FlagUserFilter")) {
            this.filterFlagUser = conf.getBoolean("FlagUserFilter", null);
        }
        super.setConfiguration(conf, completed);
    }

    @Override
    protected MailEvent createMailEvent(Message message) throws MessagingException, IOException {
        MailEvent ret = null;
        if (this.filtersApply(message, true)) {
            ret = super.createMailEvent(message);
        }
        return ret;
    }

    protected Pattern createPattern(String filter) {
        Pattern ret = null;
        if (filter != null && filter.length() > 0) {
            ret = Pattern.compile(filter);
        }
        return ret;
    }

    protected boolean filtersApply(Message message, boolean all) throws MessagingException {
        return this.filtersApply(message, this.patternSubject, this.patternTo, this.patternFrom, this.filterFlagAnswered, this.filterFlagDeleted, this.filterFlagDraft, this.filterFlagFlagged, this.filterFlagRecent, this.filterFlagSeen, this.filterFlagUser, all);
    }

    protected boolean filtersApply(Message message, Pattern subjectFilter, Pattern toFilter, Pattern fromFilter, Boolean answeredFlag, Boolean deletedFlag, Boolean draftFlag, Boolean flaggedFlag, Boolean recentFlag, Boolean seenFlag, Boolean userFlag, boolean all) throws MessagingException {
        int n;
        boolean subjectApplies = false;
        if (subjectFilter != null) {
            String subject = message.getSubject();
            subjectApplies = subjectFilter.matcher(subject).matches();
        }
        boolean toApplies = false;
        if (toFilter != null) {
            String[] recipients;
            String[] stringArray = recipients = MailTools.toString(message.getAllRecipients());
            n = recipients.length;
            int n2 = 0;
            while (n2 < n) {
                String address = stringArray[n2];
                toApplies = toFilter.matcher(address).matches();
                if (toApplies) break;
                ++n2;
            }
        }
        boolean fromApplies = false;
        if (fromFilter != null) {
            String[] senders;
            String[] stringArray = senders = MailTools.toString(message.getFrom());
            int n3 = senders.length;
            n = 0;
            while (n < n3) {
                String address = stringArray[n];
                fromApplies = fromFilter.matcher(address).matches();
                if (fromApplies) break;
                ++n;
            }
        }
        boolean answeredFlagApplies = false;
        if (answeredFlag != null) {
            answeredFlagApplies = message.isSet(Flags.Flag.ANSWERED) == answeredFlag.booleanValue();
        }
        boolean deletedFlagApplies = false;
        if (deletedFlag != null) {
            deletedFlagApplies = message.isSet(Flags.Flag.DELETED) == deletedFlag.booleanValue();
        }
        boolean draftFlagApplies = false;
        if (draftFlag != null) {
            draftFlagApplies = message.isSet(Flags.Flag.DRAFT) == draftFlag.booleanValue();
        }
        boolean flaggedFlagApplies = false;
        if (flaggedFlag != null) {
            flaggedFlagApplies = message.isSet(Flags.Flag.FLAGGED) == flaggedFlag.booleanValue();
        }
        boolean recentFlagApplies = false;
        if (recentFlag != null) {
            recentFlagApplies = message.isSet(Flags.Flag.RECENT) == recentFlag.booleanValue();
        }
        boolean seenFlagApplies = false;
        if (seenFlag != null) {
            seenFlagApplies = message.isSet(Flags.Flag.SEEN) == seenFlag.booleanValue();
        }
        boolean userFlagApplies = false;
        if (userFlag != null) {
            boolean bl = userFlagApplies = message.isSet(Flags.Flag.USER) == userFlag.booleanValue();
        }
        boolean ret = all ? !(subjectFilter != null && !subjectApplies || toFilter != null && !toApplies || fromFilter != null && !fromApplies || answeredFlag != null && !answeredFlagApplies || deletedFlag != null && !deletedFlagApplies || draftFlag != null && !draftFlagApplies || flaggedFlag != null && !flaggedFlagApplies || recentFlag != null && !recentFlagApplies || seenFlag != null && !seenFlagApplies || userFlag != null && !userFlagApplies) : subjectFilter == null || subjectApplies || toFilter == null || toApplies || fromFilter == null || fromApplies || answeredFlag == null || answeredFlagApplies || deletedFlag == null || deletedFlagApplies || draftFlag == null || draftFlagApplies || flaggedFlag == null || flaggedFlagApplies || recentFlag == null || recentFlagApplies || seenFlag == null || seenFlagApplies || userFlag == null || userFlagApplies;
        return ret;
    }
}

