/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.mailevents;

import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.eventmanager.common.DefaultEventManager;
import de.aristaflow.adept2.core.eventmanager.mailevents.AbstractMailEventHandler;
import de.aristaflow.adept2.core.eventmanager.mailevents.MailTools;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InstanceDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.events.Event;
import de.aristaflow.adept2.model.events.EventHandlingException;
import de.aristaflow.adept2.model.events.MailEvent;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="ProcessType", isRequired=true, description="The process tye of which to start the \"latest\" template as soon as the event occurs.")})
public class InstanceStartEventHandler
extends AbstractMailEventHandler {
    protected static final String CONF_PROCESS_TYPE = "ProcessType";
    protected final String processType;
    protected TemplateReference template;
    protected final DefaultEventManager eventManager;

    public InstanceStartEventHandler(Configuration conf, DefaultEventManager eventManager, Registry registry) throws ConfigurationException {
        super(conf, registry, false, false);
        ArgChecks.checkForNull(eventManager, "eventManager");
        this.processType = conf.getString(CONF_PROCESS_TYPE);
        this.eventManager = eventManager;
        SessionToken session = eventManager.createSession();
        try {
            this.template = this.getAndCheckTemplate(session);
            if (this.template == null) {
                String msg = "Cannot retrieve a template for process type '%s'. Please check the templates in the process manager.";
                msg = String.format(msg, this.processType);
                throw new ConfigurationException(String.format(msg, this.processType));
            }
        }
        catch (InvalidDataTypeException idte) {
            String msg = "Cannot use the template '%s' for process type '%s' since its input parameter have the wrong type for a mail event. Please adapt the template appropriately.";
            msg = String.format(msg, this.template.getID(), this.processType);
            throw new ConfigurationException(String.format(msg, this.processType), idte);
        }
        catch (NoSuchParameterException nspe) {
            String msg = "Cannot use the template '%s' for process type '%s' since it has a mandatory input parameter that cannot be retrieved from a mail. Please adapt the template appropriately.";
            msg = String.format(msg, this.template.getID(), this.processType);
            throw new ConfigurationException(String.format(msg, this.processType), nspe);
        }
    }

    @Override
    public boolean handleEvent(Event eve, boolean consumed) throws EventHandlingException {
        boolean ret = false;
        if (!(eve instanceof MailEvent) || consumed) {
            return ret;
        }
        MailEvent event = (MailEvent)eve;
        SessionToken session = this.eventManager.createSession();
        if (this.template == null) {
            try {
                this.template = this.getAndCheckTemplate(session);
            }
            catch (InvalidDataTypeException idte) {
                String msg = "Cannot start an instance of process type '%s' for event '%s/%s/%s/%s' (service: '%s') since not all required input parameters have the right data type.";
                msg = String.format(msg, this.processType, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
                throw new EventHandlingException(msg, idte);
            }
            catch (NoSuchParameterException nspe) {
                String msg = "Cannot start an instance of process type '%s' for event '%s/%s/%s/%s' (service: '%s') due to an input parameter not being present in the instance data container.";
                msg = String.format(msg, this.processType, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
                throw new EventHandlingException(msg, nspe);
            }
            if (this.template == null) {
                String msg = "No template for the process type '%s' to be instantiated for event '%s/%s/%s/%s' (service: '%s') found.";
                msg = String.format(msg, this.processType, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
                throw new EventHandlingException(msg);
            }
        }
        UUID templateID = this.template.getID();
        try {
            InstanceDataContainer dataContainer = this.eventManager.createInstanceDataContainer(session, templateID);
            this.processMailEvent(event, this.template.getInputParameters(), dataContainer);
            this.eventManager.createAndStartInstance(session, templateID, dataContainer);
            ret = true;
        }
        catch (InvalidDataTypeException idte) {
            this.template = null;
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') due to an input parameter having the wrong data type. For the next event a new template of the process type will will be retrieved.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, idte);
        }
        catch (NoSuchParameterException nspe) {
            this.template = null;
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') due to an input parameter not being present in the instance data container. For the next event a new template of the process type will be retrieved.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, nspe);
        }
        catch (MessagingException me) {
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') since retrieving the values of the input parameters from the message failed.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, me);
        }
        catch (IOException ioe) {
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') since retrieving contents or attachments of the message failed.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, ioe);
        }
        catch (IllegalArgumentException iae) {
            this.template = null;
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') since the template does not exist any more. For the next event a new template of the process type will be retrieved.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, iae);
        }
        catch (InvalidTemplateStateException itse) {
            this.template = null;
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') since the template is in the wrong state. For the next event a new template of the process type will be retrieved.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, itse);
        }
        catch (InvalidDataContainerException idce) {
            this.template = null;
            String msg = "Cannot start an instance of template '%s' for event '%s/%s/%s/%s' (service: '%s') due to problems with the instance data container. For the next event a new template of the process type will be retrieved.";
            msg = String.format(msg, templateID, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, idce);
        }
        return ret;
    }

    protected TemplateReference getAndCheckTemplate(SessionToken session) throws InvalidDataTypeException, NoSuchParameterException {
        TemplateReference ret = this.eventManager.getLatestTemplateReference(session, this.processType);
        if (ret != null) {
            for (Parameter parameter : ret.getInputParameters()) {
                String msg;
                String name = parameter.getName();
                ProcessConstants.AdeptDataType type = parameter.getDataType();
                if (name.equals("Subject") || name.equals("Body") || name.equals("From")) {
                    if (type == ProcessConstants.AdeptDataType.STRING) continue;
                    throw new InvalidDataTypeException(name, ProcessConstants.AdeptDataType.STRING, type);
                }
                if (name.equals("Sent Date")) {
                    if (type == ProcessConstants.AdeptDataType.DATE) continue;
                    throw new InvalidDataTypeException(name, ProcessConstants.AdeptDataType.DATE, type);
                }
                if (name.equals("Message")) {
                    if (type == ProcessConstants.AdeptDataType.USERDEFINED || type == ProcessConstants.AdeptDataType.URI) continue;
                    throw new InvalidDataTypeException(name, ProcessConstants.AdeptDataType.USERDEFINED, type);
                }
                if (name.equals("To") || name.equals("CC") || name.equals("BCC")) {
                    if (type == ProcessConstants.AdeptDataType.STRING || type == ProcessConstants.AdeptDataType.USERDEFINED && ("subtable".equals(parameter.getUDTName()) || "java.util.List<URI>".equals(parameter.getUDTName()))) continue;
                    throw new InvalidDataTypeException(name, ProcessConstants.AdeptDataType.USERDEFINED, type);
                }
                if (name.equals("Attachments")) {
                    if (type == ProcessConstants.AdeptDataType.USERDEFINED && ("subtable".equals(parameter.getUDTName()) || "java.util.List<URI>".equals(parameter.getUDTName()))) continue;
                    throw new InvalidDataTypeException(name, ProcessConstants.AdeptDataType.USERDEFINED, type);
                }
                if (parameter.isOptional()) {
                    msg = "Found parameter with unknown name '%s'. Ignoring, since the parameter is optional.";
                    this.logger.info(String.format(msg, name));
                    continue;
                }
                msg = "Found parameter with unknown name '%s', since the parameter is mandatory, it can not be ignored.";
                throw new NoSuchParameterException(String.format(msg, name), name);
            }
        }
        return ret;
    }

    protected void processMailEvent(MailEvent event, Collection<? extends Parameter> inParams, InstanceDataContainer dataContainer) throws InvalidDataTypeException, NoSuchParameterException, MessagingException, IOException {
        Message message = event.getMessage();
        for (Parameter parameter : inParams) {
            String parameterName = parameter.getName();
            ProcessConstants.AdeptDataType dataType = parameter.getDataType();
            if (parameterName.equals("Subject")) {
                dataContainer.setString(parameterName, event.getSubject());
                continue;
            }
            if (parameterName.equals("From")) {
                String fromAddresses = StringTools.join(", ", event.getSenders());
                dataContainer.setString(parameterName, fromAddresses);
                continue;
            }
            if (parameterName.equals("To") || parameterName.equals("CC") || parameterName.equals("BCC")) {
                Message.RecipientType rType = parameterName.equals("To") ? Message.RecipientType.TO : (parameterName.equals("CC") ? Message.RecipientType.CC : Message.RecipientType.BCC);
                Address[] addresses = message.getRecipients(rType);
                if (dataType == ProcessConstants.AdeptDataType.STRING) {
                    String toAddresses = StringTools.join(", ", MailTools.toString(addresses));
                    dataContainer.setString(parameterName, toAddresses);
                    continue;
                }
                dataContainer.setUDT(parameterName, this.addressListToUDT(parameter, addresses));
                continue;
            }
            if (parameterName.equals("Sent Date")) {
                Date sentDate = event.getSentDate();
                dataContainer.setDate(parameterName, sentDate);
                continue;
            }
            if (parameterName.equals("Body")) {
                String contentString = this.getStringContentOfMessage(message);
                dataContainer.setString(parameterName, contentString);
                continue;
            }
            if (parameterName.equals("Message")) {
                if (parameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                    UDTValue udtValue = parameter.getUDTName().equals("FileUDT") ? this.getMessageAsFileUDT(event) : new ADEPT2UDTValue(parameter.getUDTName(), message.getInputStream());
                    dataContainer.setUDT(parameterName, udtValue);
                    continue;
                }
                File file = this.writeMessageToFile(event, false);
                URI fileURI = file.toURI();
                dataContainer.setURI(parameterName, fileURI);
                continue;
            }
            if (parameterName.equals("Attachments")) {
                UDTValue attachmentUDT = this.attachmentsToUDT(parameter, event);
                dataContainer.setUDT(parameterName, attachmentUDT);
                continue;
            }
            String msg = "Parameter '%s' not specified, ignoring.";
            this.logger.info(String.format(msg, parameterName));
        }
    }
}

