/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.mailevents;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.eventmanager.ActivityEventManager;
import de.aristaflow.adept2.core.eventmanager.mailevents.AbstractMailEventHandler;
import de.aristaflow.adept2.core.runtimeservice.RemoteRuntimeEnvironment;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.events.Event;
import de.aristaflow.adept2.model.events.EventHandlingException;
import de.aristaflow.adept2.model.events.MailEvent;
import de.aristaflow.adept2.model.events.handler.ActivityEventHandler;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.runtimeenvironment.DataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SimpleSessionContext;
import de.aristaflow.adept2.model.runtimeenvironment.UnknownSessionException;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.StackTraceTools;
import de.aristaflow.adept2.util.StringTools;
import de.aristaflow.adept2.util.types.Pair;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.configuration.Configuration;

public class MailEventActivityHandler
extends AbstractMailEventHandler
implements ActivityEventHandler {
    public static final String HANDLER_MAIL_MESSAGING_EXCEPTION_STATE = "AristaFlow:ActivityEventHandler:MailEvent:MessagingException";
    public static final long HANDLER_MAIL_MESSAGING_EXCEPTION_CODE = 1300001L;
    public static final String HANDLER_MAIL_IO_EXCEPTION_STATE = "AristaFlow:ActivityEventHandler:MailEvent:IOException";
    public static final long HANDLER_MAIL_IO_EXCEPTION_CODE = 1200001L;
    public static final String HANDLER_MAIL_INVALID_DATA_TYPE_EXCEPTION_STATE = "AristaFlow:ActivityEventHandler:MailEvent:InvalidDataTypeException";
    public static final long HANDLER_MAIL_INVALID_DATA_TYPE_EXCEPTION_CODE = 1100001L;
    public static final String HANDLER_MAIL_NO_SUCH_PARAMETER_EXCEPTION_STATE = "AristaFlow:ActivityEventHandler:MailEvent:NoSuchParameterException";
    public static final long HANDLER_MAIL_NO_SUCH_PARAMETER_CODE = 1150001L;
    public static final String PARAM_AC_PREFIX = "MailEvent.";
    public static final String PAC_MAIL_EVENT_FIELD = "MailEvent.Field";
    public static final String PAC_MAIL_EVENT_REGEX = "MailEvent.Regex";
    public static final String PAC_MAIL_EVENT_REGEX_GROUP = "MailEvent.Group";
    protected final Map<String, SimpleSessionContext> contexts;
    protected final ActivityEventManager eventManager;

    public MailEventActivityHandler(Configuration conf, ActivityEventManager eventManager, Registry registry) throws ConfigurationException {
        super(conf, registry, false, false);
        ArgChecks.checkForNull(eventManager, "eventManager");
        this.contexts = new HashMap<String, SimpleSessionContext>();
        this.eventManager = eventManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Event eve, boolean consumed) throws EventHandlingException {
        boolean ret;
        block32: {
            Pair<SessionToken, SimpleSessionContext> newContext;
            ret = false;
            if (!(eve instanceof MailEvent) || consumed) {
                return ret;
            }
            MailEvent event = (MailEvent)eve;
            String sourceID = event.getSourceID();
            Throwable innerException = null;
            try {
                Map<String, SimpleSessionContext> map = this.contexts;
                synchronized (map) {
                    if (!this.contexts.containsKey(sourceID)) {
                        String msg = "The activity for event '%s/%s/%s/%s' (service: '%s') is not registered. Cannot handle it.";
                        msg = String.format(msg, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
                        throw new EventHandlingException(msg);
                    }
                    SimpleSessionContext oldContext = this.contexts.get(sourceID);
                    EBPInstanceReference activity = oldContext.getEBPInstanceReference();
                    newContext = this.eventManager.startActivity(activity, ProcessConstants.ExecutionMode.PRODUCTION);
                }
            }
            catch (InvalidActivityStateException iase) {
                String msg = "Could not start activity for mail event '%s/%s/%s/%s' (service: '%s'). The activity has the wrong state. Maybe it has already been started and the corresponding worklist update is pending.";
                msg = String.format(msg, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
                throw new EventHandlingException(msg, iase);
            }
            catch (InvalidInstanceStateException iise) {
                String msg = "Could not start activity for mail event '%s/%s/%s/%s' (service: %s). The corresponding instance has an invalid state  for activity execution. Maybe the corresponding worklist update is pending.";
                msg = String.format(msg, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
                throw new EventHandlingException(msg, iise);
            }
            catch (InterruptedException ie) {
                String msg = "Could not start activity for mail event '%s/%s/%s/%s' (service: %s) since the runtime service is terminating. Try again later.";
                msg = String.format(msg, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
                throw new EventHandlingException(msg, ie);
            }
            if (newContext == null) {
                String msg = "Could not start activity for mail event '%s/%s/%s/%s' (service: %s). A timeout elasped when waiting for the start of the activity. The activity may be in the wrong state now. Please check and reset it if appropriate.";
                msg = String.format(msg, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
                throw new EventHandlingException(msg);
            }
            ret = true;
            SessionToken session = newContext.getFirst();
            SimpleSessionContext context = newContext.getSecond();
            try {
                try {
                    try {
                        this.fillDataContext(event, context.getActivityInstance().getParameters(ActivityConstants.AccessType.WRITE), context.getDataContext());
                        RemoteRuntimeEnvironment environment = this.eventManager.getRuntimeEnvironment();
                        environment.applicationClosed(session, context.getSessionID(), context.getDataContext());
                    }
                    catch (MessagingException me) {
                        innerException = me;
                        String msg = "An SQL exception occurred when handling the mail event '%s/%s/%s/%s' (service: %s). We fail the corresponding activity.";
                        msg = String.format(msg, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
                        this.eventManager.getRuntimeEnvironment().applicationFailed(session, context.getSessionID(), msg, HANDLER_MAIL_MESSAGING_EXCEPTION_STATE, 1300001L, context.getDataContext());
                    }
                    catch (IOException ioe) {
                        innerException = ioe;
                        String msg = "An SQL exception occurred when handling the mail event '%s/%s/%s/%s' (service: %s). We fail the corresponding activity.";
                        msg = String.format(msg, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
                        this.eventManager.getRuntimeEnvironment().applicationFailed(session, context.getSessionID(), msg, HANDLER_MAIL_IO_EXCEPTION_STATE, 1200001L, context.getDataContext());
                    }
                    catch (InvalidDataTypeException idte) {
                        innerException = idte;
                        String msg = "An SQL exception occurred when handling the DB event '%s/%s/%s/%s' (service: %s). We fail the corresponding activity.";
                        msg = String.format(msg, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
                        this.eventManager.getRuntimeEnvironment().applicationFailed(session, context.getSessionID(), msg, HANDLER_MAIL_INVALID_DATA_TYPE_EXCEPTION_STATE, 1100001L, context.getDataContext());
                    }
                    catch (NoSuchParameterException nspe) {
                        innerException = nspe;
                        String msg = "An SQL exception occurred when handling the mail event '%s/%s/%s/%s' (service: %s). We fail the corresponding activity.";
                        msg = String.format(msg, eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()));
                        this.eventManager.getRuntimeEnvironment().applicationFailed(session, context.getSessionID(), msg, HANDLER_MAIL_NO_SUCH_PARAMETER_EXCEPTION_STATE, 1150001L, context.getDataContext());
                    }
                }
                catch (UnknownSessionException use) {
                    String innerMsg;
                    if (innerException != null) {
                        innerMsg = " Inner exception causing the failing: %s.\n%s";
                        innerMsg = String.format(innerMsg, innerException.getMessage(), StackTraceTools.stackTraceToString(innerException));
                    } else {
                        innerMsg = "";
                    }
                    String msg = "Could not %s activity when handling the DB event '%s/%s/%s/%s' (service: %s). The activity is running but we handle the event and terminate the activity. The activity is in the wrong state now. Please reset it.%s";
                    msg = String.format(msg, innerException == null ? "close" : "fail", eve.getEventType(), eve.getSourceType(), sourceID, eve.getID(), Arrays.toString(eve.getEventManager()), innerMsg);
                    this.logger.log(Level.SEVERE, msg, use);
                    Map<String, SimpleSessionContext> map = this.contexts;
                    synchronized (map) {
                        this.contexts.remove(sourceID);
                        break block32;
                    }
                }
            }
            catch (Throwable throwable) {
                Map<String, SimpleSessionContext> map = this.contexts;
                synchronized (map) {
                    this.contexts.remove(sourceID);
                }
                throw throwable;
            }
            Map<String, SimpleSessionContext> map = this.contexts;
            synchronized (map) {
                this.contexts.remove(sourceID);
            }
        }
        return ret;
    }

    protected void fillDataContext(MailEvent event, Set<? extends Parameter> parameter, DataContext dataContext) throws InvalidDataTypeException, NoSuchParameterException, MessagingException, IOException {
        for (Parameter parameter2 : parameter) {
            String field = parameter2.getConfiguration().getString(PAC_MAIL_EVENT_FIELD);
            String regex = parameter2.getConfiguration().getString(PAC_MAIL_EVENT_REGEX);
            if (ConfigurationTools.stringValid(field)) {
                this.handleField(field, parameter2, event, dataContext);
                continue;
            }
            if (ConfigurationTools.stringValid(regex)) {
                this.handleRegEx(regex, parameter2, event, dataContext);
                continue;
            }
            String msg = "The parameter configuration for output parameter '%s' does neither provide a field nor a regular expression to get a valuefrom event '%s/%s/%s/%s' (service: %s). Ignoring and continuing with further parameter.";
            msg = String.format(msg, parameter2.getName(), event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()));
            this.logger.warning(msg);
        }
    }

    protected void handleField(String field, Parameter param, MailEvent event, DataContext dataContext) throws InvalidDataTypeException, NoSuchParameterException, IOException, MessagingException {
        Message message = event.getMessage();
        String paramName = param.getName();
        ProcessConstants.AdeptDataType dataType = param.getDataType();
        if (field.equals("Subject")) {
            dataContext.storeStringParameterValue(paramName, event.getSubject());
        } else if (field.equals("From")) {
            if (dataType == ProcessConstants.AdeptDataType.STRING) {
                String addresses = StringTools.join(", ", event.getSenders());
                dataContext.storeStringParameterValue(paramName, addresses);
            } else {
                UDTValue listUDT = this.addressListToUDT(param, message.getFrom());
                dataContext.storeUDTParameterValue(paramName, listUDT);
            }
        } else if (field.equals("To")) {
            if (dataType == ProcessConstants.AdeptDataType.STRING) {
                String addresses = StringTools.join(", ", event.getAllRecipients());
                dataContext.storeStringParameterValue(paramName, addresses);
            } else {
                UDTValue listUDT = this.addressListToUDT(param, message.getAllRecipients());
                dataContext.storeUDTParameterValue(paramName, listUDT);
            }
        } else if (field.equals("Sent Date")) {
            Date sentDate = event.getSentDate();
            dataContext.storeDateParameterValue(paramName, sentDate);
        } else if (field.equals("Body")) {
            String bodyString = this.getStringContentOfMessage(message);
            dataContext.storeStringParameterValue(paramName, bodyString);
        } else if (field.equals("Message")) {
            if (dataType == ProcessConstants.AdeptDataType.USERDEFINED) {
                UDTValue udtValue = "FileUDT".equals(param.getUDTName()) ? this.getMessageAsFileUDT(event) : new ADEPT2UDTValue(param.getUDTName(), message.getInputStream());
                dataContext.storeUDTParameterValue(paramName, udtValue);
            } else {
                File file = this.writeMessageToFile(event, false);
                dataContext.storeURIParameterValue(paramName, file.toURI());
            }
        } else if (field.equals("Attachments")) {
            UDTValue attachmentUDT = this.attachmentsToUDT(param, event);
            dataContext.storeUDTParameterValue(paramName, attachmentUDT);
        } else {
            String msg = "The parameter configuration '%s' for output parameter '%s' does not specify a valid attribute of a mail for mail event '%s/%s/%s/%s' (service: %s). Ignoring and continuing with further parameter.";
            msg = String.format(msg, field, paramName, event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()));
            this.logger.info(msg);
        }
    }

    protected void handleRegEx(String regex, Parameter param, MailEvent event, DataContext dataContext) throws MessagingException, IOException, InvalidDataTypeException, NoSuchParameterException {
        Message message = event.getMessage();
        String paramName = param.getName();
        ProcessConstants.AdeptDataType dataType = param.getDataType();
        Long groupConf = param.getConfiguration().getInteger(PAC_MAIL_EVENT_REGEX_GROUP);
        int group = groupConf != null ? groupConf.intValue() : 1;
        String msg = "Found regex '%s' for parameter '%s' using group #%s for event '%s/%s/%s/%s' (service: %s).";
        msg = String.format(msg, regex, paramName, group, event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()));
        this.logger.fine(msg);
        Pattern pattern = Pattern.compile(regex, 40);
        String bodyString = this.getStringContentOfMessage(message);
        Matcher matcher = pattern.matcher(bodyString);
        String matchedString = null;
        boolean matches = matcher.matches();
        if (matches && matcher.groupCount() >= group) {
            matchedString = matcher.group(group).trim();
        }
        if (dataType == ProcessConstants.AdeptDataType.BOOLEAN) {
            dataContext.storeBooleanParameterValue(paramName, matches);
        } else {
            if (!matches || matchedString == null) {
                if (!param.isOptional()) {
                    msg = "Parameter '%s' is mandatory but regex '%s' did not matchor did not have a group #%s for event '%s/%s/%s/%s' (service: %s). This will probably fail the activity.";
                    msg = String.format(msg, paramName, regex, group, event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()));
                    this.logger.severe(msg);
                }
                return;
            }
            switch (dataType) {
                case DATE: {
                    SimpleDateFormat sdf = new SimpleDateFormat();
                    String dateFormatPattern = sdf.toPattern();
                    try {
                        sdf.setLenient(true);
                        Date value = sdf.parse(matchedString);
                        dataContext.storeDateParameterValue(paramName, value);
                    }
                    catch (ParseException pe) {
                        msg = "Could not parse the date with pattern '%s' for matched string '%s' for parameter '%s' for event '%s/%s/%s/%s' (service: %s). This may fail the activity.";
                        msg = String.format(msg, dateFormatPattern, matchedString, paramName, event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()));
                        this.logger.log(Level.WARNING, msg, pe);
                    }
                    break;
                }
                case FLOAT: {
                    try {
                        double value = Double.parseDouble(matchedString);
                        dataContext.storeFloatParameterValue(paramName, value);
                    }
                    catch (NumberFormatException nfe) {
                        msg = "Could not parse a double for matched string '%s' for parameter '%s' for event '%s/%s/%s/%s' (service: %s). This may fail the activity.";
                        msg = String.format(msg, matchedString, paramName, event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()));
                        this.logger.log(Level.WARNING, msg, nfe);
                    }
                    break;
                }
                case INTEGER: {
                    try {
                        long value = Long.parseLong(matchedString);
                        dataContext.storeIntegerParameterValue(paramName, value);
                    }
                    catch (NumberFormatException nfe) {
                        msg = "Could not parse a long for matched string '%s' for parameter '%s' for event '%s/%s/%s/%s' (service: %s). This may fail the activity.";
                        msg = String.format(msg, matchedString, paramName, event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()));
                        this.logger.log(Level.WARNING, msg, nfe);
                    }
                    break;
                }
                case STRING: {
                    dataContext.storeStringParameterValue(paramName, matchedString);
                    break;
                }
                case URI: {
                    try {
                        URI value = new URI(matchedString);
                        dataContext.storeURIParameterValue(paramName, value);
                    }
                    catch (URISyntaxException urise) {
                        msg = "Could not parse a URI for matched string '%s' for parameter '%s' for event '%s/%s/%s/%s' (service: %s). This may fail the activity.";
                        msg = String.format(msg, matchedString, paramName, event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()));
                        this.logger.log(Level.WARNING, msg, urise);
                    }
                    break;
                }
                default: {
                    msg = "Parameter '%s' has the unsupported data type '%s' when handling event '%s/%s/%s/%s' (service: %s).";
                    msg = String.format(msg, paramName, dataType.name(), event.getEventType(), event.getSourceType(), event.getSourceID(), event.getID(), Arrays.toString(event.getEventManager()));
                    this.logger.severe(msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String sourceID, SimpleSessionContext sessionContext) {
        Map<String, SimpleSessionContext> map = this.contexts;
        synchronized (map) {
            this.contexts.put(sourceID, sessionContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String sourceID) {
        Map<String, SimpleSessionContext> map = this.contexts;
        synchronized (map) {
            this.contexts.remove(sourceID);
        }
    }

    @Override
    public boolean reset(String sessionID) {
        return false;
    }

    @Override
    public boolean signal(String sessionID, int signal) {
        return false;
    }

    @Override
    public boolean close(String sessionID) {
        return false;
    }

    @Override
    public boolean suspend(String sessionID) {
        return false;
    }

    @Override
    public boolean kill(String sessionID) {
        return false;
    }
}

