/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.mailevents;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.eventmanager.EventManager;
import de.aristaflow.adept2.core.eventmanager.common.ParamRefTools;
import de.aristaflow.adept2.core.eventmanager.mailevents.MailEventSource;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.runtimeenvironment.SerialisableDataContext;
import de.aristaflow.adept2.model.runtimeenvironment.SimpleSessionContext;
import org.apache.commons.configuration.Configuration;

public class MailEventActivitySource
extends MailEventSource {
    public MailEventActivitySource(Configuration conf, EventManager eventManager, Registry registry) throws ConfigurationException {
        super(conf, eventManager, registry);
    }

    @Override
    public void setConfiguration(Configuration conf, boolean completed) throws ConfigurationException {
        if (!(!completed || conf.containsKey("SimpleSessionContext") && conf.getProperty("SimpleSessionContext") instanceof SimpleSessionContext)) {
            String msg = "The configuration for activity event source '%s/%s/%s' cannot be set since it does not provide the required simple session context.";
            msg = String.format(msg, this.eventType, this.getType(), this.getID());
            throw new ConfigurationException(msg);
        }
        super.setConfiguration(conf, false);
        if (completed) {
            SimpleSessionContext sessionContext = (SimpleSessionContext)conf.getProperty("SimpleSessionContext");
            ActivityConfiguration actConf = sessionContext.getActivityInstance().getConfiguration();
            SerialisableDataContext dataContext = sessionContext.getDataContext();
            if (actConf.getInteger("PollTime") != null) {
                this.pollTime = actConf.getInteger("PollTime");
            }
            if (actConf.getBoolean("KeepConnection") != null) {
                this.keepConnection = conf.getBoolean("KeepConnection");
            }
            if (actConf.getString("Protocol") != null) {
                this.protocol = actConf.getString("Protocol");
            }
            if (actConf.getString("Host") != null) {
                this.host = actConf.getString("Host");
            }
            if (actConf.getInteger("Port") != null) {
                this.port = actConf.getInteger("Port").intValue();
            }
            if (actConf.getString("UserName") != null) {
                this.userName = actConf.getString("UserName");
            }
            if (actConf.getString("Password") != null) {
                this.password = actConf.getString("Password");
            }
            if (actConf.getString("Folder") != null) {
                this.folderName = actConf.getString("Folder");
            }
            this.protocol = ParamRefTools.replaceParams(this.protocol, dataContext);
            this.userName = ParamRefTools.replaceParams(this.userName, dataContext);
            this.password = ParamRefTools.replaceParams(this.password, dataContext);
            this.folderName = ParamRefTools.replaceParams(this.folderName, dataContext);
            this.verifyConfigurationValues();
        }
    }
}

