/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.mailevents;

import de.aristaflow.adept2.core.eventmanager.common.AbstractEvent;
import de.aristaflow.adept2.core.eventmanager.mailevents.MailTools;
import de.aristaflow.adept2.model.events.MailEvent;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import javax.mail.Message;
import javax.mail.MessagingException;

public class MailEventImpl
extends AbstractEvent
implements MailEvent {
    protected final Message message;
    protected final String[] recipients;
    protected final String[] senders;
    protected final String subject;
    protected final Date receivedDate;
    protected final Date sentDate;
    protected final String content;

    public MailEventImpl(URI[] managerURI, String eventType, String sourceType, String sourceID, Message message) throws MessagingException, IOException {
        super(managerURI, eventType, sourceType, sourceID);
        ArgChecks.checkForNull(message, "message");
        this.message = message;
        this.recipients = MailTools.toString(message.getAllRecipients());
        this.senders = MailTools.toString(message.getFrom());
        this.subject = message.getSubject();
        this.receivedDate = message.getReceivedDate();
        this.sentDate = message.getSentDate();
        Object cont = message.getContent();
        this.content = cont instanceof String ? (String)cont : null;
    }

    @Override
    public String[] getAllRecipients() {
        return (String[])this.recipients.clone();
    }

    @Override
    public String[] getSenders() {
        return (String[])this.senders.clone();
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public Date getReceivedDate() {
        return (Date)this.receivedDate.clone();
    }

    @Override
    public Date getSentDate() {
        return (Date)this.sentDate.clone();
    }

    @Override
    public String getStringContent() {
        return this.content;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }
}

