/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.mailevents;

import de.aristaflow.adept2.base.configuration.ConfigurationDescriptionTools;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.PropertyNotSetException;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.eventmanager.EventManager;
import de.aristaflow.adept2.core.eventmanager.common.AbstractEventSource;
import de.aristaflow.adept2.core.eventmanager.mailevents.MailEventImpl;
import de.aristaflow.adept2.model.events.EventHandlingException;
import de.aristaflow.adept2.model.events.MailEvent;
import de.aristaflow.adept2.model.events.sources.PollingMailSource;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.commons.configuration.Configuration;

public class MailEventSource
extends AbstractEventSource<MailEvent>
implements PollingMailSource {
    protected final String eventType;
    protected Long pollTime;
    protected boolean keepConnection;
    protected String protocol;
    protected String host;
    protected int port;
    protected String userName;
    protected String password;
    protected String folderName;
    protected final URI[] eventManagerURIs;
    protected Store store;
    protected Thread thread;

    public MailEventSource(Configuration conf, EventManager eventManager, Registry registry) throws ConfigurationException {
        this(conf, eventManager, registry, PollingMailSource.class);
    }

    protected MailEventSource(Configuration conf, EventManager eventManager, Registry registry, Class<?> confDesc) throws ConfigurationException {
        super(AbstractRegistry.getSimpleInstanceName(registry.getInstanceName()));
        this.eventType = "MailEvent";
        this.eventManagerURIs = eventManager.getURIs();
        ConfigurationDescriptionTools.validateConfiguration(conf, confDesc, true, this.type);
        this.setConfiguration(conf, false);
    }

    protected void setConfiguration(Configuration conf, boolean completed) throws ConfigurationException {
        if (conf.containsKey("PollTime")) {
            this.pollTime = conf.getLong("PollTime");
        }
        if (conf.containsKey("KeepConnection")) {
            this.keepConnection = conf.getBoolean("KeepConnection");
        }
        if (conf.containsKey("Protocol")) {
            this.protocol = conf.getString("Protocol");
        }
        if (conf.containsKey("Host")) {
            this.host = conf.getString("Host");
        }
        if (conf.containsKey("Port")) {
            this.port = conf.getInt("Port");
        }
        if (conf.containsKey("UserName")) {
            this.userName = conf.getString("UserName");
        }
        if (conf.containsKey("Password")) {
            this.password = conf.getString("Password");
        }
        if (conf.containsKey("Folder")) {
            this.folderName = conf.getString("Folder");
        }
        if (completed) {
            this.verifyConfigurationValues();
        }
    }

    protected void verifyConfigurationValues() throws ConfigurationException {
        String msg = null;
        if (this.pollTime == null) {
            msg = "The poll time needs to be set for event source '%s/%s/%s': %s.";
            msg = String.format(msg, this.eventType, this.getType(), this.getID(), "PollTime");
        } else if (!ConfigurationTools.stringValid(this.protocol)) {
            msg = "The protocol for the mail storage needs to be set for event source '%s/%s/%s': %s.";
            msg = String.format(msg, this.eventType, this.getType(), this.getID(), "Protocol");
        }
        if (msg != null) {
            throw new PropertyNotSetException(msg);
        }
    }

    @Override
    public void setConfiguration(Configuration conf, String id) throws ConfigurationException {
        super.setConfiguration(conf, id);
        this.setConfiguration(conf, true);
    }

    @Override
    public long getPollTime() {
        return this.pollTime;
    }

    @Override
    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block37: {
            this.lock.readLock().lock();
            try {
                block39: {
                    if (this.handlerList.size() <= 0) break block37;
                    MailEventSource mailEventSource = this;
                    synchronized (mailEventSource) {
                        this.thread = Thread.currentThread();
                    }
                    try {
                        try {
                            this.connectToStore();
                            try {
                                try {
                                    Folder folder = this.openFolder();
                                    try {
                                        Message[] messageArray = folder.getMessages();
                                        int n = messageArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String msg;
                                            Message message = messageArray[n2];
                                            if (Thread.currentThread().isInterrupted()) break;
                                            String subject = null;
                                            try {
                                                subject = message.getSubject();
                                                MailEvent event = this.createMailEvent(message);
                                                if (Thread.currentThread().isInterrupted()) break;
                                                if (event != null) {
                                                    this.handleEvent(event, true);
                                                }
                                            }
                                            catch (MessagingException me) {
                                                msg = "Creating the event for message '%s' of folder '%s' of message store (protocol: %s, host: %s, port: %d, user: %s) failed for event source '%s/%s/%s' failed. Message handling and polling will continue.";
                                                msg = String.format(msg, subject, this.folderName, this.protocol, this.host, this.port, this.userName, this.eventType, this.getType(), this.getID());
                                                this.logger.log(Level.WARNING, msg, me);
                                            }
                                            catch (IOException ioe) {
                                                msg = "Retrieving the content of message '%s' of folder '%s' of message store (protocol: %s, host: %s, port: %d, user: %s) failed for event source '%s/%s/%s' failed. Message handling and polling will continue.";
                                                msg = String.format(msg, subject, this.folderName, this.protocol, this.host, this.port, this.userName, this.eventType, this.getType(), this.getID());
                                                this.logger.log(Level.WARNING, msg, ioe);
                                            }
                                            ++n2;
                                        }
                                    }
                                    catch (MessagingException me) {
                                        String msg = "Retrieving the messages of folder '%s' of message store  (protocol: %s, host: %s, port: %d, user: %s) failed for event source '%s/%s/%s' failed. Polling will continue.";
                                        msg = String.format(msg, this.folderName, this.protocol, this.host, this.port, this.userName, this.eventType, this.getType(), this.getID());
                                        this.logger.log(Level.WARNING, msg, me);
                                        this.close(folder);
                                        break block39;
                                    }
                                    catch (EventHandlingException ehe) {
                                        try {
                                            String msg = "Handling the event of event source '%s/%s/%s' for messages of folder '%s' of message store (protocol: %s, host: %s, port: %d, user: %s) failed. Polling will continue.";
                                            msg = String.format(msg, this.eventType, this.getType(), this.getID(), this.folderName, this.protocol, this.host, this.port, this.userName);
                                            this.logger.log(Level.WARNING, msg, ehe);
                                            break block39;
                                        }
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                        finally {
                                            this.close(folder);
                                        }
                                    }
                                    this.close(folder);
                                }
                                catch (MessagingException me) {
                                    String msg = "Retrieving the folder '%s' of message store (protocol: %s, host: %s, port: %d, user: %s) failed for event source '%s/%s/%s' failed. Polling will continue.";
                                    msg = String.format(msg, this.folderName, this.protocol, this.host, this.port, this.userName, this.eventType, this.getType(), this.getID());
                                    this.logger.log(Level.WARNING, msg, me);
                                }
                            }
                            finally {
                                if (Thread.interrupted() || !this.keepConnection) {
                                    this.closeStore();
                                }
                            }
                        }
                        catch (MessagingException me) {
                            String msg = "Retrieving the connection to message store failed (protocol: %s, host: %s, port: %d, user: %s) for event source '%s/%s/%s'failed. Polling will continue.";
                            msg = String.format(msg, this.protocol, this.host, this.port, this.userName, this.eventType, this.getType(), this.getID());
                            this.logger.log(Level.WARNING, msg, me);
                            MailEventSource mailEventSource2 = this;
                            synchronized (mailEventSource2) {
                                this.thread = null;
                                break block37;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        MailEventSource mailEventSource3 = this;
                        synchronized (mailEventSource3) {
                            this.thread = null;
                        }
                        throw throwable;
                    }
                }
                MailEventSource mailEventSource = this;
                synchronized (mailEventSource) {
                    this.thread = null;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        boolean active = false;
        MailEventSource mailEventSource = this;
        synchronized (mailEventSource) {
            if (this.thread != null) {
                this.thread.interrupt();
                active = true;
            }
        }
        if (!active) {
            try {
                this.closeStore();
            }
            catch (MessagingException me) {
                String msg = "Got an exception while closing the store (protocol: %s, host: %s, port: %d, user: %s) when terminating event source '%s/%s/%s'. Ignoring exception.";
                msg = String.format(msg, this.protocol, this.host, this.port, this.userName, this.eventType, this.getType(), this.getID());
                this.logger.log(Level.INFO, msg, me);
            }
        }
    }

    protected MailEvent createMailEvent(Message message) throws MessagingException, IOException {
        return new MailEventImpl(this.eventManagerURIs, this.eventType, this.getType(), this.getID(), message);
    }

    @Override
    protected boolean nextHandler(MailEvent event, boolean consumed, boolean concurrent) {
        return true;
    }

    protected void connectToStore() throws MessagingException {
        if (this.store == null || !this.store.isConnected()) {
            Properties props = new Properties();
            Session session = Session.getDefaultInstance((Properties)props);
            this.store = session.getStore(this.protocol);
            this.store.connect(this.host, this.port, this.userName, this.password);
        }
    }

    protected void closeStore() throws MessagingException {
        if (this.store != null) {
            if (this.store.isConnected()) {
                this.store.close();
            }
            this.store = null;
        }
    }

    protected Folder openFolder() throws MessagingException {
        Folder folder = this.store.getFolder(this.folderName);
        folder.open(2);
        return folder;
    }

    protected void close(Folder folder) throws MessagingException {
        if (folder.isOpen()) {
            folder.close(true);
        }
    }
}

