/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.eventmanager.mailevents;

import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.core.eventmanager.EventManager;
import de.aristaflow.adept2.core.eventmanager.common.AbstractEventHandler;
import de.aristaflow.adept2.model.events.Event;
import de.aristaflow.adept2.model.events.EventHandlingException;
import de.aristaflow.adept2.model.events.MailEvent;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.util.Arrays;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="ApplyConsumedOnly", type=Property.Type.BOOLEAN, defaultValue="true", description="Whether this handler should only handle (set flags, move, expunge) messages of which the corresponding mail event has been consumed."), @Property(name="ChangeFlagAnswered", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether to change the answered flag of the messages from mail events."), @Property(name="SetFlagAnswered", type=Property.Type.BOOLEAN, defaultValue="false", description="How to set the answered flag of messages from mail events. This only applies if the corresponding flag should be changed."), @Property(name="ChangeFlagDeleted", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether to change the deleted flag of the messages from mail events."), @Property(name="SetFlagDeleted", type=Property.Type.BOOLEAN, defaultValue="false", description="How to set the deleted flag of messages from mail events. This only applies if the corresponding flag should be changed."), @Property(name="ChangeFlagDraft", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether to change the draft flag of the messages from mail events."), @Property(name="SetFlagDraft", type=Property.Type.BOOLEAN, defaultValue="false", description="How to set the draft flag of messages from mail events. This only applies if the corresponding flag should be changed."), @Property(name="ChangeFlagFlagged", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether to change the flagged flag of the messages from mail events."), @Property(name="SetFlagFlagged", type=Property.Type.BOOLEAN, defaultValue="false", description="How to set the flagged flag of messages from mail events. This only applies if the corresponding flag should be changed."), @Property(name="ChangeFlagRecent", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether to change the recent flag of the messages from mail events."), @Property(name="SetFlagRecent", type=Property.Type.BOOLEAN, defaultValue="false", description="How to set the recent flag of messages from mail events. This only applies if the corresponding flag should be changed."), @Property(name="ChangeFlagSeen", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether to change the seen flag of the messages from mail events."), @Property(name="SetFlagSeen", type=Property.Type.BOOLEAN, defaultValue="false", description="How to set the seen flag of messages from mail events. This only applies if the corresponding flag should be changed."), @Property(name="ChangeFlagUser", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether to change the user flag of the messages from mail events."), @Property(name="SetFlagUser", type=Property.Type.BOOLEAN, defaultValue="false", description="How to set the user flag of messages from mail events. This only applies if the corresponding flag should be changed."), @Property(name="TargetFolder", defaultNull=true, description="The name of the target folder in case the messages of mail events should be moved."), @Property(name="Expunge", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether the folder of messages from mail events should be expunged. This really deletes messages that have deleted flag set. Therefore if you want do delete a handled message finally, set the deleted flag and expunge the folder.")})
public class MailFlagHandler
extends AbstractEventHandler {
    public static final String CONF_APPLY_CONSUMED_ONLY = "ApplyConsumedOnly";
    protected final boolean APPLY_CONSUMED_ONLY;
    public static final String CONF_CHANGE_FLAG_ANSWERED = "ChangeFlagAnswered";
    public static final String CONF_SET_FLAG_ANSWERED = "SetFlagAnswered";
    protected final boolean CHANGE_FLAG_ANSWERED;
    protected final boolean SET_FLAG_ANSWERED;
    public static final String CONF_CHANGE_FLAG_DELETED = "ChangeFlagDeleted";
    public static final String CONF_SET_FLAG_DELETED = "SetFlagDeleted";
    protected final boolean CHANGE_FLAG_DELETED;
    protected final boolean SET_FLAG_DELETED;
    public static final String CONF_CHANGE_FLAG_DRAFT = "ChangeFlagDraft";
    public static final String CONF_SET_FLAG_DRAFT = "SetFlagDraft";
    protected final boolean CHANGE_FLAG_DRAFT;
    protected final boolean SET_FLAG_DRAFT;
    public static final String CONF_CHANGE_FLAG_FLAGGED = "ChangeFlagFlagged";
    public static final String CONF_SET_FLAG_FLAGGED = "SetFlagFlagged";
    protected final boolean CHANGE_FLAG_FLAGGED;
    protected final boolean SET_FLAG_FLAGGED;
    public static final String CONF_CHANGE_FLAG_RECENT = "ChangeFlagRecent";
    public static final String CONF_SET_FLAG_RECENT = "SetFlagRecent";
    protected final boolean CHANGE_FLAG_RECENT;
    protected final boolean SET_FLAG_RECENT;
    public static final String CONF_CHANGE_FLAG_SEEN = "ChangeFlagSeen";
    public static final String CONF_SET_FLAG_SEEN = "SetFlagSeen";
    protected final boolean CHANGE_FLAG_SEEN;
    protected final boolean SET_FLAG_SEEN;
    public static final String CONF_CHANGE_FLAG_USER = "ChangeFlagUser";
    public static final String CONF_SET_FLAG_USER = "SetFlagUser";
    protected final boolean CHANGE_FLAG_USER;
    protected final boolean SET_FLAG_USER;
    public static final String CONF_TARGET_FOLDER = "TargetFolder";
    protected final String TARGET_FOLDER;
    public static final String CONF_EXPUNGE = "Expunge";
    protected final boolean EXPUNGE;

    public MailFlagHandler(Configuration conf, EventManager eventManager, Registry registry) {
        super(registry, true, true);
        this.APPLY_CONSUMED_ONLY = conf.getBoolean(CONF_APPLY_CONSUMED_ONLY);
        this.CHANGE_FLAG_ANSWERED = conf.getBoolean(CONF_CHANGE_FLAG_ANSWERED);
        this.SET_FLAG_ANSWERED = conf.getBoolean(CONF_SET_FLAG_ANSWERED);
        this.CHANGE_FLAG_DELETED = conf.getBoolean(CONF_CHANGE_FLAG_DELETED);
        this.SET_FLAG_DELETED = conf.getBoolean(CONF_SET_FLAG_DELETED);
        this.CHANGE_FLAG_DRAFT = conf.getBoolean(CONF_CHANGE_FLAG_DRAFT);
        this.SET_FLAG_DRAFT = conf.getBoolean(CONF_SET_FLAG_DRAFT);
        this.CHANGE_FLAG_FLAGGED = conf.getBoolean(CONF_CHANGE_FLAG_FLAGGED);
        this.SET_FLAG_FLAGGED = conf.getBoolean(CONF_SET_FLAG_FLAGGED);
        this.CHANGE_FLAG_RECENT = conf.getBoolean(CONF_CHANGE_FLAG_RECENT);
        this.SET_FLAG_RECENT = conf.getBoolean(CONF_SET_FLAG_RECENT);
        this.CHANGE_FLAG_SEEN = conf.getBoolean(CONF_CHANGE_FLAG_SEEN);
        this.SET_FLAG_SEEN = conf.getBoolean(CONF_SET_FLAG_SEEN);
        this.CHANGE_FLAG_USER = conf.getBoolean(CONF_CHANGE_FLAG_USER);
        this.SET_FLAG_USER = conf.getBoolean(CONF_SET_FLAG_USER);
        this.TARGET_FOLDER = conf.containsKey(CONF_TARGET_FOLDER) && ConfigurationTools.stringValid(conf.getString(CONF_TARGET_FOLDER)) ? conf.getString(CONF_TARGET_FOLDER) : null;
        this.EXPUNGE = conf.getBoolean(CONF_EXPUNGE);
    }

    @Override
    public boolean handleEvent(Event eve, boolean consumed) throws EventHandlingException {
        boolean ret = consumed;
        if (!(eve instanceof MailEvent) || this.APPLY_CONSUMED_ONLY && !consumed) {
            return ret;
        }
        MailEvent event = (MailEvent)eve;
        Message message = event.getMessage();
        try {
            if (this.CHANGE_FLAG_ANSWERED) {
                message.setFlag(Flags.Flag.ANSWERED, this.SET_FLAG_ANSWERED);
                ret = true;
            }
            if (this.CHANGE_FLAG_DELETED) {
                message.setFlag(Flags.Flag.DELETED, this.SET_FLAG_DELETED);
                ret = true;
            }
            if (this.CHANGE_FLAG_DRAFT) {
                message.setFlag(Flags.Flag.DRAFT, this.SET_FLAG_DRAFT);
                ret = true;
            }
            if (this.CHANGE_FLAG_FLAGGED) {
                message.setFlag(Flags.Flag.FLAGGED, this.SET_FLAG_FLAGGED);
                ret = true;
            }
            if (this.CHANGE_FLAG_RECENT) {
                message.setFlag(Flags.Flag.RECENT, this.SET_FLAG_RECENT);
                ret = true;
            }
            if (this.CHANGE_FLAG_SEEN) {
                message.setFlag(Flags.Flag.SEEN, this.SET_FLAG_SEEN);
                ret = true;
            }
            if (this.CHANGE_FLAG_USER) {
                message.setFlag(Flags.Flag.USER, this.SET_FLAG_USER);
                ret = true;
            }
            boolean moved = false;
            if (this.TARGET_FOLDER != null) {
                Folder folder = message.getFolder();
                Folder target = folder.getStore().getFolder(this.TARGET_FOLDER);
                folder.copyMessages(new Message[]{message}, target);
                message.setFlag(Flags.Flag.DELETED, true);
                folder.expunge();
                moved = true;
                ret = true;
            }
            if (this.EXPUNGE || moved) {
                message.getFolder().expunge();
                ret = true;
            }
        }
        catch (MessagingException me) {
            String msg = "Cannot flag message of event '%s/%s/%s/%s' (service: '%s') due to problems when accessing the message.";
            msg = String.format(msg, eve.getEventType(), eve.getSourceType(), eve.getSourceID(), eve.getID(), Arrays.toString(eve.getEventManager()));
            throw new EventHandlingException(msg, me);
        }
        return ret;
    }
}

