/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.base.licensing.LicenceManager;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.core.checks.processmodel.other.ErrorHandlingFilters;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.executionmanager.ActivityExecutionControl;
import de.aristaflow.adept2.core.executionmanager.ActivityStarting;
import de.aristaflow.adept2.core.executionmanager.ActivityTermination;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.executionmanager.InstanceChanging;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.executionmanager.WorklistInteraction;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.DefaultActivityActivation;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.DefaultActivityExecutionControl;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.DefaultActivityExecutionControlManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.DefaultActivityStarting;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.DefaultActivityTermination;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.DefaultStartEndNodeHandling;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.components.ADEPT2DefaultComponentFactory;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.components.DefaultADEPT2DefaultComponentFactory;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instancechanging.DefaultInstanceChanging;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instancecontrol.DefaultInstanceControl;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instancecontrol.DefaultInstanceNotification;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instanceexecution.InstanceExecution;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction.DefaultWorklistInteraction;
import de.aristaflow.adept2.core.logmanager.LogManager;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.logmanager.nullimplementation.NullLogManager;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolutionException;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.runtimemanager.RuntimeManager;
import de.aristaflow.adept2.core.subprocessmanager.SubprocessManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.ModelViewerProvider;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.Base64;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.SerialisableConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;

@ConfigurationDescription(properties={@Property(name="RTConf.SkipBlockNodes", type=Property.Type.BOOLEAN, defaultValue="true", description="Specifies if block null nodes should be skipped."), @Property(name="RTConf.EnquiryRecipients", type=Property.Type.STRING, defaultValue="OrgPosition(id=%i:orgPositionID%).getOrgUnit() OR OrgPosition(id=%i:orgPositionID%).getOrgUnit().getSuperOrgUnit()", description="Staff Assignment Rule to determine which agents the user is allowed to enquire."), @Property(name="RTConf.MaximumAutostartDelay", type=Property.Type.LONG, defaultValue="5000", description="The maximum delay in milliseconds after which a node could be started automatic after the dependent (transitive) predecessor is finished."), @Property(name="RTConf.AbortionTimeout", type=Property.Type.LONG, defaultValue="10000", description="The amount of time in milliseconds to wait until a component reacts to an abort or a suspend request. If it does not respond in case of an abort, its threads will be stopped.")})
public class DefaultExecutionManager
extends AbstractADEPT2Service
implements ExecutionManager {
    protected static final String CONF_RUNTIME_CONF_PREFIX = "RTConf.";
    public static final String CONF_RUNTIME_DEFAULT_ERROR_HANDLING_PROCESS = "DefaultErrorHandlingProcess";
    public static final String CONF_SKIP_BLOCK_NODES = "RTConf.SkipBlockNodes";
    public static final String CONF_POSSIBLE_ENQUIRY_RECIPIENTS = "RTConf.EnquiryRecipients";
    public static final String CONF_MAXIMUM_AUTOSTART_DELAY = "RTConf.MaximumAutostartDelay";
    public static final String CONF_ABORTION_TIMEOUT = "RTConf.AbortionTimeout";
    protected final DefaultInstanceControl instanceControl;
    protected final DefaultInstanceNotification instanceNotification;
    protected final DefaultActivityStarting activityStarting;
    protected final DefaultActivityTermination activityTermination;
    protected final DefaultActivityExecutionControl activityExecutionControl;
    protected final DefaultWorklistInteraction worklistInteraction;
    protected final DefaultActivityActivation activityActivation;
    protected final DefaultInstanceChanging instanceChanging;
    protected final DefaultActivityExecutionControlManager activityExecutionControlManager;
    protected ADEPT2DefaultComponentFactory adept2DefaultComponentFactory;
    protected final InstanceExecution instanceExecution;
    protected final DefaultStartEndNodeHandling startEndNodeHandling;
    protected OrgModelManager orgModelManager;
    protected ProcessManager processManager;
    protected ExecutionFactory executionFactory;
    protected ProcessModelFactory processModelFactory;
    protected final CompositeConfiguration runtimeConfiguration;
    protected String[] startupRequired;
    protected String[] runtimeRequired;

    public DefaultExecutionManager(Configuration configuration, Registry registry) throws de.aristaflow.adept2.base.configuration.ConfigurationException {
        super(configuration, registry, new String[]{"LicenceManager", "ProcessManager", "LogManager"}, new String[]{"OrgModelManager", "DataManager", "SubprocessManager", "UpdateManager"});
        this.runtimeConfiguration = new CompositeConfiguration(configuration);
        this.runtimeConfiguration.addConfiguration((Configuration)this.getRuntimeConfiguration());
        this.startupRequired = null;
        this.runtimeRequired = null;
        this.worklistInteraction = new DefaultWorklistInteraction(this);
        this.instanceExecution = new InstanceExecution(this, this.worklistInteraction);
        this.instanceNotification = new DefaultInstanceNotification(registry, this, this.worklistInteraction);
        this.instanceControl = new DefaultInstanceControl(this, this.instanceNotification, this.instanceExecution, this.worklistInteraction);
        this.instanceChanging = new DefaultInstanceChanging(this, this.instanceControl);
        this.activityTermination = new DefaultActivityTermination(this, this.instanceControl, this.instanceExecution, this.worklistInteraction);
        this.activityExecutionControl = new DefaultActivityExecutionControl(this, this.activityTermination, this.instanceExecution, this.worklistInteraction);
        this.startEndNodeHandling = new DefaultStartEndNodeHandling(this, this.activityTermination);
        this.activityActivation = new DefaultActivityActivation(this, this.startEndNodeHandling, this.worklistInteraction);
        this.activityExecutionControlManager = new DefaultActivityExecutionControlManager(this, this.activityTermination);
        this.activityStarting = new DefaultActivityStarting(this, this.activityExecutionControlManager, this.instanceExecution, this.activityTermination, this.worklistInteraction);
    }

    @Override
    public String[] getStartupRequiredServices() {
        if (this.startupRequired == null) {
            HashSet<String> ret = new HashSet<String>();
            ret.addAll(Arrays.asList(super.getStartupRequiredServices()));
            ret.addAll(Arrays.asList(this.worklistInteraction.getStartupRequiredServices()));
            ret.addAll(Arrays.asList(this.instanceExecution.getStartupRequiredServices()));
            ret.addAll(Arrays.asList(this.instanceNotification.getStartupRequiredServices()));
            ret.addAll(Arrays.asList(this.instanceControl.getStartupRequiredServices()));
            ret.addAll(Arrays.asList(this.instanceChanging.getStartupRequiredServices()));
            ret.addAll(Arrays.asList(this.activityTermination.getStartupRequiredServices()));
            ret.addAll(Arrays.asList(this.startEndNodeHandling.getStartupRequiredServices()));
            ret.addAll(Arrays.asList(this.activityActivation.getStartupRequiredServices()));
            ret.addAll(Arrays.asList(this.activityExecutionControlManager.getStartupRequiredServices()));
            ret.addAll(Arrays.asList(this.activityExecutionControl.getStartupRequiredServices()));
            ret.addAll(Arrays.asList(this.activityStarting.getStartupRequiredServices()));
            this.startupRequired = ret.toArray(new String[ret.size()]);
        }
        return this.startupRequired;
    }

    @Override
    public String[] getRuntimeRequiredServices() {
        if (this.runtimeRequired == null) {
            HashSet<String> ret = new HashSet<String>();
            ret.addAll(Arrays.asList(super.getRuntimeRequiredServices()));
            ret.addAll(Arrays.asList(this.worklistInteraction.getRuntimeRequiredServices()));
            ret.addAll(Arrays.asList(this.instanceExecution.getRuntimeRequiredServices()));
            ret.addAll(Arrays.asList(this.instanceNotification.getRuntimeRequiredServices()));
            ret.addAll(Arrays.asList(this.instanceControl.getRuntimeRequiredServices()));
            ret.addAll(Arrays.asList(this.instanceChanging.getRuntimeRequiredServices()));
            ret.addAll(Arrays.asList(this.activityTermination.getRuntimeRequiredServices()));
            ret.addAll(Arrays.asList(this.startEndNodeHandling.getRuntimeRequiredServices()));
            ret.addAll(Arrays.asList(this.activityActivation.getRuntimeRequiredServices()));
            ret.addAll(Arrays.asList(this.activityExecutionControlManager.getRuntimeRequiredServices()));
            ret.addAll(Arrays.asList(this.activityExecutionControl.getRuntimeRequiredServices()));
            ret.addAll(Arrays.asList(this.activityStarting.getRuntimeRequiredServices()));
            this.runtimeRequired = ret.toArray(new String[ret.size()]);
        }
        return this.runtimeRequired;
    }

    @Override
    public void init(URI[] exportedURIs) throws AbortServiceException {
        QualifiedAgent nodeExecutor;
        super.init(exportedURIs, -2, -2, "password");
        SessionToken session = this.sessionFactory.getSessionToken(exportedURIs);
        try {
            nodeExecutor = this.sessionFactory.checkAndGetAgent(session);
        }
        catch (SecurityTokenIntegrityException stie) {
            String errorMessage = "Cannot retrieve the agent for executing null nodes. This is a serious problem since the corresponding session factory has been retrieved recently from the SecurityManager.";
            this.logger.log(Level.SEVERE, errorMessage, stie);
            throw new InternalServiceException(errorMessage, stie);
        }
        this.executionFactory = this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
        this.processModelFactory = this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
        this.orgModelManager = this.registry.getServiceOfType(session, "OrgModelManager", OrgModelManager.class);
        this.processManager = this.registry.getServiceOfType(session, "ProcessManager", ProcessManager.class);
        this.adept2DefaultComponentFactory = new DefaultADEPT2DefaultComponentFactory(this.getProcessModelFactory(), this.getExecutionFactory());
        if (this.checkLicenceViolation(session)) {
            throw new AbortServiceException("You have violated against your licence. Aborting start.");
        }
        this.getExecutionHistory(session, null);
        this.worklistInteraction.init();
        this.instanceExecution.init(this.activityActivation, this.activityExecutionControlManager, this.startEndNodeHandling, this.instanceControl, this.instanceNotification, nodeExecutor);
        this.instanceNotification.init();
        this.instanceControl.init();
        this.instanceChanging.init();
        this.activityTermination.init();
        this.startEndNodeHandling.init();
        this.activityActivation.init();
        this.activityExecutionControlManager.init();
        this.activityExecutionControl.init();
        this.activityStarting.init();
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        this.worklistInteraction.start();
        this.instanceExecution.start();
        this.instanceNotification.start();
        this.instanceControl.start();
        this.instanceChanging.start();
        this.activityTermination.start();
        this.startEndNodeHandling.start();
        this.activityActivation.start();
        this.activityExecutionControlManager.start();
        this.activityExecutionControl.start();
        this.activityStarting.start();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.activityStarting.shutdown();
        this.activityExecutionControl.shutdown();
        this.activityExecutionControlManager.shutdown();
        this.activityActivation.shutdown();
        this.startEndNodeHandling.shutdown();
        this.activityTermination.shutdown();
        this.instanceChanging.shutdown();
        this.instanceControl.shutdown();
        this.instanceNotification.shutdown();
        this.instanceExecution.shutdown();
        this.worklistInteraction.shutdown();
        this.adept2DefaultComponentFactory = null;
        this.executionFactory = null;
        this.processManager = null;
        this.sessionFactory = null;
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        this.activityStarting.emergencyShutdown();
        this.activityExecutionControl.emergencyShutdown();
        this.activityExecutionControlManager.emergencyShutdown();
        this.activityTermination.emergencyShutdown();
        this.activityActivation.emergencyShutdown();
        this.startEndNodeHandling.emergencyShutdown();
        this.instanceChanging.emergencyShutdown();
        this.instanceControl.emergencyShutdown();
        this.instanceNotification.emergencyShutdown();
        this.instanceExecution.emergencyShutdown();
        this.worklistInteraction.emergencyShutdown();
        this.adept2DefaultComponentFactory = null;
        this.executionFactory = null;
        this.processManager = null;
        this.sessionFactory = null;
    }

    private boolean checkLicenceViolation(SessionToken session) {
        boolean ret = false;
        try {
            SessionToken subSession = this.sessionFactory.getChildSession(session, this.getURIs());
            LicenceManager licMgr = this.registry.getServiceOfType(subSession, "LicenceManager", LicenceManager.class);
            LogManager execLogMgr = this.registry.getService(session, this.getProcessManager().getExecutionLogManager(session), LogManager.class);
            if (execLogMgr instanceof NullLogManager) {
                return ret;
            }
            ExecutionHistory history = execLogMgr.getExecutionHistory();
            subSession = this.sessionFactory.getChildSession(subSession, this.getURIs());
            String query = String.format("SELECT MAX(%s) FROM %s", "timestamp", "ExecutionHistory");
            ResultSet rs = history.query(subSession, query, 1);
            try {
                Timestamp lastDate = null;
                if (rs.next()) {
                    lastDate = rs.getTimestamp(1, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                }
                subSession = this.sessionFactory.getChildSession(subSession, this.getURIs());
                long value = lastDate == null ? 0L : ((Date)lastDate).getTime();
                ret = licMgr.logViolation(subSession, "TimeInconsistency", value);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    String msg = "Closing the result set failed. Ignoring.";
                    this.logger.log(Level.FINER, msg, sqle);
                }
            }
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not retrieve a service for checking the licence violations. Ignoring it for now.";
            this.logger.log(Level.WARNING, msg, snke);
        }
        catch (SQLException sqle) {
            String msg = "Could not retrieve the necessary information for checking licence violations. Ignoring it for now.";
            this.logger.log(Level.WARNING, msg, sqle);
        }
        return ret;
    }

    protected FileConfiguration getRuntimeConfiguration() throws de.aristaflow.adept2.base.configuration.ConfigurationException {
        File confDir = new File(SystemProperties.getDataDir(), "ExecutionManager");
        File confFile = null;
        try {
            if (!(!confDir.exists() || confDir.canRead() && confDir.canWrite())) {
                String msg = String.format("Configuration directory '%s' doesn't exist or is not accessible.", confDir);
                throw new de.aristaflow.adept2.base.configuration.ConfigurationException(msg);
            }
            if (!confDir.exists() && !confDir.mkdirs()) {
                String msg = String.format("Could not create configuration directory '%s'.", confDir);
                throw new de.aristaflow.adept2.base.configuration.ConfigurationException(msg);
            }
            confFile = new File(confDir, "EM-RT.conf");
            try {
                if (!confFile.exists() && !confFile.createNewFile()) {
                    String msg = String.format("Could not create configuration file '%s'.", confFile);
                    throw new de.aristaflow.adept2.base.configuration.ConfigurationException(msg);
                }
            }
            catch (IOException ioe) {
                String msg = String.format("Could not create configuration file '%s'.", confFile);
                throw new de.aristaflow.adept2.base.configuration.ConfigurationException(msg, ioe);
            }
        }
        catch (SecurityException se) {
            String msg = confFile != null ? String.format("file '%s'", confFile) : String.format("directory '%s'", confDir);
            msg = String.format("Could not access configuration %s.", msg);
            throw new de.aristaflow.adept2.base.configuration.ConfigurationException(msg, se);
        }
        try {
            PropertiesConfiguration ret = new PropertiesConfiguration(confFile);
            return ret;
        }
        catch (ConfigurationException ce) {
            String msg = String.format("Could not load configuration from file '%s'.", confFile);
            throw new de.aristaflow.adept2.base.configuration.ConfigurationException(msg, ce);
        }
    }

    @Override
    public ActivityStarting getActivityStarting() {
        return this.activityStarting;
    }

    @Override
    public ActivityTermination getActivityTermination() {
        return this.activityTermination;
    }

    @Override
    public ActivityExecutionControl getActivityExecutionControl() {
        return this.activityExecutionControl;
    }

    @Override
    public InstanceControl getInstanceControl() {
        return this.instanceControl;
    }

    @Override
    public WorklistInteraction getWorklistInteraction() {
        return this.worklistInteraction;
    }

    @Override
    public URI[] getProcessManager(SessionToken session, UUID instanceID) throws ServiceNotKnownException {
        super.sessionActive(session);
        try {
            this.checkAccessRights(session);
            ProcessManager processManager = this.registry.getServiceOfType(session, "ProcessManager", ProcessManager.class);
            URI[] uRIArray = processManager.getURIs();
            return uRIArray;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public URI[] getDataManager(SessionToken session, UUID instanceID) throws ServiceNotKnownException {
        super.sessionActive(session);
        try {
            this.checkAccessRights(session);
            DataManager dataManager = this.registry.getServiceOfType(session, "DataManager", DataManager.class);
            URI[] uRIArray = dataManager.getURIs();
            return uRIArray;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public Configuration getConfiguration(SessionToken session) {
        super.sessionActive(session);
        try {
            SerialisableConfiguration result = new SerialisableConfiguration();
            result.setListDelimiter(this.runtimeConfiguration.getListDelimiter());
            result.setDelimiterParsingDisabled(false);
            Iterator keys = this.runtimeConfiguration.getKeys();
            while (keys.hasNext()) {
                String nextKey = (String)keys.next();
                result.setProperty(nextKey, this.runtimeConfiguration.getProperty(nextKey));
            }
            SerialisableConfiguration serialisableConfiguration = result;
            return serialisableConfiguration;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void setConfigurationValue(SessionToken session, String key, String value, ProcessConstants.AdeptDataType dataType) {
        super.sessionActive(session);
        try {
            FileConfiguration fileConf = (FileConfiguration)this.runtimeConfiguration.getConfiguration(0);
            if (value.equals("")) {
                fileConf.clearProperty(key);
            } else {
                if (key.equals(CONF_RUNTIME_DEFAULT_ERROR_HANDLING_PROCESS)) {
                    boolean isMember;
                    PolicyResolution policyResolution;
                    FilterFactory factory;
                    UUID handlingID;
                    try {
                        handlingID = UUID.fromString(value);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("The given string is not a valid UUID: " + value, e);
                    }
                    try {
                        factory = this.registry.getModelFactory("FilterFactory", FilterFactory.class);
                    }
                    catch (ServiceNotKnownException snke) {
                        String msg = "Could not retrieve filter for verifying template '%s' whether it has the needed error handling API.";
                        throw new InternalServiceException(String.format(msg, value), snke);
                    }
                    Filter filter = ErrorHandlingFilters.getTemplateFilter(factory);
                    Filter statusFilter = ErrorHandlingFilters.getTemplateStatusFilter(factory);
                    Template template = this.getProcessManager().getTemplateManager().getTemplate(session, handlingID);
                    TemplateStatus templateStatus = this.getProcessManager().getTemplateManager().getTemplateStatus(session, handlingID);
                    if (!filter.matches(template)) {
                        throw new IllegalArgumentException("The API of the template is not a valid error handling API");
                    }
                    if (!statusFilter.matches(templateStatus)) {
                        throw new IllegalArgumentException("The template has an invalid state, check the template status instantiation.");
                    }
                    String starterRule = templateStatus.getStarterRule();
                    SessionToken systemSession = this.newSession(session);
                    QualifiedAgent systemAgent = this.checkAndGetTopLevelAgent(systemSession);
                    try {
                        policyResolution = this.registry.getServiceOfType(systemSession, "OrgModelManager", OrgModelManager.class).getPolicyResolution();
                    }
                    catch (ServiceNotKnownException snke) {
                        String msg = "Could not retrieve policy resolution service for verifying the starter rule of (error handling) template '%s' to contain the system user.";
                        throw new InternalServiceException(String.format(msg, value), snke);
                    }
                    try {
                        isMember = policyResolution.isMember(systemSession, systemAgent.getAgentUserName(), starterRule);
                    }
                    catch (PolicyResolutionException e) {
                        String message = String.format("PolicyResolutionException while resolving the starter rule '%s' of the template status. ", starterRule);
                        this.logger.log(Level.SEVERE, message, e);
                        throw new InternalServiceException(message, e);
                    }
                    catch (DataSourceException e) {
                        String message = String.format("DataSourceException while resolving the starter rule '%s' of the template status. ", starterRule);
                        this.logger.log(Level.SEVERE, message, e);
                        throw new InternalServiceException(message, e);
                    }
                    if (!isMember) {
                        throw new IllegalArgumentException("The provided error handling process is not instantiable by the system user, change the starter rule of the template appropriately.");
                    }
                }
                fileConf.setProperty(key, (Object)value);
            }
            try {
                fileConf.save();
            }
            catch (ConfigurationException ce) {
                String msg = String.format("Could not store the configuration when setting the value '%s' of '%s'. The value will be ignored.", value, key);
                this.logger.log(Level.WARNING, msg, ce);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    private final void checkAccessRights(SessionToken sessionToken) {
        try {
            this.sessionFactory.checkIntegrity(sessionToken);
        }
        catch (SecurityTokenIntegrityException stie) {
            throw new ServiceAccessControlException("The designated session token failed the verification!", stie);
        }
    }

    public SessionToken newSession(SessionToken parentSession) {
        this.checkAccessRights(parentSession);
        return this.sessionFactory.getSessionToken(this.getURIs());
    }

    public SessionToken privilegedSubSession(SessionToken parentSession) {
        this.checkAccessRights(parentSession);
        return this.getSessionFactory().getPrivilegedChildSession(parentSession, this.getURIs());
    }

    public SessionToken subSession(SessionToken parentSession) {
        return this.privilegedSubSession(parentSession);
    }

    @Override
    public void sessionActive(SessionToken session) {
        super.sessionActive(session);
    }

    @Override
    public void sessionFinished(SessionToken session) {
        super.sessionFinished(session);
    }

    public SessionToken newSubstituteSession(SessionToken session, UserData substitutedSession) throws SecurityTokenIntegrityException {
        this.checkAccessRights(session);
        ArgChecks.checkForNull(substitutedSession, "substitutedSession");
        this.logger.info("Creating subsituted session token.");
        HashMap<String, String> attributes = null;
        if (substitutedSession.userSessionID != null) {
            attributes = new HashMap<String, String>();
            attributes.put("UserClientSessionID", substitutedSession.userSessionID);
            this.logger.fine(String.format("Subsituted session token has %s: %s.", "UserClientSessionID", substitutedSession.userSessionID));
        }
        return this.sessionFactory.getSubstituteSessionToken(session, substitutedSession.securityToken, attributes);
    }

    public String getSerialisedUserData(SessionToken sessionToken) throws SecurityTokenIntegrityException {
        this.sessionFactory.checkAndGetTopLevelAgent(sessionToken);
        return Base64.encodeObject(new UserData(sessionToken), 10);
    }

    public UserData deserialiseUserData(String userData) {
        return (UserData)Base64.decodeToObject(userData);
    }

    public QualifiedAgent checkAndGetTopLevelAgent(SessionToken sessionToken) {
        super.sessionActive(sessionToken);
        try {
            QualifiedAgent qualifiedAgent = this.sessionFactory.checkAndGetTopLevelAgent(sessionToken);
            return qualifiedAgent;
        }
        catch (SecurityTokenIntegrityException e) {
            throw new ServiceAccessControlException("The agent could not be retrieved from the session token!", e);
        }
        finally {
            super.sessionFinished(sessionToken);
        }
    }

    public EBPInstanceReference getEbpIRForInstance(ExecutableInstance instance) {
        return this.processModelFactory.createEBPInstanceReference(EBPType.TLPI, instance.getID(), instance.getBaseTemplateID(), Integer.MIN_VALUE, Integer.MIN_VALUE, false, this.getURIs());
    }

    public ADEPT2DefaultComponentFactory getADEPT2DefaultComponentFactory() {
        return this.adept2DefaultComponentFactory;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.executionFactory;
    }

    public ProcessModelFactory getProcessModelFactory() {
        return this.processModelFactory;
    }

    public OrgModelManager getOrgModelManager() {
        return this.orgModelManager;
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public ExecutionHistory getExecutionHistory(SessionToken session, UUID instanceID) {
        try {
            return this.registry.getService(session, this.getProcessManager().getExecutionLogManager(session), LogManager.class).getExecutionHistory();
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    public DataManager getResolvedDataManager(SessionToken session, UUID instanceID) {
        super.sessionActive(session);
        try {
            URI[] dataManagerInstanceURIs = this.getDataManager(session, instanceID);
            DataManager dataManager = this.registry.getService(session, dataManagerInstanceURIs, DataManager.class);
            return dataManager;
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public UpdateManager getUpdateManager(SessionToken session) {
        super.sessionActive(session);
        try {
            UpdateManager updateManager = this.registry.getServiceOfType(session, "UpdateManager", UpdateManager.class);
            return updateManager;
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public RuntimeManager getSubprocessManager(SessionToken session, EBPInstanceReference ebpInstanceRef) {
        super.sessionActive(session);
        try {
            RuntimeManager runtimeManager = this.registry.getServiceOfType(session, "SubprocessManager", SubprocessManager.class);
            return runtimeManager;
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    public RuntimeManager getRuntimeManager(SessionToken session, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(session);
        try {
            RuntimeManager runtimeManager = this.registry.getService(session, ebpInstanceReference.getRuntimeManagerURIs(), RuntimeManager.class);
            return runtimeManager;
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public InstanceChanging getInstanceChanging() {
        return this.instanceChanging;
    }

    public boolean getSkipBlockNodes() {
        return this.runtimeConfiguration.getBoolean(CONF_SKIP_BLOCK_NODES);
    }

    public long getAutoStartDelay() {
        return this.runtimeConfiguration.getLong(CONF_MAXIMUM_AUTOSTART_DELAY);
    }

    public long getAbortionTimeout() {
        return this.runtimeConfiguration.getLong(CONF_ABORTION_TIMEOUT);
    }

    public String getDefaultEnquiryRecipientsSAR() {
        return this.runtimeConfiguration.getString(CONF_POSSIBLE_ENQUIRY_RECIPIENTS);
    }

    public ModelViewerProvider getPluginRegistry() {
        return this.registry;
    }

    public static class UserData
    implements Serializable {
        private static final long serialVersionUID = -5157315852305174060L;
        public final SignedSecurityToken securityToken;
        public final String userSessionID;

        protected UserData(SessionToken sessionToken) {
            this.securityToken = sessionToken.getTopLevelSecurityToken();
            this.userSessionID = sessionToken.getAdditionalAttributeValue("UserClientSessionID");
        }
    }
}

