/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.ParameterResolvingMap;
import de.aristaflow.adept2.model.common.ModelViewerProvider;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.BasicSystemDataFormatter;
import de.aristaflow.adept2.model.common.systemdata.SystemDataConsumer;
import de.aristaflow.adept2.model.common.systemdata.SystemDataFormatter;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public final class ParameterRefResolver {
    private static final Logger logger = LoggerTools.getLogger(ParameterRefResolver.class);

    public static <T> T getProxy(T object, Class<T> iface, InputDataContainer data, SessionToken session, ModelViewerProvider pluginRegistry) {
        ArgChecks.checkForNull(object, "object");
        ArgChecks.checkForNull(iface, "iface");
        ArgChecks.checkForNull(data, "data");
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(pluginRegistry, "pluginRegistry");
        ResolverInvocationHandler ih = new ResolverInvocationHandler(object, data, session, pluginRegistry);
        Object proxy = Proxy.newProxyInstance(object.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)ih);
        return (T)proxy;
    }

    private ParameterRefResolver() {
    }

    public static String getFormattedReplacedString(SessionToken session, InputDataContainer data, Class<? extends SystemDataFormatter> formatterClass, String parameterisedString) {
        if (parameterisedString == null) {
            return null;
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        ParameterRef[] parameterRefArray = SystemDataTools.findParameterReferences(parameterisedString);
        int n = parameterRefArray.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                ParameterRef ref = parameterRefArray[n2];
                String parameterName = ref.getName();
                try {
                    if (data.isNull(session, parameterName)) {
                        values.put(parameterName, null);
                        break block14;
                    }
                    switch (ref.getDataType()) {
                        case INTEGER: {
                            values.put(parameterName, data.retrieveInteger(session, parameterName));
                            break;
                        }
                        case FLOAT: {
                            values.put(parameterName, data.retrieveFloat(session, parameterName));
                            break;
                        }
                        case STRING: {
                            values.put(parameterName, data.retrieveString(session, parameterName));
                            break;
                        }
                        case DATE: {
                            values.put(parameterName, data.retrieveDate(session, parameterName));
                            break;
                        }
                        case BOOLEAN: {
                            values.put(parameterName, data.retrieveBoolean(session, parameterName));
                            break;
                        }
                        case URI: {
                            values.put(parameterName, data.retrieveURI(session, parameterName));
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("unhandled data type: " + (Object)((Object)ref.getDataType())));
                        }
                    }
                }
                catch (NoSuchParameterException noSuchParameterException) {
                    String msg = "The referenced parameter '%s' is missing from the provided data container!";
                    msg = String.format(msg, parameterName);
                    logger.info(msg);
                    values.put(parameterName, null);
                }
                catch (InvalidDataTypeException ex) {
                    String msg = "The referenced parameter '%s' has a different data type (%s) than the value in the provided data container!";
                    msg = String.format(msg, new Object[]{parameterName, ref.getDataType()});
                    throw new IllegalStateException(msg, ex);
                }
            }
            ++n2;
        }
        return SystemDataTools.format(formatterClass, parameterisedString, values);
    }

    private static class ResolverInvocationHandler
    implements InvocationHandler {
        private final InputDataContainer data;
        private final SessionToken session;
        private final Object object;
        private final ModelViewerProvider modelViewerProvider;

        public ResolverInvocationHandler(Object object, InputDataContainer data, SessionToken session, ModelViewerProvider modelViewerProvider) {
            ArgChecks.checkForNull(data, "data");
            ArgChecks.checkForNull(session, "session");
            ArgChecks.checkForNull(object, "object");
            ArgChecks.checkForNull(modelViewerProvider, "modelViewerProvider");
            this.session = session;
            this.object = object;
            this.data = data;
            this.modelViewerProvider = modelViewerProvider;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            try {
                SystemDataConsumer consumer = method.getAnnotation(SystemDataConsumer.class);
                if (consumer != null) {
                    if (method.getReturnType() == String.class) {
                        Class<? extends SystemDataFormatter> formatterClass = consumer.formatter();
                        String parameterisedString = (String)method.invoke(this.object, args);
                        return ParameterRefResolver.getFormattedReplacedString(this.session, this.data, formatterClass, parameterisedString);
                    }
                    if (PluginData.class.isAssignableFrom(method.getReturnType())) {
                        PluginData pluginData = (PluginData)method.invoke(this.object, args);
                        if (pluginData == null) {
                            return null;
                        }
                        return this.resolvePluginData(pluginData);
                    }
                    if (Map.class.isAssignableFrom(method.getReturnType())) {
                        Map pluginDatas = (Map)method.invoke(this.object, args);
                        HashMap<String, PluginData> newPluginDatas = new HashMap<String, PluginData>(pluginDatas.size());
                        for (Map.Entry entry : pluginDatas.entrySet()) {
                            newPluginDatas.put((String)entry.getKey(), this.resolvePluginData((PluginData)entry.getValue()));
                        }
                        return newPluginDatas;
                    }
                    String msg = "The return type of the system data consumer '%s' is nota String / plug-in data map, as it must be! Ignoring consumer.";
                    msg = String.format(msg, method);
                    LoggerTools.getLogger(ParameterRefResolver.class).info(msg);
                }
                return method.invoke(this.object, args);
            }
            catch (IllegalAccessException ex) {
                String msg = "The system data consuming method '%s' of the wrapped object could not be accessed!";
                msg = String.format(msg, method);
                throw new IllegalStateException(msg, ex);
            }
            catch (InvocationTargetException ex) {
                String msg = "The system data consuming method '%s' of the wrapped object raised an exception!";
                msg = String.format(msg, method);
                throw new IllegalStateException(msg, ex);
            }
        }

        private PluginData resolvePluginData(PluginData pluginData) {
            Map<String, String> attributes = pluginData.getPluginData();
            Class<?> viewerClass = this.modelViewerProvider.getModelViewerClass(pluginData.getPluginID());
            if (viewerClass != null) {
                attributes = new HashMap<String, String>(new ParameterResolvingMap(this.session, this.data, viewerClass, attributes));
            } else {
                attributes = new HashMap<String, String>(attributes);
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    String value = entry.getValue();
                    value = ParameterRefResolver.getFormattedReplacedString(this.session, this.data, BasicSystemDataFormatter.class, value);
                    entry.setValue(value);
                }
            }
            return new DefaultPluginData(pluginData.getPluginID(), attributes);
        }
    }
}

