/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.ParameterRefResolver;
import de.aristaflow.adept2.model.common.systemdata.BasicSystemDataFormatter;
import de.aristaflow.adept2.model.common.systemdata.SystemDataConsumer;
import de.aristaflow.adept2.model.common.viewer.ModelViewerTools;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ParameterResolvingMap
implements Map<String, String> {
    private final SessionToken session;
    private final InputDataContainer data;
    private final Map<String, String> attributes;
    private final Class<?> viewerClass;

    public ParameterResolvingMap(SessionToken session, InputDataContainer data, Class<?> viewerClass, Map<String, String> attributes) {
        this.session = session;
        this.data = data;
        this.viewerClass = viewerClass;
        this.attributes = attributes;
    }

    @Override
    public String get(Object key) {
        String value = this.attributes.get(key);
        if (value != null) {
            Class<?> attributeViewerClass = ParameterResolvingMap.getModelViewerForAttribute(this.viewerClass, this, (String)key);
            ModelViewerTools mvt = new ModelViewerTools(attributeViewerClass, this.attributes);
            String keyS = (String)key;
            int dotIndex = keyS.indexOf(46);
            String attributeKey = dotIndex != -1 ? keyS.substring(dotIndex + 1) : keyS;
            SystemDataConsumer consumer = mvt.getSystemDataConsumerAttributes().get(attributeKey);
            Class formatter = consumer != null ? consumer.formatter() : BasicSystemDataFormatter.class;
            value = ParameterRefResolver.getFormattedReplacedString(this.session, this.data, formatter, value);
        }
        return value;
    }

    private static Class<?> getModelViewerForAttribute(Class<?> viewerClass, Map<String, String> attributes, String attribute) {
        if (attribute.indexOf(46) == -1) {
            return viewerClass;
        }
        String[] attributePath = attribute.split("\\.");
        Class<?> lastComplexViewer = viewerClass;
        int i = 0;
        while (i < attributePath.length) {
            Class<?> returnType;
            ModelViewerTools mvt = new ModelViewerTools(lastComplexViewer, attributes);
            String currentAttribute = attributePath[i];
            if (currentAttribute.endsWith("]")) {
                currentAttribute = currentAttribute.substring(0, currentAttribute.indexOf(91));
            }
            if (mvt.getComplexMethods().containsKey(currentAttribute)) {
                Method method = mvt.getComplexMethods().get(currentAttribute);
                returnType = method.getReturnType();
                if (returnType.isArray()) {
                    returnType = returnType.getComponentType();
                }
            } else {
                return lastComplexViewer;
            }
            lastComplexViewer = returnType;
            ++i;
        }
        throw new AssertionError((Object)"Unreachable");
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.attributes.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<ResolvingEntry> entrySet = new HashSet<ResolvingEntry>();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            entrySet.add(new ResolvingEntry(entry.getKey()));
        }
        return Collections.unmodifiableSet(entrySet);
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.attributes.keySet();
    }

    @Override
    public String put(String key, String value) {
        String oldValue = this.get(key);
        this.attributes.put(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> t) {
        this.attributes.putAll(t);
    }

    @Override
    public String remove(Object key) {
        return this.attributes.remove(key);
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> c = new ArrayList<String>(this.attributes.size());
        for (String key : this.attributes.values()) {
            c.add(this.get(key));
        }
        return c;
    }

    private final class ResolvingEntry
    implements Map.Entry<String, String> {
        private final String key;

        ResolvingEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return ParameterResolvingMap.this.get(this.key);
        }

        @Override
        public String setValue(String value) {
            throw new AssertionError((Object)"setValue called");
        }
    }
}

