/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.ParameterRefResolver;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.components.ADEPT2DefaultComponentFactory;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.utils.WrongAgentException;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ModelViewerProvider;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginDataContainer;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.DecisionActivityInstance;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.execution.LightWeightProcessInstance;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.execution.WrongExecutionManagerException;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.util.LockException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ActivityExecutionTools {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutableBusinessProcessInstance getEBPInstance(Node node, ExecutionFactory executionFactory, ParameterDataContext dataContext, String processInstanceName, UUID instanceLogID, String processTemplateName, PluginData translationData, boolean viewOnly) {
        void var11_18;
        ExecutableBusinessProcess nodeEBP = node.getExecutableBusinessProcess();
        String name = node.getName();
        if (name == null || name.length() == 0) {
            name = "Node #" + node.getID();
        }
        DefaultPluginDataContainer pluginData = new DefaultPluginDataContainer(node);
        if (translationData != null) {
            pluginData.addSupportedPlugin("ProcessLocalisation", "ProcessLocalisation", translationData);
        }
        if (nodeEBP instanceof Activity) {
            Activity activity = (Activity)nodeEBP;
            ExecutionControlProperties ecp = viewOnly ? new ExecutionControlProperties(false, false, true) : activity.getExecutionControlProperties();
            ActivityInstance activityInstance = executionFactory.createActivityInstance(activity.getID(), processTemplateName, processInstanceName, instanceLogID, activity.getExecutableComponentName(), activity.getOperationName(), activity.getConfigurationName(), activity.getActivityName(), name, node.getDescription(), activity.getImplementationClass(), activity.getSeparatedClassPaths(), activity.isSingleton(), activity.getSystemComponent(), activity.getGUIContextID(), ecp, activity.supportsViewOnly(), activity.getIconID(), activity.getAttributeOrigins(), activity.getConfiguration(), activity.getParameters(ActivityConstants.AccessType.READ), activity.getParameters(ActivityConstants.AccessType.WRITE), dataContext, pluginData, activity.getUserAttributes());
            if (!(activity instanceof DecisionActivity)) return var11_18;
            DecisionActivity da = (DecisionActivity)activity;
            ProcessModelParameter decisionParameter = da.getDecisionParameter();
            ArrayList<DecisionStatement> decisionStatements = new ArrayList<DecisionStatement>(da.getAllDecisionStatements().size());
            decisionStatements.addAll(da.getAllDecisionStatements());
            DecisionActivityInstance decisionActivityInstance = executionFactory.createDecisionActivityInstance(activityInstance, decisionParameter, decisionStatements);
            return var11_18;
        } else {
            boolean embedded;
            boolean fork;
            UUID templateID;
            if (!(nodeEBP instanceof LightWeightProcess) && !(nodeEBP instanceof VariableParallelismEBP)) throw new IllegalArgumentException("The sub type of the given EBP is unknown!");
            if (nodeEBP instanceof ReferencedProcess) {
                templateID = ((ReferencedProcess)nodeEBP).getTemplateID();
                fork = ((ReferencedProcess)nodeEBP).fork();
                embedded = false;
            } else if (nodeEBP instanceof EmbeddedProcess) {
                templateID = ((EmbeddedProcess)nodeEBP).getTemplateID();
                fork = false;
                embedded = true;
            } else {
                if (!(nodeEBP instanceof VariableParallelismEBP)) throw new IllegalArgumentException("The sub type of the given EBP is unknown!");
                LightWeightProcess lwp = ((VariableParallelismEBP)nodeEBP).getLightWeightProcess();
                if (lwp instanceof ReferencedProcess) {
                    templateID = ((ReferencedProcess)lwp).getTemplateID();
                    fork = ((ReferencedProcess)lwp).fork();
                    embedded = false;
                } else {
                    if (!(lwp instanceof EmbeddedProcess)) throw new IllegalArgumentException("The sub type of the given EBP is unknown!");
                    templateID = ((EmbeddedProcess)lwp).getTemplateID();
                    fork = false;
                    embedded = true;
                }
            }
            LightWeightProcessInstance lightWeightProcessInstance = executionFactory.createLightWeightProcessInstance(templateID, processTemplateName, processInstanceName, instanceLogID, name, node.getDescription(), null, nodeEBP.getExecutionControlProperties(), nodeEBP.getConfiguration(), nodeEBP.getParameters(ActivityConstants.AccessType.READ), nodeEBP.getParameters(ActivityConstants.AccessType.WRITE), dataContext, pluginData, nodeEBP.getUserAttributes(), fork, embedded);
        }
        return var11_18;
    }

    public static void checkIsInstanceRunning(InstanceStatus instanceStatus, String method, int nodeID, UUID instanceID, Logger logger) throws InvalidInstanceStateException {
        String msg = "%s node '%s' requires the instance %s to be running, but it is in%s state %s.";
        ProcessConstants.InstanceMigrationStatus instanceMigrationStatus = instanceStatus.getMigrationStatus();
        switch (instanceMigrationStatus) {
            case IM_MIGRATING: {
                msg = String.format(msg, method, nodeID, instanceID, "", instanceMigrationStatus.name());
                logger.log(Level.WARNING, msg);
                throw new InvalidInstanceStateException(instanceID, instanceMigrationStatus, msg);
            }
            case IM_MIGRATABLE: 
            case IM_NOT_MIGRATABLE: {
                break;
            }
            default: {
                logger.log(Level.WARNING, String.format(msg, method, nodeID, instanceID, " unknown", instanceMigrationStatus.name()));
                assert (false);
                break;
            }
        }
        ProcessConstants.InstanceExecutionStatus instanceExecutionStatus = instanceStatus.getExecutionStatus();
        switch (instanceExecutionStatus) {
            case IE_RUNNING: {
                break;
            }
            case IE_SUSPENDED: 
            case IE_SOFTLY_SUSPENDED: 
            case IE_ABORTED: 
            case IE_SOFTLY_ABORTED: 
            case IE_FINISHED: {
                msg = String.format(msg, method, nodeID, instanceID, "", instanceExecutionStatus.name());
                logger.log(Level.WARNING, msg);
                throw new InvalidInstanceStateException(instanceID, instanceExecutionStatus, msg);
            }
            default: {
                logger.log(Level.WARNING, String.format(msg, method, nodeID, instanceID, " unknown", instanceExecutionStatus.name()));
                assert (false);
                break;
            }
        }
    }

    public static void checkEBPInstanceReference(EBPInstanceReference ebpInstanceReference, URI[] executionManagerURIs, Instance instance) {
        if (!ActivityExecutionTools.oneCommonElement(ebpInstanceReference.getExecutionManagerURIs(), executionManagerURIs)) {
            throw new WrongExecutionManagerException(ebpInstanceReference.getExecutionManagerURIs(), executionManagerURIs);
        }
        if (!ebpInstanceReference.getInstanceID().equals(instance.getID())) {
            String msg = String.format("The designated EBPInstanceReference '%s' does not match the designated instance-ID '%s'.", ebpInstanceReference, instance.getID());
            throw new IllegalArgumentException(msg);
        }
        int nodeID = ebpInstanceReference.getNodeID();
        Node node = instance.getTemplate().getNode(nodeID);
        if (node == null) {
            String msg = String.format("The designated EBPInstanceReference '%s' does not reference a node in the instance-ID '%s'. The instance does not have a node with ID %s.", ebpInstanceReference, instance.getID(), nodeID);
            throw new IllegalArgumentException(msg);
        }
        ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
        if (ebp != null && ebpInstanceReference.getType() != ebp.getType()) {
            String msg = String.format("The designated EBPInstanceReference '%s' does not reference a node in the instance-ID '%s'. The EBP type '%s' of node %s does not match the EBP type ID '%s' in the instance.", new Object[]{ebpInstanceReference, instance.getID(), ebpInstanceReference.getType(), nodeID, ebp.getType()});
            throw new IllegalArgumentException(msg);
        }
    }

    private static boolean oneCommonElement(Object[] array1, Object[] array2) {
        Object[] objectArray = array1;
        int n = array1.length;
        int n2 = 0;
        while (n2 < n) {
            Object object1 = objectArray[n2];
            Object[] objectArray2 = array2;
            int n3 = array2.length;
            int n4 = 0;
            while (n4 < n3) {
                Object object2 = objectArray2[n4];
                if (object1 != null && object1.equals(object2)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static void checkActivityForActivation(ExecutableInstance instance, EBPInstanceReference activity, Logger logger) throws InvalidActivityStateException {
        int nodeID = activity.getNodeID();
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
            String msg = String.format("Cannot activate activity with ID = '%s' of instance with ID = '%s', because the activity is currently in iteration %s but not in %s!", nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
            throw new InvalidActivityStateException(msg);
        }
        if (nodeState != ProcessConstants.NodeState.NS_ACTIVATED) {
            String msg = String.format("The activity '%1$s' of instance '%2$s' should be in state ACTIVATED as this is the signalled state. But it is in state %3$s.", activity.getNodeID(), instance.getID(), nodeState.name());
            logger.info(msg);
            throw new InvalidActivityStateException(msg, nodeState);
        }
    }

    public static void checkActivityForStarting(ExecutableInstance instance, EBPInstanceReference activity, QualifiedAgent agent, Logger logger) throws InvalidActivityStateException {
        int nodeID = activity.getNodeID();
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
            String msg = String.format("Cannot start activity with ID = '%s' of instance with ID = '%s', because the activity is currently in iteration %s but not in %s!", nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
            throw new InvalidActivityStateException(msg);
        }
        switch (nodeState) {
            case NS_ACTIVATED: {
                break;
            }
            case NS_SELECTED: {
                if (agent.equals(instance.getPerformingAgent(nodeID))) break;
                WrongAgentException e = new WrongAgentException(instance.getPerformingAgent(nodeID), agent);
                String msg = String.format("Cannot start activity with ID = '%s' of instance with ID = '%s', because the caller (agentID = '%s', orgPositionID = '%s') does not match the agent (agentID = '%s', orgPositionID = '%s') expected!", activity.getNodeID(), activity.getInstanceID(), e.callerAgent.getAgentID(), e.callerAgent.getOrgPositionID(), e.expectedAgent.getAgentID(), e.expectedAgent.getOrgPositionID());
                logger.log(Level.WARNING, msg, e);
                throw new IllegalArgumentException(msg, e);
            }
            case NS_NOT_ACTIVATED: 
            case NS_RUNNING: 
            case NS_SUSPENDED: 
            case NS_ENQUIRED: 
            case NS_COMPLETED: 
            case NS_FAILED: 
            case NS_SKIPPED: {
                String msg = String.format("Cannot start activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in state '%s' but must be in state NS_ACTIVATED or NS_SELECTED!", activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.info(msg);
                throw new InvalidActivityStateException(msg, nodeState);
            }
            default: {
                String msg = String.format("Cannot start activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in the unknown state '%s' but must be in state NS_ACTIVATED or NS_SELECTED!", activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.log(Level.SEVERE, msg);
                assert (false);
                break;
            }
        }
    }

    public static void checkActivityForResumingOrEnquiring(ExecutableInstance instance, EBPInstanceReference activity, QualifiedAgent agent, Logger logger, boolean enquire) throws InvalidActivityStateException {
        String method;
        int nodeID = activity.getNodeID();
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        String string = method = enquire ? "enquire activity" : "resume activity";
        if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
            String msg = String.format("Cannot %s activity with ID = '%s' of instance with ID = '%s', because the activity is currently in iteration %s but not in %s!", method, nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
            throw new InvalidActivityStateException(msg);
        }
        switch (nodeState) {
            case NS_SUSPENDED: {
                break;
            }
            case NS_NOT_ACTIVATED: 
            case NS_ACTIVATED: 
            case NS_SELECTED: 
            case NS_RUNNING: 
            case NS_ENQUIRED: 
            case NS_COMPLETED: 
            case NS_FAILED: 
            case NS_SKIPPED: {
                String msg = String.format("Cannot %s with ID = '%s' of instance with ID = '%s', because the corresponding node is in state '%s' but must be in state NS_SUSPENDED!", method, activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.info(msg);
                throw new InvalidActivityStateException(msg, nodeState);
            }
            default: {
                String msg = String.format("Cannot %s with ID = '%s' of instance with ID = '%s', because the corresponding node is in the unknown state '%s' but must be in state NS_SUSPENDED!", method, activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.severe(msg);
                assert (false);
                break;
            }
        }
    }

    public static void checkActivityForReplyingEnquiry(ExecutableInstance instance, EBPInstanceReference activity, QualifiedAgent agent, Logger logger) throws InvalidActivityStateException {
        int nodeID = activity.getNodeID();
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        List<Enquiry> currentEnquiries = instance.getCurrentEnquiries(activity.getNodeID());
        int size = currentEnquiries.size();
        switch (nodeState) {
            case NS_SUSPENDED: {
                if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
                    String msg = String.format("Cannot reply enquiry for activity with ID = '%s' of instance with ID = '%s', because the activity is currently in iteration %s but not in %s!", nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
                    throw new InvalidActivityStateException(msg);
                }
                if (size <= 0) {
                    String msg = String.format("Cannot reply enquiry with ID = '%s' of instance with ID = '%s', because the corresponding node must be in enquiry mode!", activity.getNodeID(), activity.getInstanceID());
                    logger.info(msg);
                    throw new InvalidActivityStateException(msg, nodeState);
                }
                if (currentEnquiries.get(size - 1).getRecipients().contains(agent)) break;
                String msg = String.format("Cannot reply enquiry with ID = '%s' of instance with ID = '%s', because the actual agent is none of the enquiry recipients!", activity.getNodeID(), activity.getInstanceID());
                logger.info(msg);
                throw new InvalidActivityStateException(msg, nodeState);
            }
            case NS_ENQUIRED: {
                if (size > 0 && !currentEnquiries.get(size - 1).getRecipients().contains(agent)) {
                    String msg = String.format("Cannot reply enquiry with ID = '%s' of instance with ID = '%s', because the actual agent is none of the enquiry recipients!", activity.getNodeID(), activity.getInstanceID());
                    logger.info(msg);
                    throw new InvalidActivityStateException(msg, nodeState);
                }
                if (size > 0) break;
                Enquiry repliedEnquiry = instance.getRepliedEnquiry(activity.getNodeID());
                if (repliedEnquiry != null && !repliedEnquiry.getOriginator().equals(agent)) {
                    String msg = String.format("Cannot reply enquiry with ID = '%s' of instance with ID = '%s', because the actual agent is not the originator of the enquiry!", activity.getNodeID(), activity.getInstanceID());
                    logger.info(msg);
                    throw new InvalidActivityStateException(msg, nodeState);
                }
                if (repliedEnquiry != null) break;
                String msg = String.format("Cannot reply enquiry with ID = '%s' of instance with ID = '%s', because the corresponding node has no enquiries!", activity.getNodeID(), activity.getInstanceID());
                logger.info(msg);
                throw new InvalidActivityStateException(msg, nodeState);
            }
            case NS_NOT_ACTIVATED: 
            case NS_ACTIVATED: 
            case NS_SELECTED: 
            case NS_RUNNING: 
            case NS_COMPLETED: 
            case NS_FAILED: 
            case NS_SKIPPED: {
                String msg = String.format("Cannot reply enquiry with ID = '%s' of instance with ID = '%s', because the corresponding node is in state '%s' but must be in state NS_SUSPENDED!", activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.info(msg);
                throw new InvalidActivityStateException(msg, nodeState);
            }
            default: {
                String msg = String.format("Cannot reply enquiry with ID = '%s' of instance with ID = '%s', because the corresponding node is in the unknown state '%s' but must be in state NS_SUSPENDED!", activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.severe(msg);
                assert (false);
                break;
            }
        }
    }

    public static void checkActivityForSelection(ExecutableInstance instance, EBPInstanceReference activity, QualifiedAgent agent, Logger logger) throws InvalidActivityStateException {
        int nodeID = activity.getNodeID();
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
            String msg = String.format("Cannot select activity with ID = '%s' of instance with ID = '%s', because the activity is currently in iteration %s but not in %s!", nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
            throw new InvalidActivityStateException(msg);
        }
        switch (nodeState) {
            case NS_ACTIVATED: {
                break;
            }
            case NS_NOT_ACTIVATED: 
            case NS_SELECTED: 
            case NS_RUNNING: 
            case NS_SUSPENDED: 
            case NS_ENQUIRED: 
            case NS_COMPLETED: 
            case NS_FAILED: 
            case NS_SKIPPED: {
                String msg = String.format("Cannot select activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in state '%s' but must be in state NS_ACTIVATED!", activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.info(msg);
                throw new InvalidActivityStateException(msg, nodeState);
            }
            default: {
                String msg = String.format("Cannot select activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in the unknown state '%s' but must be in state NS_ACTIVATED!", activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.severe(msg);
                assert (false);
                break;
            }
        }
    }

    public static void checkActivityForDeselection(ExecutableInstance instance, EBPInstanceReference activity, QualifiedAgent agent, Logger logger) throws InvalidActivityStateException {
        String msg;
        int nodeID = activity.getNodeID();
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
            String msg2 = String.format("Cannot deselect activity with ID = '%s' of instance with ID = '%s', because the activity is currently in iteration %s but not in %s!", nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
            throw new InvalidActivityStateException(msg2);
        }
        switch (nodeState) {
            case NS_SELECTED: {
                break;
            }
            case NS_NOT_ACTIVATED: 
            case NS_ACTIVATED: 
            case NS_RUNNING: 
            case NS_SUSPENDED: 
            case NS_ENQUIRED: 
            case NS_COMPLETED: 
            case NS_FAILED: 
            case NS_SKIPPED: {
                String msg3 = String.format("Cannot deselect activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in state '%s' but must be in state NS_SELECTED!", activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.info(msg3);
                throw new InvalidActivityStateException(msg3, nodeState);
            }
            default: {
                msg = String.format("Cannot deselect activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in the unknown state '%s' but must be in state NS_SELECTED!", activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.severe(msg);
                assert (false);
                break;
            }
        }
        if (!agent.equals(instance.getPerformingAgent(nodeID)) && agent.getAgentID() != -1L && agent.getOrgPositionID() != -1L && agent.getAgentID() != -2L && agent.getOrgPositionID() != -2L) {
            WrongAgentException e = new WrongAgentException(instance.getPerformingAgent(nodeID), agent);
            msg = "Cannot deselect activity with ID = '%s' of instance with ID = '%s', because the caller (agentID = '%s', orgPositionID = '%s') does not match the agent (agentID = '%s', orgPositionID = '%s') expected!";
            msg = String.format(msg, activity.getNodeID(), activity.getInstanceID(), e.callerAgent.getAgentID(), e.callerAgent.getOrgPositionID(), e.expectedAgent.getAgentID(), e.expectedAgent.getOrgPositionID());
            logger.log(Level.INFO, msg, e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static void checkActivityForFinishing(ExecutableInstance instance, EBPInstanceReference activity, Logger logger) throws InvalidActivityStateException {
        int nodeID = activity.getNodeID();
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
            String msg = String.format("Cannot finish activity with ID = '%s' of instance with ID = '%s', because the activity is currently in iteration %s but not in %s!", nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
            throw new InvalidActivityStateException(msg);
        }
        switch (nodeState) {
            case NS_RUNNING: {
                break;
            }
            case NS_NOT_ACTIVATED: 
            case NS_ACTIVATED: 
            case NS_SELECTED: 
            case NS_SUSPENDED: 
            case NS_ENQUIRED: 
            case NS_COMPLETED: 
            case NS_FAILED: 
            case NS_SKIPPED: {
                String msg = String.format("Cannot finish the activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in state '%s' but must be in state NS_RUNNING!", nodeID, activity.getInstanceID(), nodeState.name());
                logger.info(msg);
                throw new InvalidActivityStateException(msg, nodeState);
            }
            default: {
                String msg = String.format("Cannot finish the activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in the unknown state '%s' but must be in state NS_RUNNING!", nodeID, activity.getInstanceID(), nodeState.name());
                logger.severe(msg);
                assert (false);
                break;
            }
        }
    }

    public static void checkActivityForFailing(ExecutableInstance instance, EBPInstanceReference activity, Logger logger) throws InvalidActivityStateException {
        int nodeID = activity.getNodeID();
        if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
            String msg = String.format("Cannot fail activity with ID = '%s' of instance with ID = '%s', because the activity is currently in iteration %s but not in %s!", nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
            throw new InvalidActivityStateException(msg);
        }
    }

    public static void checkActivityForSoftReset(ExecutableInstance instance, EBPInstanceReference activity, QualifiedAgent agent, Logger logger) throws InvalidActivityStateException {
        int nodeID = activity.getNodeID();
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
            String msg = String.format("Cannot soft reset activity with ID = '%s' of instance with ID = '%s', because the activity is currently in iteration %s but not in %s!", nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
            throw new InvalidActivityStateException(msg);
        }
        switch (nodeState) {
            case NS_RUNNING: {
                break;
            }
            case NS_NOT_ACTIVATED: 
            case NS_ACTIVATED: 
            case NS_SELECTED: 
            case NS_SUSPENDED: 
            case NS_ENQUIRED: 
            case NS_COMPLETED: 
            case NS_FAILED: 
            case NS_SKIPPED: {
                String msg = String.format("Cannot soft reset the activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in state '%s' but must be in state NS_RUNNING!", nodeID, activity.getInstanceID(), nodeState.name());
                logger.info(msg);
                throw new InvalidActivityStateException(msg, nodeState);
            }
            default: {
                String msg = String.format("Cannot soft reset the activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in the unknown state '%s' but must be in state NS_RUNNING!", nodeID, activity.getInstanceID(), nodeState.name());
                logger.severe(msg);
                assert (false);
                break;
            }
        }
    }

    public static void checkActivityForSuspension(Instance instance, EBPInstanceReference activity, Logger logger, boolean checkEBP) throws InvalidActivityStateException, IllegalArgumentException {
        ExecutableBusinessProcess ebp;
        int nodeID = activity.getNodeID();
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        if (checkEBP && (ebp = instance.getTemplate().getNode(nodeID).getExecutableBusinessProcess()) != null && !ebp.getExecutionControlProperties().isSuspensible()) {
            String msg = String.format("Cannot suspend activity with ID = '%s' of instance with ID = '%s', because this activity is not suspensible!", activity.getNodeID(), activity.getInstanceID());
            logger.info(msg);
            throw new InvalidActivityStateException(msg, nodeState);
        }
        if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
            String msg = String.format("Cannot suspend activity with ID = '%s' of instance with ID = '%s', because the activity is currently in iteration %s but not in %s!", nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
            throw new InvalidActivityStateException(msg);
        }
        switch (nodeState) {
            case NS_RUNNING: {
                break;
            }
            case NS_NOT_ACTIVATED: 
            case NS_ACTIVATED: 
            case NS_SELECTED: 
            case NS_SUSPENDED: 
            case NS_ENQUIRED: 
            case NS_COMPLETED: 
            case NS_FAILED: 
            case NS_SKIPPED: {
                String msg = String.format("Cannot suspend activity with ID = '%s' of instance with ID = '%s', because this activity is not in state NS_RUNNING!", nodeID, activity.getInstanceID());
                logger.info(msg);
                throw new InvalidActivityStateException(msg, nodeState);
            }
            default: {
                String msg = String.format("Cannot suspend activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in the unknown state '%s'!", nodeID, activity.getInstanceID(), nodeState.name());
                logger.log(Level.SEVERE, msg);
                assert (false);
                break;
            }
        }
    }

    public static void checkActivityForRetrievingContext(ExecutableInstance instance, EBPInstanceReference activity, QualifiedAgent agent, Logger logger) throws InvalidActivityStateException {
        int nodeID = activity.getNodeID();
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        QualifiedAgent perfAgent = instance.getPerformingAgent(nodeID);
        if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
            String msg = "Cannot retrieve the execution context of activity at node '%s' of instance '%s', because the activity is currently in iteration %s but not in %s!";
            msg = String.format(msg, nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
            throw new InvalidActivityStateException(msg);
        }
        switch (nodeState) {
            case NS_SELECTED: 
            case NS_RUNNING: 
            case NS_SUSPENDED: {
                if (agent.equals(perfAgent)) break;
                String msg = "Cannot retrieve the execution context of activity at node '%s' of instance '%s', because the activity is currently not assigned to the requesting agent '%s'.";
                msg = String.format(msg, activity.getNodeID(), activity.getInstanceID(), perfAgent);
                throw new InvalidActivityStateException(msg);
            }
            case NS_NOT_ACTIVATED: 
            case NS_ACTIVATED: 
            case NS_ENQUIRED: 
            case NS_COMPLETED: 
            case NS_FAILED: 
            case NS_SKIPPED: {
                String msg = "Cannot retrieve the execution context of activity at node '%s' of instance '%s', because the activity is currently in state %s but must be in state NS_SELECTED, NS_RUNNING or NS_SUSPENDED.";
                msg = String.format(msg, activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.info(msg);
                throw new InvalidActivityStateException(msg, nodeState);
            }
            default: {
                String msg = "Cannot retrieve the execution context of activity at node '%s' of instance '%s', because the corresponding done is in the unknown state %s but must be in state NS_SELECTED, NS_RUNNING or NS_SUSPENDED.";
                msg = String.format(msg, activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.severe(msg);
                assert (false);
                break;
            }
        }
    }

    public static void checkActivityForAbortion(Instance instance, EBPInstanceReference activity, Logger logger) throws InvalidActivityStateException {
        int nodeID = activity.getNodeID();
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
            String msg = String.format("Cannot abort activity with ID = '%s' of instance with ID = '%s', because the activity is currently in iteration %s but not in %s!", nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
            throw new InvalidActivityStateException(msg);
        }
        switch (nodeState) {
            case NS_NOT_ACTIVATED: 
            case NS_ACTIVATED: 
            case NS_SELECTED: 
            case NS_RUNNING: 
            case NS_SUSPENDED: {
                break;
            }
            case NS_ENQUIRED: 
            case NS_COMPLETED: 
            case NS_FAILED: 
            case NS_SKIPPED: {
                String msg = String.format("Cannot abort activity with ID = '%s' of instance with ID = '%s', because this activity is already terminated!", activity.getNodeID(), activity.getInstanceID());
                logger.info(msg);
                throw new InvalidActivityStateException(msg, nodeState);
            }
            default: {
                String msg = String.format("Cannot abort activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in the unknown state '%s'!", activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.log(Level.SEVERE, msg);
                assert (false);
                break;
            }
        }
    }

    public static void checkActivityForHardReset(Instance instance, EBPInstanceReference activity, Logger logger, boolean checkEBP) throws InvalidActivityStateException {
        ExecutableBusinessProcess ebp;
        int nodeID = activity.getNodeID();
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        if (checkEBP && (ebp = instance.getTemplate().getNode(nodeID).getExecutableBusinessProcess()) != null && !ebp.getExecutionControlProperties().isResettable()) {
            String msg = String.format("Cannot hard reset activity with ID = '%s' of instance with ID = '%s', because this activity is not resettable!", activity.getNodeID(), activity.getInstanceID());
            logger.info(msg);
            throw new InvalidActivityStateException(msg, nodeState);
        }
        if (activity.getNodeIteration() != instance.getNodeIteration(nodeID)) {
            String msg = String.format("Cannot hard reset activity with ID = '%s' of instance with ID = '%s', because the activity is currently in iteration %s but not in %s!", nodeID, activity.getInstanceID(), instance.getNodeIteration(nodeID), activity.getNodeIteration());
            throw new InvalidActivityStateException(msg);
        }
        switch (nodeState) {
            case NS_RUNNING: 
            case NS_SUSPENDED: 
            case NS_FAILED: {
                break;
            }
            case NS_NOT_ACTIVATED: 
            case NS_ACTIVATED: 
            case NS_SELECTED: 
            case NS_ENQUIRED: 
            case NS_COMPLETED: 
            case NS_SKIPPED: {
                String msg = String.format("Cannot reset activity with ID = '%s' of instance with ID = '%s', because this activity is in state '%s'!", activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.info(msg);
                throw new InvalidActivityStateException(msg, nodeState);
            }
            default: {
                String msg = String.format("Cannot reset activity with ID = '%s' of instance with ID = '%s', because the corresponding node is in the unknown state '%s'!", activity.getNodeID(), activity.getInstanceID(), nodeState.name());
                logger.log(Level.SEVERE, msg);
                assert (false);
                break;
            }
        }
    }

    public static InternalServiceException wrapLockException(LockException cause, String method, int nodeID, UUID instanceID) {
        String msg = String.format("Cannot '%s' with ID = '%s' of instance with  ID = '%s', because cannot get a lock for the instance!", method, nodeID, instanceID);
        return new InternalServiceException(msg, cause);
    }

    public static void fireActivityStateChanged(UpdateManager updateManager, EBPInstanceReference activity, ExecutableInstance instance, ProcessConstants.NodeState newNodeState, Logger logger) {
        Template template = instance.getTemplate();
        int nodeID = activity.getNodeID();
        Node node = template.getNode(nodeID);
        updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_STATE);
        updateManager.firePropertyChange(activity, "ActivityState", (Object)newNodeState);
        switch (newNodeState) {
            case NS_ACTIVATED: 
            case NS_SELECTED: 
            case NS_RUNNING: 
            case NS_SUSPENDED: {
                break;
            }
            case NS_NOT_ACTIVATED: 
            case NS_ENQUIRED: 
            case NS_COMPLETED: 
            case NS_FAILED: 
            case NS_SKIPPED: {
                int[] writtenDataElements;
                int succ;
                int[] nArray = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    succ = nArray[n2];
                    updateManager.firePropertyChange(template.getEdge(nodeID, succ, ProcessConstants.EdgeType.ET_CONTROL), (Object)UpdateManager.EdgeProperties.EDGE_STATE);
                    ++n2;
                }
                nArray = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_SYNC);
                n = nArray.length;
                n2 = 0;
                while (n2 < n) {
                    succ = nArray[n2];
                    updateManager.firePropertyChange(template.getEdge(nodeID, succ, ProcessConstants.EdgeType.ET_SYNC), (Object)UpdateManager.EdgeProperties.EDGE_STATE);
                    ++n2;
                }
                int[] nArray2 = writtenDataElements = template.getAccessedDataElementIDsForNode(nodeID, ActivityConstants.AccessType.WRITE);
                int n3 = writtenDataElements.length;
                n = 0;
                while (n < n3) {
                    int dataElementID = nArray2[n];
                    updateManager.firePropertyChange(template.getDataElement(dataElementID), (Object)UpdateManager.DataElementProperties.DE_NAME);
                    ++n;
                }
                break;
            }
            default: {
                String errorMsg = String.format("The new node state '%s' of node '%s' belonging to instance '%s' is unknown to the 'fireActivityStateChanged'-method!", newNodeState.name(), activity.getNodeID(), activity.getInstanceID());
                logger.log(Level.SEVERE, errorMsg);
                assert (false);
                break;
            }
        }
        updateManager.sendPropertyChanges();
    }

    public static ExecutableBusinessProcessInstance setUpEBPInstance(SessionToken session, EBPInstanceReference activityRef, Instance instance, ADEPT2DefaultComponentFactory adept2DefaultComponentFactory, ExecutionFactory executionFactory, ParameterDataContext dataContext, InputDataContainer nodeDataContainer, ModelViewerProvider pluginRegistry) {
        return ActivityExecutionTools.setUpEBPInstance(session, activityRef, instance, adept2DefaultComponentFactory, executionFactory, dataContext, nodeDataContainer, pluginRegistry, false);
    }

    public static ExecutableBusinessProcessInstance setUpEBPInstance(SessionToken session, EBPInstanceReference activityRef, Instance instance, ADEPT2DefaultComponentFactory adept2DefaultComponentFactory, ExecutionFactory executionFactory, ParameterDataContext dataContext, InputDataContainer nodeDataContainer, ModelViewerProvider pluginRegistry, boolean viewOnly) {
        String key;
        Template template = instance.getTemplate();
        Node node = template.getNode(activityRef.getNodeID());
        node = ParameterRefResolver.getProxy(node, Node.class, nodeDataContainer, session, pluginRegistry);
        ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
        HashMap<String, String> translationAttributes = new HashMap<String, String>();
        PluginData pluginData = template.getPluginData("ProcessLocalisation");
        if (pluginData != null) {
            for (Map.Entry<String, String> entry : pluginData.getPluginData().entrySet()) {
                key = entry.getKey();
                if (!key.contains("Name")) continue;
                key = key.replace("Name", "ProcessTemplateName");
                translationAttributes.put(key, entry.getValue());
            }
        }
        if ((pluginData = instance.getPluginData("ProcessLocalisation")) != null) {
            for (Map.Entry<String, String> entry : pluginData.getPluginData().entrySet()) {
                key = entry.getKey();
                if (!key.contains("Name")) continue;
                key = key.replace("Name", "ProcessInstanceName");
                translationAttributes.put(key, entry.getValue());
            }
        }
        if ((pluginData = node.getPluginData("ProcessLocalisation")) != null) {
            translationAttributes.putAll(pluginData.getPluginData());
        }
        DefaultPluginData translationData = translationAttributes.size() > 0 ? new DefaultPluginData("ProcessLocalisation", translationAttributes) : null;
        ExecutableBusinessProcessInstance ebpInstance = ebp == null ? (node.equals(template.getStartNode()) ? adept2DefaultComponentFactory.getStartActivityInstance(template, node, dataContext, instance.getName(), instance.getLogID()) : (node.equals(template.getEndNode()) ? adept2DefaultComponentFactory.getEndActivityInstance(template, node, dataContext, instance.getName(), instance.getLogID()) : adept2DefaultComponentFactory.getDummyActivityInstance(template, node, dataContext, instance.getName(), instance.getLogID(), translationData))) : ActivityExecutionTools.getEBPInstance(node, executionFactory, dataContext, instance.getName(), instance.getLogID(), template.getName(), translationData, viewOnly);
        return ebpInstance;
    }

    @Deprecated
    public static ParameterDataContext createPublicDataContext(SessionToken session, Instance instance, int nodeID, ExecutionFactory executionFactory, ProcessAwareAccess paa) {
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        UUID instanceID = instance.getID();
        HashMap<String, ProcessConstants.AdeptDataType> parameterTypes = new HashMap<String, ProcessConstants.AdeptDataType>();
        int nodeIteration = instance.getNodeIteration(nodeID);
        for (DataElement de : instance.getTemplate().getDataElements()) {
            Object value;
            String paramName = de.getName();
            if (!de.isPublic()) continue;
            parameterTypes.put(de.getName(), de.getDataType());
            if (paa.isNull(session, instanceID, nodeID, nodeIteration, de.getID())) continue;
            try {
                switch (de.getDataType()) {
                    case BOOLEAN: {
                        value = paa.retrieveBoolean(session, instanceID, nodeID, nodeIteration, de.getID());
                        break;
                    }
                    case INTEGER: {
                        value = paa.retrieveInteger(session, instanceID, nodeID, nodeIteration, de.getID());
                        break;
                    }
                    case FLOAT: {
                        value = paa.retrieveFloat(session, instanceID, nodeID, nodeIteration, de.getID());
                        break;
                    }
                    case STRING: {
                        value = paa.retrieveString(session, instanceID, nodeID, nodeIteration, de.getID());
                        break;
                    }
                    case DATE: {
                        value = paa.retrieveDate(session, instanceID, nodeID, nodeIteration, de.getID());
                        break;
                    }
                    case URI: {
                        value = paa.retrieveURI(session, instanceID, nodeID, nodeIteration, de.getID());
                        break;
                    }
                    case USERDEFINED: {
                        value = paa.retrieveUDT(session, instanceID, nodeID, nodeIteration, de.getID());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown data type '" + (Object)((Object)de.getDataType()) + "' found"));
                    }
                }
            }
            catch (InvalidDataTypeException e) {
                throw new RuntimeException("InvalidDataTypeException while trying to create a data context.", e);
            }
            parameters.put(paramName, (Serializable)value);
        }
        return executionFactory.createParameterDataContext(parameterTypes, parameters);
    }

    public static boolean isActivity(ExecutableBusinessProcess ebp) {
        boolean isActivity;
        if (ebp == null || ebp instanceof Activity) {
            isActivity = true;
        } else if (ebp instanceof LightWeightProcess || ebp instanceof VariableParallelismEBP) {
            isActivity = false;
        } else {
            throw new RuntimeException("Unknown EBP type: " + ebp.getClass().getName());
        }
        return isActivity;
    }

    public static EBPType getEBPType(ExecutableBusinessProcess ebp) {
        EBPType type = ebp == null ? EBPType.NULL : ebp.getType();
        return type;
    }

    public static long getTerminationSignalDelay(SessionToken session) {
        long ret = 0L;
        String userAtt = session.getAdditionalAttributeValue("TerminationSignalDelay");
        if (userAtt != null) {
            try {
                ret = Long.parseLong(userAtt);
            }
            catch (NumberFormatException numberFormatException) {
                ret = -1L;
            }
        }
        return ret;
    }
}

