/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution;

import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.ParameterRefResolver;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityActivation;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionTools;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.StartEndNodeHandling;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.components.ADEPT2DefaultComponentFactory;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction.WorklistAccess;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import de.aristaflow.adept2.model.execution.AgentUnknownException;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.execution.InvalidRuntimeManagerException;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.net.URI;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DefaultActivityActivation
extends AbstractSubService
implements ActivityActivation {
    protected final DefaultExecutionManager executionManager;
    protected final StartEndNodeHandling startEndNodeHandling;
    protected final WorklistAccess worklistAccess;
    protected ExecutorService executorService;

    public DefaultActivityActivation(DefaultExecutionManager executionManager, StartEndNodeHandling startEndNodeHandling, WorklistAccess worklistAccess) {
        super(new String[]{"ProcessManager", "DataManager", "LogManager", "UpdateManager"}, new String[0], executionManager);
        this.executionManager = executionManager;
        this.startEndNodeHandling = startEndNodeHandling;
        this.worklistAccess = worklistAccess;
    }

    @Override
    public void init() {
        this.executorService = Executors.newCachedThreadPool(new Adept2ThreadFactory("AutoStartActivities"));
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        this.awaitExecutorServiceShutdown();
    }

    @Override
    public void emergencyShutdown() {
        this.executorService.shutdownNow();
        this.awaitExecutorServiceShutdown();
    }

    private void awaitExecutorServiceShutdown() {
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void activateActivity(SessionToken parentSession, ExecutableInstance instance, EBPInstanceReference activity) throws InvalidActivityStateException, InvalidInstanceStateException {
        super.sessionActive(parentSession);
        try {
            ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
            ActivityExecutionTools.checkActivityForActivation(instance, activity, this.logger);
            SessionToken subSession = this.executionManager.subSession(parentSession);
            InstanceStatus instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, activity.getInstanceID());
            ActivityExecutionTools.checkIsInstanceRunning(instanceStatus, "Activation", activity.getNodeID(), activity.getInstanceID(), this.logger);
            ProcessAwareAccess paa = this.executionManager.getResolvedDataManager(subSession, instance.getID()).getProcessAwareAccess();
            ParameterDataContext dataContext = paa.getPublicDataContext(subSession, instance, activity.getNodeID());
            subSession = this.executionManager.subSession(parentSession);
            InputDataContainer nodeDataContainer = paa.getNodeDataContainer(subSession, instance, activity.getNodeID());
            ExecutableBusinessProcessInstance activityInstance = ActivityExecutionTools.setUpEBPInstance(subSession, activity, instance, this.getComponentFactory(), this.getExecutionFactory(), dataContext, nodeDataContainer, this.executionManager.getPluginRegistry());
            subSession = this.executionManager.subSession(parentSession);
            Node node = instance.getTemplate().getNode(activity.getNodeID());
            Node resolvingNode = ParameterRefResolver.getProxy(node, Node.class, nodeDataContainer, subSession, this.executionManager.getPluginRegistry());
            if (instance.getTemplate().getStartNode().getID() != activity.getNodeID() && instance.getTemplate().getEndNode().getID() != activity.getNodeID()) {
                subSession = this.executionManager.subSession(parentSession);
                this.worklistAccess.addActivity(subSession, activityInstance, ProcessConstants.NodeState.NS_ACTIVATED, activity, resolvingNode.getStaffAssignmentRule());
            }
            subSession = this.executionManager.subSession(parentSession);
            long timestamp = System.currentTimeMillis();
            try {
                this.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logNodeActivated(subSession, timestamp, instance, activity.getNodeID(), activity.getNodeIteration());
            }
            catch (DataSourceException ex) {
                String msg = "The node activation could not be logged to the execution history! [Timestamp(%s), Instance(%s), Node(%s), Iteration(%s), StateChange(%s)";
                msg = String.format(msg, new Object[]{timestamp, instance.getID(), activity.getNodeID(), activity.getNodeIteration(), ExecutionHistory.StateChange.NODE_STARTED});
                this.logger.log(Level.SEVERE, msg, ex);
            }
            subSession = this.executionManager.subSession(parentSession);
            this.activityIsActivated(subSession, instance, activity);
            this.tryAutoStart(parentSession, activity);
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    private void activityIsActivated(SessionToken parentSession, ExecutableInstance instance, EBPInstanceReference activity) {
        SessionToken subSession = this.executionManager.subSession(parentSession);
        if (instance.getTemplate().getNodeType(activity.getNodeID()).equals((Object)ProcessConstants.NodeType.NT_ENDFLOW)) {
            this.startEndNodeHandling.endActivityIsActivated(subSession, activity);
        }
        subSession = this.executionManager.subSession(parentSession);
        ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), activity, instance, ProcessConstants.NodeState.NS_ACTIVATED, this.logger);
    }

    protected void tryAutoStart(SessionToken parentSession, final EBPInstanceReference activity) {
        block29: {
            super.sessionActive(parentSession);
            try {
                String msg;
                String timeString;
                URI[] runtimeManagerURIs;
                String userDataString;
                SessionToken subSession;
                block28: {
                    ExecutableInstance instance;
                    subSession = this.executionManager.subSession(parentSession);
                    boolean storeInstance = false;
                    UUID instanceID = activity.getInstanceID();
                    int nodeID = activity.getNodeID();
                    userDataString = null;
                    runtimeManagerURIs = null;
                    timeString = null;
                    try {
                        instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
                    }
                    catch (LockException e) {
                        String msg2 = String.format("Cannot autostart instance '%s', because cannot get a lock on it! Aborted autostarting.", instanceID);
                        this.logger.log(Level.INFO, msg2, e);
                        super.sessionFinished(parentSession);
                        return;
                    }
                    try {
                        try {
                            if (instance.getTemplate().getNode(nodeID).isAutoStartEnabled()) {
                                msg = String.format("Found autostart flag for activity '%s'. Trying to start it automatically.", activity);
                                this.logger.info(msg);
                                userDataString = instance.getUserAttributeValue("AutoStartUserData" + nodeID);
                                instance.removeUserAttributeValue("AutoStartUserData" + nodeID);
                                runtimeManagerURIs = instance.getAssignedRuntimeManager(nodeID);
                                timeString = instance.getUserAttributeValue("AutoStartTime" + nodeID);
                                instance.removeUserAttributeValue("AutoStartTime" + nodeID);
                                storeInstance = true;
                                msg = String.format("Removed data needed for autostarting activity '%s'. Storing instance.", activity);
                                this.logger.fine(msg);
                            }
                            if (storeInstance) {
                                this.getInstanceManager().setExecutableInstance(subSession, instance);
                            }
                        }
                        catch (LockException le) {
                            msg = String.format("tryAutoStart: Cannot store the instance '%1$s' when autostarting. Autostart related data will remain in the instance.", instanceID);
                            this.logger.log(Level.SEVERE, msg, le);
                            try {
                                this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                            }
                            catch (LockException le2) {
                                msg = String.format("tryAutoStart: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instanceID);
                                this.logger.log(Level.SEVERE, msg, le2);
                            }
                            break block28;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                        }
                        catch (LockException le) {
                            String msg3 = String.format("tryAutoStart: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instanceID);
                            this.logger.log(Level.SEVERE, msg3, le);
                        }
                        throw throwable;
                    }
                    try {
                        this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                    }
                    catch (LockException le) {
                        msg = String.format("tryAutoStart: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instanceID);
                        this.logger.log(Level.SEVERE, msg, le);
                    }
                }
                if (userDataString != null && runtimeManagerURIs != null && timeString != null && timeString.length() > 0) {
                    DefaultExecutionManager.UserData userData = this.executionManager.deserialiseUserData(userDataString);
                    if (userData != null) {
                        try {
                            long terminationTime = Long.parseLong(timeString);
                            if (terminationTime + this.executionManager.getAutoStartDelay() >= System.currentTimeMillis()) {
                                activity.setRuntimeManagerURIs(runtimeManagerURIs);
                                subSession = this.executionManager.subSession(parentSession);
                                final SessionToken startSession = this.executionManager.newSubstituteSession(subSession, userData);
                                super.privilegeSession(parentSession, startSession);
                                this.executorService.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            DefaultActivityActivation.this.executionManager.getActivityStarting().startActivity(startSession, activity, ProcessConstants.ExecutionMode.PRODUCTION);
                                        }
                                        catch (InvalidRuntimeManagerException irme) {
                                            String msg = String.format("Cannot start '%s' automatically since the activity has no valid runtime manager assigned. Aborted autostarting.", activity);
                                            DefaultActivityActivation.this.logger.log(Level.INFO, msg, irme);
                                        }
                                        catch (InvalidActivityStateException iase) {
                                            String msg = String.format("Cannot start '%s' automatically since the activity has the wrong state. Maybe another user has already started it. Aborted autostarting.", activity);
                                            DefaultActivityActivation.this.logger.log(Level.INFO, msg, iase);
                                        }
                                        catch (InvalidInstanceStateException iise) {
                                            String msg = String.format("Cannot start '%s' automatically since the corresponding instance is in the wrong state. Aborted autostarting.", activity);
                                            DefaultActivityActivation.this.logger.log(Level.INFO, msg, iise);
                                        }
                                        catch (AgentUnknownException aue) {
                                            String msg = String.format("Cannot start '%s' automatically since the runtime manager '%s' does not know the agent '%s'. Maybe the agent has already logged off. Aborted autostarting.", activity, Arrays.toString(aue.getRuntimeManagerURIs()), aue.getAgent());
                                            DefaultActivityActivation.this.logger.log(Level.INFO, msg, aue);
                                        }
                                        catch (RuntimeException re) {
                                            String msg = String.format("Cannot start '%s' automatically due to a runtime exception. Aborted autostarting.", activity);
                                            DefaultActivityActivation.this.logger.log(Level.INFO, msg, re);
                                        }
                                    }
                                });
                            }
                            break block29;
                        }
                        catch (NumberFormatException nfe) {
                            msg = String.format("Cannot parse the termination time of the preceding node for autostarting '%s'. Aborted autostarting.", activity);
                            this.logger.log(Level.INFO, msg, nfe);
                        }
                        catch (SecurityTokenIntegrityException stie) {
                            msg = String.format("Cannot get a new session token needed for autostarting '%s'. Aborted autostarting.", activity);
                            this.logger.log(Level.INFO, msg, stie);
                        }
                        break block29;
                    }
                    msg = String.format("Cannot decode the stored session token for autostarting '%s'. Aborted autostarting.", activity);
                    this.logger.info(msg);
                    break block29;
                }
                StringBuilder missing = new StringBuilder("Missing data: ");
                if (userDataString == null) {
                    missing.append("UserData, ");
                }
                if (runtimeManagerURIs == null) {
                    missing.append("RuntimeManagerURIs, ");
                }
                if (timeString == null) {
                    missing.append("Termination time of preceding node, ");
                }
                missing.delete(missing.length() - 2, missing.length());
                msg = String.format("Did not have all data for autostarting activity '%s'. %s.", activity, missing);
                this.logger.info(msg);
            }
            finally {
                super.sessionFinished(parentSession);
            }
        }
    }

    protected ADEPT2DefaultComponentFactory getComponentFactory() {
        return this.executionManager.getADEPT2DefaultComponentFactory();
    }

    protected ExecutionFactory getExecutionFactory() {
        return this.executionManager.getExecutionFactory();
    }

    protected ExecutionHistory getExecutionHistory(SessionToken session, UUID instanceID) {
        return this.executionManager.getExecutionHistory(session, instanceID);
    }

    protected UpdateManager getUpdateManager(SessionToken session) {
        return this.executionManager.getUpdateManager(session);
    }

    protected InstanceManager getInstanceManager() {
        return this.executionManager.getProcessManager().getInstanceManager();
    }
}

