/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution;

import de.aristaflow.adept2.base.communication.ServiceConnectionException;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.executionmanager.ActivityExecutionControl;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionTools;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.DefaultActivityTermination;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instanceexecution.InstanceExecution;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction.WorklistAccess;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.runtimemanager.RuntimeManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.net.URI;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DefaultActivityExecutionControl
extends AbstractSubService
implements ActivityExecutionControl {
    protected final DefaultExecutionManager executionManager;
    protected final DefaultActivityTermination terminationSignalling;
    protected final InstanceExecution instanceExecution;
    protected final WorklistAccess worklistAccess;

    public DefaultActivityExecutionControl(DefaultExecutionManager executionManager, DefaultActivityTermination terminationSignalling, InstanceExecution instanceExecution, WorklistAccess worklistAccess) {
        super(new String[0], new String[]{"ProcessManager", "DataManager", "RuntimeManager", "UpdateManager"}, executionManager);
        this.executionManager = executionManager;
        this.terminationSignalling = terminationSignalling;
        this.instanceExecution = instanceExecution;
        this.worklistAccess = worklistAccess;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean suspendActivity(SessionToken parentSession, EBPInstanceReference activity, boolean waitForAcknowledgement) throws InvalidActivityStateException {
        super.sessionActive(parentSession);
        try {
            SessionToken subSession = this.executionManager.subSession(parentSession);
            UUID instanceID = activity.getInstanceID();
            ExecutableInstance instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
            boolean bl = this.suspendActivity(parentSession, instance, activity, waitForAcknowledgement);
            try {
                this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
            }
            catch (LockException le) {
                String msg = String.format("suspendActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instanceID);
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
            return bl;
            catch (LockException e) {
                try {
                    throw ActivityExecutionTools.wrapLockException(e, "suspend activity", activity.getNodeID(), instanceID);
                }
                catch (Throwable throwable) {
                    try {
                        this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                    }
                    catch (LockException le) {
                        String msg = String.format("suspendActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instanceID);
                        this.logger.log(Level.SEVERE, msg, le);
                        throw new InternalServiceException(msg);
                    }
                    throw throwable;
                }
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    public boolean suspendActivity(SessionToken parentSession, Instance instance, EBPInstanceReference activity, boolean waitForAcknowledgement) throws InvalidActivityStateException {
        ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
        ActivityExecutionTools.checkActivityForSuspension(instance, activity, this.logger, true);
        boolean ret = false;
        SessionToken privSession = this.executionManager.privilegedSubSession(parentSession);
        SessionToken subSession = this.executionManager.subSession(privSession);
        RuntimeManager runtimeManager = this.executionManager.getRuntimeManager(subSession, activity);
        if (runtimeManager == null) {
            String msg = String.format("Activity cannot be suspended since the runtime manager cannot be determined. Are you sure the activity of node '%s' of instance '%s' is still running?", activity.getNodeID(), activity.getInstanceID());
            throw new InvalidActivityStateException(msg);
        }
        if (waitForAcknowledgement) {
            try {
                CountDownLatch waitLatch = this.terminationSignalling.getFlagForActivityTermination(activity);
                runtimeManager.getExecutionControlManager().suspendActivity(subSession, activity);
                ret = waitLatch.await(this.executionManager.getAbortionTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        } else {
            runtimeManager.getExecutionControlManager().suspendActivity(subSession, activity);
        }
        return ret;
    }

    @Override
    public void resetActivity(SessionToken parentSession, EBPInstanceReference activity, boolean forceReset) throws InvalidActivityStateException, InvalidInstanceStateException {
        super.sessionActive(parentSession);
        try {
            String msg;
            ProcessConstants.NodeState nodeState;
            int nodeID;
            ExecutableInstance instance;
            UUID instanceID;
            SessionToken subSession;
            SessionToken privSession;
            QualifiedAgent resettingAgent;
            block42: {
                resettingAgent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
                privSession = this.executionManager.privilegedSubSession(parentSession);
                subSession = this.executionManager.subSession(privSession);
                instanceID = activity.getInstanceID();
                try {
                    try {
                        instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
                    }
                    catch (LockException e) {
                        throw ActivityExecutionTools.wrapLockException(e, "reset activity", activity.getNodeID(), instanceID);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                    }
                    catch (LockException le) {
                        String msg2 = "resetActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                        msg2 = String.format(msg2, instanceID);
                        this.logger.log(Level.SEVERE, msg2, le);
                        throw new InternalServiceException(msg2);
                    }
                    throw throwable;
                }
                try {
                    this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                }
                catch (LockException le) {
                    String msg3 = "resetActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg3 = String.format(msg3, instanceID);
                    this.logger.log(Level.SEVERE, msg3, le);
                    throw new InternalServiceException(msg3);
                }
                nodeID = activity.getNodeID();
                InstanceStatus instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, instanceID);
                ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                if (instanceStatus.getExecutionStatus() != ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_SUSPENDED && instanceStatus.getExecutionStatus() != ProcessConstants.InstanceExecutionStatus.IE_SUSPENDED && instanceStatus.getExecutionStatus() != ProcessConstants.InstanceExecutionStatus.IE_ABORTED) {
                    ActivityExecutionTools.checkIsInstanceRunning(instanceStatus, "Resetting", nodeID, instanceID, this.logger);
                }
                ActivityExecutionTools.checkActivityForHardReset(instance, activity, this.logger, !forceReset);
                nodeState = instance.getNodeState(nodeID);
                if (nodeState == ProcessConstants.NodeState.NS_RUNNING) {
                    long errorCode = 4L;
                    String errorMessage = "Resetting the activity.";
                    subSession = this.executionManager.subSession(privSession);
                    activity.setRuntimeManagerURIs(instance.getAssignedRuntimeManager(nodeID));
                    if (instance.getNodeLWPInstanceID(nodeID) == null || instance.getNodeLWPInstanceID(nodeID).isEmpty()) {
                        try {
                            if (this.suspendActivity(subSession, instance, activity, true)) break block42;
                            this.abortActivity(subSession, instance, activity, errorMessage, errorCode, forceReset);
                            break block42;
                        }
                        catch (InvalidActivityStateException invalidActivityStateException) {
                            this.abortActivity(subSession, instance, activity, errorMessage, errorCode, forceReset);
                            break block42;
                        }
                        catch (RuntimeException runtimeException) {
                            this.abortActivity(subSession, instance, activity, errorMessage, errorCode, forceReset);
                            break block42;
                        }
                    }
                    this.abortActivity(subSession, instance, activity, errorMessage, errorCode, forceReset);
                }
            }
            try {
                subSession = this.executionManager.subSession(privSession);
                instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
            }
            catch (LockException le) {
                throw ActivityExecutionTools.wrapLockException(le, "reset activity, re-get instance", activity.getNodeID(), instanceID);
            }
            boolean successful = false;
            try {
                try {
                    subSession = this.executionManager.subSession(privSession);
                    DataManager dataManager = this.executionManager.getResolvedDataManager(subSession, instanceID);
                    nodeState = instance.getNodeState(nodeID);
                    dataManager.getProcessAwareAccess().dropWrittenValues(subSession, instance, nodeID, activity.getNodeIteration());
                    Template template = instance.getTemplate();
                    Node tempNode = template.getNode(nodeID);
                    int connectorID = tempNode.getConnector(SystemDataProducer.NODE_PERFORMING_AGENT_ID.getParameterProperties().getName(), ActivityConstants.AccessType.SYSTEM_WRITE);
                    if (connectorID != Integer.MIN_VALUE) {
                        int[] successors;
                        DataElement dataElement = template.getDataElement(nodeID, connectorID);
                        int[] nArray = successors = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_READ);
                        int n = successors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int succNodeID = nArray[n2];
                            Node node = template.getNode(succNodeID);
                            if (node.isAutoStartEnabled()) {
                                instance.setAssignedRuntimeManager(succNodeID, null);
                                instance.setPerformingAgent(succNodeID, null);
                            }
                            ++n2;
                        }
                    }
                    if (nodeState == ProcessConstants.NodeState.NS_SUSPENDED) {
                        subSession = this.executionManager.subSession(privSession);
                        this.worklistAccess.removeActivity(subSession, activity);
                    }
                    subSession = this.executionManager.subSession(privSession);
                    long timestamp = System.currentTimeMillis();
                    try {
                        this.executionManager.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logNodeResetHard(subSession, timestamp, instance, activity.getNodeID(), activity.getNodeIteration());
                    }
                    catch (DataSourceException ex) {
                        msg = "The node reset could not be logged to the execution history! [Timestamp(%s), Instance(%s), Node(%s), Iteration(%s), StateChange(%s), PerformingAgentID(%s), Performing AgentOrgPositionID(%s), ResettingAgentID(%s), Resetting AgentOrgPositionID(%s)]";
                        QualifiedAgent qa = instance.getPerformingAgent(activity.getNodeID());
                        msg = String.format(msg, new Object[]{timestamp, instanceID, activity.getNodeID(), activity.getNodeIteration(), ExecutionHistory.StateChange.NODE_FAILED, qa.getAgentID(), qa.getOrgPositionID(), resettingAgent.getAgentID(), resettingAgent.getOrgPositionID()});
                        this.logger.log(Level.SEVERE, msg, ex);
                    }
                    instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_NOT_ACTIVATED);
                    instance.setPerformingAgent(nodeID, null);
                    instance.setAssignedRuntimeManager(nodeID, null);
                    HashSet<UUID> subInstanceIDs = new HashSet<UUID>(instance.getNodeLWPInstanceID(nodeID));
                    for (UUID subInstanceID : subInstanceIDs) {
                        instance.removeNodeLWPInstanceID(nodeID, subInstanceID);
                    }
                    instance.dropEnquiries(nodeID);
                    subSession = this.executionManager.subSession(privSession);
                    this.instanceExecution.afterResetted(subSession, instance, activity);
                    subSession = this.executionManager.subSession(privSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                    successful = true;
                }
                catch (LockException le) {
                    String msg4 = "resetActivity: Cannot store the executable instance '%1$s'. It is locked by another user. Aborting reset of activity '%2$s'.";
                    msg4 = String.format(msg4, instance.getID(), activity);
                    this.logger.log(Level.SEVERE, msg4, le);
                    throw new InternalServiceException(msg4);
                }
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(privSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                }
                catch (LockException le) {
                    String msg5 = "resetActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg5 = String.format(msg5, instanceID);
                    this.logger.log(Level.SEVERE, msg5, le);
                    throw new InternalServiceException(msg5);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(privSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
            }
            catch (LockException le) {
                msg = "resetActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                msg = String.format(msg, instanceID);
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
            if (successful) {
                subSession = this.executionManager.subSession(privSession);
                ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), activity, instance, ProcessConstants.NodeState.NS_NOT_ACTIVATED, this.logger);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void abortActivity(SessionToken parentSession, EBPInstanceReference activity, String errorMessage, long errorCode, boolean force) throws InvalidActivityStateException {
        super.sessionActive(parentSession);
        try {
            SessionToken subSession = this.executionManager.subSession(parentSession);
            UUID instanceID = activity.getInstanceID();
            try {
                try {
                    ExecutableInstance instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
                    this.abortActivity(parentSession, instance, activity, errorMessage, errorCode, force);
                }
                catch (LockException e) {
                    throw ActivityExecutionTools.wrapLockException(e, "abort activity", activity.getNodeID(), instanceID);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                }
                catch (LockException le) {
                    String msg = String.format("abortActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instanceID);
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
                throw throwable;
            }
            try {
                this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
            }
            catch (LockException le) {
                String msg = String.format("abortActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instanceID);
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    public void abortActivity(SessionToken parentSession, ExecutableInstance instance, EBPInstanceReference activity, String errorMessage, long errorCode, boolean force) throws InvalidActivityStateException {
        SessionToken privSession = this.executionManager.privilegedSubSession(parentSession);
        SessionToken subSession = this.executionManager.subSession(privSession);
        try {
            ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
            ActivityExecutionTools.checkActivityForAbortion(instance, activity, this.logger);
            URI[] rtMgr = instance.getAssignedRuntimeManager(activity.getNodeID());
            activity.setRuntimeManagerURIs(rtMgr);
            RuntimeManager runtimeManager = this.executionManager.getRuntimeManager(subSession, activity);
            if (runtimeManager != null) {
                runtimeManager.getExecutionControlManager().abortActivity(subSession, activity, force ? this.executionManager.getAbortionTimeout() : 0L);
            } else {
                String logMessage = String.format("The runtime manager for the activity '%s' cannot be determined. Obviously it does not execute the activity any more, setting the activity to failed.", activity);
                this.logger.info(logMessage);
                this.failDirectly(subSession, instance, activity, errorMessage, "ADEPT2:ExecutionManager:ExecutionControlManager:RuntimeManagerActivityUnknown", errorCode);
            }
        }
        catch (IllegalArgumentException iae) {
            String logMessage = String.format("The runtime manager for the activity '%s' does not execute the activity any  more, setting the activity to failed.", activity);
            this.logger.log(Level.INFO, logMessage, iae);
            this.failDirectly(subSession, instance, activity, errorMessage, "ADEPT2:ExecutionManager:ExecutionControlManager:RuntimeManagerActivityUnknown", errorCode);
        }
        catch (ServiceConnectionException sce) {
            String logMessage = String.format("The runtime manager for the activity '%s' is unreachable, setting the activity to failed.", activity);
            this.logger.log(Level.INFO, logMessage, sce);
            this.failDirectly(subSession, instance, activity, errorMessage, "ADEPT2:ExecutionManager:ExecutionControlManager:RuntimeManagerUnreachable", errorCode);
        }
    }

    protected void failDirectly(SessionToken parentSession, Instance instance, EBPInstanceReference activity, String errorMessage, String state, long errorCode) throws InvalidActivityStateException {
        SessionToken subSession = this.executionManager.subSession(parentSession);
        ProcessAwareAccess paa = this.executionManager.getResolvedDataManager(subSession, activity.getInstanceID()).getProcessAwareAccess();
        DataContainer dataContainer = paa.getDataContainer(subSession, instance, activity.getNodeID());
        subSession = this.executionManager.subSession(parentSession);
        this.terminationSignalling.activityFailed(subSession, activity, dataContainer, errorMessage, state, errorCode);
    }

    protected UpdateManager getUpdateManager(SessionToken session) {
        return this.executionManager.getUpdateManager(session);
    }

    protected InstanceManager getInstanceManager() {
        return this.executionManager.getProcessManager().getInstanceManager();
    }
}

