/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution;

import de.aristaflow.adept2.base.communication.ServiceConnectionException;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionControlManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionTools;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.InternalActivityTerminationSignalling;
import de.aristaflow.adept2.core.runtimemanager.RuntimeManager;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Instance;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DefaultActivityExecutionControlManager
extends AbstractSubService
implements ActivityExecutionControlManager {
    protected final DefaultExecutionManager executionManager;
    protected final InternalActivityTerminationSignalling terminationSignalling;

    public DefaultActivityExecutionControlManager(DefaultExecutionManager executionManager, InternalActivityTerminationSignalling terminationSignalling) {
        super(new String[0], new String[]{"DataManager", "RuntimeManager"}, executionManager);
        this.executionManager = executionManager;
        this.terminationSignalling = terminationSignalling;
    }

    @Override
    public void abortActivity(SessionToken parentSession, Instance instance, EBPInstanceReference activity, String errorMessage, long errorCode, boolean force) throws InvalidActivityStateException {
        super.sessionActive(parentSession);
        try {
            try {
                SessionToken subSession = this.executionManager.subSession(parentSession);
                ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                ActivityExecutionTools.checkActivityForAbortion(instance, activity, this.logger);
                RuntimeManager runtimeManager = this.executionManager.getRuntimeManager(subSession, activity);
                runtimeManager.getExecutionControlManager().abortActivity(subSession, activity, force ? this.executionManager.getAbortionTimeout() : 0L);
            }
            catch (IllegalArgumentException iae) {
                String logMessage = String.format("The runtime manager for the activity '%s' does not execute the activity any  more, setting the activity to failed.", activity);
                this.logger.log(Level.INFO, logMessage, iae);
                this.failDirectly(parentSession, instance, activity, errorMessage, "ADEPT2:ExecutionManager:ExecutionControlManager:RuntimeManagerActivityUnknown", errorCode);
                super.sessionFinished(parentSession);
            }
            catch (ServiceConnectionException sce) {
                String logMessage = String.format("The runtime manager for the activity '%s' is unreachable, setting the activity to failed.", activity);
                this.logger.log(Level.INFO, logMessage, sce);
                this.failDirectly(parentSession, instance, activity, errorMessage, "ADEPT2:ExecutionManager:ExecutionControlManager:RuntimeManagerUnreachable", errorCode);
                super.sessionFinished(parentSession);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public boolean suspendActivity(SessionToken parentSession, Instance instance, EBPInstanceReference activity, boolean waitForAcknowledgement) throws InvalidActivityStateException {
        super.sessionActive(parentSession);
        try {
            SessionToken subSession = this.executionManager.subSession(parentSession);
            boolean ret = false;
            ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
            ActivityExecutionTools.checkActivityForSuspension(instance, activity, this.logger, true);
            RuntimeManager runtimeManager = this.executionManager.getRuntimeManager(subSession, activity);
            if (waitForAcknowledgement) {
                try {
                    CountDownLatch waitLatch = this.terminationSignalling.getFlagForActivityTermination(activity);
                    runtimeManager.getExecutionControlManager().suspendActivity(subSession, activity);
                    ret = waitLatch.await(this.executionManager.getAbortionTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            } else {
                runtimeManager.getExecutionControlManager().suspendActivity(subSession, activity);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    protected void failDirectly(SessionToken parentSession, Instance instance, EBPInstanceReference activity, String errorMessage, String state, long errorCode) throws InvalidActivityStateException {
        SessionToken subSession = this.executionManager.subSession(parentSession);
        ProcessAwareAccess paa = this.executionManager.getResolvedDataManager(subSession, activity.getInstanceID()).getProcessAwareAccess();
        DataContainer dataContainer = paa.getDataContainer(subSession, instance, activity.getNodeID());
        subSession = this.executionManager.subSession(parentSession);
        this.executionManager.getActivityTermination().activityFailed(subSession, activity, dataContainer, errorMessage, state, errorCode);
    }
}

