/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution;

import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.executionmanager.ActivityStarting;
import de.aristaflow.adept2.core.executionmanager.ActivityTermination;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.ParameterRefResolver;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionControlManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionTools;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.components.ADEPT2DefaultComponentFactory;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instanceexecution.InstanceExecution;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction.WorklistAccess;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolutionException;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.runtimemanager.RuntimeManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.plugindata.EnquiryData;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.AgentUnknownException;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.execution.InvalidRuntimeManagerException;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.orgmodel.OrgPolicySystemDataFormatter;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DefaultActivityStarting
extends AbstractSubService
implements ActivityStarting {
    final DefaultExecutionManager executionManager;
    protected final ActivityExecutionControlManager activityExecution;
    protected final InstanceExecution instanceExecution;
    protected final ActivityTermination activityTermination;
    protected final WorklistAccess worklistAccess;
    protected ExecutorService subprocessExecutor;

    public DefaultActivityStarting(DefaultExecutionManager executionManager, ActivityExecutionControlManager activityExecution, InstanceExecution instanceExecution, ActivityTermination activityTermination, WorklistAccess worklistAccess) {
        super(new String[0], new String[]{"ProcessManager", "DataManager", "OrgModelManager", "LogManager", "UpdateManager", "RuntimeManager", "SubprocessManager"}, executionManager);
        this.executionManager = executionManager;
        this.activityExecution = activityExecution;
        this.instanceExecution = instanceExecution;
        this.activityTermination = activityTermination;
        this.worklistAccess = worklistAccess;
    }

    @Override
    public void init() {
        this.subprocessExecutor = Executors.newCachedThreadPool(new Adept2ThreadFactory("SubprocessStarter"));
    }

    @Override
    public void shutdown() {
        this.subprocessExecutor.shutdown();
        this.awaitExecutorServiceShutdown();
    }

    @Override
    public void emergencyShutdown() {
        this.subprocessExecutor.shutdownNow();
        this.awaitExecutorServiceShutdown();
    }

    private void awaitExecutorServiceShutdown() {
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = this.subprocessExecutor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void selectActivity(SessionToken parentSession, EBPInstanceReference activity) throws InvalidActivityStateException, InvalidInstanceStateException {
        super.sessionActive(parentSession);
        try {
            String msg;
            ExecutableInstance instance;
            boolean successful = false;
            QualifiedAgent agent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken privSession = this.executionManager.privilegedSubSession(parentSession);
            SessionToken subSession = this.executionManager.subSession(privSession);
            try {
                instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, activity.getInstanceID());
            }
            catch (LockException e) {
                throw ActivityExecutionTools.wrapLockException(e, "select activity", activity.getNodeID(), activity.getInstanceID());
            }
            try {
                try {
                    int nodeID = activity.getNodeID();
                    UUID instanceID = activity.getInstanceID();
                    InstanceStatus instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, activity.getInstanceID());
                    ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                    ActivityExecutionTools.checkIsInstanceRunning(instanceStatus, "Selecting", nodeID, activity.getInstanceID(), this.logger);
                    ActivityExecutionTools.checkActivityForSelection(instance, activity, agent, this.logger);
                    instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_SELECTED);
                    instance.setPerformingAgent(nodeID, agent);
                    subSession = this.executionManager.subSession(privSession);
                    long timestamp = System.currentTimeMillis();
                    try {
                        this.getExecutionHistory(subSession, instanceID).getWriteAccess().logNodeSelected(subSession, timestamp, instance, nodeID, activity.getNodeIteration());
                    }
                    catch (DataSourceException ex) {
                        msg = "Selecting node could not be logged to the execution history! [Timestamp(%s), Instance(%s), Node(%s), Iteration(%s), StateChange(%s), AgentID(%s), AgentAgentOrgPositionID(%s)]";
                        QualifiedAgent performingAgent = instance.getPerformingAgent(nodeID);
                        msg = String.format(msg, new Object[]{timestamp, instanceID, nodeID, activity.getNodeIteration(), ExecutionHistory.StateChange.NODE_SELECTED, performingAgent.getAgentID(), performingAgent.getOrgPositionID()});
                        this.logger.log(Level.SEVERE, msg, ex);
                    }
                    subSession = this.executionManager.subSession(privSession);
                    this.worklistAccess.assignAndUpdateActivity(subSession, activity, ProcessConstants.NodeState.NS_SELECTED, agent);
                    subSession = this.executionManager.subSession(privSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                    successful = true;
                }
                catch (LockException le) {
                    String msg2 = "selectActivity: Cannot store the executable instance '%1$s'. It is locked by another user. Aborting selecting activity '%2$s'.";
                    msg2 = String.format(msg2, instance.getID(), activity);
                    this.logger.log(Level.SEVERE, msg2, le);
                    throw new InternalServiceException(msg2);
                }
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(privSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                }
                catch (LockException le) {
                    String msg3 = "selectActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg3 = String.format(msg3, instance.getID());
                    this.logger.log(Level.SEVERE, msg3, le);
                    throw new InternalServiceException(msg3);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(privSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
            }
            catch (LockException le) {
                msg = "selectActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                msg = String.format(msg, instance.getID());
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
            if (successful) {
                subSession = this.executionManager.subSession(privSession);
                ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), activity, instance, ProcessConstants.NodeState.NS_SELECTED, this.logger);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void deselectActivity(SessionToken parentSession, EBPInstanceReference activity) throws InvalidActivityStateException, InvalidInstanceStateException {
        super.sessionActive(parentSession);
        try {
            String msg;
            ExecutableInstance instance;
            boolean successful = false;
            QualifiedAgent agent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken privSession = this.executionManager.privilegedSubSession(parentSession);
            SessionToken subSession = this.executionManager.subSession(privSession);
            try {
                instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, activity.getInstanceID());
            }
            catch (LockException e) {
                throw ActivityExecutionTools.wrapLockException(e, "deselect activity", activity.getNodeID(), activity.getInstanceID());
            }
            try {
                try {
                    int nodeID = activity.getNodeID();
                    UUID instanceID = activity.getInstanceID();
                    InstanceStatus instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, instanceID);
                    ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                    ActivityExecutionTools.checkIsInstanceRunning(instanceStatus, "Deselecting", nodeID, activity.getInstanceID(), this.logger);
                    ActivityExecutionTools.checkActivityForDeselection(instance, activity, agent, this.logger);
                    instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_ACTIVATED);
                    instance.setPerformingAgent(nodeID, null);
                    instance.setAssignedRuntimeManager(nodeID, null);
                    subSession = this.executionManager.subSession(privSession);
                    long timestamp = System.currentTimeMillis();
                    try {
                        this.getExecutionHistory(subSession, instanceID).getWriteAccess().logNodeDeselected(subSession, timestamp, instance, nodeID, activity.getNodeIteration());
                    }
                    catch (DataSourceException ex) {
                        msg = "Deselecting node could not be logged to the execution history! [Timestamp(%s), Instance(%s), Node(%s), Iteration(%s), StateChange(%s), AgentID(%s), AgentAgentOrgPositionID(%s)]";
                        QualifiedAgent performingAgent = instance.getPerformingAgent(nodeID);
                        msg = String.format(msg, new Object[]{timestamp, instanceID, nodeID, activity.getNodeIteration(), ExecutionHistory.StateChange.NODE_DESELECTED, performingAgent.getAgentID(), performingAgent.getOrgPositionID()});
                        this.logger.log(Level.SEVERE, msg, ex);
                    }
                    subSession = this.executionManager.subSession(privSession);
                    this.worklistAccess.updateActivityState(subSession, activity, ProcessConstants.NodeState.NS_ACTIVATED);
                    subSession = this.executionManager.subSession(privSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                    successful = true;
                }
                catch (LockException le) {
                    String msg2 = "deselectActivity: Cannot store the executable instance '%1$s'. It is locked by another user. Aborting deselect of activity '%2$s'.";
                    msg2 = String.format(msg2, instance.getID(), activity);
                    this.logger.log(Level.SEVERE, msg2, le);
                    throw new InternalServiceException(msg2);
                }
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(privSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                }
                catch (LockException le) {
                    String msg3 = "deselectActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg3 = String.format(msg3, instance.getID());
                    this.logger.log(Level.SEVERE, msg3, le);
                    throw new InternalServiceException(msg3);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(privSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
            }
            catch (LockException le) {
                msg = "deselectActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                msg = String.format(msg, instance.getID());
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
            if (successful) {
                subSession = this.executionManager.subSession(privSession);
                ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), activity, instance, ProcessConstants.NodeState.NS_ACTIVATED, this.logger);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void startActivity(SessionToken parentSession, EBPInstanceReference activity, ProcessConstants.ExecutionMode executionMode) throws InvalidActivityStateException, InvalidInstanceStateException, AgentUnknownException {
        super.sessionActive(parentSession);
        try {
            String msg;
            ExecutableInstance instance;
            boolean successful = false;
            int nodeID = activity.getNodeID();
            UUID instanceID = activity.getInstanceID();
            QualifiedAgent agent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken subSession = this.executionManager.subSession(parentSession);
            try {
                instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
            }
            catch (LockException e) {
                throw ActivityExecutionTools.wrapLockException(e, "start activity", nodeID, instanceID);
            }
            try {
                try {
                    RuntimeManager rtMgr;
                    DataContainer dataContainer;
                    boolean supportsViewOnly;
                    URI[] runtimeManagerURIs;
                    ProcessAwareAccess paa = this.getDataManager(subSession, instanceID).getProcessAwareAccess();
                    subSession = this.executionManager.subSession(parentSession);
                    InputDataContainer nodeDataContainer = paa.getNodeDataContainer(subSession, instance, nodeID);
                    Template template = instance.getTemplate();
                    ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
                    if (executionMode.equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                        if (instance.getNodeIteration(nodeID) < activity.getNodeIteration() || instance.getNodeIteration(nodeID) == activity.getNodeIteration() && (nodeState != ProcessConstants.NodeState.NS_COMPLETED || nodeState != ProcessConstants.NodeState.NS_ENQUIRED)) {
                            String msg2 = "Cannot display activity '%s' since it is not fully completed yet.";
                            msg2 = String.format(msg2, activity);
                            throw new InvalidActivityStateException(msg2, nodeState);
                        }
                        ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                        try {
                            this.checkAndGetRuntimeManager(subSession, activity);
                        }
                        catch (ServiceNotKnownException snke) {
                            String msg3 = "Could not retrieve runtime manager '%s'. Forwarding ServiceNotKnownException as InvalidActivityStateException.";
                            msg3 = String.format(msg3, Arrays.toString(activity.getRuntimeManagerURIs()));
                            this.logger.log(Level.INFO, msg3, snke);
                            throw new InvalidRuntimeManagerException(activity, nodeState);
                        }
                    }
                    InstanceStatus instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, instanceID);
                    ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                    ActivityExecutionTools.checkIsInstanceRunning(instanceStatus, "Starting", nodeID, instanceID, this.logger);
                    ActivityExecutionTools.checkActivityForStarting(instance, activity, agent, this.logger);
                    try {
                        runtimeManagerURIs = this.checkAndGetRuntimeManager(subSession, activity).getURIs();
                    }
                    catch (ServiceNotKnownException snke) {
                        String msg4 = "Could not retrieve runtime manager '%s'. Forwarding ServiceNotKnownException as InvalidActivityStateException.";
                        msg4 = String.format(msg4, Arrays.toString(activity.getRuntimeManagerURIs()));
                        this.logger.log(Level.INFO, msg4, snke);
                        throw new InvalidRuntimeManagerException(activity, nodeState);
                    }
                    instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_RUNNING);
                    instance.setAssignedRuntimeManager(nodeID, runtimeManagerURIs);
                    instance.setPerformingAgent(nodeID, agent);
                    instance.setExecutionMode(nodeID, executionMode);
                    subSession = this.executionManager.subSession(parentSession);
                    long timestamp = System.currentTimeMillis();
                    try {
                        Node node = template.getNode(nodeID);
                        node = ParameterRefResolver.getProxy(node, Node.class, nodeDataContainer, subSession, this.executionManager.getPluginRegistry());
                        String nodeName = node.getName();
                        this.getExecutionHistory(subSession, instanceID).getWriteAccess().logNodeStarted(subSession, timestamp, instance, nodeID, nodeName, activity.getNodeIteration());
                    }
                    catch (DataSourceException ex) {
                        msg = "The node start could not be logged to the execution history! [Timestamp(%s), Instance(%s), Node(%s), Iteration(%s), StateChange(%s), AgentID(%s), AgentAgentOrgPositionID(%s)]";
                        QualifiedAgent performingAgent = instance.getPerformingAgent(nodeID);
                        msg = String.format(msg, new Object[]{timestamp, instanceID, nodeID, activity.getNodeIteration(), ExecutionHistory.StateChange.NODE_STARTED, performingAgent.getAgentID(), performingAgent.getOrgPositionID()});
                        this.logger.log(Level.SEVERE, msg, ex);
                    }
                    subSession = this.executionManager.subSession(parentSession);
                    ParameterDataContext dataContext = paa.getPublicDataContext(subSession, instance, nodeID);
                    subSession = this.executionManager.subSession(parentSession);
                    ExecutableBusinessProcessInstance ebpInstance = ActivityExecutionTools.setUpEBPInstance(subSession, activity, instance, this.getComponentFactory(), this.getExecutionFactory(), dataContext, nodeDataContainer, this.executionManager.getPluginRegistry(), executionMode.equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY));
                    boolean bl = supportsViewOnly = ebpInstance instanceof ActivityInstance && ((ActivityInstance)ebpInstance).supportsViewOnly();
                    if (!supportsViewOnly && executionMode.equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                        throw new InvalidActivityStateException("ViewOnly not supported!");
                    }
                    subSession = this.executionManager.subSession(parentSession);
                    if (!executionMode.equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY)) {
                        dataContainer = paa.getDataContainer(subSession, instance, nodeID);
                    } else {
                        ExecutionHistory executionHistory = this.getExecutionHistory(subSession, instance.getID());
                        dataContainer = paa.getObsoleteDataContainer(subSession, executionHistory, instance, nodeID, activity.getNodeIteration());
                    }
                    Enquiry currentEnquiry = null;
                    List<Enquiry> currentEnquiries = instance.getCurrentEnquiries(nodeID);
                    if (currentEnquiries.size() > 0) {
                        currentEnquiry = currentEnquiries.get(currentEnquiries.size() - 1);
                    }
                    ExecutionContext executionContext = this.getExecutionFactory().getExecutionContext(agent, ebpInstance, dataContainer, executionMode, currentEnquiry, instance.getRepliedEnquiry(nodeID));
                    try {
                        subSession = this.executionManager.subSession(parentSession);
                        rtMgr = this.getAndAssignRuntimeManager(subSession, activity);
                    }
                    catch (ServiceNotKnownException snke) {
                        msg = "Could not retrieve runtime manager '%s'. Forwarding ServiceNotKnownException as InvalidActivityStateException.";
                        msg = String.format(msg, Arrays.toString(activity.getRuntimeManagerURIs()));
                        this.logger.log(Level.INFO, msg, snke);
                        throw new InvalidRuntimeManagerException(activity, ProcessConstants.NodeState.NS_RUNNING);
                    }
                    if (!executionMode.equals((Object)ProcessConstants.ExecutionMode.VIEW_ONLY) && template.getStartNode().getID() != nodeID && template.getEndNode().getID() != nodeID) {
                        subSession = this.executionManager.subSession(parentSession);
                        this.worklistAccess.assignAndUpdateActivity(subSession, activity, ProcessConstants.NodeState.NS_RUNNING, instance.getPerformingAgent(nodeID));
                    }
                    subSession = this.executionManager.subSession(parentSession);
                    this.startActivityInRuntimeManager(subSession, activity, executionContext, rtMgr);
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                    successful = true;
                }
                catch (LockException le) {
                    String msg5 = "startActivity: Cannot store the executable instance '%1$s'. It is locked by another user. Aborting start of activity '%2$s'.";
                    msg5 = String.format(msg5, instance.getID(), activity);
                    this.logger.log(Level.SEVERE, msg5, le);
                    throw new InternalServiceException(msg5);
                }
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                }
                catch (LockException le) {
                    String msg6 = "startActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg6 = String.format(msg6, instance.getID());
                    this.logger.log(Level.SEVERE, msg6, le);
                    throw new InternalServiceException(msg6);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
            }
            catch (LockException le) {
                msg = "startActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                msg = String.format(msg, instance.getID());
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
            if (successful) {
                subSession = this.executionManager.subSession(parentSession);
                ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), activity, instance, ProcessConstants.NodeState.NS_RUNNING, this.logger);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void resumeActivity(SessionToken parentSession, EBPInstanceReference activity) throws InvalidActivityStateException, InvalidInstanceStateException, AgentUnknownException {
        super.sessionActive(parentSession);
        try {
            String msg;
            ExecutableInstance instance;
            boolean successful = false;
            int nodeID = activity.getNodeID();
            UUID instanceID = activity.getInstanceID();
            QualifiedAgent agent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken subSession = this.executionManager.subSession(parentSession);
            try {
                instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
            }
            catch (LockException e) {
                throw ActivityExecutionTools.wrapLockException(e, "resume activity", nodeID, instanceID);
            }
            try {
                RuntimeManager rtMgr;
                ProcessAwareAccess paa = this.getDataManager(subSession, instanceID).getProcessAwareAccess();
                subSession = this.executionManager.subSession(parentSession);
                InstanceStatus instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, instanceID);
                ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                ActivityExecutionTools.checkIsInstanceRunning(instanceStatus, "Resuming", nodeID, instanceID, this.logger);
                ActivityExecutionTools.checkActivityForResumingOrEnquiring(instance, activity, agent, this.logger, false);
                URI[] runtimeManagerURIs = activity.getRuntimeManagerURIs();
                Template template = instance.getTemplate();
                Node tempNode = template.getNode(nodeID);
                int connectorID = tempNode.getConnector(SystemDataProducer.NODE_PERFORMING_AGENT_ID.getParameterProperties().getName(), ActivityConstants.AccessType.SYSTEM_WRITE);
                if (connectorID != Integer.MIN_VALUE) {
                    int[] successors;
                    DataElement dataElement = template.getDataElement(nodeID, connectorID);
                    int[] nArray = successors = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_READ);
                    int n = successors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int succNodeID = nArray[n2];
                        if (template.getNode(succNodeID).isAutoStartEnabled() && instance.getAssignedRuntimeManager(succNodeID) != null) {
                            instance.setPerformingAgent(succNodeID, agent);
                            instance.setAssignedRuntimeManager(succNodeID, runtimeManagerURIs);
                        }
                        ++n2;
                    }
                }
                instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_RUNNING);
                instance.setPerformingAgent(nodeID, agent);
                subSession = this.executionManager.subSession(parentSession);
                long timestamp = System.currentTimeMillis();
                try {
                    this.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logNodeResumed(subSession, timestamp, instance, activity.getNodeID(), activity.getNodeIteration());
                }
                catch (DataSourceException ex) {
                    msg = "The node resume could not be logged to the execution history! [Timestamp(%s), Instance(%s), Node(%s), Iteration(%s), StateChange(%s), AgentID(%s), AgentAgentOrgPositionID(%s)]";
                    msg = String.format(msg, new Object[]{timestamp, instanceID, nodeID, activity.getNodeIteration(), ExecutionHistory.StateChange.NODE_RESUMED, agent.getAgentID(), agent.getOrgPositionID()});
                    this.logger.log(Level.SEVERE, msg, ex);
                }
                subSession = this.executionManager.subSession(parentSession);
                ParameterDataContext dataContext = paa.getPublicDataContext(subSession, instance, nodeID);
                subSession = this.executionManager.subSession(parentSession);
                ExecutableBusinessProcessInstance ebpInstance = ActivityExecutionTools.setUpEBPInstance(subSession, activity, instance, this.getComponentFactory(), this.getExecutionFactory(), dataContext, paa.getNodeDataContainer(subSession, instance, nodeID), this.executionManager.getPluginRegistry());
                ProcessConstants.ExecutionMode executionMode = instance.getExecutionMode(nodeID);
                subSession = this.executionManager.subSession(parentSession);
                DataContainer dataContainer = paa.getDataContainer(subSession, instance, nodeID);
                Enquiry currentEnquiry = null;
                List<Enquiry> currentEnquiries = instance.getCurrentEnquiries(nodeID);
                if (currentEnquiries.size() > 0) {
                    currentEnquiry = currentEnquiries.get(currentEnquiries.size() - 1);
                }
                ExecutionContext executionContext = this.getExecutionFactory().getExecutionContext(agent, ebpInstance, dataContainer, executionMode, currentEnquiry, instance.getRepliedEnquiry(nodeID));
                int savepointID = dataContainer.getLastSavepointID(subSession);
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    rtMgr = this.getAndAssignRuntimeManager(subSession, activity);
                }
                catch (ServiceNotKnownException snke) {
                    msg = "Could not retrieve runtime manager '%s'. Forwarding ServiceNotKnownException as InvalidActivityStateException.";
                    msg = String.format(msg, Arrays.toString(activity.getRuntimeManagerURIs()));
                    this.logger.log(Level.INFO, msg, snke);
                    throw new InvalidRuntimeManagerException(activity, ProcessConstants.NodeState.NS_RUNNING);
                }
                subSession = this.executionManager.subSession(parentSession);
                this.worklistAccess.assignAndUpdateActivity(subSession, activity, ProcessConstants.NodeState.NS_RUNNING, instance.getPerformingAgent(activity.getNodeID()));
                subSession = this.executionManager.subSession(parentSession);
                this.resumeActivityInRuntimeManager(subSession, activity, executionContext, savepointID, instance, rtMgr);
                try {
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                }
                catch (LockException le) {
                    msg = "resumeActivity: Cannot store the executable instance '%1$s'. It is locked by another user. Aborting resume of activity '%2$s'.";
                    msg = String.format(msg, instance.getID(), activity);
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
                successful = true;
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                }
                catch (LockException le) {
                    String msg2 = "resumeActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg2 = String.format(msg2, instance.getID());
                    this.logger.log(Level.SEVERE, msg2, le);
                    throw new InternalServiceException(msg2);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
            }
            catch (LockException le) {
                msg = "resumeActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                msg = String.format(msg, instance.getID());
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
            if (successful) {
                subSession = this.executionManager.subSession(parentSession);
                ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), activity, instance, ProcessConstants.NodeState.NS_RUNNING, this.logger);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public Set<QualifiedAgent> getEnquiryRecipients(SessionToken parentSession, EBPInstanceReference activity) {
        super.sessionActive(parentSession);
        try {
            String message;
            HashSet<QualifiedAgent> recipients;
            String staffAssignmentRule;
            block9: {
                QualifiedAgent agent;
                block10: {
                    agent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
                    staffAssignmentRule = "Agent()";
                    recipients = new HashSet<QualifiedAgent>();
                    if (agent.getAgentUserName().equals("supervisor")) break block9;
                    SessionToken subSession = this.executionManager.subSession(parentSession);
                    Instance instance = this.getInstanceManager().getInstance(subSession, activity.getInstanceID());
                    PluginData pluginData = instance.getTemplate().getNode(activity.getNodeID()).getPluginData("Enquiry");
                    if (pluginData == null) break block10;
                    EnquiryData data = ModelViewer.createView(pluginData.getPluginData(), EnquiryData.class);
                    switch (data.getEnquiryRecipientMode()) {
                        case RecipientsFromSar: {
                            staffAssignmentRule = this.resolveStaffAssigmentRule(data.getEnquiryRecipientsRule(), agent);
                            break block9;
                        }
                        default: {
                            throw new RuntimeException("This feature is not yet implemented!");
                        }
                    }
                }
                staffAssignmentRule = this.resolveStaffAssigmentRule(this.executionManager.getDefaultEnquiryRecipientsSAR(), agent);
            }
            SessionToken newSession = this.executionManager.newSession(parentSession);
            try {
                OrgModelManager omm = this.executionManager.getOrgModelManager();
                recipients.addAll(omm.getPolicyResolution().resolvePolicy(newSession, staffAssignmentRule));
            }
            catch (PolicyResolutionException e) {
                message = String.format("Policy resolution exception while retrieving enquiry recipients, SAR='%s', node '%s'.", staffAssignmentRule, activity);
                this.logger.log(Level.SEVERE, message, e);
            }
            catch (DataSourceException e) {
                message = String.format("Data source problems while retrieving enquiry recipients, SAR='%s', node '%s'.", staffAssignmentRule, activity);
                this.logger.log(Level.SEVERE, message, e);
            }
            HashSet<QualifiedAgent> hashSet = recipients;
            return hashSet;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    private String resolveStaffAssigmentRule(String staffAssignmentRule, QualifiedAgent agent) {
        HashMap<String, Object> value = new HashMap<String, Object>(4);
        value.put("agentID", agent.getAgentID());
        value.put("agentUserName", agent.getAgentUserName());
        value.put("orgPositionID", agent.getOrgPositionID());
        value.put("orgPositionName", agent.getOrgPositionName());
        return SystemDataTools.format(OrgPolicySystemDataFormatter.class, staffAssignmentRule, value);
    }

    @Override
    public void enquireActivity(SessionToken parentSession, EBPInstanceReference activity, Set<QualifiedAgent> recipients, String question) throws InvalidActivityStateException, InvalidInstanceStateException {
        super.sessionActive(parentSession);
        try {
            ExecutableInstance instance;
            QualifiedAgent agent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken subSession = this.executionManager.subSession(parentSession);
            try {
                instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, activity.getInstanceID());
            }
            catch (LockException e) {
                throw ActivityExecutionTools.wrapLockException(e, "enquire activity", activity.getNodeID(), activity.getInstanceID());
            }
            try {
                try {
                    int nodeID = activity.getNodeID();
                    subSession = this.executionManager.subSession(parentSession);
                    InstanceStatus instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, activity.getInstanceID());
                    ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                    ActivityExecutionTools.checkIsInstanceRunning(instanceStatus, "Enquiring", nodeID, activity.getInstanceID(), this.logger);
                    ActivityExecutionTools.checkActivityForResumingOrEnquiring(instance, activity, agent, this.logger, true);
                    Template template = instance.getTemplate();
                    Node tempNode = template.getNode(nodeID);
                    int connectorID = tempNode.getConnector(SystemDataProducer.NODE_PERFORMING_AGENT_ID.getParameterProperties().getName(), ActivityConstants.AccessType.SYSTEM_WRITE);
                    if (connectorID != Integer.MIN_VALUE) {
                        int[] successors;
                        DataElement dataElement = template.getDataElement(nodeID, connectorID);
                        int[] nArray = successors = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_READ);
                        int n = successors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int succNodeID = nArray[n2];
                            Node node = template.getNode(succNodeID);
                            if (node.isAutoStartEnabled()) {
                                instance.setAssignedRuntimeManager(succNodeID, null);
                                instance.setPerformingAgent(succNodeID, null);
                            }
                            ++n2;
                        }
                    }
                    Enquiry enquiry = this.getExecutionFactory().createEnquiry(agent, recipients, question);
                    instance.addEnquiry(nodeID, enquiry);
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                    this.worklistAccess.enquireActivity(subSession, activity, enquiry);
                }
                catch (LockException le) {
                    String msg = "enquireActivity: Cannot store the executable instance '%1$s'. It is locked by another user. Aborting enquiry of activity '%2$s'.";
                    msg = String.format(msg, instance.getID(), activity);
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                }
                catch (LockException le) {
                    String msg = "enquireActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg = String.format(msg, instance.getID());
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
            }
            catch (LockException le) {
                String msg = "enquireActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                msg = String.format(msg, instance.getID());
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void replyEnquiry(SessionToken parentSession, EBPInstanceReference activity, String reply) throws InvalidActivityStateException, InvalidInstanceStateException {
        super.sessionActive(parentSession);
        try {
            ExecutableInstance instance;
            QualifiedAgent agent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken subSession = this.executionManager.subSession(parentSession);
            try {
                instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, activity.getInstanceID());
            }
            catch (LockException e) {
                throw ActivityExecutionTools.wrapLockException(e, "reply enquiry", activity.getNodeID(), activity.getInstanceID());
            }
            try {
                try {
                    int nodeID = activity.getNodeID();
                    subSession = this.executionManager.subSession(parentSession);
                    InstanceStatus instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, activity.getInstanceID());
                    boolean checkState = instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_ENQUIRED;
                    ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                    if (checkState) {
                        ActivityExecutionTools.checkIsInstanceRunning(instanceStatus, "Replying", nodeID, activity.getInstanceID(), this.logger);
                    }
                    ActivityExecutionTools.checkActivityForReplyingEnquiry(instance, activity, agent, this.logger);
                    if (instance.getCurrentEnquiries(nodeID).size() > 0) {
                        subSession = this.executionManager.subSession(parentSession);
                        instance.replyEnquiry(nodeID, reply, agent);
                        Enquiry enquiry = instance.getRepliedEnquiry(nodeID);
                        this.worklistAccess.replyActivity(subSession, activity, enquiry);
                    } else if (instance.getCurrentEnquiries(nodeID).size() == 0 && instance.getRepliedEnquiry(nodeID) != null) {
                        subSession = this.executionManager.subSession(parentSession);
                        instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_COMPLETED);
                        instance.dropEnquiries(nodeID);
                        this.worklistAccess.removeActivity(subSession, activity);
                    }
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                }
                catch (LockException le) {
                    String msg = "replyEnquiry: Cannot store the executable instance '%1$s'. It is locked by another user. Aborting reply enquiry of activity '%2$s'.";
                    msg = String.format(msg, instance.getID(), activity);
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                }
                catch (LockException le) {
                    String msg = "replyEnquiry: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg = String.format(msg, instance.getID());
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
            }
            catch (LockException le) {
                String msg = "replyEnquiry: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                msg = String.format(msg, instance.getID());
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public ExecutionContext getExecutionContext(SessionToken parentSession, EBPInstanceReference activity) throws InvalidActivityStateException, InvalidInstanceStateException {
        super.sessionActive(parentSession);
        try {
            ExecutionContext ret;
            ExecutableInstance instance;
            int nodeID = activity.getNodeID();
            UUID instanceID = activity.getInstanceID();
            QualifiedAgent agent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken subSession = this.executionManager.subSession(parentSession);
            try {
                instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
            }
            catch (LockException e) {
                throw ActivityExecutionTools.wrapLockException(e, "start activity", nodeID, instanceID);
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                ProcessAwareAccess paa = this.getDataManager(subSession, instanceID).getProcessAwareAccess();
                InstanceStatus instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, instanceID);
                ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                ActivityExecutionTools.checkIsInstanceRunning(instanceStatus, "Starting", nodeID, instanceID, this.logger);
                ActivityExecutionTools.checkActivityForRetrievingContext(instance, activity, agent, this.logger);
                ParameterDataContext dataContext = paa.getPublicDataContext(subSession, instance, nodeID);
                subSession = this.executionManager.subSession(parentSession);
                ExecutableBusinessProcessInstance ebpInstance = ActivityExecutionTools.setUpEBPInstance(subSession, activity, instance, this.getComponentFactory(), this.getExecutionFactory(), dataContext, paa.getNodeDataContainer(subSession, instance, nodeID), this.executionManager.getPluginRegistry());
                subSession = this.executionManager.subSession(parentSession);
                DataContainer dataContainer = paa.getDataContainer(subSession, instance, nodeID);
                Enquiry currentEnquiry = null;
                List<Enquiry> currentEnquiries = instance.getCurrentEnquiries(nodeID);
                if (currentEnquiries.size() > 0) {
                    currentEnquiry = currentEnquiries.get(currentEnquiries.size() - 1);
                }
                ret = this.getExecutionFactory().getExecutionContext(agent, ebpInstance, dataContainer, null, currentEnquiry, instance.getRepliedEnquiry(nodeID));
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                }
                catch (LockException le) {
                    String msg = "getExecutionContext: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg = String.format(msg, instance.getID());
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
            }
            catch (LockException le) {
                String msg = "getExecutionContext: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                msg = String.format(msg, instance.getID());
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
            ExecutionContext executionContext = ret;
            return executionContext;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void resetActivity(SessionToken parentSession, EBPInstanceReference activity, boolean forceReset) throws InvalidActivityStateException, InvalidInstanceStateException {
        super.sessionActive(parentSession);
        try {
            ProcessConstants.NodeState nodeState;
            int nodeID;
            ExecutableInstance instance;
            UUID instanceID;
            SessionToken subSession;
            QualifiedAgent resettingAgent;
            block42: {
                resettingAgent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
                subSession = this.executionManager.subSession(parentSession);
                instanceID = activity.getInstanceID();
                try {
                    try {
                        instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
                    }
                    catch (LockException e) {
                        throw ActivityExecutionTools.wrapLockException(e, "reset activity", activity.getNodeID(), instanceID);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                    }
                    catch (LockException le) {
                        String msg = String.format("resetActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instanceID);
                        this.logger.log(Level.SEVERE, msg, le);
                        throw new InternalServiceException(msg);
                    }
                    throw throwable;
                }
                try {
                    this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                }
                catch (LockException le) {
                    String msg = String.format("resetActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instanceID);
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
                nodeID = activity.getNodeID();
                InstanceStatus instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, instanceID);
                ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                if (instanceStatus.getExecutionStatus() != ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_SUSPENDED && instanceStatus.getExecutionStatus() != ProcessConstants.InstanceExecutionStatus.IE_SUSPENDED) {
                    ActivityExecutionTools.checkIsInstanceRunning(instanceStatus, "Resetting", nodeID, instanceID, this.logger);
                }
                ActivityExecutionTools.checkActivityForHardReset(instance, activity, this.logger, !forceReset);
                nodeState = instance.getNodeState(nodeID);
                if (nodeState == ProcessConstants.NodeState.NS_RUNNING) {
                    long errorCode = 4L;
                    String errorMessage = "Resetting the activity.";
                    subSession = this.executionManager.subSession(parentSession);
                    activity.setRuntimeManagerURIs(instance.getAssignedRuntimeManager(nodeID));
                    if (instance.getNodeLWPInstanceID(nodeID) == null || instance.getNodeLWPInstanceID(nodeID).isEmpty()) {
                        try {
                            if (this.activityExecution.suspendActivity(subSession, instance, activity, true)) break block42;
                            this.activityExecution.abortActivity(subSession, instance, activity, errorMessage, errorCode, forceReset);
                            break block42;
                        }
                        catch (InvalidActivityStateException invalidActivityStateException) {
                            this.activityExecution.abortActivity(subSession, instance, activity, errorMessage, errorCode, forceReset);
                            break block42;
                        }
                        catch (RuntimeException runtimeException) {
                            this.activityExecution.abortActivity(subSession, instance, activity, errorMessage, errorCode, forceReset);
                            break block42;
                        }
                    }
                    this.activityExecution.abortActivity(subSession, instance, activity, errorMessage, errorCode, forceReset);
                }
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
            }
            catch (LockException le) {
                throw ActivityExecutionTools.wrapLockException(le, "reset activity, re-get instance", activity.getNodeID(), instanceID);
            }
            boolean successful = false;
            try {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    DataManager dataManager = this.getDataManager(subSession, instanceID);
                    nodeState = instance.getNodeState(nodeID);
                    dataManager.getProcessAwareAccess().dropWrittenValues(subSession, instance, nodeID, activity.getNodeIteration());
                    Template template = instance.getTemplate();
                    Node tempNode = template.getNode(nodeID);
                    int connectorID = tempNode.getConnector(SystemDataProducer.NODE_PERFORMING_AGENT_ID.getParameterProperties().getName(), ActivityConstants.AccessType.SYSTEM_WRITE);
                    if (connectorID != Integer.MIN_VALUE) {
                        int[] successors;
                        DataElement dataElement = template.getDataElement(nodeID, connectorID);
                        int[] nArray = successors = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_READ);
                        int n = successors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int succNodeID = nArray[n2];
                            Node node = template.getNode(succNodeID);
                            if (node.isAutoStartEnabled()) {
                                instance.setAssignedRuntimeManager(succNodeID, null);
                                instance.setPerformingAgent(succNodeID, null);
                            }
                            ++n2;
                        }
                    }
                    if (nodeState == ProcessConstants.NodeState.NS_SUSPENDED) {
                        subSession = this.executionManager.subSession(parentSession);
                        this.worklistAccess.removeActivity(subSession, activity);
                    }
                    subSession = this.executionManager.subSession(parentSession);
                    long timestamp = System.currentTimeMillis();
                    try {
                        this.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logNodeResetHard(subSession, timestamp, instance, activity.getNodeID(), activity.getNodeIteration());
                    }
                    catch (DataSourceException ex) {
                        String msg = "The node reset could not be logged to the execution history! [Timestamp(%s), Instance(%s), Node(%s), Iteration(%s), StateChange(%s), PerformingAgentID(%s), PerformingAgentOrgPositionID(%s), ResettingAgentID(%s), ResettingAgentOrgPositionID(%s)]";
                        QualifiedAgent qa = instance.getPerformingAgent(activity.getNodeID());
                        msg = String.format(msg, new Object[]{timestamp, instanceID, activity.getNodeID(), activity.getNodeIteration(), ExecutionHistory.StateChange.NODE_FAILED, qa.getAgentID(), qa.getOrgPositionID(), resettingAgent.getAgentID(), resettingAgent.getOrgPositionID()});
                        this.logger.log(Level.SEVERE, msg, ex);
                    }
                    instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_NOT_ACTIVATED);
                    instance.setPerformingAgent(nodeID, null);
                    instance.setAssignedRuntimeManager(nodeID, null);
                    HashSet<UUID> subInstanceIDs = new HashSet<UUID>(instance.getNodeLWPInstanceID(nodeID));
                    for (UUID subInstanceID : subInstanceIDs) {
                        instance.removeNodeLWPInstanceID(nodeID, subInstanceID);
                    }
                    instance.dropEnquiries(nodeID);
                    subSession = this.executionManager.subSession(parentSession);
                    this.instanceExecution.afterResetted(subSession, instance, activity);
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                    successful = true;
                }
                catch (LockException le) {
                    String msg = "resetActivity: Cannot store the executable instance '%1$s'. It is locked by another user. Aborting reset of activity '%2$s'.";
                    msg = String.format(msg, instance.getID(), activity);
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                }
                catch (LockException le) {
                    String msg = String.format("resetActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instanceID);
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
            }
            catch (LockException le) {
                String msg = String.format("resetActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instanceID);
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
            if (successful) {
                subSession = this.executionManager.subSession(parentSession);
                ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), activity, instance, ProcessConstants.NodeState.NS_NOT_ACTIVATED, this.logger);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    private RuntimeManager getAndAssignRuntimeManager(SessionToken session, EBPInstanceReference ebpReference) throws ServiceNotKnownException {
        RuntimeManager ret = this.checkAndGetRuntimeManager(session, ebpReference);
        if (!ebpReference.isActivity()) {
            ebpReference.setRuntimeManagerURIs(ret.getURIs());
        }
        return ret;
    }

    private void startActivityInRuntimeManager(final SessionToken session, final EBPInstanceReference ebpReference, final ExecutionContext executionContext, final RuntimeManager runtimeManager) throws AgentUnknownException {
        try {
            if (ebpReference.isActivity()) {
                runtimeManager.startActivity(this.executionManager.subSession(session), ebpReference, executionContext);
            } else {
                this.subprocessExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            runtimeManager.startActivity(DefaultActivityStarting.this.executionManager.newSession(session), ebpReference, executionContext);
                        }
                        catch (AgentUnknownException aue) {
                            throw new RuntimeException("The subprocess manager must not throw an AgentUnknownException when starting a subpocess", aue);
                        }
                    }
                });
            }
        }
        catch (RuntimeException re) {
            if (executionContext.getExecutionMode() == ProcessConstants.ExecutionMode.VIEW_ONLY) {
                this.logger.log(Level.INFO, String.format("Could not start activity %s in view only mode due to an exception.", ebpReference), re);
            }
            this.logger.log(Level.SEVERE, String.format("Could not start activity %s due to an exception. Trying to fail this activity.", ebpReference), re);
            try {
                Instance instance = this.getInstanceManager().getInstance(session, ebpReference.getInstanceID());
                this.activityExecution.abortActivity(session, instance, ebpReference, "Providing the activity for starting in the runtime manager failed!", 6L, true);
                this.logger.severe(String.format("Failed activity %s!", ebpReference));
            }
            catch (InvalidActivityStateException iase) {
                this.logger.log(Level.SEVERE, String.format("Could not fail activity '%s' due to an invalid state. There seems to be a problem with inconsistent states. Aborting!", ebpReference), iase);
            }
        }
    }

    private void resumeActivityInRuntimeManager(SessionToken session, EBPInstanceReference ebpReference, ExecutionContext executionContext, int savepointID, ExecutableInstance instance, RuntimeManager runtimeManager) throws AgentUnknownException {
        instance.setAssignedRuntimeManager(ebpReference.getNodeID(), runtimeManager.getURIs());
        try {
            runtimeManager.resumeActivity(session, ebpReference, executionContext, savepointID);
        }
        catch (RuntimeException re) {
            this.logger.log(Level.SEVERE, String.format("Could not resume activity %s due to an exception.Trying to fail this activity.", ebpReference), re);
            try {
                this.activityTermination.activityFailed(session, ebpReference, executionContext.getDataContainer(), "Providing the activity for resuming in the runtime manager failed!", "ADEPT2:ExecutionManager:ActivityStarting:ProvideActivityForResumingFailed", 7L);
                this.logger.severe(String.format("Failed activity %s!", ebpReference));
            }
            catch (InvalidActivityStateException iase) {
                this.logger.log(Level.SEVERE, String.format("Could not fail activity '%s' due to an invalid state. There seems to be a problem with inconsistent states. Aborting!", ebpReference), iase);
            }
        }
    }

    private RuntimeManager checkAndGetRuntimeManager(SessionToken session, EBPInstanceReference ebpIR) throws ServiceNotKnownException {
        RuntimeManager runtimeManager;
        if (ebpIR.isActivity()) {
            try {
                runtimeManager = this.getRuntimeManager(session, ebpIR);
            }
            catch (RTServiceNotKnownException snke) {
                throw snke.getWrappedException();
            }
        }
        try {
            runtimeManager = this.getSubprocessManager(session, ebpIR);
        }
        catch (RTServiceNotKnownException snke) {
            throw snke.getWrappedException();
        }
        return runtimeManager;
    }

    protected ADEPT2DefaultComponentFactory getComponentFactory() {
        return this.executionManager.getADEPT2DefaultComponentFactory();
    }

    protected ExecutionFactory getExecutionFactory() {
        return this.executionManager.getExecutionFactory();
    }

    protected UpdateManager getUpdateManager(SessionToken session) {
        return this.executionManager.getUpdateManager(session);
    }

    protected ExecutionHistory getExecutionHistory(SessionToken session, UUID instanceID) {
        return this.executionManager.getExecutionHistory(session, instanceID);
    }

    protected DataManager getDataManager(SessionToken session, UUID instanceID) {
        return this.executionManager.getResolvedDataManager(session, instanceID);
    }

    protected InstanceManager getInstanceManager() {
        return this.executionManager.getProcessManager().getInstanceManager();
    }

    protected RuntimeManager getSubprocessManager(SessionToken session, EBPInstanceReference ebpInstanceRef) {
        return this.executionManager.getSubprocessManager(session, ebpInstanceRef);
    }

    protected RuntimeManager getRuntimeManager(SessionToken session, EBPInstanceReference ebpInstanceReference) {
        return this.executionManager.getRuntimeManager(session, ebpInstanceReference);
    }
}

