/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution;

import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.datamanager.ProcessUnawareAccess;
import de.aristaflow.adept2.core.executionmanager.ActivityTermination;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.ParameterRefResolver;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionTools;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.InternalActivityTerminationSignalling;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instanceexecution.InstanceExecution;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction.WorklistAccess;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.plugindata.ErrorHandlingProcessData;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import de.aristaflow.adept2.model.datamanagement.InstanceDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.ValidationFailedException;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.xml.DataContainerXMLExport;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.ExecutorTools;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.NullArgumentException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class DefaultActivityTermination
extends AbstractSubService
implements ActivityTermination,
InternalActivityTerminationSignalling {
    private Map<EBPInstanceReference, CountDownLatch> waitersForTerminationAcknowledgement = new HashMap<EBPInstanceReference, CountDownLatch>();
    protected ExecutorService executorService;
    protected final DefaultExecutionManager executionManager;
    protected InstanceControl instanceControl;
    protected final InstanceExecution instanceExecution;
    protected final WorklistAccess worklistAccess;

    public DefaultActivityTermination(DefaultExecutionManager executionManager, InstanceControl instanceControl, InstanceExecution instanceExecution, WorklistAccess worklistAccess) {
        super(new String[]{"ProcessManager", "DataManager", "OrgModelManager", "LogManager", "UpdateManager"}, new String[0], executionManager);
        this.executionManager = executionManager;
        this.instanceControl = instanceControl;
        this.instanceExecution = instanceExecution;
        this.worklistAccess = worklistAccess;
    }

    @Override
    public void init() {
        this.executorService = Executors.newCachedThreadPool(new Adept2ThreadFactory("ErrorHandlingInstantiation"));
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        ExecutorTools.awaitTermination(this.executorService);
    }

    @Override
    public void emergencyShutdown() {
        this.executorService.shutdownNow();
        ExecutorTools.awaitTermination(this.executorService);
    }

    @Override
    public void activityFinished(SessionToken parentSession, EBPInstanceReference activity, DataContainer dataContainer) throws InvalidActivityStateException {
        super.sessionActive(parentSession);
        try {
            try {
                ExecutableInstance instance;
                ProcessConstants.NodeState newNodeState;
                SessionToken subSession;
                boolean successful;
                block55: {
                    String msg;
                    successful = false;
                    subSession = this.executionManager.subSession(parentSession);
                    newNodeState = null;
                    int nodeID = activity.getNodeID();
                    try {
                        instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, activity.getInstanceID());
                    }
                    catch (LockException e) {
                        throw ActivityExecutionTools.wrapLockException(e, "finish activity", nodeID, activity.getInstanceID());
                    }
                    try {
                        ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                        ActivityExecutionTools.checkActivityForFinishing(instance, activity, this.logger);
                        subSession = this.executionManager.subSession(parentSession);
                        ProcessAwareAccess paa = this.getProcessAwareAccess(subSession, activity.getInstanceID());
                        paa.flushDataContainer(subSession, instance, nodeID, instance.getNodeIteration(nodeID), dataContainer);
                        Template template = instance.getTemplate();
                        Node node = template.getNode(nodeID);
                        int iteration = activity.getNodeIteration();
                        long terminationTime = System.currentTimeMillis();
                        Set<ProcessModelParameter> parameters = node.getSystemParameters(ActivityConstants.AccessType.SYSTEM_WRITE);
                        for (ProcessModelParameter param : parameters) {
                            SystemDataProducer producer = SystemDataProducer.getProducerForIdentifierID(param.getIdentifierID());
                            if (producer == null) {
                                msg = "No matching SystemDataProducer found for the identifier ID %s of parameter '%s' at node #%d in instance '%s'!";
                                msg = String.format(msg, param.getIdentifierID(), param.getName(), nodeID, instance.getID());
                                this.logger.severe(msg);
                                continue;
                            }
                            int connectorID = node.getConnector(param.getName(), ActivityConstants.AccessType.SYSTEM_WRITE);
                            if (connectorID == Integer.MIN_VALUE) continue;
                            DataElement dataElement = template.getDataElement(nodeID, connectorID);
                            long integerValue = Integer.MIN_VALUE;
                            String staffAssignmentRule = null;
                            boolean storeDate = false;
                            switch (producer) {
                                case TEMPLATE_SUPERVISOR_AGENT_ID: {
                                    integerValue = template.getSupervisorAgent().getAgentID();
                                    break;
                                }
                                case TEMPLATE_SUPERVISOR_ORGPOSITION_ID: {
                                    integerValue = template.getSupervisorAgent().getOrgPositionID();
                                    break;
                                }
                                case INSTANCE_INITIATOR_AGENT_ID: {
                                    integerValue = instance.getInitiatorAgent().getAgentID();
                                    break;
                                }
                                case INSTANCE_INITIATOR_ORGPOSITION_ID: {
                                    integerValue = instance.getInitiatorAgent().getOrgPositionID();
                                    break;
                                }
                                case INSTANCE_SUPERVISOR_AGENT_ID: {
                                    integerValue = instance.getSupervisorAgent().getAgentID();
                                    break;
                                }
                                case INSTANCE_SUPERVISOR_ORGPOSITION_ID: {
                                    integerValue = instance.getSupervisorAgent().getOrgPositionID();
                                    break;
                                }
                                case NODE_PERFORMING_AGENT_ID: {
                                    integerValue = instance.getPerformingAgent(nodeID).getAgentID();
                                    break;
                                }
                                case NODE_PERFORMING_ORGPOSITION_ID: {
                                    integerValue = instance.getPerformingAgent(nodeID).getOrgPositionID();
                                    break;
                                }
                                case NODE_STAFF_ASSIGNMENT_RULE: {
                                    subSession = this.executionManager.subSession(parentSession);
                                    Node wrappedNode = ParameterRefResolver.getProxy(node, Node.class, dataContainer, subSession, this.executionManager.getPluginRegistry());
                                    staffAssignmentRule = wrappedNode.getStaffAssignmentRule();
                                    break;
                                }
                                case NODE_TERMINATION_DATE: {
                                    integerValue = terminationTime;
                                    storeDate = true;
                                    break;
                                }
                                case INSTANCE_CREATION_DATE: {
                                    integerValue = instance.getCreationTime();
                                    storeDate = true;
                                    break;
                                }
                                default: {
                                    throw new AssertionError((Object)("unhandled system data producer: " + (Object)((Object)producer)));
                                }
                            }
                            try {
                                subSession = this.executionManager.subSession(parentSession);
                                if (staffAssignmentRule != null) {
                                    paa.storeString(subSession, instance.getID(), nodeID, iteration, dataElement.getID(), staffAssignmentRule);
                                    continue;
                                }
                                if (storeDate) {
                                    paa.storeDate(subSession, instance.getID(), nodeID, iteration, dataElement.getID(), new Date(integerValue));
                                    continue;
                                }
                                paa.storeInteger(subSession, instance.getID(), nodeID, iteration, dataElement.getID(), integerValue);
                            }
                            catch (InvalidDataTypeException ex) {
                                msg = "System parameter '%s' at node #%d in instance '%s' does not have the same data type as the data element #%d it is connected to (%s <-> %s)! Activity will be failed!";
                                msg = String.format(msg, new Object[]{param.getName(), nodeID, instance.getID(), dataElement.getID(), param.getDataType(), dataElement.getDataType()});
                                this.logger.log(Level.SEVERE, msg, ex);
                            }
                        }
                        subSession = this.executionManager.subSession(parentSession);
                        paa.validateWrittenValues(subSession, instance, nodeID, activity.getNodeIteration());
                        subSession = this.executionManager.subSession(parentSession);
                        InputDataContainer nodeDataContainer = paa.getNodeDataContainer(subSession, instance, nodeID);
                        long clientDelay = ActivityExecutionTools.getTerminationSignalDelay(subSession);
                        try {
                            node = ParameterRefResolver.getProxy(node, Node.class, nodeDataContainer, subSession, this.executionManager.getPluginRegistry());
                            String nodeName = node.getName();
                            this.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logNodeFinished(subSession, terminationTime, clientDelay, instance, activity.getNodeID(), nodeName, activity.getNodeIteration(), activity.getExecutionManagerURIs());
                        }
                        catch (DataSourceException ex) {
                            msg = "The node finish could not be logged to the execution history! [Timestamp(%s), Instance(%s), Node(%s), Iteration(%s), StateChange(%s), AgentID(%s), AgentOrgPositionID(%s)]";
                            QualifiedAgent qa = instance.getPerformingAgent(activity.getNodeID());
                            msg = String.format(msg, new Object[]{terminationTime, instance.getID(), activity.getNodeID(), activity.getNodeIteration(), ExecutionHistory.StateChange.NODE_FINISHED, qa.getAgentID(), qa.getOrgPositionID()});
                            this.logger.log(Level.SEVERE, msg, ex);
                        }
                        if (instance.getCurrentEnquiries(nodeID).size() == 0) {
                            subSession = this.executionManager.subSession(parentSession);
                            newNodeState = ProcessConstants.NodeState.NS_COMPLETED;
                            instance.setNodeState(nodeID, newNodeState);
                            if (nodeID != instance.getTemplate().getStartNode().getID() && nodeID != instance.getTemplate().getEndNode().getID()) {
                                instance.dropEnquiries(nodeID);
                                this.worklistAccess.removeActivity(subSession, activity);
                            }
                            String sdpAgentID = SystemDataProducer.NODE_PERFORMING_AGENT_ID.getParameterProperties().getName();
                            String sdpOrgPosID = SystemDataProducer.NODE_PERFORMING_ORGPOSITION_ID.getParameterProperties().getName();
                            URI[] runtimeManagerURIs = activity.getRuntimeManagerURIs();
                            if (clientDelay > 0L) {
                                terminationTime -= clientDelay;
                            }
                            this.checkAndSetAutostart(parentSession, instance, activity, sdpAgentID, sdpOrgPosID, runtimeManagerURIs, terminationTime);
                        } else {
                            subSession = this.executionManager.subSession(parentSession);
                            newNodeState = ProcessConstants.NodeState.NS_ENQUIRED;
                            instance.setNodeState(nodeID, newNodeState);
                            this.worklistAccess.updateActivityState(subSession, activity, newNodeState);
                        }
                        instance.increaseNodeIteration(nodeID);
                        if (!ProcessModelTools.isInParallelBranch(template, nodeID)) {
                            subSession = this.executionManager.subSession(parentSession);
                            Map<Integer, String> dataElements = ProcessModelTools.getWrittenDataElements(template, nodeID);
                            String instanceNameTemplate = template.getInstanceNameTemplate();
                            if (instanceNameTemplate == null) {
                                instanceNameTemplate = String.format("%1$s (%2$s)", template.getName(), new SimpleDateFormat().format(new Date()));
                            }
                            ParameterRef[] paramRefs = SystemDataTools.findParameterReferences(instanceNameTemplate);
                            boolean nameChanged = false;
                            int i = 0;
                            while (i < paramRefs.length) {
                                ParameterRef ref = paramRefs[i];
                                if (dataElements.containsValue(ref.getName())) {
                                    nameChanged = true;
                                    break;
                                }
                                ++i;
                            }
                            if (nameChanged) {
                                ProcessUnawareAccess pua = this.getProcessUnawareAccess(subSession, instance.getID());
                                HashSet<String> names = new HashSet<String>(paramRefs.length);
                                int i2 = 0;
                                while (i2 < paramRefs.length) {
                                    ParameterRef ref = paramRefs[i2];
                                    names.add(ref.getName());
                                    ++i2;
                                }
                                Set<Integer> allDataElements = ProcessModelTools.getDataElementIDsByName(template, names);
                                InputDataContainer puaContainer = pua.getInputDataContainer(subSession, instance, allDataElements);
                                Template templateRes = ParameterRefResolver.getProxy(template, Template.class, puaContainer, subSession, this.executionManager.getPluginRegistry());
                                String defInstanceName = templateRes.getInstanceNameTemplate();
                                HashMap<String, String> locInstanceNames = null;
                                PluginData pluginData = templateRes.getPluginData("ProcessLocalisation");
                                if (pluginData != null) {
                                    locInstanceNames = new HashMap<String, String>();
                                    for (Map.Entry<String, String> entry : pluginData.getPluginData().entrySet()) {
                                        if (!entry.getKey().startsWith("InstanceNameTemplate.")) continue;
                                        String locale = entry.getKey().substring(entry.getKey().indexOf(46) + 1);
                                        locInstanceNames.put(locale, entry.getValue());
                                    }
                                }
                                instance.setInstanceName(defInstanceName, locInstanceNames);
                            }
                        }
                        try {
                            subSession = this.executionManager.subSession(parentSession);
                            this.adaptInstanceExecutionStatus(subSession, instance);
                        }
                        catch (LockException le) {
                            msg = "activityFinished: LockException while setting execution status of instance ('%1$s'). An execution lock is missing although we have retrieved an executable instance. Please set the execution state manually! Continuing.";
                            msg = String.format(msg, instance.getID());
                            this.logger.log(Level.SEVERE, msg, le);
                        }
                        subSession = this.executionManager.subSession(parentSession);
                        this.instanceExecution.afterFinished(subSession, instance, activity);
                        this.signalActivityTermination(activity);
                        subSession = this.executionManager.subSession(parentSession);
                        this.getInstanceManager().setExecutableInstance(subSession, instance);
                        successful = true;
                    }
                    catch (InvalidDataContainerException e) {
                        String msg2 = "activityFinished: InvalidDataContainerException while flushing the data container for node '%s', iteration '%s' of instance '%s'.";
                        msg2 = String.format(msg2, nodeID, instance.getNodeIteration(nodeID), instance.getID());
                        this.logger.log(Level.SEVERE, msg2, e);
                        try {
                            subSession = this.executionManager.subSession(parentSession);
                            this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                            break block55;
                        }
                        catch (LockException le) {
                            msg2 = "activityFinished: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                            msg2 = String.format(msg2, instance.getID());
                            this.logger.log(Level.SEVERE, msg2, le);
                            throw new InternalServiceException(msg2);
                        }
                    }
                    catch (LockException le) {
                        try {
                            String msg3 = "activityFinished: Cannot store the executable instance '%1$s'. It is locked by another user. Aborting finishing of activity '%2$s'.";
                            msg3 = String.format(msg3, instance.getID(), activity);
                            this.logger.log(Level.SEVERE, msg3, le);
                            throw new InternalServiceException(msg3);
                        }
                        catch (Throwable throwable) {
                            try {
                                subSession = this.executionManager.subSession(parentSession);
                                this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                            }
                            catch (LockException le2) {
                                String msg4 = "activityFinished: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                                msg4 = String.format(msg4, instance.getID());
                                this.logger.log(Level.SEVERE, msg4, le2);
                                throw new InternalServiceException(msg4);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        subSession = this.executionManager.subSession(parentSession);
                        this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                    }
                    catch (LockException le) {
                        msg = "activityFinished: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                        msg = String.format(msg, instance.getID());
                        this.logger.log(Level.SEVERE, msg, le);
                        throw new InternalServiceException(msg);
                    }
                }
                subSession = this.executionManager.subSession(parentSession);
                if (successful) {
                    ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), activity, instance, newNodeState, this.logger);
                }
            }
            catch (ValidationFailedException vfe) {
                this.activityFailed(this.executionManager.subSession(parentSession), activity, dataContainer, vfe.getMessage(), "ADEPT2:ExecutionManager:ActivityTermination:DataValidationFailed", 5L);
                super.sessionFinished(parentSession);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void activitySuspended(SessionToken parentSession, EBPInstanceReference activity, DataContainer dataContainer) throws InvalidActivityStateException {
        super.sessionActive(parentSession);
        try {
            ExecutableInstance instance;
            SessionToken subSession;
            boolean successful;
            block24: {
                String msg;
                successful = false;
                QualifiedAgent agent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
                subSession = this.executionManager.subSession(parentSession);
                int nodeID = activity.getNodeID();
                try {
                    instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, activity.getInstanceID());
                }
                catch (LockException e) {
                    throw ActivityExecutionTools.wrapLockException(e, "suspend activity", nodeID, activity.getInstanceID());
                }
                try {
                    InstanceStatus instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, activity.getInstanceID());
                    ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                    ActivityExecutionTools.checkActivityForSuspension(instance, activity, this.logger, false);
                    subSession = this.executionManager.subSession(parentSession);
                    this.getProcessAwareAccess(subSession, activity.getInstanceID()).flushDataContainer(subSession, instance, nodeID, instance.getNodeIteration(nodeID), dataContainer);
                    instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_SUSPENDED);
                    subSession = this.executionManager.subSession(parentSession);
                    long timestamp = System.currentTimeMillis();
                    long clientDelay = ActivityExecutionTools.getTerminationSignalDelay(subSession);
                    try {
                        this.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logNodeSuspended(subSession, timestamp, clientDelay, instance, activity.getNodeID(), activity.getNodeIteration());
                    }
                    catch (DataSourceException ex) {
                        msg = "The node suspend could not be logged to the execution history! [Timestamp(%s), Instance(%s), Node(%s), Iteration(%s), StateChange(%s), AgentID(%s), AgentOrgPositionID(%s)]";
                        msg = String.format(msg, new Object[]{timestamp, instance.getID(), activity.getNodeID(), activity.getNodeIteration(), ExecutionHistory.StateChange.NODE_SUSPENDED, agent.getAgentID(), agent.getOrgPositionID()});
                        this.logger.log(Level.SEVERE, msg, ex);
                    }
                    subSession = this.executionManager.subSession(parentSession);
                    if (instanceStatus.getExecutionStatus() == ProcessConstants.InstanceExecutionStatus.IE_RUNNING) {
                        this.worklistAccess.updateActivityState(subSession, activity, ProcessConstants.NodeState.NS_SUSPENDED);
                    } else {
                        this.worklistAccess.removeActivity(subSession, activity);
                    }
                    try {
                        subSession = this.executionManager.subSession(parentSession);
                        this.adaptInstanceExecutionStatus(subSession, instance);
                    }
                    catch (LockException le) {
                        msg = "activitySuspended: LockException while setting execution status of instance ('%1$s'). An execution lock is missing although we have retrieved an executable instance. Please set the execution state manually! Continuing.";
                        msg = String.format(msg, instance.getID());
                        this.logger.log(Level.SEVERE, msg, le);
                    }
                    this.signalActivityTermination(activity);
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                    successful = true;
                }
                catch (InvalidDataContainerException e) {
                    String msg2 = "activityFinished: InvalidDataContainerException while flushing the data container for node '%s', iteration '%s' of instance '%s'.";
                    msg2 = String.format(msg2, nodeID, instance.getNodeIteration(nodeID), instance.getID());
                    this.logger.log(Level.SEVERE, msg2, e);
                    try {
                        subSession = this.executionManager.subSession(parentSession);
                        this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                        break block24;
                    }
                    catch (LockException le) {
                        msg2 = "activitySuspended: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                        msg2 = String.format(msg2, instance.getID());
                        this.logger.log(Level.SEVERE, msg2, le);
                        throw new InternalServiceException(msg2);
                    }
                }
                catch (LockException le) {
                    try {
                        String msg3 = "activityFinished: Cannot store the executable instance '%1$s'. It is locked by another user. Aborting finishing of activity '%2$s'.";
                        msg3 = String.format(msg3, instance.getID(), activity);
                        this.logger.log(Level.SEVERE, msg3, le);
                        throw new InternalServiceException(msg3);
                    }
                    catch (Throwable throwable) {
                        try {
                            subSession = this.executionManager.subSession(parentSession);
                            this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                        }
                        catch (LockException le2) {
                            String msg4 = "activitySuspended: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                            msg4 = String.format(msg4, instance.getID());
                            this.logger.log(Level.SEVERE, msg4, le2);
                            throw new InternalServiceException(msg4);
                        }
                        throw throwable;
                    }
                }
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                }
                catch (LockException le) {
                    msg = "activitySuspended: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg = String.format(msg, instance.getID());
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
            }
            if (successful) {
                subSession = this.executionManager.subSession(parentSession);
                ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), activity, instance, ProcessConstants.NodeState.NS_SUSPENDED, this.logger);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void activityReset(SessionToken parentSession, EBPInstanceReference activity) throws InvalidActivityStateException {
        super.sessionActive(parentSession);
        try {
            String msg;
            ExecutableInstance instance;
            boolean successful = false;
            QualifiedAgent resettingAgent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken subSession = this.executionManager.subSession(parentSession);
            UUID instanceID = activity.getInstanceID();
            try {
                instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
            }
            catch (LockException e) {
                throw ActivityExecutionTools.wrapLockException(e, "reset activity", activity.getNodeID(), activity.getInstanceID());
            }
            try {
                try {
                    int nodeID = activity.getNodeID();
                    ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                    ActivityExecutionTools.checkActivityForSoftReset(instance, activity, resettingAgent, this.logger);
                    subSession = this.executionManager.subSession(parentSession);
                    DataManager dataManager = this.executionManager.getResolvedDataManager(subSession, instanceID);
                    int nodeIteration = activity.getNodeIteration();
                    dataManager.getProcessAwareAccess().dropWrittenValues(subSession, instance, nodeID, nodeIteration);
                    Template template = instance.getTemplate();
                    Node tempNode = template.getNode(nodeID);
                    int connectorID = tempNode.getConnector(SystemDataProducer.NODE_PERFORMING_AGENT_ID.getParameterProperties().getName(), ActivityConstants.AccessType.SYSTEM_WRITE);
                    if (connectorID != Integer.MIN_VALUE) {
                        int[] successors;
                        DataElement dataElement = template.getDataElement(nodeID, connectorID);
                        int[] nArray = successors = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_READ);
                        int n = successors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int succNodeID = nArray[n2];
                            Node node = template.getNode(succNodeID);
                            if (node.isAutoStartEnabled()) {
                                instance.setAssignedRuntimeManager(succNodeID, null);
                                instance.setPerformingAgent(succNodeID, null);
                            }
                            ++n2;
                        }
                    }
                    instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_ACTIVATED);
                    subSession = this.executionManager.subSession(parentSession);
                    long timestamp = System.currentTimeMillis();
                    long clientDelay = ActivityExecutionTools.getTerminationSignalDelay(subSession);
                    try {
                        this.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logNodeResetSoft(subSession, timestamp, clientDelay, instance, activity.getNodeID(), activity.getNodeIteration());
                    }
                    catch (DataSourceException ex) {
                        msg = "The node reset could not be logged to the execution history! [Timestamp(%s), Instance(%s), Node(%s), Iteration(%s), StateChange(%s), PerformingAgentID(%s), PerformingAgentOrgPositionID(%s), ResettingAgentID(%s), ResettingAgentOrgPositionID(%s)]";
                        QualifiedAgent qa = instance.getPerformingAgent(nodeID);
                        msg = String.format(msg, new Object[]{timestamp, instance.getID(), nodeID, nodeIteration, ExecutionHistory.StateChange.NODE_FAILED, qa.getAgentID(), qa.getOrgPositionID(), resettingAgent.getAgentID(), resettingAgent.getOrgPositionID()});
                        this.logger.log(Level.SEVERE, msg, ex);
                    }
                    instance.setPerformingAgent(nodeID, null);
                    instance.setAssignedRuntimeManager(nodeID, null);
                    InstanceStatus status = this.getInstanceManager().getInstanceStatus(subSession, instance.getID());
                    subSession = this.executionManager.subSession(parentSession);
                    if (status.getExecutionStatus() == ProcessConstants.InstanceExecutionStatus.IE_RUNNING) {
                        this.worklistAccess.updateActivityState(subSession, activity, ProcessConstants.NodeState.NS_ACTIVATED);
                    } else {
                        this.worklistAccess.removeActivity(subSession, activity);
                    }
                    try {
                        subSession = this.executionManager.subSession(parentSession);
                        this.adaptInstanceExecutionStatus(subSession, instance);
                    }
                    catch (LockException le) {
                        msg = "activityReset: LockException while setting execution status of instance ('%1$s'). An execution lock is missing although we have retrieved an executable instance. Please set the execution state manually! Continuing.";
                        msg = String.format(msg, instanceID);
                        this.logger.log(Level.SEVERE, msg, le);
                    }
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                }
                catch (LockException le) {
                    String msg2 = "activityReset: Cannot store the executable instance '%1$s'. It is locked by another user. Aborting reset of activity '%2$s'.";
                    msg2 = String.format(msg2, instance.getID(), activity);
                    this.logger.log(Level.SEVERE, msg2, le);
                    throw new InternalServiceException(msg2);
                }
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                }
                catch (LockException le) {
                    String msg3 = "activityReset: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg3 = String.format(msg3, instance.getID());
                    this.logger.log(Level.SEVERE, msg3, le);
                    throw new InternalServiceException(msg3);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
            }
            catch (LockException le) {
                msg = "activityReset: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                msg = String.format(msg, instance.getID());
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
            if (successful) {
                subSession = this.executionManager.subSession(parentSession);
                ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), activity, instance, ProcessConstants.NodeState.NS_ACTIVATED, this.logger);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void activityFailed(SessionToken parentSession, EBPInstanceReference activity, DataContainer dataContainer, String errorMessage, String state, long errorCode) throws InvalidActivityStateException {
        block33: {
            super.sessionActive(parentSession);
            try {
                ErrorHandlingProcessData data;
                String msg;
                ExecutableInstance instance;
                int nodeID;
                SessionToken subSession;
                QualifiedAgent agent;
                boolean successful;
                block32: {
                    successful = false;
                    agent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
                    subSession = this.executionManager.subSession(parentSession);
                    nodeID = activity.getNodeID();
                    try {
                        instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, activity.getInstanceID());
                    }
                    catch (LockException e) {
                        throw ActivityExecutionTools.wrapLockException(e, "fail activity", nodeID, activity.getInstanceID());
                    }
                    try {
                        ActivityExecutionTools.checkEBPInstanceReference(activity, this.getURIs(), instance);
                        ActivityExecutionTools.checkActivityForFailing(instance, activity, this.logger);
                        subSession = this.executionManager.subSession(parentSession);
                        this.getProcessAwareAccess(subSession, activity.getInstanceID()).flushDataContainer(subSession, instance, nodeID, instance.getNodeIteration(nodeID), dataContainer);
                        subSession = this.executionManager.subSession(parentSession);
                        long timestamp = System.currentTimeMillis();
                        long clientDelay = ActivityExecutionTools.getTerminationSignalDelay(subSession);
                        try {
                            this.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logNodeFailed(subSession, timestamp, clientDelay, instance, activity.getNodeID(), activity.getNodeIteration(), errorCode, state, errorMessage);
                        }
                        catch (DataSourceException ex) {
                            msg = "The node failure could not be logged to the execution history! [Timestamp(%s), Instance(%s), Node(%s), Iteration(%s), StateChange(%s), AgentID(%s), AgentOrgPositionID(%s), ErrorCode(%d), ErrorState(%s), ErrorMessage(%s)]";
                            QualifiedAgent qa = instance.getPerformingAgent(activity.getNodeID());
                            msg = String.format(msg, new Object[]{timestamp, instance.getID(), activity.getNodeID(), activity.getNodeIteration(), ExecutionHistory.StateChange.NODE_FAILED, qa.getAgentID(), qa.getOrgPositionID(), errorCode, state, errorMessage});
                            this.logger.log(Level.SEVERE, msg, ex);
                        }
                        instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_FAILED);
                        subSession = this.executionManager.subSession(parentSession);
                        instance.dropEnquiries(nodeID);
                        this.worklistAccess.removeActivity(subSession, activity);
                        try {
                            subSession = this.executionManager.subSession(parentSession);
                            this.adaptInstanceExecutionStatus(subSession, instance);
                        }
                        catch (LockException le) {
                            msg = "activityFailed: LockException while setting execution status of instance ('%1$s'). An execution lock is missing although we have retrieved an executable instance. Please set the execution state manually! Continuing.";
                            msg = String.format(msg, instance.getID());
                            this.logger.log(Level.SEVERE, msg, le);
                        }
                        this.instanceExecution.afterFailed(subSession, instance, activity, dataContainer, errorCode, state, errorMessage);
                        this.signalActivityTermination(activity);
                        subSession = this.executionManager.subSession(parentSession);
                        this.getInstanceManager().setExecutableInstance(subSession, instance);
                        successful = true;
                    }
                    catch (InvalidDataContainerException e) {
                        msg = "activityFinished: InvalidDataContainerException while flushing the data container for node '%s', iteration '%s' of instance '%s'";
                        msg = String.format(msg, nodeID, instance.getNodeIteration(nodeID), instance.getID());
                        this.logger.log(Level.SEVERE, msg, e);
                        try {
                            subSession = this.executionManager.subSession(parentSession);
                            this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                            break block32;
                        }
                        catch (LockException le) {
                            msg = "activityFailed: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                            msg = String.format(msg, instance.getID());
                            this.logger.log(Level.SEVERE, msg, le);
                            throw new InternalServiceException(msg);
                        }
                    }
                    catch (LockException le) {
                        try {
                            String msg2 = "activityFailed: Cannot store the executable instance '%1$s'. It is locked by another user. Aborting failing of activity '%2$s'.";
                            msg2 = String.format(msg2, instance.getID(), activity);
                            this.logger.log(Level.SEVERE, msg2, le);
                            throw new InternalServiceException(msg2);
                        }
                        catch (Throwable throwable) {
                            try {
                                subSession = this.executionManager.subSession(parentSession);
                                this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                            }
                            catch (LockException le2) {
                                String msg3 = "activityFailed: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                                msg3 = String.format(msg3, instance.getID());
                                this.logger.log(Level.SEVERE, msg3, le2);
                                throw new InternalServiceException(msg3);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        subSession = this.executionManager.subSession(parentSession);
                        this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                    }
                    catch (LockException le) {
                        msg = "activityFailed: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                        msg = String.format(msg, instance.getID());
                        this.logger.log(Level.SEVERE, msg, le);
                        throw new InternalServiceException(msg);
                    }
                }
                if (!successful) break block33;
                subSession = this.executionManager.subSession(parentSession);
                ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), activity, instance, ProcessConstants.NodeState.NS_FAILED, this.logger);
                SessionToken errorHandlingSession = this.executionManager.newSession(subSession);
                UUID errorHandlingTemplateID = null;
                UUID defaultErrorHandlingTemplateID = null;
                String defaultIDString = this.executionManager.getConfiguration(errorHandlingSession).getString("DefaultErrorHandlingProcess");
                if (defaultIDString != null) {
                    try {
                        defaultErrorHandlingTemplateID = UUID.fromString(defaultIDString);
                    }
                    catch (IllegalArgumentException e) {
                        String message = String.format("Illegal runtime configuration value for the error handling process: '%s' not a valid UUID.", defaultIDString);
                        this.logger.log(Level.SEVERE, message, e);
                    }
                }
                Node node = instance.getTemplate().getNode(nodeID);
                ProcessAwareAccess paa = this.getProcessAwareAccess(errorHandlingSession, instance.getID());
                InputDataContainer nodeDataContainer = paa.getNodeDataContainer(subSession, instance, nodeID);
                node = ParameterRefResolver.getProxy(node, Node.class, nodeDataContainer, subSession, this.executionManager.getPluginRegistry());
                String ecName = null;
                if (node.getExecutableBusinessProcess() instanceof Activity) {
                    ecName = ((Activity)node.getExecutableBusinessProcess()).getExecutableComponentName();
                }
                if (node.getPluginDatas().containsKey("ErrorHandlingProcessData")) {
                    data = ModelViewer.createView(node.getPluginData("ErrorHandlingProcessData").getPluginData(), ErrorHandlingProcessData.class);
                    errorHandlingTemplateID = data.getTemplateID();
                }
                if (errorHandlingTemplateID == null && instance.getTemplate().getPluginDatas().containsKey("ErrorHandlingProcessData")) {
                    data = ModelViewer.createView(instance.getTemplate().getPluginData("ErrorHandlingProcessData").getPluginData(), ErrorHandlingProcessData.class);
                    errorHandlingTemplateID = data.getTemplateID();
                }
                if (errorHandlingTemplateID == null) {
                    errorHandlingTemplateID = defaultErrorHandlingTemplateID;
                }
                if (instance.getBaseTemplateID().equals(errorHandlingTemplateID) || instance.getBaseTemplateID().equals(defaultErrorHandlingTemplateID)) {
                    this.handleErrorHandlingLoop();
                } else if (errorHandlingTemplateID != null) {
                    this.executorService.execute(new ErrorHandlingInstantiation(errorHandlingSession, activity, ecName, errorHandlingTemplateID, instance.getName(), instance.getBaseTemplateID(), instance.getTemplate().getName(), node.getName(), node.getStaffAssignmentRule(), dataContainer, agent, errorCode, state, errorMessage, instance.getSupervisorAgent(), this.logger));
                } else {
                    msg = "There is no default error handling process set! Setting an default error handling process is highly recommended! Logging the error instead:\nActivity:        %s\nTemplate name:   %s\nInstance name:   %s\nNode name:       %s\nECName:          %s\nExecuting agent: %s\nError message:   %s\nError state:     %s\nError code:      %s\n";
                    msg = String.format(msg, activity, instance.getTemplate().getName(), instance.getName(), node.getName(), ecName, agent, errorMessage, state, errorCode);
                    this.logger.severe(msg);
                }
            }
            finally {
                super.sessionFinished(parentSession);
            }
        }
    }

    private void handleErrorHandlingLoop() {
        this.logger.severe("An activity in an error handling process failed and the error handling process to be instantiated was of the same type, ie. there is a direct cycle within the error handling process, or the default error handling process has another error handling process configured.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CountDownLatch getFlagForActivityTermination(EBPInstanceReference activity) {
        if (activity == null) {
            throw new NullArgumentException("Activity must be specified, i. e. null must not be passed to activity.");
        }
        Map<EBPInstanceReference, CountDownLatch> map = this.waitersForTerminationAcknowledgement;
        synchronized (map) {
            CountDownLatch latch = this.waitersForTerminationAcknowledgement.get(activity);
            if (latch == null) {
                latch = new CountDownLatch(1);
                this.waitersForTerminationAcknowledgement.put(activity, latch);
            }
            return latch;
        }
    }

    protected void adaptInstanceExecutionStatus(SessionToken session, ExecutableInstance instance) throws LockException {
        int[] runningNodes;
        SessionToken subSession = this.executionManager.subSession(session);
        InstanceStatus status = this.getInstanceManager().getInstanceStatus(subSession, instance.getID());
        if ((status.getExecutionStatus() == ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_SUSPENDED || status.getExecutionStatus() == ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_ABORTED) && (runningNodes = instance.getNodesInState(ProcessConstants.NodeState.NS_RUNNING)).length <= 0) {
            subSession = this.executionManager.subSession(session);
            switch (status.getExecutionStatus()) {
                case IE_SOFTLY_SUSPENDED: {
                    this.getInstanceManager().setExecutionStatus(subSession, instance.getID(), ProcessConstants.InstanceExecutionStatus.IE_SUSPENDED, status.getExecutionStatusComment());
                    break;
                }
                case IE_SOFTLY_ABORTED: {
                    this.getInstanceManager().setExecutionStatus(subSession, instance.getID(), ProcessConstants.InstanceExecutionStatus.IE_ABORTED, status.getExecutionStatusComment());
                    break;
                }
                default: {
                    String msg = String.format("Nonrelevant execution status '%s' found!", new Object[]{status.getExecutionStatus()});
                    this.logger.finest(msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalActivityTermination(EBPInstanceReference activity) {
        Map<EBPInstanceReference, CountDownLatch> map = this.waitersForTerminationAcknowledgement;
        synchronized (map) {
            CountDownLatch latch = this.waitersForTerminationAcknowledgement.remove(activity);
            if (latch != null) {
                latch.countDown();
            }
        }
    }

    protected void checkAndSetAutostart(SessionToken session, ExecutableInstance instance, EBPInstanceReference activity, String sdpAgentID, String sdpOrgPosID, URI[] runtimeManagerURIs, long terminationTime) {
        Template template = instance.getTemplate();
        int nodeID = activity.getNodeID();
        Node tempNode = template.getNode(nodeID);
        int[] agentAccessors = null;
        int agentConnectorID = tempNode.getConnector(sdpAgentID, ActivityConstants.AccessType.SYSTEM_WRITE);
        if (agentConnectorID != Integer.MIN_VALUE) {
            DataElement de = template.getDataElement(nodeID, agentConnectorID);
            agentAccessors = template.getAccessingNodeIDsForDataElement(de.getID(), ActivityConstants.AccessType.SYSTEM_READ);
        }
        if (agentAccessors != null) {
            int n;
            int n2;
            int[] nArray;
            HashSet<Integer> orgPosAccessors = new HashSet<Integer>();
            int orgPosConnectorID = tempNode.getConnector(sdpOrgPosID, ActivityConstants.AccessType.SYSTEM_WRITE);
            if (orgPosConnectorID != Integer.MIN_VALUE) {
                DataElement de = template.getDataElement(nodeID, orgPosConnectorID);
                nArray = template.getAccessingNodeIDsForDataElement(de.getID(), ActivityConstants.AccessType.SYSTEM_READ);
                n2 = nArray.length;
                n = 0;
                while (n < n2) {
                    int accessingID = nArray[n];
                    orgPosAccessors.add(accessingID);
                    ++n;
                }
            }
            try {
                String token = this.executionManager.getSerialisedUserData(session);
                nArray = agentAccessors;
                n2 = agentAccessors.length;
                n = 0;
                while (n < n2) {
                    int accessingNodeID = nArray[n];
                    Node accessingNode = template.getNode(accessingNodeID);
                    if (accessingNode.isAutoStartEnabled() && runtimeManagerURIs != null) {
                        this.logger.fine("Prepared autostart for " + accessingNode);
                        instance.setPerformingAgent(accessingNodeID, this.executionManager.checkAndGetTopLevelAgent(session));
                        instance.setAssignedRuntimeManager(accessingNodeID, runtimeManagerURIs);
                        instance.setUserAttributeValue("AutoStartUserData" + accessingNodeID, token);
                        instance.setUserAttributeValue("AutoStartTime" + accessingNodeID, Long.toString(terminationTime));
                    }
                    ++n;
                }
            }
            catch (SecurityTokenIntegrityException stie) {
                String msg = String.format("There were problems serialising the necessary  information for setting the autostart for the successors of node '%s'. Ignoring autostart.", activity);
                this.logger.log(Level.INFO, msg, stie);
            }
        }
    }

    protected ExecutionHistory getExecutionHistory(SessionToken session, UUID instanceID) {
        return this.executionManager.getExecutionHistory(session, instanceID);
    }

    protected ProcessAwareAccess getProcessAwareAccess(SessionToken session, UUID instanceID) {
        return this.executionManager.getResolvedDataManager(session, instanceID).getProcessAwareAccess();
    }

    protected ProcessUnawareAccess getProcessUnawareAccess(SessionToken session, UUID instanceID) {
        return this.executionManager.getResolvedDataManager(session, instanceID).getProcessUnawareAccess();
    }

    protected InstanceManager getInstanceManager() {
        return this.executionManager.getProcessManager().getInstanceManager();
    }

    protected UpdateManager getUpdateManager(SessionToken session) {
        return this.executionManager.getUpdateManager(session);
    }

    protected class ErrorHandlingInstantiation
    implements Runnable {
        private final SessionToken session;
        private final EBPInstanceReference activity;
        private final UUID errorHandlingTemplateID;
        private final DataContainer dataContainer;
        private final String errorMessage;
        private final String errorState;
        private final long errorCode;
        private final String instanceName;
        private final UUID baseTemplateID;
        private final QualifiedAgent executingAgent;
        private final String templateName;
        private final String nodeName;
        private final String nodeStaffAssignmentRule;
        private final Logger logger;
        private final String executableComponentName;
        private final QualifiedAgent instanceSupervisor;

        public ErrorHandlingInstantiation(SessionToken sessionToken, EBPInstanceReference activity, String ecName, UUID errorHandlingTemplateID, String instanceName, UUID baseTemplateID, String templateName, String nodeName, String nodeStaffAssignmentRule, DataContainer dataContainer, QualifiedAgent executingAgent, long errorCode, String errorState, String errorMessage, QualifiedAgent instanceSupervisor, Logger logger) {
            this.session = sessionToken;
            this.activity = activity;
            this.errorHandlingTemplateID = errorHandlingTemplateID;
            this.instanceName = instanceName;
            this.baseTemplateID = baseTemplateID;
            this.templateName = templateName;
            this.nodeName = nodeName;
            this.nodeStaffAssignmentRule = nodeStaffAssignmentRule;
            this.dataContainer = dataContainer;
            this.executingAgent = executingAgent;
            this.errorMessage = errorMessage;
            this.errorState = errorState;
            this.errorCode = errorCode;
            this.logger = logger;
            this.executableComponentName = ecName;
            this.instanceSupervisor = instanceSupervisor;
        }

        @Override
        public void run() {
            String message;
            String message2;
            InstanceDataContainer errorDataContainer;
            try {
                errorDataContainer = DefaultActivityTermination.this.instanceControl.createInstanceDataContainer(this.session, this.errorHandlingTemplateID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String msg = String.format("Error handling template '%s' configured, but not available in process manager! Logging the error instead:\nActivity:        %s\nTemplate name:   %s\nInstance name:   %s\nNode name:       %s\nECName:          %s\nExecuting agent: %s\nError message:   %s\nError state:     %s\nError code:      %s\n", this.errorHandlingTemplateID, this.activity, this.templateName, this.instanceName, this.nodeName, this.executableComponentName, this.executingAgent, this.errorMessage, this.errorState, this.errorCode);
                this.logger.severe(msg);
                return;
            }
            try {
                byte[] data;
                errorDataContainer.setInteger(ErrorHandlingProcessData.ErrorHandlingParameter.EBP_TYPE.parameterName, this.activity.getType().getCode());
                if (this.executableComponentName != null) {
                    errorDataContainer.setString(ErrorHandlingProcessData.ErrorHandlingParameter.EC_NAME.parameterName, this.executableComponentName);
                }
                errorDataContainer.setString(ErrorHandlingProcessData.ErrorHandlingParameter.INSTANCE_ID.parameterName, this.activity.getInstanceID().toString());
                errorDataContainer.setString(ErrorHandlingProcessData.ErrorHandlingParameter.INSTANCE_NAME.parameterName, this.instanceName);
                errorDataContainer.setBoolean(ErrorHandlingProcessData.ErrorHandlingParameter.IS_ACTIVITY.parameterName, this.activity.isActivity());
                errorDataContainer.setInteger(ErrorHandlingProcessData.ErrorHandlingParameter.ITERATION_ID.parameterName, this.activity.getNodeIteration());
                errorDataContainer.setInteger(ErrorHandlingProcessData.ErrorHandlingParameter.NODE_ID.parameterName, this.activity.getNodeID());
                errorDataContainer.setString(ErrorHandlingProcessData.ErrorHandlingParameter.NODE_NAME.parameterName, this.nodeName);
                errorDataContainer.setString(ErrorHandlingProcessData.ErrorHandlingParameter.NODE_STAFF_ASSIGNMENT_RULE.parameterName, this.nodeStaffAssignmentRule);
                errorDataContainer.setInteger(ErrorHandlingProcessData.ErrorHandlingParameter.PERFORMING_AGENT_AGENT_ID.parameterName, this.executingAgent.getAgentID());
                errorDataContainer.setInteger(ErrorHandlingProcessData.ErrorHandlingParameter.PERFORMING_AGENT_ORG_POSITION_ID.parameterName, this.executingAgent.getOrgPositionID());
                errorDataContainer.setString(ErrorHandlingProcessData.ErrorHandlingParameter.TEMPLATE_ID.parameterName, this.baseTemplateID.toString());
                errorDataContainer.setString(ErrorHandlingProcessData.ErrorHandlingParameter.TEMPLATE_NAME.parameterName, this.templateName);
                errorDataContainer.setInteger(ErrorHandlingProcessData.ErrorHandlingParameter.ERROR_CODE.parameterName, this.errorCode);
                if (this.errorState != null) {
                    errorDataContainer.setString(ErrorHandlingProcessData.ErrorHandlingParameter.ERROR_STATE.parameterName, this.errorState);
                }
                if (this.errorMessage != null) {
                    errorDataContainer.setString(ErrorHandlingProcessData.ErrorHandlingParameter.ERROR_MESSAGE.parameterName, this.errorMessage);
                }
                try {
                    errorDataContainer.setInteger(ErrorHandlingProcessData.ErrorHandlingParameter.INSTANCE_SUPERVISOR_AGENT_ID.parameterName, this.instanceSupervisor.getAgentID());
                }
                catch (NoSuchParameterException e) {
                    message2 = String.format("The error handling template with ID %s, started for instance with ID %s, node with ID %s, is missing a parameter!", this.errorHandlingTemplateID, this.activity.getInstanceID(), this.activity.getNodeID());
                    this.logger.log(Level.WARNING, message2, e);
                }
                try {
                    errorDataContainer.setInteger(ErrorHandlingProcessData.ErrorHandlingParameter.INSTANCE_SUPERVISOR_ORG_POSITION_ID.parameterName, this.instanceSupervisor.getOrgPositionID());
                }
                catch (NoSuchParameterException e) {
                    message2 = String.format("The error handling template with ID %s, started for instance with ID %s, node with ID %s, is missing a parameter!", this.errorHandlingTemplateID, this.activity.getInstanceID(), this.activity.getNodeID());
                    this.logger.log(Level.WARNING, message2, e);
                }
                Document doc = DataContainerXMLExport.getDocumentForDataContainer(this.dataContainer);
                try {
                    data = XMLHelperTools.getByteArrayForDocument(doc);
                }
                catch (IOException e) {
                    message = String.format("IO Exception while serialising the data container of the failed activity: %s. Will try to continue with an empty UDT stream.", e.getMessage());
                    this.logger.log(Level.SEVERE, message, e);
                    data = new byte[]{};
                }
                ADEPT2UDTValue value = new ADEPT2UDTValue(ErrorHandlingProcessData.ErrorHandlingParameter.DATA_CONTEXT.udtName, data);
                errorDataContainer.setUDT(ErrorHandlingProcessData.ErrorHandlingParameter.DATA_CONTEXT.parameterName, value);
            }
            catch (InvalidDataTypeException e) {
                message2 = String.format("The error handling template with ID %s, started for instance with ID %s, node with ID %s, has a parameter with the wrong data type!", this.errorHandlingTemplateID, this.activity.getInstanceID(), this.activity.getNodeID());
                this.logger.log(Level.SEVERE, message2, e);
            }
            catch (NoSuchParameterException e) {
                message2 = String.format("The error handling template with ID %s, started for instance with ID %s, node with ID %s, is missing a parameter!", this.errorHandlingTemplateID, this.activity.getInstanceID(), this.activity.getNodeID());
                this.logger.log(Level.SEVERE, message2, e);
            }
            QualifiedAgent systemAgent = DefaultActivityTermination.this.executionManager.checkAndGetTopLevelAgent(this.session);
            ExecutionContext executionContext = DefaultActivityTermination.this.executionManager.getExecutionFactory().getExecutionContext(systemAgent, null, errorDataContainer, null, null);
            try {
                DefaultActivityTermination.this.instanceControl.createAndStartInstance(this.session, this.errorHandlingTemplateID, executionContext, null);
            }
            catch (InvalidTemplateStateException e) {
                message = String.format("The error handling template with ID %s, started for instance with ID %s, node with ID %s, has an invalid state!", this.errorHandlingTemplateID, this.activity.getInstanceID(), this.activity.getNodeID());
                this.logger.log(Level.SEVERE, message, e);
            }
            catch (InvalidDataContainerException e) {
                message = String.format("The error handling template with ID %s, started for instance with ID %s, node with ID %s, has an invalid set of input parameters, or the input data container could not set up correctly!", this.errorHandlingTemplateID, this.activity.getInstanceID(), this.activity.getNodeID());
                this.logger.log(Level.SEVERE, message, e);
            }
        }
    }
}

