/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution;

import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionTools;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.DefaultActivityTermination;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.StartEndNodeHandling;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.model.runtimeenvironment.ApplicationFailedException;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.LockException;
import java.net.URI;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DefaultStartEndNodeHandling
extends AbstractSubService
implements StartEndNodeHandling {
    protected final DefaultExecutionManager executionManager;
    protected final DefaultActivityTermination activityTermination;
    protected ExecutorService executorService;

    public DefaultStartEndNodeHandling(DefaultExecutionManager executionManager, DefaultActivityTermination activityTermination) {
        super(new String[]{"ProcessManager", "DataManager", "UpdateManager"}, new String[0], executionManager);
        this.executionManager = executionManager;
        this.activityTermination = activityTermination;
    }

    @Override
    public void init() {
        this.executorService = Executors.newCachedThreadPool(new Adept2ThreadFactory("StartEndNodeHandling"));
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        this.awaitExecutorServiceShutdown();
    }

    @Override
    public void emergencyShutdown() {
        this.executorService.shutdownNow();
        this.awaitExecutorServiceShutdown();
    }

    private void awaitExecutorServiceShutdown() {
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void executeStartActivity(SessionToken parentSession, SessionToken autoStartSessionToken, EBPInstanceReference startActivity, ProcessConstants.ExecutionMode executionMode, DataContainer instanceDataContainer) throws InvalidActivityStateException {
        super.sessionActive(parentSession);
        try {
            ExecutableInstance instance;
            QualifiedAgent agent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken subSession = this.executionManager.subSession(parentSession);
            try {
                instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, startActivity.getInstanceID());
            }
            catch (LockException e) {
                throw ActivityExecutionTools.wrapLockException(e, "execute start activity", startActivity.getNodeID(), startActivity.getInstanceID());
            }
            ApplicationFailedException applicationFailed = null;
            DataContainer nodeDataContainer = this.getDataManager(subSession, startActivity.getInstanceID()).getProcessAwareAccess().getDataContainer(subSession, instance, startActivity.getNodeID());
            try {
                Node startNode = instance.getTemplate().getStartNode();
                int startNodeID = startNode.getID();
                ActivityExecutionTools.checkEBPInstanceReference(startActivity, this.getURIs(), instance);
                ActivityExecutionTools.checkActivityForStarting(instance, startActivity, agent, this.logger);
                instance.setNodeState(startNodeID, ProcessConstants.NodeState.NS_RUNNING);
                instance.setPerformingAgent(startNodeID, agent);
                instance.setExecutionMode(startNodeID, executionMode);
                subSession = this.executionManager.subSession(parentSession);
                ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), startActivity, instance, ProcessConstants.NodeState.NS_RUNNING, this.logger);
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.runStartActivity(subSession, instance, instanceDataContainer, nodeDataContainer);
                    String sdpAgentID = SystemDataProducer.INSTANCE_INITIATOR_AGENT_ID.getParameterProperties().getName();
                    String sdpOrgPosID = SystemDataProducer.INSTANCE_INITIATOR_ORGPOSITION_ID.getParameterProperties().getName();
                    this.activityTermination.checkAndSetAutostart(autoStartSessionToken, instance, startActivity, sdpAgentID, sdpOrgPosID, autoStartSessionToken.getCallingComponent(), System.currentTimeMillis());
                }
                catch (ApplicationFailedException afe) {
                    String infoMessage = String.format("Executing the start node '%s' of instance '%s' (ID = '%s') raised an ApplicationFailException! Try to fail activity!", startActivity, instance.getName(), instance.getID());
                    this.logger.log(Level.WARNING, infoMessage, afe);
                    applicationFailed = afe;
                }
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                    subSession = this.executionManager.subSession(parentSession);
                    if (applicationFailed == null) {
                        this.activityTermination.activityFinished(subSession, startActivity, nodeDataContainer);
                    } else {
                        this.activityTermination.activityFailed(subSession, startActivity, nodeDataContainer, String.valueOf(applicationFailed.getMessage()) + "\n" + applicationFailed.getCompleteStackTrace(), applicationFailed.getState(), applicationFailed.getErrorCode());
                    }
                }
                catch (LockException le) {
                    String msg = String.format("executeStartActivity: Cannot set the changes for instance '%1$s' for execution. Another method may have unlocked it.", instance.getID());
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                }
                catch (LockException le) {
                    String msg = String.format("executeStartActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instance.getID());
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
            }
            catch (LockException le) {
                String msg = String.format("executeStartActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instance.getID());
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void executeEndActivity(SessionToken parentSession, EBPInstanceReference endActivity, ProcessConstants.ExecutionMode executionMode) throws InvalidActivityStateException, InvalidInstanceStateException {
        super.sessionActive(parentSession);
        try {
            ExecutableInstance instance;
            QualifiedAgent agent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken subSession = this.executionManager.subSession(parentSession);
            try {
                instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, endActivity.getInstanceID());
            }
            catch (LockException e) {
                throw ActivityExecutionTools.wrapLockException(e, "execute end activity", endActivity.getNodeID(), endActivity.getInstanceID());
            }
            ApplicationFailedException applicationFailed = null;
            DataContainer nodeDataContainer = this.getDataManager(subSession, endActivity.getInstanceID()).getProcessAwareAccess().getDataContainer(subSession, instance, endActivity.getNodeID());
            try {
                Node endNode = instance.getTemplate().getEndNode();
                int endNodeID = endNode.getID();
                subSession = this.executionManager.subSession(parentSession);
                InstanceStatus instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, endActivity.getInstanceID());
                ActivityExecutionTools.checkEBPInstanceReference(endActivity, this.getURIs(), instance);
                ActivityExecutionTools.checkIsInstanceRunning(instanceStatus, "Executing (end node)", endNodeID, instance.getID(), this.logger);
                ActivityExecutionTools.checkActivityForStarting(instance, endActivity, agent, this.logger);
                instance.setNodeState(endNodeID, ProcessConstants.NodeState.NS_RUNNING);
                instance.setPerformingAgent(endNodeID, agent);
                instance.setExecutionMode(endNodeID, executionMode);
                subSession = this.executionManager.subSession(parentSession);
                DataManager dataManager = this.getDataManager(subSession, instance.getID());
                DataContainer instanceDataContainer = dataManager.retrieveInstanceDataContainer(subSession, instance, false);
                subSession = this.executionManager.subSession(parentSession);
                ActivityExecutionTools.fireActivityStateChanged(this.getUpdateManager(subSession), endActivity, instance, ProcessConstants.NodeState.NS_RUNNING, this.logger);
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.runEndActivity(subSession, instance, instanceDataContainer, nodeDataContainer);
                }
                catch (ApplicationFailedException afe) {
                    String infoMessage = String.format("Executing the end node '%s' of instance '%s' (ID = '%s') raised an ApplicationFailException! Try to fail activity!", endActivity, instance.getName(), instance.getID());
                    this.logger.log(Level.INFO, infoMessage, afe);
                    applicationFailed = afe;
                }
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                    subSession = this.executionManager.subSession(parentSession);
                    if (applicationFailed == null) {
                        this.activityTermination.activityFinished(subSession, endActivity, nodeDataContainer);
                    } else {
                        this.activityTermination.activityFailed(subSession, endActivity, nodeDataContainer, String.valueOf(applicationFailed.getMessage()) + "\n" + applicationFailed.getCompleteStackTrace(), applicationFailed.getState(), applicationFailed.getErrorCode());
                    }
                }
                catch (LockException le) {
                    String msg = String.format("executeStartActivity: Cannot set the changes for instance '%1$s' for execution. Another method may have unlocked it.", instance.getID());
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
                }
                catch (LockException le) {
                    String msg = String.format("executeStartActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instance.getID());
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instance.getID());
            }
            catch (LockException le) {
                String msg = String.format("executeStartActivity: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instance.getID());
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void endActivityIsActivated(SessionToken parentSession, final EBPInstanceReference endActivity) {
        super.sessionActive(parentSession);
        try {
            final SessionToken newSession = this.executionManager.newSession(parentSession);
            super.privilegeSession(parentSession, newSession);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefaultStartEndNodeHandling.this.executeEndActivity(newSession, endActivity, ProcessConstants.ExecutionMode.PRODUCTION);
                    }
                    catch (InvalidActivityStateException e) {
                        String errorMessage = String.format("Cannot start the end activity with ID = '%s' of instance with ID = '%s', because the end node isin state '%s' but must be in state NS_ACTIVATED or NS_SELECTED!", new Object[]{endActivity.getNodeID(), endActivity.getInstanceID(), e.getActivityState()});
                        DefaultStartEndNodeHandling.this.logger.log(Level.SEVERE, errorMessage, e);
                    }
                    catch (InvalidInstanceStateException e) {
                        String warningMessage = String.format("Cannot start end activity with ID = '%s' of instance with ID = '%s', because the instance is in state '%s' but must be in state RUNNING!", endActivity.getNodeID(), endActivity.getInstanceID(), e.getPreventingState());
                        DefaultStartEndNodeHandling.this.logger.log(Level.WARNING, warningMessage);
                    }
                }
            });
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    private void runStartActivity(SessionToken session, ExecutableInstance instance, DataContainer instanceDataContainer, DataContainer nodeDataContainer) {
        Template template = instance.getTemplate();
        Set<ProcessModelParameter> processInputParameters = template.getParameters(ActivityConstants.AccessType.READ);
        if (instanceDataContainer == null) {
            for (ProcessModelParameter inputParameter : processInputParameters) {
                if (inputParameter.isOptional()) continue;
                String errorMessage = String.format("No instance data container has been provided to instance '%s' (ID = '%s'), but the instance has mandatory process input parameters", instance.getName(), instance.getID());
                throw new ApplicationFailedException(errorMessage, "ADEPT2:ExecutionManager:StartNodeHandling:InputParameterValueMissing", 1100005L);
            }
            if (template.getParameters(ActivityConstants.AccessType.WRITE).size() > 0) {
                String msg = "No instance data container has been provided to started instance '%s' (ID = '%s'), but the instance has process output parameters. The corresponding values will be lost.";
                this.logger.info(String.format(msg, instance.getName(), instance.getID()));
            }
        } else {
            block15: for (ProcessModelParameter inputParameter : processInputParameters) {
                String errorMessage;
                String parameterName = inputParameter.getName();
                try {
                    if (instanceDataContainer.isNull(session, parameterName)) {
                        if (inputParameter.isOptional()) continue;
                        String errorMessage2 = String.format("Process input parameter '%s' of instance '%s' (ID= '%s') is not optional but no value - i. e. NULL - is provided by the instance data container.", parameterName, instance.getName(), instance.getID());
                        throw new ApplicationFailedException(errorMessage2, "ADEPT2:ExecutionManager:StartNodeHandling:InputParameterValueMissing", 1100005L);
                    }
                    switch (inputParameter.getDataType()) {
                        case BOOLEAN: {
                            boolean booleanValue = instanceDataContainer.retrieveBoolean(session, parameterName);
                            nodeDataContainer.storeBoolean(session, parameterName, booleanValue);
                            continue block15;
                        }
                        case DATE: {
                            Date dateValue = instanceDataContainer.retrieveDate(session, parameterName);
                            nodeDataContainer.storeDate(session, parameterName, dateValue);
                            continue block15;
                        }
                        case FLOAT: {
                            double floatValue = instanceDataContainer.retrieveFloat(session, parameterName);
                            nodeDataContainer.storeFloat(session, parameterName, floatValue);
                            continue block15;
                        }
                        case INTEGER: {
                            long integerValue = instanceDataContainer.retrieveInteger(session, parameterName);
                            nodeDataContainer.storeInteger(session, parameterName, integerValue);
                            continue block15;
                        }
                        case STRING: {
                            String stringValue = instanceDataContainer.retrieveString(session, parameterName);
                            nodeDataContainer.storeString(session, parameterName, stringValue);
                            continue block15;
                        }
                        case URI: {
                            URI uriValue = instanceDataContainer.retrieveURI(session, parameterName);
                            nodeDataContainer.storeURI(session, parameterName, uriValue);
                            continue block15;
                        }
                        case USERDEFINED: {
                            UDTValue udtValue = instanceDataContainer.retrieveUDT(session, parameterName);
                            nodeDataContainer.storeUDT(session, parameterName, udtValue);
                            continue block15;
                        }
                        default: {
                            assert (false) : inputParameter.getDataType();
                            continue block15;
                        }
                    }
                }
                catch (NoSuchParameterException e) {
                    errorMessage = String.format("The process input parameter '%s' is unknown to the designated instance data container!", parameterName);
                    this.logger.log(Level.SEVERE, errorMessage, e);
                    throw new ApplicationFailedException(errorMessage, "ADEPT2:ExecutionManager:StartNodeHandling:InputParameterMissing", -401000L);
                }
                catch (InvalidDataTypeException e) {
                    errorMessage = String.format("There is either any problem with the type of the process input parameter '%s' to copy or the type of the parameter '%s' registered within the data container does not match the type of the parameter value to copy.", new Object[]{parameterName, inputParameter.getDataType()});
                    this.logger.log(Level.SEVERE, errorMessage, e);
                    throw new ApplicationFailedException(errorMessage, "ADEPT2:ExecutionManager:StartNodeHandling:WrongInputParameterType", 1100004L);
                }
            }
            SessionToken subSession = this.executionManager.subSession(session);
            int startNodeID = template.getStartNode().getID();
            try {
                this.getDataManager(subSession, instance.getID()).getProcessAwareAccess().flushDataContainer(subSession, instance, startNodeID, instance.getNodeIteration(startNodeID), nodeDataContainer);
            }
            catch (InvalidDataContainerException e) {
                String msg = String.format("activityFinished: InvalidDataContainerException while flushing the data container for node '%s', iteration '%s' of instance '%s'", startNodeID, instance.getNodeIteration(startNodeID), instance.getID());
                this.logger.log(Level.SEVERE, msg, e);
            }
        }
    }

    private void runEndActivity(SessionToken session, ExecutableInstance instance, DataContainer instanceDataContainer, DataContainer nodeDataContainer) throws ApplicationFailedException {
        Template template = instance.getTemplate();
        Set<ProcessModelParameter> processOutputParameters = template.getParameters(ActivityConstants.AccessType.WRITE);
        if (instanceDataContainer == null) {
            if (template.getParameters(ActivityConstants.AccessType.WRITE).size() > 0) {
                String msg = "No instance data container has been provided to finished instance '%s' (ID = '%s'), but the instance has process output parameters. The corresponding values will be lost.";
                this.logger.info(String.format(msg, instance.getName(), instance.getID()));
            }
        } else {
            block12: for (ProcessModelParameter outputParameter : processOutputParameters) {
                String errorMessage;
                String parameterName = outputParameter.getName();
                try {
                    if (nodeDataContainer.isNull(session, parameterName)) {
                        if (outputParameter.isOptional()) continue;
                        String errorMessage2 = String.format("Process output parameter '%s' of instance '%s' (ID = '%s') is not optional but no value - i. e. NULL - is provided by the instance data container.", parameterName, instance.getName(), instance.getID());
                        throw new ApplicationFailedException(errorMessage2, "ADEPT2:ExecutionManager:EndNodeHandling:OutputParameterValueMissing", 1100005L);
                    }
                    switch (outputParameter.getDataType()) {
                        case BOOLEAN: {
                            boolean booleanValue = nodeDataContainer.retrieveBoolean(session, parameterName);
                            instanceDataContainer.storeBoolean(session, parameterName, booleanValue);
                            continue block12;
                        }
                        case DATE: {
                            Date dateValue = nodeDataContainer.retrieveDate(session, parameterName);
                            instanceDataContainer.storeDate(session, parameterName, dateValue);
                            continue block12;
                        }
                        case FLOAT: {
                            double floatValue = nodeDataContainer.retrieveFloat(session, parameterName);
                            instanceDataContainer.storeFloat(session, parameterName, floatValue);
                            continue block12;
                        }
                        case INTEGER: {
                            long integerValue = nodeDataContainer.retrieveInteger(session, parameterName);
                            instanceDataContainer.storeInteger(session, parameterName, integerValue);
                            continue block12;
                        }
                        case STRING: {
                            String stringValue = nodeDataContainer.retrieveString(session, parameterName);
                            instanceDataContainer.storeString(session, parameterName, stringValue);
                            continue block12;
                        }
                        case URI: {
                            URI uriValue = nodeDataContainer.retrieveURI(session, parameterName);
                            instanceDataContainer.storeURI(session, parameterName, uriValue);
                            continue block12;
                        }
                        case USERDEFINED: {
                            UDTValue udtValue = nodeDataContainer.retrieveUDT(session, parameterName);
                            instanceDataContainer.storeUDT(session, parameterName, udtValue);
                            continue block12;
                        }
                        default: {
                            assert (false) : outputParameter.getDataType();
                            continue block12;
                        }
                    }
                }
                catch (NoSuchParameterException e) {
                    errorMessage = String.format("The process output parameter '%s' is unknown to the designated instance data container!", parameterName);
                    this.logger.log(Level.SEVERE, errorMessage, e);
                    throw new ApplicationFailedException(errorMessage, "ADEPT2:ExecutionManager:EndNodeHandling:OutputParameterMissing", -401000L);
                }
                catch (InvalidDataTypeException e) {
                    errorMessage = String.format("There is either any problem with the type of the process output parameter '%s' to copy or the type of the parameter '%s' registered within the data container does not match the type of the parameter value to copy.", new Object[]{parameterName, outputParameter.getDataType()});
                    this.logger.log(Level.SEVERE, errorMessage, e);
                    throw new ApplicationFailedException(errorMessage, "ADEPT2:ExecutionManager:EndNodeHandling:WrongOutputParameterType", 1100004L);
                }
            }
            this.getDataManager(session, instance.getID()).instanceTerminated(session, instance, instanceDataContainer);
        }
    }

    protected UpdateManager getUpdateManager(SessionToken session) {
        return this.executionManager.getUpdateManager(session);
    }

    protected DataManager getDataManager(SessionToken session, UUID instanceID) {
        return this.executionManager.getResolvedDataManager(session, instanceID);
    }

    protected InstanceManager getInstanceManager() {
        return this.executionManager.getProcessManager().getInstanceManager();
    }
}

