/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.dummies;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processmanager.storage.ProcessManagerStorageTools;
import de.aristaflow.adept2.core.processmanager.transientprocessmanager.TransientProcessManager;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class DummyProcessManager
extends TransientProcessManager {
    public DummyProcessManager(Configuration configuration, Registry registry) {
        super(configuration, registry, new String[0], new String[0]);
    }

    @Override
    public void init(URI[] uris) throws AbortServiceException {
        SessionFactory sf;
        super.init(uris);
        try {
            sf = this.registry.getSecurityManager().authenticatePrivileged(-2L, -2L, "password");
        }
        catch (AuthenticationException ae) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to wrongauthentication data. Check the configuration of this ProcessManager.", ae);
        }
        catch (DataSourceException dse) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to unavailability of the data.", dse);
        }
        SessionToken session = sf.getSessionToken(uris);
        String prefix = SystemProperties.getDataDir();
        ProcessModelFactory processModelFactory = this.registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
        processModelFactory.setCreateChangeable(false);
        ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(processModelFactory);
        try {
            TemplateStatus[] templateStatus = new TemplateStatus[1];
            Template[] template = new Template[1];
            this.logger.info("Loaded SellingEBP.template from file.");
            template[0] = xmlImport.getTemplateFromFile(new File(prefix.concat("/november2006/SellingEBP.template")).getCanonicalFile());
            templateStatus[0] = ProcessManagerStorageTools.getDefaultTemplateStatus(template[0].getID());
            CheckReport checkReport = this.getTemplateManager().storeNewTemplates(session, template, templateStatus);
            if (checkReport.getCheckResult().ordinal() >= CheckReport.ResultType.WARNING.ordinal()) {
                throw new RuntimeException("One or more of the templates contain errors:\n" + checkReport.getSimpleReportSummary());
            }
        }
        catch (XMLFormatException e) {
            this.logger.log(Level.SEVERE, "XMLFormatException while trying to load a template from a file.", e);
        }
        catch (VersionException e) {
            this.logger.log(Level.SEVERE, "VersionException while trying to load a template from a file.", e);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "IOException while trying to load a template from a file.", e);
        }
    }
}

