/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.instancechanging;

import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.executionmanager.InstanceChanging;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeReport;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.util.UUID;
import java.util.logging.Level;

public class DefaultInstanceChanging
extends AbstractSubService
implements InstanceChanging {
    protected final DefaultExecutionManager executionManager;
    protected final InstanceControl instanceControl;

    public DefaultInstanceChanging(DefaultExecutionManager executionManager, InstanceControl instanceControl) {
        super(new String[0], new String[]{"ProcessManager", "DataManager"}, executionManager);
        this.executionManager = executionManager;
        this.instanceControl = instanceControl;
    }

    @Override
    public void abortInstanceChanging(SessionToken session, UUID instanceID) {
        InstanceManager instanceManager = this.executionManager.getProcessManager().getInstanceManager();
        try {
            instanceManager.unlockChangeableInstance(session, instanceID);
        }
        catch (LockException e) {
            this.logger.log(Level.SEVERE, "Instance is locked.", e);
        }
        try {
            this.instanceControl.resumeInstance(session, instanceID);
        }
        catch (InvalidInstanceStateException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ChangeReport changeAndUnlockInstance(SessionToken session, ChangeableInstance instance) {
        ChangeReport ret = this.changeInstance(session, instance);
        if (ret.newInstanceID != null) {
            this.unlockChangeableInstance(session, ret.newInstanceID);
        }
        return ret;
    }

    @Override
    public ChangeReport changeInstance(SessionToken session, ChangeableInstance instance) {
        ChangeReport ret;
        block4: {
            InstanceManager instanceManager = this.executionManager.getProcessManager().getInstanceManager();
            ret = null;
            try {
                DataManager dataManager = this.executionManager.getResolvedDataManager(session, instance.getID());
                ret = instanceManager.changeInstance(session, instance);
                if (ret.newInstanceID == null) break block4;
                long timestamp = System.currentTimeMillis();
                try {
                    this.executionManager.getExecutionHistory(session, instance.getID()).getWriteAccess().logInstanceChanged(session, timestamp, instance);
                }
                catch (DataSourceException ex) {
                    String msg = "The instance changing could not be logged to the execution history! [Timestamp(%s), Instance(%s), StateChange(%s), AgentID(%s), AgentAgentOrgPositionID(%s)]";
                    QualifiedAgent agent = instance.getInitiatorAgent();
                    msg = String.format(msg, new Object[]{timestamp, instance.getID(), ExecutionHistory.StateChange.INSTANCE_CHANGED, agent.getAgentID(), agent.getOrgPositionID()});
                    this.logger.log(Level.SEVERE, msg, ex);
                }
                dataManager.instanceChanged(session, instanceManager.getInstance(session, ret.newInstanceID));
            }
            catch (LockException e) {
                this.logger.log(Level.SEVERE, "Instance is locked.", e);
            }
        }
        return ret;
    }

    @Override
    public void unlockChangeableInstance(SessionToken session, UUID instanceID) {
        InstanceManager instanceManager = this.executionManager.getProcessManager().getInstanceManager();
        try {
            instanceManager.unlockChangeableInstance(session, instanceID);
            try {
                this.instanceControl.resumeInstance(session, instanceID);
            }
            catch (InvalidInstanceStateException e) {
                e.printStackTrace();
            }
        }
        catch (LockException e) {
            this.logger.log(Level.SEVERE, "Instance is locked.", e);
        }
    }

    @Override
    public ChangeableInstance getInstanceForChanging(SessionToken session, UUID instanceID) throws InvalidInstanceStateException {
        ChangeableInstance changeableInstance;
        ProcessConstants.InstanceExecutionStatus executionState = this.getInstanceExecutionStatus(session, instanceID);
        boolean isSuspended = executionState == ProcessConstants.InstanceExecutionStatus.IE_SUSPENDED ? true : this.executionManager.getInstanceControl().suspendInstance(session, instanceID, true);
        if (!isSuspended) {
            executionState = this.getInstanceExecutionStatus(session, instanceID);
            throw new InvalidInstanceStateException(instanceID, executionState, "Cannot change the instance since it cannot be suspended!");
        }
        InstanceManager instanceManager = this.executionManager.getProcessManager().getInstanceManager();
        try {
            changeableInstance = instanceManager.getAndLockInstanceForChanging(session, instanceID);
        }
        catch (LockException e) {
            String msg = String.format("Cannot lock instance with ID '%s' forsession '%s', a LockException was thrown!", instanceID, session);
            throw new InternalServiceException(msg, e);
        }
        return changeableInstance;
    }

    private ProcessConstants.InstanceExecutionStatus getInstanceExecutionStatus(SessionToken session, UUID instanceID) {
        InstanceStatus status = this.executionManager.getProcessManager().getInstanceManager().getInstanceStatus(session, instanceID);
        ProcessConstants.InstanceExecutionStatus execStatus = status.getExecutionStatus();
        return execStatus;
    }
}

