/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.instancecontrol;

import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.ParameterRefResolver;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instancecontrol.InstanceExecutionTools;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instancecontrol.InstanceNotificationManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instanceexecution.InstanceExecution;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction.WorklistAccess;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolutionException;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InstanceDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.execution.LightWeightProcessInstance;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.execution.Vote;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.CommonConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.tools.TemplateReferenceComparator;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;

public class DefaultInstanceControl
extends AbstractSubService
implements InstanceControl {
    protected final DefaultExecutionManager executionManager;
    protected final InstanceNotificationManager notificationManager;
    protected final InstanceExecution instanceExecution;
    protected final WorklistAccess worklistAccess;

    public DefaultInstanceControl(DefaultExecutionManager executionManager, InstanceNotificationManager notificationManager, InstanceExecution instanceExecution, WorklistAccess worklistAccess) {
        super(new String[0], new String[]{"ProcessManager", "DataManager", "OrgModelManager", "LogManager", "UpdateManager"}, executionManager);
        this.executionManager = executionManager;
        this.notificationManager = notificationManager;
        this.instanceExecution = instanceExecution;
        this.worklistAccess = worklistAccess;
    }

    @Override
    public InstanceDataContainer createInstanceDataContainer(SessionToken parentSession, UUID processTemplateID) {
        super.sessionActive(parentSession);
        try {
            SessionToken subSession = this.executionManager.subSession(parentSession);
            Template template = this.getTemplateManager().getTemplate(subSession, processTemplateID);
            InstanceDataContainer instanceDataContainer = this.getDataManager(subSession, CommonConstants.UUID_NOT_EXISTING).createInstanceDataContainer(subSession, template);
            return instanceDataContainer;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public ParameterDataContext getPublicDataContext(SessionToken parentSession, UUID instanceID) {
        super.sessionActive(parentSession);
        try {
            SessionToken subSession = this.executionManager.subSession(parentSession);
            Instance instance = this.getInstanceManager().getInstance(subSession, instanceID);
            DataManager dm = this.getDataManager(subSession, instance.getTemplate().getID());
            subSession = this.executionManager.subSession(parentSession);
            ParameterDataContext parameterDataContext = dm.getProcessUnawareAccess().getPublicDataContext(subSession, instance);
            return parameterDataContext;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public UUID createAndStartInstance(SessionToken parentSession, UUID templateID, URI[] stateListener) throws InvalidTemplateStateException, InvalidDataContainerException {
        super.sessionActive(parentSession);
        try {
            SessionToken subSession = this.executionManager.subSession(parentSession);
            ExecutionContext executionContext = this.getExecutionFactory().getExecutionContext(this.executionManager.checkAndGetTopLevelAgent(parentSession), null, null, ProcessConstants.ExecutionMode.PRODUCTION, null, null);
            UUID uUID = this.createAndStartInstance(subSession, templateID, executionContext, stateListener);
            return uUID;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public UUID createAndStartInstance(SessionToken parentSession, UUID templateID, ExecutionContext executionContext, URI[] stateListener) throws InvalidTemplateStateException, InvalidDataContainerException {
        super.sessionActive(parentSession);
        try {
            Runnable startNodeRunner;
            String msg;
            ExecutableInstance instance;
            boolean isMember;
            QualifiedAgent callingAgent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken subSession = this.executionManager.subSession(parentSession);
            TemplateStatus templateStatus = this.getTemplateManager().getTemplateStatus(subSession, templateID);
            if (!templateStatus.isTopLevelUsable()) {
                throw new InvalidTemplateStateException("Template not top level usable.");
            }
            if (!templateStatus.isInstantiable(false)) {
                throw new InvalidTemplateStateException("Template not instantiable.");
            }
            String starterRule = templateStatus.getStarterRule();
            if (DefaultInstanceControl.isPrivilegedAgent(callingAgent)) {
                isMember = true;
            } else {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    PolicyResolution policyResolution = this.executionManager.getOrgModelManager().getPolicyResolution();
                    isMember = policyResolution.isMember(subSession, callingAgent.getOrgPositionID(), callingAgent.getAgentUserName(), starterRule);
                }
                catch (PolicyResolutionException e) {
                    String msg2 = "PolicyResolutionException while resolving the starter rule '%s' of the template status of the template with ID %s.";
                    msg2 = String.format(msg2, starterRule, templateID);
                    this.logger.log(Level.SEVERE, msg2, e);
                    throw new InternalServiceException(msg2, e);
                }
                catch (DataSourceException e) {
                    String msg3 = "DataSourceException while resolving the starter rule '%s' of the template status of the template with ID %s.";
                    msg3 = String.format(msg3, starterRule, templateID);
                    this.logger.log(Level.SEVERE, msg3, e);
                    throw new InternalServiceException(msg3, e);
                }
            }
            if (!isMember) {
                String msg4 = "You do not have the permission to instantiate the template %s.";
                throw new ServiceAccessControlException(String.format(msg4, templateID));
            }
            subSession = this.executionManager.subSession(parentSession);
            Template template = this.getTemplateManager().getTemplate(subSession, templateID);
            InstanceExecutionTools.checkDataContextForTemplateParameters(subSession, executionContext, template);
            String defInstanceName = this.getInstanceName(subSession, template, executionContext.getDataContainer());
            Map<String, String> locInstanceNames = this.getLocalisedInstanceName(subSession, template, executionContext.getDataContainer());
            try {
                subSession = this.executionManager.subSession(parentSession);
                instance = this.getInstanceManager().createInstanceOf(subSession, templateID, defInstanceName, template.getSupervisorAgent(), System.currentTimeMillis());
                instance.setInstanceName(defInstanceName, locInstanceNames);
            }
            catch (LockException lockException) {
                String msg5 = "The template '%1$s' is currently locked for updating the template status.";
                throw new InvalidTemplateStateException(String.format(msg5, templateID));
            }
            try {
                try {
                    long timestamp = System.currentTimeMillis();
                    try {
                        subSession = this.executionManager.subSession(parentSession);
                        this.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logInstanceStarted(subSession, timestamp, instance);
                    }
                    catch (DataSourceException ex) {
                        msg = "The instance start could not be logged to the execution history! [Timestamp(%s), Instance(%s), StateChange(%s), AgentID(%s), AgentAgentOrgPositionID(%s)]";
                        QualifiedAgent agent = instance.getInitiatorAgent();
                        msg = String.format(msg, new Object[]{timestamp, instance.getID(), ExecutionHistory.StateChange.INSTANCE_STARTED, agent.getAgentID(), agent.getOrgPositionID()});
                        this.logger.log(Level.SEVERE, msg, ex);
                    }
                    if (stateListener != null) {
                        instance.setInstanceStateListener(stateListener);
                    }
                    subSession = this.executionManager.subSession(parentSession);
                    DataManager dataManager = this.getDataManager(subSession, instance.getID());
                    dataManager.instanceStarted(subSession, instance, executionContext.getDataContainer());
                    subSession = this.executionManager.subSession(parentSession);
                    InstanceExecutionTools.fireInstanceEvent(this.getUpdateManager(subSession), instance, UpdateManager.InstanceProperties.INSTANCE_ACTIVATED);
                    this.addInstanceToSupervisingWorklist(subSession, instance);
                    subSession = this.executionManager.subSession(parentSession);
                    startNodeRunner = this.instanceExecution.activateStartNode(subSession, executionContext, instance);
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                }
                catch (LockException le) {
                    String msg6 = "createAndStartInstance: Cannot store the newly created instance '%1$s' of template '%2$s! This is a serious problem since we have instantiated and locked it recently! Another method may have unlocked it. Aborting start.";
                    msg6 = String.format(msg6, instance.getID(), templateID);
                    this.logger.log(Level.SEVERE, msg6, le);
                    throw new InternalServiceException(msg6);
                }
            }
            catch (Throwable throwable) {
                UUID ret = instance.getID();
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, ret);
                }
                catch (LockException le) {
                    String msg7 = "createAndStartInstance: Cannot unlock the newly created instance '%1$s' of template '%2$s! This is a serious problem since we have instantiated it recently! Another method may have unlocked it.";
                    msg7 = String.format(msg7, ret, templateID);
                    this.logger.log(Level.SEVERE, msg7, le);
                    throw new InternalServiceException(msg7);
                }
                throw throwable;
            }
            UUID ret = instance.getID();
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, ret);
            }
            catch (LockException le) {
                msg = "createAndStartInstance: Cannot unlock the newly created instance '%1$s' of template '%2$s! This is a serious problem since we have instantiated it recently! Another method may have unlocked it.";
                msg = String.format(msg, ret, templateID);
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg);
            }
            startNodeRunner.run();
            UUID uUID = ret;
            return uUID;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public UUID createAndStartSubInstance(SessionToken parentSession, EBPInstanceReference superInstanceActivity, ExecutionContext executionContext, URI[] stateListener) throws InvalidTemplateStateException, InvalidDataContainerException {
        super.sessionActive(parentSession);
        try {
            Runnable startNodeRunner;
            String msg;
            ExecutableInstance subprocessInstance;
            SessionToken subSession = this.executionManager.subSession(parentSession);
            ExecutableBusinessProcessInstance ebp = executionContext.getEBPInstance();
            if (!(ebp instanceof LightWeightProcessInstance)) {
                String msg2 = "The passed ebp '%s' is not of type LightWeightProcess, so no subprocess to instantiate can be derived!";
                msg2 = String.format(msg2, ebp);
                this.logger.severe(msg2);
                throw new IllegalArgumentException(msg2);
            }
            LightWeightProcessInstance lwp = (LightWeightProcessInstance)ebp;
            boolean fork = lwp.fork();
            UUID templateID = lwp.getTemplateID();
            TemplateStatus templateStatus = this.getTemplateManager().getTemplateStatus(subSession, templateID);
            if (!lwp.isEmbedded() && !templateStatus.isInstantiable(true)) {
                String msg3 = "The requested template with ID = '%s' is not allowed to be instantiated as a subprocess due to its template status!";
                msg3 = String.format(msg3, templateID);
                this.logger.warning(msg3);
                throw new InvalidTemplateStateException(msg3);
            }
            ProcessConstants.TemplateUsage templateUsage = templateStatus.getUsageAsSubprocess();
            if (!fork && !lwp.isEmbedded() && (templateUsage.equals((Object)ProcessConstants.TemplateUsage.NO_SUBPROCESS) || templateUsage.equals((Object)ProcessConstants.TemplateUsage.AS_COPY))) {
                String msg4 = "The requested template with ID = '%s' cannot be instantiated as a referenced subprocess";
                msg4 = String.format(msg4, templateID);
                this.logger.warning(msg4);
                throw new InvalidTemplateStateException(msg4);
            }
            if (!(lwp.isEmbedded() && (templateUsage.equals((Object)ProcessConstants.TemplateUsage.NO_SUBPROCESS) || templateUsage.equals((Object)ProcessConstants.TemplateUsage.AS_REFERENCE)) || !fork || templateStatus.isTopLevelUsable())) {
                String msg5 = "The requested template with ID = '%s' cannot be instantiated as a forked process";
                msg5 = String.format(msg5, templateID);
                this.logger.warning(msg5);
                throw new InvalidTemplateStateException(msg5);
            }
            subSession = this.executionManager.subSession(parentSession);
            Template template = this.getTemplateManager().getTemplate(subSession, templateID);
            InstanceExecutionTools.checkDataContextForTemplateParameters(subSession, executionContext, template);
            String defInstanceName = this.getInstanceName(subSession, template, executionContext.getDataContainer());
            Map<String, String> locInstanceNames = this.getLocalisedInstanceName(subSession, template, executionContext.getDataContainer());
            try {
                subSession = this.executionManager.subSession(parentSession);
                subprocessInstance = this.getInstanceManager().createSubInstanceOf(subSession, templateID, defInstanceName, template.getSupervisorAgent(), superInstanceActivity, System.currentTimeMillis());
                subprocessInstance.setInstanceName(defInstanceName, locInstanceNames);
            }
            catch (LockException le) {
                String msg6 = "The template '%1$s' is currently locked for updating the template status.";
                msg6 = String.format(msg6, templateID);
                this.logger.log(Level.WARNING, msg6, le);
                throw new InvalidTemplateStateException(msg6);
            }
            try {
                try {
                    long timestamp = System.currentTimeMillis();
                    try {
                        subSession = this.executionManager.subSession(parentSession);
                        this.getExecutionHistory(subSession, subprocessInstance.getID()).getWriteAccess().logInstanceStarted(subSession, timestamp, subprocessInstance);
                    }
                    catch (DataSourceException ex) {
                        msg = "The subinstance start could not be logged to the execution history! [Timestamp(%s), Instance(%s), StateChange(%s), AgentID(%s), AgentAgentOrgPositionID(%s)]";
                        QualifiedAgent agent = subprocessInstance.getInitiatorAgent();
                        msg = String.format(msg, new Object[]{timestamp, subprocessInstance.getID(), ExecutionHistory.StateChange.INSTANCE_STARTED, agent.getAgentID(), agent.getOrgPositionID()});
                        this.logger.log(Level.SEVERE, msg, ex);
                    }
                    if (!fork) {
                        subprocessInstance.setInstanceStateListener(stateListener);
                    }
                    subSession = this.executionManager.subSession(parentSession);
                    DataManager dataManager = this.getDataManager(subSession, subprocessInstance.getID());
                    dataManager.instanceStarted(subSession, subprocessInstance, executionContext.getDataContainer());
                    subSession = this.executionManager.subSession(parentSession);
                    InstanceExecutionTools.fireInstanceEvent(this.getUpdateManager(subSession), subprocessInstance, UpdateManager.InstanceProperties.INSTANCE_ACTIVATED);
                    subSession = this.executionManager.subSession(parentSession);
                    startNodeRunner = this.instanceExecution.activateStartNode(subSession, executionContext, subprocessInstance);
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().setExecutableInstance(subSession, subprocessInstance);
                }
                catch (LockException e) {
                    String msg7 = "createAndStartSubInstance: Cannot store the newly created sub-instance '%1$s' of template '%2$s! This is a serious problem since we have instantiated and locked it recently! Another method may have unlocked it. Aborting start.";
                    msg7 = String.format(msg7, subprocessInstance.getID(), templateID);
                    this.logger.log(Level.SEVERE, msg7, e);
                    throw new InternalServiceException(msg7);
                }
            }
            catch (Throwable throwable) {
                UUID ret = subprocessInstance.getID();
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, ret);
                }
                catch (LockException e) {
                    String msg8 = "createAndStartSubInstance: Cannot unlock the newly created sub-instance '%1$s' of template '%2$s! This is a serious problem since we have instantiated  it recently! Another method may have unlocked it. Aborting start.";
                    msg8 = String.format(msg8, ret, templateID);
                    this.logger.log(Level.SEVERE, msg8, e);
                    throw new InternalServiceException(msg8);
                }
                throw throwable;
            }
            UUID ret = subprocessInstance.getID();
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, ret);
            }
            catch (LockException e) {
                msg = "createAndStartSubInstance: Cannot unlock the newly created sub-instance '%1$s' of template '%2$s! This is a serious problem since we have instantiated  it recently! Another method may have unlocked it. Aborting start.";
                msg = String.format(msg, ret, templateID);
                this.logger.log(Level.SEVERE, msg, e);
                throw new InternalServiceException(msg);
            }
            startNodeRunner.run();
            UUID uUID = ret;
            return uUID;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public Set<UUID> getInstantiableTemplates(SessionToken parentSession) {
        return this.getInstantiableTemplates(parentSession, false);
    }

    @Override
    public Set<UUID> getInstantiableTemplates(SessionToken parentSession, boolean includeOutdated) {
        super.sessionActive(parentSession);
        try {
            QualifiedAgent callingAgent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken session = this.executionManager.subSession(parentSession);
            TreeSet<UUID> instantiableTemplates = new TreeSet<UUID>();
            PolicyResolution policyResolution = this.executionManager.getOrgModelManager().getPolicyResolution();
            for (UUID templateID : this.getTemplateManager().getAllTemplateIDs(session)) {
                TemplateStatus templateStatus = this.getTemplateManager().getTemplateStatus(session, templateID);
                if (!templateStatus.isTopLevelUsable() || !templateStatus.isInstantiable(false) || !includeOutdated && templateStatus.isOutdated(false)) continue;
                boolean isMember = DefaultInstanceControl.isPrivilegedAgent(callingAgent);
                if (!isMember) {
                    String msg;
                    try {
                        isMember = policyResolution.isMember(session, callingAgent.getOrgPositionID(), callingAgent.getAgentUserName(), templateStatus.getStarterRule());
                    }
                    catch (PolicyResolutionException e) {
                        msg = "PolicyResolutionException while resolving the starter rule '%s' of the template status of the template with ID %s.";
                        msg = String.format(msg, templateStatus.getStarterRule(), templateID);
                        this.logger.log(Level.SEVERE, msg, e);
                        continue;
                    }
                    catch (DataSourceException e) {
                        msg = "DataSourceException while resolving the starter rule '%s' of the template status of the template with ID %s.";
                        msg = String.format(msg, templateStatus.getStarterRule(), templateID);
                        this.logger.log(Level.SEVERE, msg, e);
                        continue;
                    }
                }
                if (!isMember) continue;
                instantiableTemplates.add(templateID);
            }
            TreeSet<UUID> treeSet = instantiableTemplates;
            return treeSet;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public TemplateReference getTemplateReference(SessionToken session, UUID templateID) {
        return this.getTemplateManager().getTemplateReference(session, templateID);
    }

    @Override
    public Set<TemplateReference> getInstantiableTemplateReferences(SessionToken parentSession) {
        return this.getInstantiableTemplateReferences(parentSession, false);
    }

    @Override
    public Set<TemplateReference> getInstantiableTemplateReferences(SessionToken parentSession, boolean includeOutdated) {
        super.sessionActive(parentSession);
        try {
            QualifiedAgent callingAgent = this.executionManager.checkAndGetTopLevelAgent(parentSession);
            SessionToken session = this.executionManager.subSession(parentSession);
            TreeSet<TemplateReference> instantiableTemplates = new TreeSet<TemplateReference>(new TemplateReferenceComparator());
            PolicyResolution policyResolution = this.executionManager.getOrgModelManager().getPolicyResolution();
            for (TemplateReference templateRef : this.getTemplateManager().getAllTemplateReferences(session)) {
                if (!templateRef.isTopLevelUsable() || !templateRef.isInstantiable(false) || !includeOutdated && templateRef.isOutdated(false)) continue;
                boolean isMember = DefaultInstanceControl.isPrivilegedAgent(callingAgent);
                if (!isMember) {
                    String msg;
                    UUID templateID = templateRef.getID();
                    TemplateStatus templateStatus = this.getTemplateManager().getTemplateStatus(session, templateID);
                    try {
                        isMember = policyResolution.isMember(session, callingAgent.getOrgPositionID(), callingAgent.getAgentUserName(), templateStatus.getStarterRule());
                    }
                    catch (PolicyResolutionException e) {
                        msg = "PolicyResolutionException while resolving the starter rule '%s' of the template status of the template with ID %s.";
                        msg = String.format(msg, templateStatus.getStarterRule(), templateID);
                        this.logger.log(Level.SEVERE, msg, e);
                        continue;
                    }
                    catch (DataSourceException e) {
                        msg = "DataSourceException while resolving the starter rule '%s' of the template status of the template with ID %s.";
                        msg = String.format(msg, templateStatus.getStarterRule(), templateID);
                        this.logger.log(Level.SEVERE, msg, e);
                        continue;
                    }
                }
                if (!isMember) continue;
                instantiableTemplates.add(templateRef);
            }
            TreeSet<TemplateReference> treeSet = instantiableTemplates;
            return treeSet;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean suspendInstance(SessionToken parentSession, UUID instanceID, boolean propagateToRunningActs) throws InvalidInstanceStateException {
        super.sessionActive(parentSession);
        try {
            block25: {
                subSession = this.executionManager.subSession(parentSession);
                try {
                    instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
                }
                catch (LockException le) {
                    msg = String.format("suspendInstance: Cannot suspend instance '%1$s', because we cannot get the execution lock. This is a serious problem since we have the lock on the instance status. Trying to unlock the instance status.", new Object[]{instanceID});
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg, le);
                }
                instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, instanceID);
                formerExecutionStatus = instanceStatus.getExecutionStatus();
                v0 = alreadySuspended = InstanceExecutionTools.checkIsInstanceSuspendable(instanceID, formerExecutionStatus, this.getInstanceManager()) == false;
                if (!alreadySuspended) break block25;
                if (formerExecutionStatus == ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_SUSPENDED && propagateToRunningActs) ** GOTO lbl39
                var14_16 = formerExecutionStatus == ProcessConstants.InstanceExecutionStatus.IE_SUSPENDED;
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                }
                catch (LockException le) {
                    msg = String.format("suspendInstance: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", new Object[]{instanceID});
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg, le);
                }
                return var14_16;
            }
            parent = instance.getParentEBPReference();
            if (parent != null) {
                instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, parent.getInstanceID());
                parentInstance = this.getInstanceManager().getInstance(subSession, parent.getInstanceID());
                if (!this.isForked(parentInstance, parent.getNodeID())) {
                    InstanceExecutionTools.checkIsInstanceSuspendable(instanceID, parent.getInstanceID(), instanceStatus.getExecutionStatus(), this.getInstanceManager());
                }
            }
            msg = String.format("Handling suspend request for instance %s with%s  propagation to running activities. Setting intermediately to IE_SOFTLY_SUSPENDED.", new Object[]{instanceID, propagateToRunningActs != false ? "" : "out"});
            this.getInstanceManager().setExecutionStatus(subSession, instanceID, ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_SUSPENDED, msg);
            subSession = this.executionManager.subSession(parentSession);
            this.worklistAccess.removeActivitiesFromWorklist(subSession, instanceID, new ProcessConstants.NodeState[]{ProcessConstants.NodeState.NS_ACTIVATED, ProcessConstants.NodeState.NS_SELECTED, ProcessConstants.NodeState.NS_SUSPENDED});
lbl39:
            // 2 sources

            if (!propagateToRunningActs) {
                runningActivities = instance.getNodesInState(ProcessConstants.NodeState.NS_RUNNING);
                allRunningActivitiesStopped = runningActivities.length == 0;
            } else {
                subSession = this.executionManager.subSession(parentSession);
                allRunningActivitiesStopped = this.instanceExecution.suspendRunningActivityInstances(subSession, instance);
            }
            newExecutionStatus = allRunningActivitiesStopped != false ? ProcessConstants.InstanceExecutionStatus.IE_SUSPENDED : ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_SUSPENDED;
            try {
                this.getInstanceManager().setExecutionStatus(subSession, instanceID, newExecutionStatus, "");
            }
            catch (LockException le) {
                msg = String.format("suspendInstance: LockException while setting execution status of instance ('%1$s'). An execution lock is missing although we have retrieved an executable instance. Please set the execution state manually! Continuing.", new Object[]{instanceID});
                this.logger.log(Level.SEVERE, msg, le);
            }
            if (formerExecutionStatus != newExecutionStatus) {
                subSession = this.executionManager.subSession(parentSession);
                this.notificationManager.instanceSuspended(subSession, instance);
            }
            var14_17 = allRunningActivitiesStopped;
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
            }
            catch (LockException le) {
                msg = String.format("suspendInstance: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", new Object[]{instanceID});
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg, le);
            }
            return var14_17;
            catch (LockException le) {
                try {
                    msg = String.format("suspendInstance: LockException while setting execution status of instance ('%1$s'). Suspending is aborted.", new Object[]{instanceID});
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg, le);
                }
                catch (Throwable var13_25) {
                    try {
                        subSession = this.executionManager.subSession(parentSession);
                        this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                    }
                    catch (LockException le) {
                        msg = String.format("suspendInstance: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", new Object[]{instanceID});
                        this.logger.log(Level.SEVERE, msg, le);
                        throw new InternalServiceException(msg, le);
                    }
                    throw var13_25;
                }
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void resumeInstance(SessionToken parentSession, UUID instanceID) throws InvalidInstanceStateException {
        this.resumeInstance(parentSession, instanceID, null);
    }

    @Override
    public void resumeInstance(SessionToken parentSession, UUID instanceID, URI[] stateListener) throws InvalidInstanceStateException {
        super.sessionActive(parentSession);
        try {
            ProcessConstants.InstanceExecutionStatus formerExecutionStatus;
            ExecutableInstance instance;
            SessionToken subSession;
            block20: {
                InstanceStatus instanceStatus;
                subSession = this.executionManager.subSession(parentSession);
                try {
                    instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
                }
                catch (LockException le) {
                    String msg = "resumeInstance: Cannot resume instance '%1$s', because we cannot get the execution lock. This is a serious problem since we have the lock on the instance status. Trying to unlock the instance status.";
                    msg = String.format(msg, instanceID);
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg, le);
                }
                EBPInstanceReference parent = instance.getParentEBPReference();
                if (parent != null) {
                    instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, parent.getInstanceID());
                    formerExecutionStatus = instanceStatus.getExecutionStatus();
                    Instance parentInstance = this.getInstanceManager().getInstance(subSession, parent.getInstanceID());
                    if (!this.isForked(parentInstance, parent.getNodeID())) {
                        InstanceExecutionTools.checkIsInstanceResumeable(instanceID, parent.getInstanceID(), formerExecutionStatus, this.getInstanceManager());
                    }
                }
                instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, instanceID);
                formerExecutionStatus = instanceStatus.getExecutionStatus();
                if (parent == null || formerExecutionStatus != ProcessConstants.InstanceExecutionStatus.IE_RUNNING) break block20;
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                }
                catch (LockException le) {
                    String msg = "resumeInstance: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg = String.format(msg, instanceID);
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg, le);
                }
                return;
            }
            try {
                try {
                    InstanceExecutionTools.checkIsInstanceResumeable(instanceID, formerExecutionStatus, this.getInstanceManager());
                    if (stateListener != null) {
                        instance.setInstanceStateListener(stateListener);
                    }
                    this.getInstanceManager().setExecutionStatus(subSession, instanceID, ProcessConstants.InstanceExecutionStatus.IE_RUNNING, "");
                    subSession = this.executionManager.subSession(parentSession);
                    this.instanceExecution.rescheduleActivities(subSession, instance);
                    subSession = this.executionManager.subSession(parentSession);
                    this.notificationManager.instanceResumed(subSession, instance);
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().setExecutableInstance(subSession, instance);
                }
                catch (LockException le) {
                    String msg = "resumeInstance: LockException while storing instance or execution status of instance '%1$s'. An execution lock is missing although we have retrieved an executable instance. Aborting resume since the instance state is wrong.";
                    msg = String.format(msg, instanceID);
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg, le);
                }
            }
            catch (Throwable throwable) {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                }
                catch (LockException le) {
                    String msg = "resumeInstance: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                    msg = String.format(msg, instanceID);
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg, le);
                }
                throw throwable;
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
            }
            catch (LockException le) {
                String msg = "resumeInstance: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                msg = String.format(msg, instanceID);
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg, le);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void stopAndAbortInstance(SessionToken parentSession, UUID instanceID, boolean propagateToRunningActs, String errorMessage, String state, long errorCode) throws InvalidInstanceStateException {
        super.sessionActive(parentSession);
        try {
            block23: {
                subSession = this.executionManager.subSession(parentSession);
                try {
                    instance = this.getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
                }
                catch (LockException le) {
                    msg = String.format("stopAndAbortInstance: Cannot stop instance '%1$s', because we cannot get the execution lock.", new Object[]{instanceID});
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg, le);
                }
                instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, instanceID);
                formerExecutionStatus = instanceStatus.getExecutionStatus();
                v0 = alreadyAborted = InstanceExecutionTools.checkIsInstanceAbortable(instanceID, formerExecutionStatus, this.getInstanceManager()) == false;
                if (!alreadyAborted) break block23;
                ** if (formerExecutionStatus == ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_ABORTED && propagateToRunningActs) goto lbl26
lbl-1000:
                // 1 sources

                {
                    try {
                        subSession = this.executionManager.subSession(parentSession);
                        this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                    }
                    catch (LockException le) {
                        msg = String.format("stopAndAbortInstance: Cannot unlock the instance '%1$s' for execution. Another method may have  unlocked it.", new Object[]{instanceID});
                        this.logger.log(Level.SEVERE, msg, le);
                        throw new InternalServiceException(msg, le);
                    }
                    return;
                }
lbl26:
                // 1 sources

                ** GOTO lbl41
            }
            try {
                try {
                    parent = instance.getParentEBPReference();
                    if (parent != null) {
                        instanceStatus = this.getInstanceManager().getInstanceStatus(subSession, parent.getInstanceID());
                        parentInstance = this.getInstanceManager().getInstance(subSession, parent.getInstanceID());
                        if (!this.isForked(parentInstance, parent.getNodeID())) {
                            InstanceExecutionTools.checkIsInstanceAbortable(instanceID, parent.getInstanceID(), instanceStatus.getExecutionStatus(), this.getInstanceManager());
                        }
                    }
                    msg = String.format("Handling abort request (error code: %s, error state: %s, error message: %s) for instance %s with%s  propagation to running activities. Setting intermediately to IE_SOFTLY_ABORTED.", new Object[]{errorCode, state, errorMessage, instanceID, propagateToRunningActs != false ? "" : "out"});
                    this.getInstanceManager().setExecutionStatus(subSession, instanceID, ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_ABORTED, msg);
                    if (formerExecutionStatus != ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_SUSPENDED && formerExecutionStatus != ProcessConstants.InstanceExecutionStatus.IE_SUSPENDED) {
                        subSession = this.executionManager.subSession(parentSession);
                        this.worklistAccess.removeActivitiesFromWorklist(subSession, instanceID, new ProcessConstants.NodeState[]{ProcessConstants.NodeState.NS_ACTIVATED, ProcessConstants.NodeState.NS_SELECTED, ProcessConstants.NodeState.NS_SUSPENDED});
                    }
lbl41:
                    // 4 sources

                    if (propagateToRunningActs) {
                        this.instanceExecution.abortRunningActivityInstances(subSession, instance);
                    }
                    msg = String.format("Aborted instance %s with%s propagation to running activities. Reason:\nerror code: %s\nerror state: %s\nerror message: %s.", new Object[]{instanceID, propagateToRunningActs != false ? "" : "out", errorCode, state, errorMessage});
                    newExecutionStatus = propagateToRunningActs != false ? ProcessConstants.InstanceExecutionStatus.IE_ABORTED : ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_ABORTED;
                    this.getInstanceManager().setExecutionStatus(subSession, instanceID, newExecutionStatus, msg);
                    if (formerExecutionStatus != newExecutionStatus) {
                        this.notificationManager.instanceFailed(subSession, instance, errorCode, state, errorMessage);
                    }
                }
                catch (LockException le) {
                    msg = String.format("stopAndAbortInstance: LockException while setting execution status of instance ('%1$s'). Abortion is aborted.", new Object[]{instanceID});
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg, le);
                }
            }
            catch (Throwable var16_24) {
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                }
                catch (LockException le) {
                    msg = String.format("stopAndAbortInstance: Cannot unlock the instance '%1$s' for execution. Another method may have  unlocked it.", new Object[]{instanceID});
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg, le);
                }
                throw var16_24;
            }
            try {
                subSession = this.executionManager.subSession(parentSession);
                this.getInstanceManager().unlockExecutableInstance(subSession, instanceID);
            }
            catch (LockException le) {
                msg = String.format("stopAndAbortInstance: Cannot unlock the instance '%1$s' for execution. Another method may have  unlocked it.", new Object[]{instanceID});
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg, le);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public Vote prepareCommitInstance(SessionToken session, UUID instanceID) throws InvalidInstanceStateException {
        super.sessionActive(session);
        try {
            throw new RuntimeException("Not yet implemented!");
        }
        catch (Throwable throwable) {
            super.sessionFinished(session);
            throw throwable;
        }
    }

    @Override
    public void commitInstance(SessionToken session, UUID instanceID) throws InvalidInstanceStateException {
        super.sessionActive(session);
        try {
            throw new RuntimeException("Not yet implemented!");
        }
        catch (Throwable throwable) {
            super.sessionFinished(session);
            throw throwable;
        }
    }

    @Override
    public void rollbackInstance(SessionToken session, UUID instanceID) throws InvalidInstanceStateException {
        super.sessionActive(session);
        try {
            throw new RuntimeException("Not yet implemented!");
        }
        catch (Throwable throwable) {
            super.sessionFinished(session);
            throw throwable;
        }
    }

    protected ExecutionHistory getExecutionHistory(SessionToken session, UUID instanceID) {
        return this.executionManager.getExecutionHistory(session, instanceID);
    }

    protected ExecutionFactory getExecutionFactory() {
        return this.executionManager.getExecutionFactory();
    }

    protected InstanceManager getInstanceManager() {
        return this.executionManager.getProcessManager().getInstanceManager();
    }

    protected TemplateManager getTemplateManager() {
        return this.executionManager.getProcessManager().getTemplateManager();
    }

    protected UpdateManager getUpdateManager(SessionToken session) {
        return this.executionManager.getUpdateManager(session);
    }

    protected DataManager getDataManager(SessionToken session, UUID instanceID) {
        return this.executionManager.getResolvedDataManager(session, instanceID);
    }

    private void addInstanceToSupervisingWorklist(SessionToken session, ExecutableInstance instance) {
        Template template = instance.getTemplate();
        ExecutionControlProperties ecp = new ExecutionControlProperties(false, false, false);
        ExecutableBusinessProcessInstance ebpi = this.getExecutionFactory().createTopLevelProcessInstance(template.getID(), template.getName(), instance.getName(), instance.getLogID(), instance.getName(), template.getDescription(), null, ecp, null, template.getParameters(ActivityConstants.AccessType.READ), template.getParameters(ActivityConstants.AccessType.WRITE), this.getExecutionFactory().createParameterDataContext(null, null), template, instance.getUserAttributes());
        EBPInstanceReference ebpIR = this.executionManager.getEbpIRForInstance(instance);
        QualifiedAgent initiator = instance.getInitiatorAgent();
        String initiatorPolicy = String.format("OrgPosition(id=%s).getAgents(id=%s)", initiator.getOrgPositionID(), initiator.getAgentID());
        this.worklistAccess.addAndAssignActivity(session, ebpi, ProcessConstants.NodeState.NS_RUNNING, ebpIR, initiatorPolicy, initiator);
    }

    private static boolean isPrivilegedAgent(QualifiedAgent agent) {
        return agent.getAgentUserName().equals("supervisor");
    }

    private String getInstanceName(SessionToken session, Template template, DataContainer dataContainer) {
        String ret = "";
        if (dataContainer != null) {
            Template templateRes = ParameterRefResolver.getProxy(template, Template.class, dataContainer, session, this.executionManager.getPluginRegistry());
            ret = templateRes.getInstanceNameTemplate();
        }
        if (dataContainer == null || ret == null || ret.equals("")) {
            ret = String.format("%1$s (%2$s)", template.getName(), new SimpleDateFormat().format(new Date()));
        }
        return ret;
    }

    private Map<String, String> getLocalisedInstanceName(SessionToken session, Template template, DataContainer dataContainer) {
        HashMap<String, String> ret;
        block4: {
            block3: {
                ret = new HashMap<String, String>();
                if (dataContainer == null) break block3;
                Template templateRes = ParameterRefResolver.getProxy(template, Template.class, dataContainer, session, this.executionManager.getPluginRegistry());
                PluginData pluginData = templateRes.getPluginData("ProcessLocalisation");
                if (pluginData == null) break block4;
                HashMap<String, String> data = new HashMap<String, String>(pluginData.getPluginData());
                for (Map.Entry entry : data.entrySet()) {
                    if (!((String)entry.getKey()).startsWith("InstanceNameTemplate.")) continue;
                    String locale = ((String)entry.getKey()).substring(((String)entry.getKey()).indexOf(46) + 1);
                    ret.put(locale, (String)entry.getValue());
                }
                break block4;
            }
            PluginData pluginData = template.getPluginData("ProcessLocalisation");
            if (pluginData != null) {
                HashMap<String, String> data = new HashMap<String, String>(pluginData.getPluginData());
                SimpleDateFormat df = new SimpleDateFormat();
                for (Map.Entry entry : data.entrySet()) {
                    if (!((String)entry.getKey()).startsWith("Name.")) continue;
                    String locale = ((String)entry.getKey()).substring(((String)entry.getKey()).indexOf(46) + 1);
                    String name = String.format("%1$s (%2$s)", entry.getValue(), df.format(new Date()));
                    ret.put(locale, name);
                }
            }
        }
        return ret;
    }

    private boolean isForked(Instance instance, int nodeID) {
        LightWeightProcess lwp;
        boolean ret;
        ExecutableBusinessProcess ebp = instance.getTemplate().getNode(nodeID).getExecutableBusinessProcess();
        boolean bl = ret = ebp instanceof ReferencedProcess && ((ReferencedProcess)ebp).fork();
        if (!ret && ebp instanceof VariableParallelismEBP && (lwp = ((VariableParallelismEBP)ebp).getLightWeightProcess()) instanceof ReferencedProcess) {
            ret = ((ReferencedProcess)lwp).fork();
        }
        return ret;
    }
}

