/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.instancecontrol;

import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.executionmanager.InstanceStateListener;
import de.aristaflow.adept2.core.executionmanager.InstanceStateNotification;
import de.aristaflow.adept2.core.executionmanager.SubInstanceStateListener;
import de.aristaflow.adept2.core.executionmanager.SubInstanceStateNotification;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instancecontrol.InstanceExecutionTools;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instancecontrol.InstanceNotificationManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction.DefaultWorklistInteraction;
import de.aristaflow.adept2.core.logmanager.logs.ExecutionHistory;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DefaultInstanceNotification
extends AbstractSubService
implements InstanceNotificationManager {
    protected final ExecutorService callbackNotifiers;
    protected Registry registry;
    protected final DefaultExecutionManager executionManager;
    protected final DefaultWorklistInteraction worklistInteraction;

    public DefaultInstanceNotification(Registry registry, DefaultExecutionManager executionManager, DefaultWorklistInteraction worklistInteraction) {
        super(new String[0], new String[]{"ProcessManager", "DataManager", "LogManager", "UpdateManager"}, executionManager);
        this.registry = registry;
        this.executionManager = executionManager;
        this.worklistInteraction = worklistInteraction;
        this.callbackNotifiers = Executors.newCachedThreadPool(new Adept2ThreadFactory("InstanceNotification"));
    }

    @Override
    public void shutdown() {
        this.callbackNotifiers.shutdown();
        this.awaitExecutorServiceShutdown();
    }

    @Override
    public void emergencyShutdown() {
        this.callbackNotifiers.shutdownNow();
        this.awaitExecutorServiceShutdown();
    }

    private void awaitExecutorServiceShutdown() {
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = this.callbackNotifiers.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void instanceFinished(final SessionToken session, ExecutableInstance instance, final DataContainer dataContainer) throws InvalidInstanceStateException {
        super.sessionActive(session);
        try {
            URI[] stateListener;
            String msg;
            SessionToken subSession = this.executionManager.subSession(session);
            try {
                this.getInstanceManager().setExecutionStatus(subSession, instance.getID(), ProcessConstants.InstanceExecutionStatus.IE_FINISHED, "");
            }
            catch (LockException le) {
                msg = String.format("instanceFinished: LockException while setting execution status of instance ('%1$s'). An execution lock is missing although we have retrieved an executable instance. Please set the execution state manually! Continuing.", instance.getID());
                this.logger.log(Level.SEVERE, msg, le);
            }
            long timestamp = System.currentTimeMillis();
            try {
                subSession = this.executionManager.subSession(session);
                this.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logInstanceFinished(subSession, timestamp, instance);
            }
            catch (DataSourceException ex) {
                msg = "The instance finish could not be logged to the execution history! [Timestamp(%s), Instance(%s), StateChange(%s), AgentID(%s), AgentAgentOrgPositionID(%s)]";
                QualifiedAgent agent = instance.getInitiatorAgent();
                msg = String.format(msg, new Object[]{timestamp, instance.getID(), ExecutionHistory.StateChange.INSTANCE_FINISHED, agent.getAgentID(), agent.getOrgPositionID()});
                this.logger.log(Level.SEVERE, msg, ex);
            }
            if (instance.getParentEBPReference() == null) {
                subSession = this.executionManager.subSession(session);
                EBPInstanceReference ebpIR = this.executionManager.getEbpIRForInstance(instance);
                this.worklistInteraction.removeActivity(subSession, ebpIR);
            }
            if ((stateListener = instance.getInstanceStateListener()) != null && stateListener.length > 0) {
                EBPInstanceReference parentEBPReference = instance.getParentEBPReference();
                final UUID instanceID = instance.getID();
                if (parentEBPReference != null) {
                    subSession = this.executionManager.subSession(session);
                    SubInstanceStateNotification notification = null;
                    try {
                        notification = this.resolveSubInstanceStateListenerByURI(session, stateListener);
                    }
                    catch (ServiceNotKnownException skne) {
                        msg = String.format("Problems when retrieving the state listener for the subprocess instance %s. The listener will not be notified about finishing.", instanceID);
                        this.logger.log(Level.WARNING, msg, skne);
                    }
                    catch (IllegalArgumentException iae) {
                        msg = String.format("Problems when retrieving the state listener for the subprocess instance %s. The listener will not be notified about finishing.", instanceID);
                        this.logger.log(Level.WARNING, msg, iae);
                    }
                    if (notification != null) {
                        notification.instanceFinished(subSession, instanceID, parentEBPReference, dataContainer);
                    }
                } else {
                    this.callbackNotifiers.execute(new Runnable(){

                        @Override
                        public void run() {
                            String name = Thread.currentThread().getName();
                            Thread.currentThread().setName("InstanceControl.instanceFinished[" + instanceID + "]-Thread");
                            InstanceStateNotification notification = null;
                            try {
                                notification = DefaultInstanceNotification.this.resolveInstanceStateListenerByURI(session, stateListener);
                            }
                            catch (ServiceNotKnownException snke) {
                                String msg = String.format("Problems when retrieving the state listener for the instance %s. The listener will not be notified about finishing.", instanceID);
                                DefaultInstanceNotification.this.logger.log(Level.WARNING, msg, snke);
                            }
                            catch (IllegalArgumentException iae) {
                                String msg = String.format("Problems when retrieving the state listener for the instance %s. The listener will not be notified about finishing.", instanceID);
                                DefaultInstanceNotification.this.logger.log(Level.WARNING, msg, iae);
                            }
                            if (notification != null) {
                                notification.instanceFinished(instanceID, dataContainer);
                            }
                            Thread.currentThread().setName(name);
                        }
                    });
                }
            }
            subSession = this.executionManager.subSession(session);
            UpdateManager updateManager = this.getUpdateManager(subSession);
            InstanceExecutionTools.fireInstanceEvent(updateManager, instance, UpdateManager.InstanceProperties.INSTANCE_FINISHED);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void instanceFailed(final SessionToken session, ExecutableInstance instance, final long errorCode, final String state, final String errorMessage) throws InvalidInstanceStateException {
        super.sessionActive(session);
        try {
            URI[] stateListener;
            String msg;
            SessionToken subSession;
            long timestamp = System.currentTimeMillis();
            try {
                subSession = this.executionManager.subSession(session);
                this.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logInstanceFailed(subSession, timestamp, instance, errorCode, state, errorMessage);
            }
            catch (DataSourceException ex) {
                msg = "The instance failure could not be logged to the execution history! [Timestamp(%s), Instance(%s), StateChange(%s), AgentID(%s), AgentAgentOrgPositionID(%s), ErrorCode(%d), ErrorState(%s), ErrorMessage(%s)]";
                QualifiedAgent agent = instance.getInitiatorAgent();
                msg = String.format(msg, new Object[]{timestamp, instance.getID(), ExecutionHistory.StateChange.INSTANCE_FAILED, agent.getAgentID(), agent.getOrgPositionID(), errorCode, state, errorMessage});
                this.logger.log(Level.SEVERE, msg, ex);
            }
            subSession = this.executionManager.subSession(session);
            final DataContainer dataContainer = this.getDataManager(subSession, instance.getID()).retrieveInstanceDataContainer(subSession, instance, false);
            if (instance.getParentEBPReference() == null) {
                subSession = this.executionManager.subSession(session);
                EBPInstanceReference ebpIR = this.executionManager.getEbpIRForInstance(instance);
                this.worklistInteraction.removeActivity(subSession, ebpIR);
            }
            if ((stateListener = instance.getInstanceStateListener()) != null && stateListener.length > 0) {
                EBPInstanceReference parentEBPReference = instance.getParentEBPReference();
                final UUID instanceID = instance.getID();
                if (parentEBPReference != null) {
                    subSession = this.executionManager.subSession(session);
                    SubInstanceStateNotification notification = null;
                    try {
                        notification = this.resolveSubInstanceStateListenerByURI(session, stateListener);
                    }
                    catch (ServiceNotKnownException skne) {
                        msg = String.format("Problems when retrieving the state listener for the subprocess instance %s. The listener will not be notified about failing.", instanceID);
                        this.logger.log(Level.WARNING, msg, skne);
                    }
                    catch (IllegalArgumentException iae) {
                        msg = String.format("Problems when retrieving the state listener for the subprocess instance %s. The listener will not be notified about failing.", instanceID);
                        this.logger.log(Level.WARNING, msg, iae);
                    }
                    if (notification != null) {
                        notification.instanceFailed(subSession, instanceID, parentEBPReference, dataContainer, errorMessage, state, errorCode);
                    }
                } else {
                    this.callbackNotifiers.execute(new Runnable(){

                        @Override
                        public void run() {
                            String name = Thread.currentThread().getName();
                            Thread.currentThread().setName("InstanceControl.instanceFailed[" + instanceID + "]-Thread");
                            InstanceStateNotification notification = null;
                            try {
                                notification = DefaultInstanceNotification.this.resolveInstanceStateListenerByURI(session, stateListener);
                            }
                            catch (ServiceNotKnownException skne) {
                                String msg = String.format("Problems when retrieving the state listener for the instance %s. The listener will not be notified about failing.", instanceID);
                                DefaultInstanceNotification.this.logger.log(Level.WARNING, msg, skne);
                            }
                            catch (IllegalArgumentException iae) {
                                String msg = String.format("Problems when retrieving the state listener for the instance %s. The listener will not be notified about failing.", instanceID);
                                DefaultInstanceNotification.this.logger.log(Level.WARNING, msg, iae);
                            }
                            if (notification != null) {
                                notification.instanceFailed(instanceID, dataContainer, errorMessage, state, errorCode);
                            }
                            Thread.currentThread().setName(name);
                        }
                    });
                }
            }
            subSession = this.executionManager.subSession(session);
            UpdateManager updateManager = this.getUpdateManager(subSession);
            InstanceExecutionTools.fireInstanceEvent(updateManager, instance, UpdateManager.InstanceProperties.INSTANCE_FAILED);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void instanceSuspended(final SessionToken session, ExecutableInstance instance) throws InvalidInstanceStateException {
        super.sessionActive(session);
        try {
            URI[] stateListener;
            String msg;
            SessionToken subSession;
            long timestamp = System.currentTimeMillis();
            try {
                subSession = this.executionManager.subSession(session);
                this.executionManager.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logInstanceSuspended(subSession, timestamp, instance);
            }
            catch (DataSourceException ex) {
                msg = "The instance suspension could not be logged to the execution history! [Timestamp(%s), Instance(%s), StateChange(%s), AgentID(%s), AgentAgentOrgPositionID(%s)]";
                QualifiedAgent agent = instance.getInitiatorAgent();
                msg = String.format(msg, new Object[]{timestamp, instance.getID(), ExecutionHistory.StateChange.INSTANCE_SUSPENDED, agent.getAgentID(), agent.getOrgPositionID()});
                this.logger.log(Level.SEVERE, msg, ex);
            }
            subSession = this.executionManager.subSession(session);
            DataContainer dataContainer = this.getDataManager(subSession, instance.getID()).retrieveInstanceDataContainer(session, instance, false);
            if (instance.getParentEBPReference() == null) {
                subSession = this.executionManager.subSession(session);
                EBPInstanceReference ebpIR = this.executionManager.getEbpIRForInstance(instance);
                this.worklistInteraction.updateActivityState(subSession, ebpIR, ProcessConstants.NodeState.NS_SUSPENDED);
            }
            if ((stateListener = instance.getInstanceStateListener()) != null && stateListener.length > 0) {
                EBPInstanceReference parentEBPReference = instance.getParentEBPReference();
                final UUID instanceID = instance.getID();
                if (parentEBPReference != null) {
                    subSession = this.executionManager.subSession(session);
                    SubInstanceStateNotification notification = null;
                    try {
                        notification = this.resolveSubInstanceStateListenerByURI(session, stateListener);
                    }
                    catch (ServiceNotKnownException skne) {
                        msg = String.format("Problems when retrieving the state listener for the subprocess instance %s. The listener will not be notified about suspension.", instanceID);
                        this.logger.log(Level.WARNING, msg, skne);
                    }
                    catch (IllegalArgumentException iae) {
                        msg = String.format("Problems when retrieving the state listener for the subprocess instance %s. The listener will not be notified about suspension.", instanceID);
                        this.logger.log(Level.WARNING, msg, iae);
                    }
                    if (notification != null) {
                        notification.instanceSuspended(subSession, instanceID, parentEBPReference, dataContainer);
                    }
                } else {
                    this.callbackNotifiers.execute(new Runnable(){

                        @Override
                        public void run() {
                            String name = Thread.currentThread().getName();
                            Thread.currentThread().setName("InstanceControl.instanceSuspended[" + instanceID + "]-Thread");
                            InstanceStateNotification notification = null;
                            try {
                                notification = DefaultInstanceNotification.this.resolveInstanceStateListenerByURI(session, stateListener);
                            }
                            catch (ServiceNotKnownException skne) {
                                String msg = String.format("Problems when retrieving the state listener for the instance %s. The listener will not be notified about suspension.", instanceID);
                                DefaultInstanceNotification.this.logger.log(Level.WARNING, msg, skne);
                            }
                            catch (IllegalArgumentException iae) {
                                String msg = String.format("Problems when retrieving the state listener for the instance %s. The listener will not be notified about suspension.", instanceID);
                                DefaultInstanceNotification.this.logger.log(Level.WARNING, msg, iae);
                            }
                            if (notification != null) {
                                notification.instanceSuspended(instanceID);
                            }
                            Thread.currentThread().setName(name);
                        }
                    });
                }
            }
            subSession = this.executionManager.subSession(session);
            UpdateManager updateManager = this.getUpdateManager(subSession);
            InstanceExecutionTools.fireInstanceEvent(updateManager, instance, UpdateManager.InstanceProperties.INSTANCE_SUSPENDED);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void instanceResumed(SessionToken session, ExecutableInstance instance) {
        super.sessionActive(session);
        try {
            URI[] stateListener;
            SessionToken subSession;
            long timestamp = System.currentTimeMillis();
            try {
                subSession = this.executionManager.subSession(session);
                this.executionManager.getExecutionHistory(subSession, instance.getID()).getWriteAccess().logInstanceResumed(subSession, timestamp, instance);
            }
            catch (DataSourceException ex) {
                String msg = "The instance resuming could not be logged to the execution history! [Timestamp(%s), Instance(%s), StateChange(%s), AgentID(%s), AgentAgentOrgPositionID(%s)]";
                QualifiedAgent agent = instance.getInitiatorAgent();
                msg = String.format(msg, new Object[]{timestamp, instance.getID(), ExecutionHistory.StateChange.INSTANCE_RESUMED, agent.getAgentID(), agent.getOrgPositionID()});
                this.logger.log(Level.SEVERE, msg, ex);
            }
            if (instance.getParentEBPReference() == null) {
                subSession = this.executionManager.subSession(session);
                EBPInstanceReference ebpIR = this.executionManager.getEbpIRForInstance(instance);
                this.worklistInteraction.updateActivityState(subSession, ebpIR, ProcessConstants.NodeState.NS_RUNNING);
            }
            if ((stateListener = instance.getInstanceStateListener()) != null && stateListener.length > 0) {
                EBPInstanceReference parentEBPReference = instance.getParentEBPReference();
                UUID instanceID = instance.getID();
                if (parentEBPReference != null) {
                    subSession = this.executionManager.subSession(session);
                    SubInstanceStateNotification notification = null;
                    try {
                        notification = this.resolveSubInstanceStateListenerByURI(subSession, stateListener);
                    }
                    catch (ServiceNotKnownException skne) {
                        String msg = String.format("Problems when retrieving the state listener for the subprocess instance %s. The listener will not be notified about resuming.", instanceID);
                        this.logger.log(Level.SEVERE, msg, skne);
                    }
                    catch (IllegalArgumentException iae) {
                        String msg = String.format("Problems when retrieving the state listener for the subprocess instance %s. The listener will not be notified about resuming.", instanceID);
                        this.logger.log(Level.SEVERE, msg, iae);
                    }
                    if (notification != null) {
                        notification.instanceResumed(subSession, instanceID, parentEBPReference);
                    }
                } else {
                    subSession = this.executionManager.subSession(session);
                    InstanceStateNotification notification = null;
                    try {
                        notification = this.resolveInstanceStateListenerByURI(subSession, stateListener);
                    }
                    catch (ServiceNotKnownException skne) {
                        String msg = String.format("Problems when retrieving the state listener for the instance %s. The listener will not be notified about resuming.", instanceID);
                        this.logger.log(Level.WARNING, msg, skne);
                    }
                    catch (IllegalArgumentException iae) {
                        String msg = String.format("Problems when retrieving the state listener for the instance %s. The listener will not be notified about resuming.", instanceID);
                        this.logger.log(Level.WARNING, msg, iae);
                    }
                    if (notification != null) {
                        notification.instanceResumed(instanceID);
                    }
                }
            }
            subSession = this.executionManager.subSession(session);
            InstanceExecutionTools.fireInstanceEvent(this.getUpdateManager(subSession), instance, UpdateManager.InstanceProperties.INSTANCE_RESUMED);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected InstanceStateNotification resolveInstanceStateListenerByURI(SessionToken session, URI[] stateListener) throws ServiceNotKnownException {
        InstanceStateListener listener = this.registry.getService(session, stateListener, InstanceStateListener.class);
        return listener.getInstanceStateNotification();
    }

    protected SubInstanceStateNotification resolveSubInstanceStateListenerByURI(SessionToken session, URI[] stateListener) throws ServiceNotKnownException {
        SubInstanceStateListener listener = this.registry.getService(session, stateListener, SubInstanceStateListener.class);
        return listener.getSubInstanceStateNotification();
    }

    protected ExecutionHistory getExecutionHistory(SessionToken session, UUID instanceID) {
        return this.executionManager.getExecutionHistory(session, instanceID);
    }

    protected InstanceManager getInstanceManager() {
        return this.executionManager.getProcessManager().getInstanceManager();
    }

    protected UpdateManager getUpdateManager(SessionToken session) {
        return this.executionManager.getUpdateManager(session);
    }

    protected DataManager getDataManager(SessionToken session, UUID instanceID) {
        return this.executionManager.getResolvedDataManager(session, instanceID);
    }
}

