/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.instancecontrol;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InstanceExecutionTools {
    private static final Logger logger = LoggerTools.getLogger(InstanceExecutionTools.class);

    public static void checkDataContextForTemplateParameters(SessionToken session, ExecutionContext executionContext, Template template) throws InvalidDataContainerException {
        DataContainer dataContainer = executionContext.getDataContainer();
        for (ProcessModelParameter parameter : template.getParameters(ActivityConstants.AccessType.READ)) {
            boolean parameterIsNull;
            if (parameter.isOptional()) continue;
            if (dataContainer == null) {
                String message = String.format("Found mandatory input parameter '%s', but data container was null.", parameter.getName());
                logger.warning(message);
                throw new InvalidDataContainerException(null, parameter.getName());
            }
            try {
                parameterIsNull = dataContainer.isNull(session, parameter.getName());
            }
            catch (NoSuchParameterException noSuchParameterException) {
                String message = String.format("Found mandatory input parameter '%s', but data container has no such parameter.", parameter.getName());
                logger.warning(message);
                throw new InvalidDataContainerException((InputDataContainer)dataContainer, parameter.getName());
            }
            if (!parameterIsNull) continue;
            String message = String.format("Found mandatory input parameter '%s', but the value in the data container is null.", parameter.getName());
            logger.warning(message);
            throw new InvalidDataContainerException((InputDataContainer)dataContainer, parameter.getName());
        }
    }

    public static boolean checkIsInstanceAbortable(UUID instanceID, ProcessConstants.InstanceExecutionStatus instanceExecutionStatus, InstanceManager instanceManager) throws InvalidInstanceStateException {
        boolean ret = true;
        String msg = "Aborting an instance requires the InstanceExecutionStatus IE_RUNNING, IE_SUSPENDED or IE_SOFTLY_SUSPENDED, but the instance %s to abort has the%s InstanceExecutionStatus %s!";
        switch (instanceExecutionStatus) {
            case IE_FINISHED: {
                msg = String.format(msg, instanceID, "", instanceExecutionStatus.name());
                throw new InvalidInstanceStateException(instanceID, instanceExecutionStatus, msg);
            }
            case IE_RUNNING: 
            case IE_SUSPENDED: 
            case IE_SOFTLY_SUSPENDED: {
                ret = true;
                break;
            }
            case IE_ABORTED: 
            case IE_SOFTLY_ABORTED: {
                ret = false;
                break;
            }
            default: {
                logger.log(Level.SEVERE, String.format(msg, instanceID, " unknown", instanceExecutionStatus.name()));
                assert (false);
                break;
            }
        }
        if (instanceManager.getChangeLockingAgent(instanceID) != null) {
            msg = "The instance %s can not be aborted since it is currently changed!";
            throw new InvalidInstanceStateException(instanceID, ProcessConstants.InstanceMigrationStatus.IM_MIGRATING, String.format(msg, instanceID));
        }
        return ret;
    }

    public static void checkIsInstanceAbortable(UUID instanceID, UUID parentInstanceID, ProcessConstants.InstanceExecutionStatus parentExecutionStatus, InstanceManager instanceManager) throws InvalidInstanceStateException {
        String msg = "Aborting a subprocess instance requires the InstanceExecutionStatus of the parent instance to be IE_RUNNING, IE_SOFTLY_SUSPENDED or IE_SOFTLY_ABORTED, but the parent instance %s (of subprocess %s) has the%s InstanceExecutionStatus %s!";
        switch (parentExecutionStatus) {
            case IE_SUSPENDED: 
            case IE_ABORTED: 
            case IE_FINISHED: {
                msg = String.format(msg, parentInstanceID, instanceID, "", parentExecutionStatus.name());
                throw new InvalidInstanceStateException(instanceID, parentExecutionStatus, msg);
            }
            case IE_RUNNING: 
            case IE_SOFTLY_SUSPENDED: 
            case IE_SOFTLY_ABORTED: {
                break;
            }
            default: {
                logger.log(Level.SEVERE, String.format(msg, parentInstanceID, instanceID, " unknown", parentExecutionStatus.name()));
                assert (false);
                break;
            }
        }
        if (instanceManager.getChangeLockingAgent(parentInstanceID) != null) {
            msg = "The instance %s can not be aborted since its parent instance %s is currently changed!";
            throw new InvalidInstanceStateException(instanceID, ProcessConstants.InstanceMigrationStatus.IM_MIGRATING, String.format(msg, instanceID, parentInstanceID));
        }
    }

    public static boolean checkIsInstanceSuspendable(UUID instanceID, ProcessConstants.InstanceExecutionStatus instanceExecutionStatus, InstanceManager instanceManager) throws InvalidInstanceStateException {
        boolean ret = true;
        String msg = "Suspending an instance requires the InstanceExecutionStatus IE_RUNNING, but the instance %s to suspend has the%s InstanceExecutionStatus %s!";
        switch (instanceExecutionStatus) {
            case IE_ABORTED: 
            case IE_SOFTLY_ABORTED: 
            case IE_FINISHED: {
                msg = String.format(msg, instanceID, "", instanceExecutionStatus.name());
                throw new InvalidInstanceStateException(instanceID, instanceExecutionStatus, msg);
            }
            case IE_SUSPENDED: 
            case IE_SOFTLY_SUSPENDED: {
                ret = false;
                break;
            }
            case IE_RUNNING: {
                ret = true;
                break;
            }
            default: {
                logger.log(Level.SEVERE, String.format(msg, instanceID, " unknown", instanceExecutionStatus.name()));
                assert (false);
                break;
            }
        }
        if (instanceManager.getChangeLockingAgent(instanceID) != null) {
            msg = "The instance %s can not be suspended since it is currently changed!";
            throw new InvalidInstanceStateException(instanceID, ProcessConstants.InstanceMigrationStatus.IM_MIGRATING, String.format(msg, instanceID));
        }
        return ret;
    }

    public static void checkIsInstanceSuspendable(UUID instanceID, UUID parentInstanceID, ProcessConstants.InstanceExecutionStatus parentExecutionStatus, InstanceManager instanceManager) throws InvalidInstanceStateException {
        String msg = "Suspending a subprocess instance requires the InstanceExecutionStatus of the parent instance to be IE_RUNNING, IE_SOFTLY_SUSPENDED or IE_SOFTLY_ABORTED, but the parent instance %s (of subprocess %s) has the%s InstanceExecutionStatus %s!";
        switch (parentExecutionStatus) {
            case IE_SUSPENDED: 
            case IE_ABORTED: 
            case IE_FINISHED: {
                msg = String.format(msg, parentInstanceID, instanceID, "", parentExecutionStatus.name());
                throw new InvalidInstanceStateException(instanceID, parentExecutionStatus, msg);
            }
            case IE_RUNNING: 
            case IE_SOFTLY_SUSPENDED: 
            case IE_SOFTLY_ABORTED: {
                break;
            }
            default: {
                logger.log(Level.SEVERE, String.format(msg, parentInstanceID, instanceID, " unknown", parentExecutionStatus.name()));
                assert (false);
                break;
            }
        }
        if (instanceManager.getChangeLockingAgent(parentInstanceID) != null) {
            msg = "The instance %s can not be suspended since its parent instance %s is currently changed!";
            throw new InvalidInstanceStateException(instanceID, ProcessConstants.InstanceMigrationStatus.IM_MIGRATING, String.format(msg, instanceID, parentInstanceID));
        }
    }

    public static void checkIsInstanceResumeable(UUID instanceID, ProcessConstants.InstanceExecutionStatus instanceExecutionStatus, InstanceManager instanceManager) throws InvalidInstanceStateException {
        String msg = "Resuming an instance requires the InstanceExecutionStatus IE_SUSPENDED, but the Instance %s to resume has the%s InstanceExecutionStatus %s!";
        switch (instanceExecutionStatus) {
            case IE_RUNNING: 
            case IE_ABORTED: 
            case IE_SOFTLY_ABORTED: 
            case IE_FINISHED: {
                msg = String.format(msg, instanceID, "", instanceExecutionStatus.name());
                throw new InvalidInstanceStateException(instanceID, instanceExecutionStatus, msg);
            }
            case IE_SUSPENDED: 
            case IE_SOFTLY_SUSPENDED: {
                break;
            }
            default: {
                logger.log(Level.SEVERE, String.format(msg, instanceID, " unknown", instanceExecutionStatus.name()));
                assert (false);
                break;
            }
        }
        if (instanceManager.getChangeLockingAgent(instanceID) != null) {
            msg = "The instance %s can not be resumed since it is currently changed!";
            throw new InvalidInstanceStateException(instanceID, ProcessConstants.InstanceMigrationStatus.IM_MIGRATING, String.format(msg, instanceID));
        }
    }

    public static void checkIsInstanceResumeable(UUID instanceID, UUID parentInstanceID, ProcessConstants.InstanceExecutionStatus parentExecutionStatus, InstanceManager instanceManager) throws InvalidInstanceStateException {
        String msg = "Resuming a subprocess instance requires the InstanceExecutionStatus of the parent instance to be IE_RUNNING, but the parent instance %s (of subprocess %s) has the%s InstanceExecutionStatus %s!";
        switch (parentExecutionStatus) {
            case IE_SUSPENDED: 
            case IE_SOFTLY_SUSPENDED: 
            case IE_ABORTED: 
            case IE_SOFTLY_ABORTED: 
            case IE_FINISHED: {
                msg = String.format(msg, parentInstanceID, instanceID, "", parentExecutionStatus.name());
                throw new InvalidInstanceStateException(instanceID, parentExecutionStatus, msg);
            }
            case IE_RUNNING: {
                break;
            }
            default: {
                logger.log(Level.SEVERE, String.format(msg, parentInstanceID, instanceID, " unknown", parentExecutionStatus.name()));
                assert (false);
                break;
            }
        }
        if (instanceManager.getChangeLockingAgent(parentInstanceID) != null) {
            msg = "The instance %s can not be resumed since its parent instance %s is currently changed!";
            throw new InvalidInstanceStateException(instanceID, ProcessConstants.InstanceMigrationStatus.IM_MIGRATING, String.format(msg, instanceID, parentInstanceID));
        }
    }

    public static void fireInstanceEvent(UpdateManager updateManager, Instance instance, UpdateManager.InstanceProperties eventType) {
        updateManager.firePropertyChange(instance, (Object)eventType);
        updateManager.sendPropertyChanges();
    }
}

