/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.instanceexecution;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.ParameterRefResolver;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityActivation;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionControlManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionTools;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.StartEndNodeHandling;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.components.ADEPT2DefaultComponentFactory;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instancecontrol.InstanceNotificationManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.instanceexecution.InstanceProceeding;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction.WorklistAccess;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;

public class InstanceExecution
extends InstanceProceeding {
    public static final long USER_SIGNALED_INSTANCE_FAIL = 1L;
    protected ActivityExecutionControlManager activityExecution;
    protected StartEndNodeHandling startEndNodeHandling;
    protected InstanceControl instanceControl;
    protected InstanceNotificationManager instanceNotificationManager;

    public InstanceExecution(DefaultExecutionManager executionManager, WorklistAccess worklistAccess) {
        super(new String[0], new String[]{"DataManager"}, executionManager, worklistAccess);
    }

    public void init(ActivityActivation activityActivation, ActivityExecutionControlManager activityExecution, StartEndNodeHandling startEndNodeHandling, InstanceControl instanceControl, InstanceNotificationManager instanceNotificationManager, QualifiedAgent nodeExecutor) throws AbortServiceException {
        super.init(activityActivation, nodeExecutor);
        this.activityExecution = activityExecution;
        this.startEndNodeHandling = startEndNodeHandling;
        this.instanceControl = instanceControl;
        this.instanceNotificationManager = instanceNotificationManager;
    }

    public Runnable activateStartNode(final SessionToken parentSession, final ExecutionContext executionContext, final ExecutableInstance instance) {
        super.sessionActive(parentSession);
        try {
            SessionToken subSession = this.executionManager.subSession(parentSession);
            UUID instanceID = instance.getID();
            Node startNode = instance.getTemplate().getStartNode();
            int startNodeID = startNode.getID();
            this.activateNode(subSession, instance, startNodeID);
            final EBPInstanceReference startActivity = this.executionManager.getProcessModelFactory().createEBPInstanceReference(EBPType.NULL, instanceID, instance.getBaseTemplateID(), startNodeID, instance.getNodeIteration(startNodeID), true, this.getURIs());
            final SessionToken startToken = this.executionManager.newSession(parentSession);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        InstanceExecution.this.startEndNodeHandling.executeStartActivity(startToken, parentSession, startActivity, executionContext.getExecutionMode(), executionContext.getDataContainer());
                    }
                    catch (InvalidActivityStateException e) {
                        String errorMessage = String.format("Cannot execute the start node of instance '%s' even though the instance was just started.", instance.getID());
                        InstanceExecution.this.logger.log(Level.SEVERE, errorMessage, e);
                    }
                }
            };
            return runnable;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    public void afterFinished(SessionToken parentSession, ExecutableInstance instance, EBPInstanceReference activity) {
        super.sessionActive(parentSession);
        try {
            SessionToken subSession = this.executionManager.subSession(parentSession);
            ProcessConstants.NodeState nodeState = instance.getNodeState(activity.getNodeID());
            if (!nodeState.equals((Object)ProcessConstants.NodeState.NS_COMPLETED) && !nodeState.equals((Object)ProcessConstants.NodeState.NS_ENQUIRED)) {
                String msg = String.format("The node '%1$s' of instance '%2$s' should be in state  NS_COMPLETED or NS_ENQUIRED for finishing but it is in state %3$s. This is a serious problem because the complete instance is in an inconsistent state!", activity.getNodeID(), instance.getID(), nodeState.name());
                this.logger.severe(msg);
                throw new InternalServiceException(msg);
            }
            if (activity.getNodeID() == instance.getTemplate().getEndNode().getID()) {
                DataManager dataManager = this.getDataManager(subSession, instance.getID());
                DataContainer instanceDataContainer = dataManager.retrieveInstanceDataContainer(subSession, instance, true);
                try {
                    subSession = this.executionManager.subSession(parentSession);
                    this.instanceNotificationManager.instanceFinished(subSession, instance, instanceDataContainer);
                }
                catch (InvalidInstanceStateException iise) {
                    this.logger.log(Level.SEVERE, "Could not finish activity since instance was in wrong state.", iise);
                }
            } else {
                SessionToken newSession = this.executionManager.newSession(parentSession);
                super.privilegeSession(parentSession, newSession);
                this.proceedProcessInstance(newSession, instance.getID(), activity.getNodeID());
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    public void afterResetted(SessionToken parentSession, ExecutableInstance instance, EBPInstanceReference activity) {
        super.sessionActive(parentSession);
        try {
            ProcessConstants.NodeState nodeState = instance.getNodeState(activity.getNodeID());
            if (!nodeState.equals((Object)ProcessConstants.NodeState.NS_NOT_ACTIVATED)) {
                String message = String.format("Node was expected to be in state '%s', but was in state '%s'.", new Object[]{ProcessConstants.NodeState.NS_NOT_ACTIVATED, nodeState});
                throw new InternalServiceException(message);
            }
            int pred = instance.getTemplate().getPredByEdgeType(activity.getNodeID(), ProcessConstants.EdgeType.ET_CONTROL)[0];
            SessionToken newSession = this.executionManager.newSession(parentSession);
            super.privilegeSession(parentSession, newSession);
            this.proceedProcessInstance(newSession, instance.getID(), pred);
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    public void afterFailed(SessionToken parentSession, ExecutableInstance instance, EBPInstanceReference activity, DataContainer dataContainer, long errorCode, String state, String errorMessage) {
    }

    public void abortRunningActivityInstances(SessionToken parentSession, final ExecutableInstance instance) {
        super.sessionActive(parentSession);
        try {
            int[] runningNodeIDs = instance.getNodesInState(ProcessConstants.NodeState.NS_RUNNING);
            ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>(runningNodeIDs.length);
            Object object = runningNodeIDs;
            int n = runningNodeIDs.length;
            int n2 = 0;
            while (n2 < n) {
                int runningNodeID = object[n2];
                ExecutableBusinessProcess ebp = instance.getTemplate().getNode(runningNodeID).getExecutableBusinessProcess();
                boolean isActivity = ActivityExecutionTools.isActivity(ebp);
                EBPType ebpType = ActivityExecutionTools.getEBPType(ebp);
                final EBPInstanceReference abortNode = this.executionManager.getProcessModelFactory().createEBPInstanceReference(ebpType, instance.getID(), instance.getBaseTemplateID(), runningNodeID, instance.getNodeIteration(runningNodeID), isActivity, this.getURIs(), instance.getAssignedRuntimeManager(runningNodeID));
                final SessionToken abortSession = this.executionManager.subSession(parentSession);
                results.add(this.executorService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws InvalidActivityStateException {
                        InstanceExecution.this.activityExecution.abortActivity(abortSession, instance, abortNode, "The instance this activity is assigned to was aborted.", 1L, true);
                        return Boolean.TRUE;
                    }
                }));
                ++n2;
            }
            boolean interrupted = false;
            object = results.iterator();
            while (object.hasNext()) {
                String msg;
                Future result = (Future)object.next();
                try {
                    boolean aborted = false;
                    while (!aborted) {
                        try {
                            result.get();
                            aborted = true;
                        }
                        catch (InterruptedException interruptedException) {
                            msg = "Interrupted while waiting for the termination of aborting running instances. Ignoring interrupt until abortion has finished.";
                            this.logger.warning(msg);
                            interrupted = true;
                        }
                    }
                }
                catch (ExecutionException ee) {
                    msg = "There was an exception while aborting a running activity! Since we are already aborting, we can not do anything. Continuing.";
                    this.logger.log(Level.WARNING, msg, ee.getCause());
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    public boolean suspendRunningActivityInstances(SessionToken parentSession, final ExecutableInstance instance) {
        super.sessionActive(parentSession);
        try {
            int[] runningNodeIDs = instance.getNodesInState(ProcessConstants.NodeState.NS_RUNNING);
            ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>(runningNodeIDs.length);
            int[] nArray = runningNodeIDs;
            int n = runningNodeIDs.length;
            int n2 = 0;
            while (n2 < n) {
                int runningNodeID = nArray[n2];
                ExecutableBusinessProcess executableBusinessProcess = instance.getTemplate().getNode(runningNodeID).getExecutableBusinessProcess();
                boolean isActivity = ActivityExecutionTools.isActivity(executableBusinessProcess);
                EBPType ebpType = ActivityExecutionTools.getEBPType(executableBusinessProcess);
                final EBPInstanceReference suspendNode = this.executionManager.getProcessModelFactory().createEBPInstanceReference(ebpType, instance.getID(), instance.getBaseTemplateID(), runningNodeID, instance.getNodeIteration(runningNodeID), isActivity, this.getURIs(), instance.getAssignedRuntimeManager(runningNodeID));
                final SessionToken suspendSession = this.executionManager.subSession(parentSession);
                results.add(this.executorService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws InvalidActivityStateException {
                        boolean ret = InstanceExecution.this.activityExecution.suspendActivity(suspendSession, instance, suspendNode, true);
                        return ret;
                    }
                }));
                ++n2;
            }
            boolean ret = true;
            boolean interrupted = false;
            Boolean suspensionResult = Boolean.FALSE;
            for (Future future : results) {
                String msg;
                try {
                    boolean suspended = false;
                    while (!suspended) {
                        try {
                            suspensionResult = (Boolean)future.get();
                            suspended = true;
                        }
                        catch (InterruptedException interruptedException) {
                            msg = "Interrupted while waiting for the termination of suspending running instances. Ignoring interrupt until suspension has finished.";
                            this.logger.warning(msg);
                            interrupted = true;
                        }
                    }
                }
                catch (ExecutionException ee) {
                    msg = "There was an exception while suspending a running activity!  Trying to suspend other running activities of the instance.";
                    if (ee.getCause() instanceof InvalidActivityStateException) {
                        this.logger.log(Level.INFO, msg, ee.getCause());
                    } else {
                        this.logger.log(Level.WARNING, msg, ee.getCause());
                    }
                    suspensionResult = Boolean.FALSE;
                }
                ret &= suspensionResult.booleanValue();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    public void rescheduleActivities(SessionToken session, ExecutableInstance instance) {
        super.sessionActive(session);
        try {
            WorklistData worklistData;
            SessionToken subSession;
            int nodeID;
            LinkedList<Integer> successors = new LinkedList<Integer>();
            LinkedList<Integer> predecessors = new LinkedList<Integer>();
            HashSet<Integer> activated = new HashSet<Integer>();
            HashSet<Integer> assigned = new HashSet<Integer>();
            HashSet<Integer> completed = new HashSet<Integer>();
            successors.add(instance.getTemplate().getStartNode().getID());
            predecessors.add(instance.getTemplate().getStartNode().getID());
            block9: while (!successors.isEmpty()) {
                int current = (Integer)successors.remove(0);
                int pred = (Integer)predecessors.remove(0);
                ProcessConstants.NodeState currState = instance.getNodeState(current);
                switch (currState) {
                    case NS_NOT_ACTIVATED: {
                        int n;
                        boolean inconsistentState = true;
                        if (instance.getTemplate().getNodeType(current) == ProcessConstants.NodeType.NT_XOR_JOIN || instance.getTemplate().getNodeType(current) == ProcessConstants.NodeType.NT_AND_JOIN) {
                            int[] joinPreds;
                            int[] nArray = joinPreds = instance.getTemplate().getPredByEdgeType(current, ProcessConstants.EdgeType.ET_CONTROL);
                            int n2 = joinPreds.length;
                            n = 0;
                            while (n < n2) {
                                int joinPred = nArray[n];
                                if (instance.getNodeState(joinPred) != ProcessConstants.NodeState.NS_COMPLETED && instance.getNodeState(joinPred) != ProcessConstants.NodeState.NS_ENQUIRED && instance.getNodeState(joinPred) != ProcessConstants.NodeState.NS_SKIPPED) {
                                    inconsistentState = false;
                                    break;
                                }
                                ++n;
                            }
                        }
                        if (!inconsistentState) break;
                        completed.add(pred);
                        break;
                    }
                    case NS_ENQUIRED: 
                    case NS_COMPLETED: 
                    case NS_SKIPPED: {
                        int[] currSuccs;
                        int[] nArray = currSuccs = instance.getTemplate().getSuccByEdgeType(current, ProcessConstants.EdgeType.ET_CONTROL);
                        int n = currSuccs.length;
                        int n3 = 0;
                        while (n3 < n) {
                            int i = nArray[n3];
                            predecessors.add(current);
                            successors.add(i);
                            ++n3;
                        }
                        continue block9;
                    }
                    case NS_ACTIVATED: {
                        activated.add(current);
                        break;
                    }
                    case NS_SELECTED: 
                    case NS_SUSPENDED: {
                        assigned.add(current);
                    }
                }
            }
            Iterator iterator = activated.iterator();
            while (iterator.hasNext()) {
                nodeID = (Integer)iterator.next();
                if (nodeID == instance.getTemplate().getEndNode().getID()) {
                    subSession = this.executionManager.subSession(session);
                    EBPType type = EBPType.NULL;
                    boolean isActivity = ActivityExecutionTools.isActivity(null);
                    EBPInstanceReference endNodeActivity = this.executionManager.getProcessModelFactory().createEBPInstanceReference(type, instance.getID(), instance.getBaseTemplateID(), nodeID, instance.getNodeIteration(nodeID), isActivity, this.getURIs());
                    this.startEndNodeHandling.endActivityIsActivated(subSession, endNodeActivity);
                    continue;
                }
                subSession = this.executionManager.subSession(session);
                worklistData = this.getWorklistData(subSession, instance, nodeID);
                this.worklistAccess.addActivity(subSession, worklistData.ebpInstance, instance.getNodeState(nodeID), worklistData.ebpIR, worklistData.resolvingNode.getStaffAssignmentRule());
            }
            iterator = assigned.iterator();
            while (iterator.hasNext()) {
                nodeID = (Integer)iterator.next();
                subSession = this.executionManager.subSession(session);
                worklistData = this.getWorklistData(subSession, instance, nodeID);
                this.worklistAccess.addAndAssignActivity(subSession, worklistData.ebpInstance, instance.getNodeState(nodeID), worklistData.ebpIR, worklistData.resolvingNode.getStaffAssignmentRule(), instance.getPerformingAgent(nodeID));
            }
            subSession = this.executionManager.subSession(session);
            this.resumeEmbeddedProcesses(subSession, instance);
            iterator = completed.iterator();
            while (iterator.hasNext()) {
                nodeID = (Integer)iterator.next();
                SessionToken proceedSession = this.executionManager.newSession(session);
                super.privilegeSession(session, proceedSession);
                this.proceedProcessInstance(proceedSession, instance.getID(), nodeID);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected void resumeEmbeddedProcesses(SessionToken session, final ExecutableInstance instance) {
        int[] nArray = instance.getNodesInState(ProcessConstants.NodeState.NS_RUNNING);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            final int parent = nArray[n2];
            ExecutableBusinessProcess ebp = instance.getTemplate().getNode(parent).getExecutableBusinessProcess();
            if (ebp instanceof EmbeddedProcess) {
                for (final UUID lwpID : instance.getNodeLWPInstanceID(parent)) {
                    final SessionToken resumeSession = this.executionManager.newSession(session);
                    this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                InstanceExecution.this.instanceControl.resumeInstance(resumeSession, lwpID);
                            }
                            catch (InvalidInstanceStateException iise) {
                                String msg = String.format("Cannot resume embedded process at node '%s' of instance '%s', because subprocess instance '%s'is in wrong state %s! Aborting resume. Try to resume manually.", parent, instance.getID(), lwpID, iise.getPreventingState());
                                InstanceExecution.this.logger.warning(msg);
                            }
                        }
                    });
                }
            }
            ++n2;
        }
    }

    protected WorklistData getWorklistData(SessionToken session, ExecutableInstance instance, int nodeID) {
        Node node = instance.getTemplate().getNode(nodeID);
        ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
        boolean isActivity = ActivityExecutionTools.isActivity(ebp);
        EBPType ebpType = ActivityExecutionTools.getEBPType(ebp);
        int nodeIteration = instance.getNodeIteration(nodeID);
        SessionToken subSession = this.executionManager.subSession(session);
        EBPInstanceReference ebpIR = this.executionManager.getProcessModelFactory().createEBPInstanceReference(ebpType, instance.getID(), instance.getBaseTemplateID(), nodeID, nodeIteration, isActivity, this.getURIs());
        ProcessAwareAccess paa = this.executionManager.getResolvedDataManager(subSession, instance.getID()).getProcessAwareAccess();
        ParameterDataContext dataContext = paa.getPublicDataContext(session, instance, nodeID);
        InputDataContainer nodeDataContainer = paa.getNodeDataContainer(subSession, instance, nodeID);
        subSession = this.executionManager.subSession(session);
        ExecutableBusinessProcessInstance ebpInstance = ActivityExecutionTools.setUpEBPInstance(subSession, ebpIR, instance, this.getComponentFactory(), this.getExecutionFactory(), dataContext, nodeDataContainer, this.executionManager.getPluginRegistry());
        subSession = this.executionManager.subSession(session);
        Node resolvingNode = ParameterRefResolver.getProxy(node, Node.class, nodeDataContainer, subSession, this.executionManager.getPluginRegistry());
        return new WorklistData(ebpInstance, resolvingNode, ebpIR);
    }

    protected ADEPT2DefaultComponentFactory getComponentFactory() {
        return this.executionManager.getADEPT2DefaultComponentFactory();
    }

    protected ExecutionFactory getExecutionFactory() {
        return this.executionManager.getExecutionFactory();
    }

    protected static class WorklistData {
        public final ExecutableBusinessProcessInstance ebpInstance;
        public final Node resolvingNode;
        public final EBPInstanceReference ebpIR;

        protected WorklistData(ExecutableBusinessProcessInstance ebpInstance, Node resolvingNode, EBPInstanceReference ebpIR) {
            this.ebpInstance = ebpInstance;
            this.resolvingNode = resolvingNode;
            this.ebpIR = ebpIR;
        }
    }
}

