/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.instanceexecution;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityActivation;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionTools;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction.WorklistAccess;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.ArrayTools;
import de.aristaflow.adept2.util.LockException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class InstanceProceeding
extends AbstractSubService {
    protected final DefaultExecutionManager executionManager;
    protected ActivityActivation activityActivation;
    protected final WorklistAccess worklistAccess;
    protected ExecutorService executorService;
    protected QualifiedAgent nodeExecutor;

    public InstanceProceeding(String[] startupRequiredServices, String[] runtimeRequiredServices, DefaultExecutionManager executionManager, WorklistAccess worklistAccess) {
        super(ArrayTools.join(startupRequiredServices, {"ProcessManager", "DataManager", "UpdateManager"}), runtimeRequiredServices, executionManager);
        this.executionManager = executionManager;
        this.worklistAccess = worklistAccess;
    }

    public void init(ActivityActivation activityActivation, QualifiedAgent nodeExecutor) throws AbortServiceException {
        this.activityActivation = activityActivation;
        this.nodeExecutor = nodeExecutor;
        this.executorService = Executors.newCachedThreadPool(new Adept2ThreadFactory("InstanceExecution"));
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        this.awaitExecutorServiceShutdown();
    }

    @Override
    public void emergencyShutdown() {
        this.executorService.shutdownNow();
        this.awaitExecutorServiceShutdown();
    }

    private void awaitExecutorServiceShutdown() {
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void proceedProcessInstance(final SessionToken newSession, final UUID instanceID, final int nodeID) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block20: {
                    InstanceProceeding.this.sessionActive(newSession);
                    try {
                        ExecutableInstance instance;
                        try {
                            instance = InstanceProceeding.this.getInstanceManager().getAndLockInstanceForExecution(newSession, instanceID);
                        }
                        catch (LockException e) {
                            String msg;
                            Level level;
                            if (e.getLockType().equals("InstanceChangeLock")) {
                                level = Level.INFO;
                                msg = String.format("Cannot proceed instance '%s', because it is currently locked for changes. It will be proceeded when resuming when releasing the change lock.", instanceID);
                            } else {
                                level = Level.SEVERE;
                                msg = String.format("Cannot proceed instance '%s', because cannot get a lock on it! Proceeding is aborted. You need to re-activate the instance.", instanceID);
                            }
                            InstanceProceeding.this.logger.log(level, msg, e);
                            InstanceProceeding.this.sessionFinished(newSession);
                            return;
                        }
                        try {
                            try {
                                SessionToken proceedSession = InstanceProceeding.this.executionManager.subSession(newSession);
                                InstanceStatus instanceStatus = InstanceProceeding.this.getInstanceManager().getInstanceStatus(InstanceProceeding.this.executionManager.subSession(proceedSession), instance.getID());
                                ProcessConstants.InstanceExecutionStatus instanceExecutionStatus = instanceStatus.getExecutionStatus();
                                if (instanceExecutionStatus == ProcessConstants.InstanceExecutionStatus.IE_RUNNING) {
                                    InstanceProceeding.this.proceedProcessInstance(proceedSession, instance, nodeID);
                                    InstanceProceeding.this.getInstanceManager().setExecutableInstance(newSession, instance);
                                }
                            }
                            catch (LockException le) {
                                String msg = "proceedProcessInstance: Cannot store the executed instance '%1$s'. The instance will be in an inconsistent state.";
                                msg = String.format(msg, instanceID);
                                InstanceProceeding.this.logger.log(Level.SEVERE, msg, le);
                                try {
                                    InstanceProceeding.this.getInstanceManager().unlockExecutableInstance(newSession, instanceID);
                                }
                                catch (LockException le2) {
                                    msg = "proceedProcessInstance: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                                    msg = String.format(msg, instanceID);
                                    InstanceProceeding.this.logger.log(Level.SEVERE, msg, le2);
                                }
                                break block20;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                InstanceProceeding.this.getInstanceManager().unlockExecutableInstance(newSession, instanceID);
                            }
                            catch (LockException le) {
                                String msg = "proceedProcessInstance: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                                msg = String.format(msg, instanceID);
                                InstanceProceeding.this.logger.log(Level.SEVERE, msg, le);
                            }
                            throw throwable;
                        }
                        try {
                            InstanceProceeding.this.getInstanceManager().unlockExecutableInstance(newSession, instanceID);
                        }
                        catch (LockException le) {
                            String msg = "proceedProcessInstance: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.";
                            msg = String.format(msg, instanceID);
                            InstanceProceeding.this.logger.log(Level.SEVERE, msg, le);
                        }
                    }
                    finally {
                        InstanceProceeding.this.sessionFinished(newSession);
                    }
                }
            }
        });
    }

    void proceedProcessInstance(SessionToken session, ExecutableInstance instance, int nodeID) {
        Template template = instance.getTemplate();
        int[] nodeCandidatesForActivation = new int[]{};
        switch (template.getNodeType(nodeID)) {
            case NT_NORMAL: 
            case NT_STARTFLOW: 
            case NT_AND_SPLIT: 
            case NT_AND_JOIN: 
            case NT_XOR_JOIN: 
            case NT_STARTLOOP: {
                nodeCandidatesForActivation = this.handleNode(instance, nodeID);
                break;
            }
            case NT_ENDLOOP: {
                nodeCandidatesForActivation = this.handleEndLoopNode(session, nodeID, instance);
                break;
            }
            case NT_XOR_SPLIT: {
                nodeCandidatesForActivation = this.handleXORSplitNode(session, nodeID, instance);
                break;
            }
            case NT_ENDFLOW: {
                break;
            }
        }
        int[] nArray = nodeCandidatesForActivation;
        int n = nodeCandidatesForActivation.length;
        int n2 = 0;
        while (n2 < n) {
            int nodeCandidate = nArray[n2];
            if (template.getNodeType(nodeID) != ProcessConstants.NodeType.NT_AND_SPLIT || instance.getNodeState(nodeCandidate) == ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
                this.activateNode(session, instance, nodeCandidate);
            }
            ++n2;
        }
    }

    private int[] handleNode(ExecutableInstance instance, int nodeID) {
        return instance.getTemplate().getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_SYNC);
    }

    private int[] handleEndLoopNode(SessionToken session, int loopEndNodeID, ExecutableInstance instance) {
        Template template = instance.getTemplate();
        int loopStartNodeID = template.getNodeCorrespondingBlockNodeID(loopEndNodeID);
        long edgeToActivate = this.getEdgeToActivate(session, loopEndNodeID, instance);
        Edge loopEdge = template.getEdge(loopEndNodeID, loopStartNodeID, ProcessConstants.EdgeType.ET_LOOP);
        if (loopEdge.getEdgeCode() == edgeToActivate) {
            this.resetLoop(session, instance, loopStartNodeID, loopEndNodeID);
            return new int[]{loopStartNodeID};
        }
        return template.getSuccByEdgeType(loopEndNodeID, ProcessConstants.EdgeType.ET_CONTROL);
    }

    private int[] handleXORSplitNode(SessionToken session, int nodeID, ExecutableInstance instance) {
        Template template = instance.getTemplate();
        Node xorSplit = template.getNode(nodeID);
        long edgeToActivate = this.getEdgeToActivate(session, nodeID, instance);
        int[] successors = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
        boolean isSuccessorToActivateFound = false;
        HashSet<Integer> nodesForActivationCheck = new HashSet<Integer>();
        int[] nArray = successors;
        int n = successors.length;
        int n2 = 0;
        while (n2 < n) {
            int successor = nArray[n2];
            Edge edge = template.getEdge(xorSplit.getID(), successor, ProcessConstants.EdgeType.ET_CONTROL);
            if (edge.getEdgeCode() == edgeToActivate) {
                isSuccessorToActivateFound = true;
                nodesForActivationCheck.add(successor);
            } else if (instance.getNodeIteration(successor) < instance.getNodeIteration(nodeID)) {
                nodesForActivationCheck.addAll(this.skipBranch(session, instance, nodeID, successor));
            }
            ++n2;
        }
        if (!isSuccessorToActivateFound) {
            String errorMessage = String.format("Cannot determine the successor to activate for the XOR  split '%s (ID='%s')', because the edgeCode '%s' is unknown.", xorSplit.getName(), xorSplit.getID(), edgeToActivate);
            this.logger.severe(errorMessage);
            throw new InternalServiceException(errorMessage);
        }
        int[] successorsBySyncEdges = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_SYNC);
        int[] nodeSet = new int[nodesForActivationCheck.size() + successorsBySyncEdges.length];
        int i = 0;
        for (Integer nodeToCheck : nodesForActivationCheck) {
            nodeSet[i] = nodeToCheck;
            ++i;
        }
        System.arraycopy(successorsBySyncEdges, 0, nodeSet, i, successorsBySyncEdges.length);
        return nodeSet;
    }

    private Set<Integer> skipBranch(SessionToken session, ExecutableInstance instance, int splitNodeID, int branchStartNodeID) {
        Template template = instance.getTemplate();
        HashSet<Integer> candidates = new HashSet<Integer>();
        if (template.getNodeType(branchStartNodeID).equals((Object)ProcessConstants.NodeType.NT_XOR_JOIN)) {
            return candidates;
        }
        instance.setNodeState(branchStartNodeID, ProcessConstants.NodeState.NS_SKIPPED);
        instance.increaseNodeIteration(branchStartNodeID);
        this.fireNodeStateChangedEvent(this.executionManager.subSession(session), template, branchStartNodeID);
        int[] syncSuccessors = template.getSuccByEdgeType(branchStartNodeID, ProcessConstants.EdgeType.ET_SYNC);
        int i = 0;
        while (i < syncSuccessors.length) {
            candidates.add(syncSuccessors[i]);
            ++i;
        }
        int branchEndNodeID = ProcessModelTools.getBranchEndNode(template, splitNodeID, template.getNodeBranchID(branchStartNodeID));
        if (branchEndNodeID != branchStartNodeID) {
            int[] area;
            int[] nArray = area = template.getNodeIDsInArea(branchStartNodeID, branchEndNodeID, true);
            int n = area.length;
            int n2 = 0;
            while (n2 < n) {
                int branchNodeID = nArray[n2];
                instance.setNodeState(branchNodeID, ProcessConstants.NodeState.NS_SKIPPED);
                instance.increaseNodeIteration(branchNodeID);
                this.fireNodeStateChangedEvent(this.executionManager.subSession(session), template, branchNodeID);
                syncSuccessors = template.getSuccByEdgeType(branchNodeID, ProcessConstants.EdgeType.ET_SYNC);
                int i2 = 0;
                while (i2 < syncSuccessors.length) {
                    candidates.add(syncSuccessors[i2]);
                    ++i2;
                }
                ++n2;
            }
            instance.setNodeState(branchEndNodeID, ProcessConstants.NodeState.NS_SKIPPED);
            instance.increaseNodeIteration(branchEndNodeID);
            this.fireNodeStateChangedEvent(this.executionManager.subSession(session), template, branchEndNodeID);
            syncSuccessors = template.getSuccByEdgeType(branchEndNodeID, ProcessConstants.EdgeType.ET_SYNC);
            int i3 = 0;
            while (i3 < syncSuccessors.length) {
                candidates.add(syncSuccessors[i3]);
                ++i3;
            }
        }
        return candidates;
    }

    private void resetLoop(SessionToken session, ExecutableInstance instance, int loopStartNodeID, int loopEndNodeID) {
        int[] nodesInLoop;
        Template template = instance.getTemplate();
        if (template.getNodeBranchID(loopStartNodeID) != template.getNodeBranchID(loopEndNodeID)) {
            String message = "try to reset a loop which is not a loop";
            throw new IllegalArgumentException(message);
        }
        instance.setNodeState(loopEndNodeID, ProcessConstants.NodeState.NS_NOT_ACTIVATED);
        this.fireNodeStateChangedEvent(this.executionManager.subSession(session), template, loopEndNodeID);
        int[] nArray = nodesInLoop = instance.getTemplate().getNodeIDsInArea(loopStartNodeID, loopEndNodeID, true);
        int n = nodesInLoop.length;
        int n2 = 0;
        while (n2 < n) {
            int nodeID = nArray[n2];
            if (instance.getNodeState(nodeID).equals((Object)ProcessConstants.NodeState.NS_ENQUIRED)) {
                Node node = template.getNode(nodeID);
                ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
                boolean isActivity = ActivityExecutionTools.isActivity(ebp);
                EBPType ebpType = ActivityExecutionTools.getEBPType(ebp);
                int nodeIteration = instance.getNodeIteration(nodeID) - 1;
                URI[] runtimeManagerURIs = instance.getAssignedRuntimeManager(nodeID);
                EBPInstanceReference activity = this.executionManager.getProcessModelFactory().createEBPInstanceReference(ebpType, instance.getID(), instance.getBaseTemplateID(), nodeID, nodeIteration, isActivity, this.getURIs(), runtimeManagerURIs);
                this.worklistAccess.removeActivity(session, activity);
            }
            instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_NOT_ACTIVATED);
            instance.dropEnquiries(nodeID);
            ArrayList<UUID> lwpInstanceIDs = new ArrayList<UUID>(instance.getNodeLWPInstanceID(nodeID));
            for (UUID lwpInstanceID : lwpInstanceIDs) {
                instance.removeNodeLWPInstanceID(nodeID, lwpInstanceID);
            }
            this.fireNodeStateChangedEvent(this.executionManager.subSession(session), template, nodeID);
            ++n2;
        }
        instance.setNodeState(loopStartNodeID, ProcessConstants.NodeState.NS_NOT_ACTIVATED);
        this.fireNodeStateChangedEvent(this.executionManager.subSession(session), template, loopStartNodeID);
    }

    private long getEdgeToActivate(SessionToken session, int nodeID, ExecutableInstance instance) {
        long decisionID;
        Template template = instance.getTemplate();
        Node node = template.getNode(nodeID);
        DecisionActivity activity = (DecisionActivity)node.getExecutableBusinessProcess();
        DataManager dataManager = this.getDataManager(session, instance.getID());
        ProcessAwareAccess processAwareAccess = dataManager.getProcessAwareAccess();
        int connector = node.getConnector(activity.getDecisionParameter().getName(), ActivityConstants.AccessType.WRITE);
        DataElement dataElement = template.getDataElement(nodeID, connector);
        try {
            if (processAwareAccess.isNull(session, instance.getID(), nodeID, instance.getNodeIteration(nodeID), dataElement.getID())) {
                String errorMessage = String.format("Cannot determine the successor to activate for the XOR split '%s (ID='%s')', because the chosen decisionID was never written to the parameter '%s' specified as the decision parameter or was explicitly set to null.", node.getName(), node.getID(), activity.getDecisionParameter().getName());
                this.logger.severe(errorMessage);
                throw new InternalServiceException(errorMessage);
            }
            decisionID = processAwareAccess.retrieveInteger(session, instance.getID(), nodeID, instance.getNodeIteration(nodeID), dataElement.getID());
        }
        catch (InvalidDataTypeException e) {
            String errorMessage = String.format("Cannot determine the successor to activate for the XOR split '%s (ID='%s')', because the specified decision  parameter '%s' is not of the expected type '%s' specified within the decision activity.", new Object[]{node.getName(), node.getID(), activity.getDecisionParameter().getName(), activity.getDecisionParameter().getDataType()});
            this.logger.severe(errorMessage);
            throw new InternalServiceException(errorMessage, e);
        }
        long edgeCodeForDecisionID = activity.getEdgeCode(decisionID);
        return edgeCodeForDecisionID;
    }

    void activateNode(SessionToken session, ExecutableInstance instance, int nodeID) {
        if (!this.nodeCanBeActivated(instance, nodeID)) {
            String msg = String.format("Cannot activate the activity with ID = '%s' of instance with ID = '%s', because not all conditions for activating the activity are fulfilled!", nodeID, instance.getID());
            this.logger.finer(msg);
            return;
        }
        instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_ACTIVATED);
        ExecutableBusinessProcess ebp = instance.getTemplate().getNode(nodeID).getExecutableBusinessProcess();
        if (ebp == null) {
            switch (instance.getTemplate().getNodeType(nodeID)) {
                case NT_STARTFLOW: 
                case NT_ENDFLOW: {
                    break;
                }
                case NT_AND_SPLIT: 
                case NT_AND_JOIN: 
                case NT_XOR_JOIN: 
                case NT_STARTLOOP: {
                    if (!this.executionManager.getSkipBlockNodes() || !instance.getTemplate().getNode(nodeID).getStaffAssignmentRule().equals("")) break;
                    instance.setNodeState(nodeID, ProcessConstants.NodeState.NS_COMPLETED);
                    instance.increaseNodeIteration(nodeID);
                    instance.setPerformingAgent(nodeID, this.nodeExecutor);
                    instance.setExecutionMode(nodeID, ProcessConstants.ExecutionMode.PRODUCTION);
                    SessionToken newSession = this.executionManager.newSession(session);
                    super.privilegeSession(session, newSession);
                    this.proceedProcessInstance(newSession, instance.getID(), nodeID);
                    this.fireNodeStateChangedEvent(this.executionManager.subSession(session), instance.getTemplate(), nodeID);
                    return;
                }
            }
        }
        boolean isActivity = ActivityExecutionTools.isActivity(ebp);
        EBPType ebpType = ActivityExecutionTools.getEBPType(ebp);
        EBPInstanceReference activityToActivate = this.executionManager.getProcessModelFactory().createEBPInstanceReference(ebpType, instance.getID(), instance.getBaseTemplateID(), nodeID, instance.getNodeIteration(nodeID), isActivity, this.getURIs());
        try {
            this.activityActivation.activateActivity(session, instance, activityToActivate);
        }
        catch (InvalidActivityStateException iase) {
            String msg = String.format("The activity '%1$s' of instance '%2$s' should be in state ACTIVATED but it is in state %3$s. This state was already checked shortly. Since it has changed meanwhile there is a concurrency problem with activity state changes when activating!", new Object[]{nodeID, instance.getID(), iase.getActivityState()});
            this.logger.severe(msg);
            throw new InternalServiceException(msg, iase);
        }
        catch (InvalidInstanceStateException iise) {
            String msg = String.format("The activity '%1$s' of instance '%2$s' can not be activated since the instance is in state %3$s which prevents the activation. This is a serious problem since the activation should not be tried at all in this case!", nodeID, instance.getID(), iise.getPreventingState());
            this.logger.severe(msg);
            throw new InternalServiceException(msg, iise);
        }
    }

    private boolean nodeCanBeActivated(ExecutableInstance instance, int nodeID) {
        ProcessConstants.EdgeState edgeState;
        int predecessorID;
        int n;
        int n2;
        int[] nArray;
        int[] predecessors;
        ProcessConstants.NodeState nodeState = instance.getNodeState(nodeID);
        if (nodeState != ProcessConstants.NodeState.NS_NOT_ACTIVATED && instance.getTemplate().getNodeType(nodeID) == ProcessConstants.NodeType.NT_AND_JOIN) {
            return false;
        }
        if (nodeState != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            String msg = String.format("The node '%1$s' of instance '%2$s' should be in state NS_NOT_ACTIVATED for activation but it is in state %3$s. This can be caused by a very short suspend-resume cycle of the instance, in case the 'rescheduleActivities has overtaken this instance proceeding thread!", nodeID, instance.getID(), nodeState.name());
            this.logger.info(msg);
            return false;
        }
        Template template = instance.getTemplate();
        ProcessConstants.NodeType nodeType = template.getNodeType(nodeID);
        switch (nodeType) {
            case NT_STARTFLOW: {
                break;
            }
            case NT_NORMAL: 
            case NT_ENDFLOW: 
            case NT_AND_SPLIT: 
            case NT_AND_JOIN: 
            case NT_XOR_SPLIT: 
            case NT_STARTLOOP: 
            case NT_ENDLOOP: {
                nArray = predecessors = instance.getTemplate().getPredByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
                n2 = predecessors.length;
                n = 0;
                while (n < n2) {
                    predecessorID = nArray[n];
                    edgeState = instance.getEdgeState(predecessorID, nodeID, ProcessConstants.EdgeType.ET_CONTROL);
                    if (!edgeState.equals((Object)ProcessConstants.EdgeState.ES_TRUE)) {
                        return false;
                    }
                    ++n;
                }
                break;
            }
            case NT_XOR_JOIN: {
                boolean isOneTrueSignaledEdgeExisting = false;
                int[] nArray2 = predecessors = instance.getTemplate().getPredByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
                int n3 = predecessors.length;
                n2 = 0;
                while (n2 < n3) {
                    int predecessorID2 = nArray2[n2];
                    edgeState = instance.getEdgeState(predecessorID2, nodeID, ProcessConstants.EdgeType.ET_CONTROL);
                    switch (edgeState) {
                        case ES_FALSE: {
                            break;
                        }
                        case ES_NS: {
                            return false;
                        }
                        case ES_TRUE: {
                            isOneTrueSignaledEdgeExisting = true;
                            break;
                        }
                    }
                    ++n2;
                }
                if (isOneTrueSignaledEdgeExisting) break;
                return false;
            }
        }
        nArray = predecessors = instance.getTemplate().getPredByEdgeType(nodeID, ProcessConstants.EdgeType.ET_SYNC);
        n2 = predecessors.length;
        n = 0;
        while (n < n2) {
            predecessorID = nArray[n];
            edgeState = instance.getEdgeState(predecessorID, nodeID, ProcessConstants.EdgeType.ET_SYNC);
            if (edgeState.equals((Object)ProcessConstants.EdgeState.ES_NS)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void fireNodeStateChangedEvent(SessionToken session, Template template, int nodeID) {
        int[] writtenDataElements;
        int succ;
        UpdateManager updateManager = this.getUpdateManager(session);
        if (updateManager == null) {
            return;
        }
        Node node = template.getNode(nodeID);
        updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_STATE);
        int[] nArray = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            succ = nArray[n2];
            updateManager.firePropertyChange(template.getEdge(nodeID, succ, ProcessConstants.EdgeType.ET_CONTROL), (Object)UpdateManager.EdgeProperties.EDGE_STATE);
            ++n2;
        }
        nArray = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_SYNC);
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            succ = nArray[n2];
            updateManager.firePropertyChange(template.getEdge(nodeID, succ, ProcessConstants.EdgeType.ET_SYNC), (Object)UpdateManager.EdgeProperties.EDGE_STATE);
            ++n2;
        }
        int[] nArray2 = writtenDataElements = template.getAccessedDataElementIDsForNode(nodeID, ActivityConstants.AccessType.WRITE);
        int n3 = writtenDataElements.length;
        n = 0;
        while (n < n3) {
            int dataElementID = nArray2[n];
            updateManager.firePropertyChange(template.getDataElement(dataElementID), (Object)UpdateManager.DataElementProperties.DE_NAME);
            ++n;
        }
        updateManager.sendPropertyChanges();
    }

    protected DataManager getDataManager(SessionToken session, UUID instanceID) {
        return this.executionManager.getResolvedDataManager(session, instanceID);
    }

    protected UpdateManager getUpdateManager(SessionToken session) {
        return this.executionManager.getUpdateManager(session);
    }

    protected InstanceManager getInstanceManager() {
        return this.executionManager.getProcessManager().getInstanceManager();
    }
}

