/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction;

import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.WorklistInteraction;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionTools;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction.InitialWorklistUpdater;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction.WorklistAccess;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.worklistmanager.WorklistNotification;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.LockException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DefaultWorklistInteraction
extends AbstractSubService
implements WorklistInteraction,
WorklistAccess {
    protected final DefaultExecutionManager executionManager;
    protected final Set<WorklistNotification> worklistManagers = new HashSet<WorklistNotification>();
    protected final Map<WorklistNotification, Future<?>> worklistCompletionSignalling = new HashMap();
    protected final Map<WorklistNotification, Queue<Runnable>> pendingUpdates = new HashMap<WorklistNotification, Queue<Runnable>>();
    protected final ExecutorService updateThreads = Executors.newCachedThreadPool(new Adept2ThreadFactory("WorklistInteraction_UpdateThreads"));

    public DefaultWorklistInteraction(DefaultExecutionManager executionManager) {
        super(new String[]{"ProcessManager", "DataManager"}, new String[0], executionManager);
        this.executionManager = executionManager;
    }

    @Override
    public void shutdown() {
        this.removeManagersAndWait();
    }

    @Override
    public void emergencyShutdown() {
        this.removeManagersAndWait();
    }

    protected void removeManagersAndWait() {
        for (WorklistNotification worklistManager : this.getWorklistManagers()) {
            this.internalRemoveWorklistManager(worklistManager);
        }
        this.updateThreads.shutdown();
        boolean terminated = false;
        while (!terminated) {
            try {
                terminated = this.updateThreads.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWorklistManager(SessionToken parentSession, final WorklistNotification worklistManager) {
        Set<WorklistNotification> set = this.worklistManagers;
        synchronized (set) {
            this.worklistManagers.add(worklistManager);
        }
        SessionToken subSession = this.executionManager.subSession(parentSession);
        Set<UUID> templateIDs = this.executionManager.getProcessManager().getTemplateManager().getAllTemplateIDs(subSession);
        final ArrayList updateTransactions = new ArrayList(templateIDs.size());
        for (UUID templateID : templateIDs) {
            subSession = this.executionManager.subSession(parentSession);
            InitialWorklistUpdater updateWorker = new InitialWorklistUpdater(subSession, worklistManager, templateID, this.getURIs(), this.executionManager);
            updateTransactions.add(this.updateThreads.submit(updateWorker));
        }
        final CountDownLatch added = new CountDownLatch(1);
        Future<?> completionSignal = this.updateThreads.submit(new Runnable(){

            @Override
            public void run() {
                String threadName = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName("WorklistInteraction.addWorklistManager(): Completion Signalling-Thread");
                    try {
                        added.await();
                    }
                    catch (InterruptedException ie) {
                        DefaultWorklistInteraction.this.logger.log(Level.INFO, "Interrupted before awaiting the termination of updating a worklist manager, aborting updates.", ie);
                        Thread.currentThread().interrupt();
                    }
                    for (Future singleUpdate : updateTransactions) {
                        if (!Thread.currentThread().isInterrupted()) {
                            try {
                                singleUpdate.get();
                            }
                            catch (ExecutionException ee) {
                                DefaultWorklistInteraction.this.logger.log(Level.WARNING, "An exception occured while updating the worklist due to the adding of a worklist manager", ee);
                            }
                            catch (InterruptedException ie) {
                                DefaultWorklistInteraction.this.logger.log(Level.INFO, "Interrupted while awaiting the termination of updating a worklist manager, aborting update.", ie);
                                singleUpdate.cancel(true);
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                        singleUpdate.cancel(true);
                    }
                    worklistManager.initialUpdateComplete();
                    Queue<Runnable> pendings = DefaultWorklistInteraction.this.pendingUpdates.get(worklistManager);
                    while (pendings.size() > 0 && !Thread.currentThread().isInterrupted()) {
                        pendings.poll().run();
                    }
                    DefaultWorklistInteraction.this.pendingUpdates.remove(worklistManager);
                    DefaultWorklistInteraction.this.worklistCompletionSignalling.remove(worklistManager);
                }
                finally {
                    Thread.currentThread().setName(threadName);
                }
            }
        });
        this.worklistCompletionSignalling.put(worklistManager, completionSignal);
        this.pendingUpdates.put(worklistManager, new ConcurrentLinkedQueue());
        added.countDown();
    }

    @Override
    public void removeWorklistManager(SessionToken session, WorklistNotification worklistManager) {
        this.internalRemoveWorklistManager(worklistManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRemoveWorklistManager(WorklistNotification worklistManager) {
        Future<?> completionSignal = this.worklistCompletionSignalling.remove(worklistManager);
        if (completionSignal != null) {
            completionSignal.cancel(true);
        }
        Set<WorklistNotification> set = this.worklistManagers;
        synchronized (set) {
            this.worklistManagers.remove(worklistManager);
        }
    }

    protected Set<WorklistNotification> getWorklistManagers() {
        HashSet<WorklistNotification> ret = new HashSet<WorklistNotification>(this.worklistManagers);
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public void removeActivitiesFromWorklist(SessionToken session, UUID instanceID, ProcessConstants.NodeState ... nodeStates) {
        super.sessionActive(session);
        try {
            ExecutableInstance instance;
            if (nodeStates.length == 0) {
                return;
            }
            InstanceManager instanceManager = this.executionManager.getProcessManager().getInstanceManager();
            try {
                instance = instanceManager.getAndLockInstanceForExecution(session, instanceID);
            }
            catch (LockException e) {
                String warningMessage = String.format("Cannot get a lock for the given instance '%s'!", instanceID);
                this.logger.log(Level.WARNING, warningMessage, e);
                throw new InternalServiceException(warningMessage, e);
            }
            try {
                Template template = instance.getTemplate();
                ProcessConstants.NodeState[] nodeStateArray = nodeStates;
                int n = nodeStates.length;
                int n2 = 0;
                while (n2 < n) {
                    int[] affectedNodes;
                    ProcessConstants.NodeState nodeState = nodeStateArray[n2];
                    int[] nArray = affectedNodes = instance.getNodesInState(nodeState);
                    int n3 = affectedNodes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int affectedNodeID = nArray[n4];
                        Node affectedNode = template.getNode(affectedNodeID);
                        if (affectedNode.getID() != template.getStartNode().getID() && affectedNode.getID() != template.getEndNode().getID()) {
                            ExecutableBusinessProcess ebp = affectedNode.getExecutableBusinessProcess();
                            boolean isActivity = ActivityExecutionTools.isActivity(ebp);
                            EBPType ebpType = ActivityExecutionTools.getEBPType(ebp);
                            int nodeIteration = instance.getNodeIteration(affectedNodeID);
                            final EBPInstanceReference ebpIR = this.executionManager.getProcessModelFactory().createEBPInstanceReference(ebpType, instanceID, instance.getBaseTemplateID(), affectedNodeID, nodeIteration, isActivity, this.getURIs());
                            Set<WorklistNotification> wlManagers = this.getWorklistManagers();
                            for (final WorklistNotification worklistManager : wlManagers) {
                                this.runOrStoreUpdate(worklistManager, new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        boolean worklistManagerPresent;
                                        Set<WorklistNotification> set = DefaultWorklistInteraction.this.worklistManagers;
                                        synchronized (set) {
                                            worklistManagerPresent = DefaultWorklistInteraction.this.worklistManagers.contains(worklistManager);
                                        }
                                        if (worklistManagerPresent) {
                                            worklistManager.removeActivity(ebpIR);
                                        }
                                    }
                                });
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                try {
                    instanceManager.unlockExecutableInstance(session, instance.getID());
                }
                catch (LockException le) {
                    String msg = String.format("removeActivitiesFromWorklist: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instance.getID());
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg, le);
                }
                throw throwable;
            }
            try {
                instanceManager.unlockExecutableInstance(session, instance.getID());
            }
            catch (LockException le) {
                String msg = String.format("removeActivitiesFromWorklist: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instance.getID());
                this.logger.log(Level.SEVERE, msg, le);
                throw new InternalServiceException(msg, le);
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void addActivity(SessionToken session, final ExecutableBusinessProcessInstance ebpInstance, final ProcessConstants.NodeState state, final EBPInstanceReference ebpInstanceReference, final String staffAssignmentRule) {
        super.sessionActive(session);
        try {
            Set<WorklistNotification> wlManagers = this.getWorklistManagers();
            for (final WorklistNotification worklistManager : wlManagers) {
                this.runOrStoreUpdate(worklistManager, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean worklistManagerPresent;
                        Set<WorklistNotification> set = DefaultWorklistInteraction.this.worklistManagers;
                        synchronized (set) {
                            worklistManagerPresent = DefaultWorklistInteraction.this.worklistManagers.contains(worklistManager);
                        }
                        if (worklistManagerPresent) {
                            worklistManager.addActivity(ebpInstance, state, ebpInstanceReference, staffAssignmentRule);
                        }
                    }
                });
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void addAndAssignActivity(SessionToken session, final ExecutableBusinessProcessInstance ebpInstance, final ProcessConstants.NodeState state, final EBPInstanceReference ebpInstanceReference, final String staffAssignmentRule, final QualifiedAgent agent) {
        super.sessionActive(session);
        try {
            Set<WorklistNotification> wlManagers = this.getWorklistManagers();
            for (final WorklistNotification worklistManager : wlManagers) {
                this.runOrStoreUpdate(worklistManager, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean worklistManagerPresent;
                        Set<WorklistNotification> set = DefaultWorklistInteraction.this.worklistManagers;
                        synchronized (set) {
                            worklistManagerPresent = DefaultWorklistInteraction.this.worklistManagers.contains(worklistManager);
                        }
                        if (worklistManagerPresent) {
                            worklistManager.addAndAssignActivity(ebpInstance, state, ebpInstanceReference, staffAssignmentRule, agent);
                        }
                    }
                });
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void assignAndUpdateActivity(SessionToken session, final EBPInstanceReference activity, final ProcessConstants.NodeState state, final QualifiedAgent agent) {
        super.sessionActive(session);
        try {
            Set<WorklistNotification> wlManagers = this.getWorklistManagers();
            for (final WorklistNotification worklistManager : wlManagers) {
                this.runOrStoreUpdate(worklistManager, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean worklistManagerPresent;
                        Set<WorklistNotification> set = DefaultWorklistInteraction.this.worklistManagers;
                        synchronized (set) {
                            worklistManagerPresent = DefaultWorklistInteraction.this.worklistManagers.contains(worklistManager);
                        }
                        if (worklistManagerPresent) {
                            worklistManager.assignAndUpdateActivity(activity, state, agent);
                        }
                    }
                });
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void removeActivity(SessionToken session, final EBPInstanceReference activity) {
        super.sessionActive(session);
        try {
            Set<WorklistNotification> wlManagers = this.getWorklistManagers();
            for (final WorklistNotification worklistManager : wlManagers) {
                this.runOrStoreUpdate(worklistManager, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean worklistManagerPresent;
                        Set<WorklistNotification> set = DefaultWorklistInteraction.this.worklistManagers;
                        synchronized (set) {
                            worklistManagerPresent = DefaultWorklistInteraction.this.worklistManagers.contains(worklistManager);
                        }
                        if (worklistManagerPresent) {
                            worklistManager.removeActivity(activity);
                        }
                    }
                });
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void updateActivityState(SessionToken session, final EBPInstanceReference activity, final ProcessConstants.NodeState state) {
        super.sessionActive(session);
        try {
            Set<WorklistNotification> wlManagers = this.getWorklistManagers();
            for (final WorklistNotification worklistManager : wlManagers) {
                this.runOrStoreUpdate(worklistManager, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean worklistManagerPresent;
                        Set<WorklistNotification> set = DefaultWorklistInteraction.this.worklistManagers;
                        synchronized (set) {
                            worklistManagerPresent = DefaultWorklistInteraction.this.worklistManagers.contains(worklistManager);
                        }
                        if (worklistManagerPresent) {
                            worklistManager.updateActivityState(activity, state);
                        }
                    }
                });
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void removeAllActivities(SessionToken session) {
        super.sessionActive(session);
        try {
            Set<WorklistNotification> wlManagers = this.getWorklistManagers();
            for (final WorklistNotification worklistManager : wlManagers) {
                this.runOrStoreUpdate(worklistManager, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean worklistManagerPresent;
                        Set<WorklistNotification> set = DefaultWorklistInteraction.this.worklistManagers;
                        synchronized (set) {
                            worklistManagerPresent = DefaultWorklistInteraction.this.worklistManagers.contains(worklistManager);
                        }
                        if (worklistManagerPresent) {
                            worklistManager.removeAllActivities();
                        }
                    }
                });
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void enquireActivity(SessionToken session, final EBPInstanceReference activity, final Enquiry enquiry) {
        super.sessionActive(session);
        try {
            Set<WorklistNotification> wlManagers = this.getWorklistManagers();
            for (final WorklistNotification worklistManager : wlManagers) {
                this.runOrStoreUpdate(worklistManager, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean worklistManagerPresent;
                        Set<WorklistNotification> set = DefaultWorklistInteraction.this.worklistManagers;
                        synchronized (set) {
                            worklistManagerPresent = DefaultWorklistInteraction.this.worklistManagers.contains(worklistManager);
                        }
                        if (worklistManagerPresent) {
                            worklistManager.enquireActivity(activity, enquiry);
                        }
                    }
                });
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void replyActivity(SessionToken session, final EBPInstanceReference activity, final Enquiry enquiry) {
        super.sessionActive(session);
        try {
            Set<WorklistNotification> wlManagers = this.getWorklistManagers();
            for (final WorklistNotification worklistManager : wlManagers) {
                this.runOrStoreUpdate(worklistManager, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean worklistManagerPresent;
                        Set<WorklistNotification> set = DefaultWorklistInteraction.this.worklistManagers;
                        synchronized (set) {
                            worklistManagerPresent = DefaultWorklistInteraction.this.worklistManagers.contains(worklistManager);
                        }
                        if (worklistManagerPresent) {
                            worklistManager.replyEnquiry(activity, enquiry);
                        }
                    }
                });
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    private void runOrStoreUpdate(WorklistNotification worklistManager, Runnable update) {
        Queue<Runnable> pendings = this.pendingUpdates.get(worklistManager);
        if (pendings != null) {
            pendings.add(update);
        } else {
            update.run();
        }
    }
}

