/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.executionmanager.defaultimplementation.worklistinteraction;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.DefaultExecutionManager;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.ParameterRefResolver;
import de.aristaflow.adept2.core.executionmanager.defaultimplementation.activityexecution.ActivityExecutionTools;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.worklistmanager.WorklistNotification;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

class InitialWorklistUpdater
implements Runnable {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final SessionToken session;
    protected final UUID templateID;
    protected final URI[] uris;
    protected final WorklistNotification wlm;
    protected final DefaultExecutionManager execMgr;

    public InitialWorklistUpdater(SessionToken session, WorklistNotification worklistManager, UUID templateID, URI[] uris, DefaultExecutionManager executionManager) {
        this.session = session;
        this.templateID = templateID;
        this.uris = uris;
        this.wlm = worklistManager;
        this.execMgr = executionManager;
    }

    @Override
    public void run() {
        String threadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("WorklistInteraction.addWorklistManager(Template: " + this.templateID + "-Thread)");
            InstanceManager instMgr = this.execMgr.getProcessManager().getInstanceManager();
            Set<UUID> instIDsOf = instMgr.getAllInstanceIDsOf(this.session, this.templateID);
            ArrayList<UUID> instanceIDs = new ArrayList<UUID>(instIDsOf);
            while (instanceIDs.size() > 0) {
                Template template;
                ExecutableInstance instance;
                InstanceStatus instanceStatus;
                SessionToken subSession;
                UUID instanceID;
                block26: {
                    instanceID = (UUID)instanceIDs.remove(0);
                    if (Thread.interrupted()) {
                        break;
                    }
                    subSession = this.execMgr.subSession(this.session);
                    instanceStatus = this.execMgr.getProcessManager().getInstanceManager().getInstanceStatus(subSession, instanceID);
                    if (instanceStatus.getExecutionStatus() == ProcessConstants.InstanceExecutionStatus.IE_FINISHED || instanceStatus.getExecutionStatus() == ProcessConstants.InstanceExecutionStatus.IE_ABORTED) continue;
                    try {
                        subSession = this.execMgr.subSession(this.session);
                        instance = this.execMgr.getProcessManager().getInstanceManager().getAndLockInstanceForExecution(subSession, instanceID);
                    }
                    catch (LockException e) {
                        String warningMessage = String.format("Cannot get a lock for the given instance '%s'!", instanceID);
                        this.logger.log(Level.WARNING, warningMessage, e);
                        continue;
                    }
                    subSession = this.execMgr.subSession(this.session);
                    instanceStatus = this.execMgr.getProcessManager().getInstanceManager().getInstanceStatus(subSession, instanceID);
                    template = instance.getTemplate();
                    if (instanceStatus.getExecutionStatus().equals((Object)ProcessConstants.InstanceExecutionStatus.IE_RUNNING)) break block26;
                    try {
                        subSession = this.execMgr.subSession(this.session);
                        this.execMgr.getProcessManager().getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                        continue;
                    }
                    catch (LockException le) {
                        String msg = String.format("addWorklistManager: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instance.getID());
                        this.logger.log(Level.SEVERE, msg, le);
                        throw new InternalServiceException(msg);
                    }
                }
                try {
                    ProcessConstants.NodeState[] nodeStates;
                    int[] affectedNodeIDs;
                    if (instance.getParentEBPReference() == null) {
                        EBPInstanceReference ebpIR = this.execMgr.getEbpIRForInstance(instance);
                        ExecutionControlProperties ecp = new ExecutionControlProperties(false, false, false);
                        ExecutableBusinessProcessInstance tlpi = this.execMgr.getExecutionFactory().createTopLevelProcessInstance(template.getID(), template.getName(), instance.getName(), instance.getLogID(), instance.getName(), template.getDescription(), null, ecp, null, template.getParameters(ActivityConstants.AccessType.READ), template.getParameters(ActivityConstants.AccessType.WRITE), this.execMgr.getExecutionFactory().createParameterDataContext(null, null), template, instance.getUserAttributes());
                        QualifiedAgent initiator = instance.getInitiatorAgent();
                        String initiatorPolicy = String.format("OrgPosition(id=%s).getAgents(id=%s)", initiator.getOrgPositionID(), initiator.getAgentID());
                        this.wlm.addAndAssignActivity(tlpi, ProcessConstants.NodeState.NS_RUNNING, ebpIR, initiatorPolicy, initiator);
                    }
                    int[] nArray = affectedNodeIDs = instance.getNodesInState(ProcessConstants.NodeState.NS_ACTIVATED);
                    int n = affectedNodeIDs.length;
                    int tlpi = 0;
                    while (tlpi < n) {
                        int nodeID = nArray[tlpi];
                        if (Thread.currentThread().isInterrupted()) break;
                        try {
                            this.addActivatedNode(instance, nodeID);
                        }
                        catch (RuntimeException re) {
                            String msg = "A RuntimeException occurred while adding node %d of instance '%s' to the worklist manager. Continuing with the activated next node.";
                            this.logger.log(Level.WARNING, String.format(msg, nodeID, instanceID), re);
                        }
                        ++tlpi;
                    }
                    ProcessConstants.NodeState[] nodeStateArray = nodeStates = new ProcessConstants.NodeState[]{ProcessConstants.NodeState.NS_SELECTED, ProcessConstants.NodeState.NS_RUNNING, ProcessConstants.NodeState.NS_SUSPENDED, ProcessConstants.NodeState.NS_ENQUIRED};
                    int n2 = nodeStates.length;
                    n = 0;
                    while (n < n2) {
                        ProcessConstants.NodeState nodeState = nodeStateArray[n];
                        int[] nArray2 = affectedNodeIDs = instance.getNodesInState(nodeState);
                        int n3 = affectedNodeIDs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int nodeID = nArray2[n4];
                            if (Thread.currentThread().isInterrupted()) break;
                            try {
                                List<UUID> embds;
                                if (!instanceStatus.getExecutionStatus().equals((Object)ProcessConstants.InstanceExecutionStatus.IE_ABORTED) && (embds = this.addNode(instance, nodeID, nodeState)) != null && embds.size() > 0) {
                                    instanceIDs.addAll(embds);
                                }
                            }
                            catch (RuntimeException re) {
                                String msg = "A RuntimeException occurred while adding node %d (state: %s) of instance '%s' to the worklist manager. Continuing with the next node.";
                                msg = String.format(msg, nodeID, nodeState.name(), instanceID);
                                this.logger.log(Level.WARNING, msg, re);
                            }
                            ++n4;
                        }
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        subSession = this.execMgr.subSession(this.session);
                        this.execMgr.getProcessManager().getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                    }
                    catch (LockException le) {
                        String msg = String.format("addWorklistManager: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instance.getID());
                        this.logger.log(Level.SEVERE, msg, le);
                        throw new InternalServiceException(msg);
                    }
                    throw throwable;
                }
                try {
                    subSession = this.execMgr.subSession(this.session);
                    this.execMgr.getProcessManager().getInstanceManager().unlockExecutableInstance(subSession, instanceID);
                }
                catch (LockException le) {
                    String msg = String.format("addWorklistManager: Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it.", instance.getID());
                    this.logger.log(Level.SEVERE, msg, le);
                    throw new InternalServiceException(msg);
                }
            }
        }
        finally {
            Thread.currentThread().setName(threadName);
        }
    }

    protected void addActivatedNode(Instance instance, int nodeID) {
        Node affectedNode = instance.getTemplate().getNode(nodeID);
        if (nodeID == instance.getTemplate().getStartNode().getID() || nodeID == instance.getTemplate().getEndNode().getID()) {
            return;
        }
        ExecutableBusinessProcess ebp = affectedNode.getExecutableBusinessProcess();
        boolean isActivity = ActivityExecutionTools.isActivity(ebp);
        EBPType ebpType = ActivityExecutionTools.getEBPType(ebp);
        int nodeIteration = instance.getNodeIteration(nodeID);
        SessionToken subSession = this.execMgr.subSession(this.session);
        EBPInstanceReference ebpIR = this.execMgr.getProcessModelFactory().createEBPInstanceReference(ebpType, instance.getID(), instance.getBaseTemplateID(), nodeID, nodeIteration, isActivity, this.uris);
        ProcessAwareAccess paa = this.execMgr.getResolvedDataManager(subSession, instance.getID()).getProcessAwareAccess();
        ParameterDataContext dataContext = paa.getPublicDataContext(subSession, instance, nodeID);
        InputDataContainer nodeDataContainer = paa.getNodeDataContainer(subSession, instance, nodeID);
        subSession = this.execMgr.subSession(this.session);
        ExecutableBusinessProcessInstance ebpInstance = ActivityExecutionTools.setUpEBPInstance(subSession, ebpIR, instance, this.execMgr.getADEPT2DefaultComponentFactory(), this.execMgr.getExecutionFactory(), dataContext, nodeDataContainer, this.execMgr.getPluginRegistry());
        subSession = this.execMgr.subSession(this.session);
        Node resolvingAffectedNode = ParameterRefResolver.getProxy(affectedNode, Node.class, nodeDataContainer, subSession, this.execMgr.getPluginRegistry());
        this.wlm.addActivity(ebpInstance, ProcessConstants.NodeState.NS_ACTIVATED, ebpIR, resolvingAffectedNode.getStaffAssignmentRule());
    }

    protected List<UUID> addNode(ExecutableInstance instance, int nodeID, ProcessConstants.NodeState nodeState) {
        Node affectedNode = instance.getTemplate().getNode(nodeID);
        ExecutableBusinessProcess ebp = affectedNode.getExecutableBusinessProcess();
        List<UUID> ret = this.getEmbds(instance, nodeID, ebp);
        boolean isActivity = ActivityExecutionTools.isActivity(ebp);
        EBPType ebpType = ActivityExecutionTools.getEBPType(ebp);
        int nodeIteration = nodeState == ProcessConstants.NodeState.NS_ENQUIRED ? instance.getNodeIteration(nodeID) - 1 : instance.getNodeIteration(nodeID);
        URI[] runtimeManagerURIs = instance.getAssignedRuntimeManager(nodeID);
        SessionToken subSession = this.execMgr.subSession(this.session);
        EBPInstanceReference ebpIR = this.execMgr.getProcessModelFactory().createEBPInstanceReference(ebpType, instance.getID(), instance.getBaseTemplateID(), nodeID, nodeIteration, isActivity, this.uris, runtimeManagerURIs);
        ProcessAwareAccess paa = this.execMgr.getResolvedDataManager(subSession, instance.getID()).getProcessAwareAccess();
        ParameterDataContext dataContext = paa.getPublicDataContext(subSession, instance, nodeID);
        InputDataContainer nodeDataContainer = paa.getNodeDataContainer(subSession, instance, nodeID);
        subSession = this.execMgr.subSession(this.session);
        ExecutableBusinessProcessInstance ebpInstance = ActivityExecutionTools.setUpEBPInstance(subSession, ebpIR, instance, this.execMgr.getADEPT2DefaultComponentFactory(), this.execMgr.getExecutionFactory(), dataContext, nodeDataContainer, this.execMgr.getPluginRegistry());
        subSession = this.execMgr.subSession(this.session);
        Node resolvingAffectedNode = ParameterRefResolver.getProxy(affectedNode, Node.class, nodeDataContainer, subSession, this.execMgr.getPluginRegistry());
        this.wlm.addAndAssignActivity(ebpInstance, nodeState, ebpIR, resolvingAffectedNode.getStaffAssignmentRule(), instance.getPerformingAgent(nodeID));
        for (Enquiry enquiry : instance.getCurrentEnquiries(nodeID)) {
            this.wlm.enquireActivity(ebpIR, enquiry);
        }
        Enquiry repliedEnquiry = instance.getRepliedEnquiry(nodeID);
        if (repliedEnquiry != null) {
            this.wlm.enquireActivity(ebpIR, repliedEnquiry);
            this.wlm.replyEnquiry(ebpIR, repliedEnquiry);
        }
        return ret;
    }

    protected List<UUID> getEmbds(Instance instance, int nodeID, ExecutableBusinessProcess ebp) {
        List<UUID> ret = null;
        ExecutableBusinessProcess sub = ebp;
        if (sub instanceof VariableParallelismEBP) {
            sub = ((VariableParallelismEBP)ebp).getLightWeightProcess();
        }
        if (sub instanceof EmbeddedProcess) {
            ret = instance.getNodeLWPInstanceID(nodeID);
        }
        return ret;
    }
}

